/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmButtonStateListener;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDateTimeChangeListener;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

class WcmDateTimeEditor
extends JPanel
implements WcmDateTimeChangeListener {
    public static final int TIME = 0;
    public static final int DATE = 1;
    public static final int DATETIME = 2;
    private Date m_date;
    private Calendar m_calendar = Calendar.getInstance();
    private int m_dateTimeFmt = 2;
    private DateFormat m_dateFormat = DateFormat.getDateTimeInstance();
    private int m_curField = -1;
    private ArrayList m_fieldPositions = new ArrayList();
    private int[] m_fieldTypes = new int[]{14, 3, 9, 11, 10, 0, 16, 15, 5, 4, 8, 6, 2, 7, 13, 12, 1};
    private JTextField m_textField;
    private Caret m_caret;
    private WcmSpinner m_spinner;
    private boolean m_clear;
    private boolean m_bInitEditor = true;
    private boolean m_saveInitEditor = true;
    private AbstractAction m_upAction = new UpDownAction(1, "up");
    private AbstractAction m_downAction = new UpDownAction(-1, "down");
    private EventListenerList listenerList = new EventListenerList();
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;

    WcmDateTimeEditor() {
        this.init(new Date());
    }

    WcmDateTimeEditor(Date date) {
        this.init(date);
    }

    private void init(Date date) {
        this.initComponents();
        this.initKeyMap();
        this.initDate(date);
    }

    public void initEditor(boolean bInit) {
        this.m_saveInitEditor = bInit;
        if (!this.m_saveInitEditor) {
            this.m_textField.setText("");
            this.m_clear = true;
            this.m_bInitEditor = false;
        }
    }

    public void initDate(Date date) {
        this.m_date = date;
        this.m_calendar.setTime(date);
        this.initFieldPositions();
        this.m_textField.setText(this.m_dateFormat.format(this.m_date));
        this.initDefaultField();
        this.setCurField();
        this.repaint();
        if (!this.m_bInitEditor) {
            this.m_textField.setText("");
        }
    }

    private void initDateTimeFormat() {
        this.initFieldPositions();
        this.m_textField.setText(this.m_dateFormat.format(this.m_date));
        this.initDefaultField();
        this.setCurField();
    }

    public void setDateTimeFormat(int dateTimeFmt) {
        this.m_dateTimeFmt = dateTimeFmt;
        switch (this.m_dateTimeFmt) {
            case 0: {
                this.m_dateFormat = DateFormat.getTimeInstance();
                break;
            }
            case 1: {
                this.m_dateFormat = DateFormat.getDateInstance();
                break;
            }
            case 2: {
                this.m_dateFormat = DateFormat.getDateTimeInstance();
            }
        }
        this.initDateTimeFormat();
    }

    private void initComponents() {
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
    }

    private void initKeyMap() {
        Keymap keymap = JTextField.addKeymap("DateTimeEditorKeyMap", null);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(38, 0), this.m_upAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(40, 0), this.m_downAction);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(37, 0), new LeftAction("caret-backward"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(39, 0), new RightAction("caret-forward"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(36, 0), new HomeAction("caret-begin"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(35, 0), new EndAction("caret-end"));
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(127, 0), new DeleteAction("delete-next"));
        this.m_textField.getActionMap().put("delete-previous", new AbstractAction(){

            public void actionPerformed(ActionEvent ae) {
            }
        });
        this.m_textField.setKeymap(keymap);
    }

    public void clear() {
        this.m_textField.setText("");
        this.m_clear = true;
        this.m_bInitEditor = this.m_saveInitEditor;
    }

    public Date getDate() {
        if (this.m_clear || this.m_textField.getText().length() == 0) {
            return null;
        }
        return this.m_date;
    }

    public boolean isEditorInitialized() {
        return this.m_bInitEditor;
    }

    private void createComponents() {
        this.setLayout(new BorderLayout());
        this.m_textField = new JTextField();
        this.m_caret = this.m_textField.getCaret();
        this.m_caret.setDot(0);
        this.m_spinner = new WcmSpinner();
    }

    private void layoutComponents() {
        this.add((Component)this.m_textField, "Center");
        this.add((Component)this.m_spinner, "After");
    }

    private void setupListeners() {
        this.m_caret.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WcmDateTimeEditor.this.setCurField();
            }
        });
        this.m_spinner.getIncrementButton().addActionListener(this.m_upAction);
        this.m_spinner.getDecrementButton().addActionListener(this.m_downAction);
    }

    public void dateTimeChanged(Date date) {
        this.initDate(date);
    }

    public void dateChanged(Date date) {
        if (this.m_clear) {
            this.initDate(date);
            this.m_clear = false;
            this.fireButtonStateChanged(true);
        } else {
            Calendar dateCal = Calendar.getInstance();
            dateCal.setTime(date);
            dateCal.set(11, this.m_calendar.get(11));
            dateCal.set(12, this.m_calendar.get(12));
            dateCal.set(13, this.m_calendar.get(13));
            dateCal.set(14, this.m_calendar.get(14));
            this.m_calendar = dateCal;
            this.initDate(this.m_calendar.getTime());
        }
    }

    public void timeChanged(Date date) {
        if (this.m_clear) {
            this.initDate(date);
            this.m_clear = false;
            this.fireButtonStateChanged(true);
        } else {
            Calendar timeCal = Calendar.getInstance();
            timeCal.setTime(date);
            this.m_calendar.set(11, timeCal.get(11));
            this.m_calendar.set(12, timeCal.get(12));
            this.m_calendar.set(13, timeCal.get(13));
            this.m_calendar.set(14, timeCal.get(14));
            this.m_date = this.m_calendar.getTime();
            this.initDate(this.m_date);
        }
    }

    public void addDateTimeChangeListener(WcmDateTimeChangeListener dateTimeListener) {
        this.listenerList.add(WcmDateTimeChangeListener.class, dateTimeListener);
    }

    public void removeDateTimeChangeListener(WcmDateTimeChangeListener dateTimeListener) {
        this.listenerList.remove(WcmDateTimeChangeListener.class, dateTimeListener);
    }

    private void fireDateChanged(Date date) {
        if (date == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WcmDateTimeChangeListener.class) continue;
            if (this.m_dateTimeFmt == 1) {
                ((WcmDateTimeChangeListener)listeners[i + 1]).dateChanged(date);
                continue;
            }
            if (this.m_dateTimeFmt != 0) continue;
            ((WcmDateTimeChangeListener)listeners[i + 1]).timeChanged(date);
        }
    }

    public void addButtonStateListener(WcmButtonStateListener btnStateListener) {
        this.listenerList.add(WcmButtonStateListener.class, btnStateListener);
    }

    public void removeButtonStateListener(WcmButtonStateListener btnStateListener) {
        this.listenerList.remove(WcmButtonStateListener.class, btnStateListener);
    }

    private void fireButtonStateChanged(boolean bEnable) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WcmButtonStateListener.class) continue;
            ((WcmButtonStateListener)listeners[i + 1]).buttonStateChanged(bEnable);
        }
    }

    private void initFieldPositions() {
        this.m_fieldPositions.clear();
        for (int idx = 0; idx < this.m_fieldTypes.length; ++idx) {
            FieldPosition fieldPos = new FieldPosition(this.m_fieldTypes[idx]);
            StringBuffer formattedField = new StringBuffer();
            this.m_dateFormat.format(this.m_date, formattedField, fieldPos);
            if (fieldPos.getEndIndex() <= 0) continue;
            this.m_fieldPositions.add(fieldPos);
        }
        this.m_fieldPositions.trimToSize();
        Collections.sort(this.m_fieldPositions, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((FieldPosition)obj1).getBeginIndex() - ((FieldPosition)obj2).getBeginIndex();
            }
        });
    }

    private void initDefaultField() {
        int caretLoc = 0;
        FieldPosition pos = this.getFieldPosition(7);
        if (pos != null) {
            caretLoc = pos.getBeginIndex();
        } else {
            pos = this.getFieldPosition(3);
            if (pos != null) {
                caretLoc = pos.getBeginIndex();
            }
        }
        this.m_caret.setDot(caretLoc);
        this.m_curField = pos.getField();
    }

    private void setCurField() {
        FieldPosition fieldPos = this.getField(this.m_caret.getDot());
        if (fieldPos != null) {
            if (fieldPos.getBeginIndex() != this.m_caret.getDot()) {
                this.m_caret.setDot(fieldPos.getBeginIndex());
            }
        } else {
            fieldPos = this.getPrevField(this.m_caret.getDot());
            if (fieldPos != null) {
                this.m_caret.setDot(fieldPos.getBeginIndex());
            } else {
                fieldPos = this.getFirstField();
                if (fieldPos != null) {
                    this.m_caret.setDot(fieldPos.getBeginIndex());
                }
            }
        }
        this.m_curField = fieldPos != null ? fieldPos.getField() : -1;
    }

    private FieldPosition getField(int caretLoc) {
        FieldPosition fieldPos = null;
        for (FieldPosition curPos : this.m_fieldPositions) {
            if (curPos.getBeginIndex() > caretLoc || curPos.getEndIndex() <= caretLoc) continue;
            fieldPos = curPos;
            break;
        }
        return fieldPos;
    }

    private FieldPosition getPrevField(int caretLoc) {
        FieldPosition fieldPos = this.getField(caretLoc);
        for (int idx = this.m_fieldPositions.size() - 1; idx > -1; --idx) {
            FieldPosition curPos = (FieldPosition)this.m_fieldPositions.get(idx);
            if (curPos.getEndIndex() > caretLoc) continue;
            fieldPos = curPos;
            break;
        }
        return fieldPos;
    }

    private FieldPosition getNextField(int caretLoc) {
        FieldPosition fieldPos = null;
        for (FieldPosition curPos : this.m_fieldPositions) {
            if (curPos.getBeginIndex() <= caretLoc) continue;
            fieldPos = curPos;
            break;
        }
        return fieldPos;
    }

    private FieldPosition getFirstField() {
        FieldPosition fieldPos = null;
        try {
            fieldPos = (FieldPosition)this.m_fieldPositions.get(0);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return fieldPos;
    }

    private FieldPosition getLastField() {
        FieldPosition fieldPos = null;
        try {
            fieldPos = (FieldPosition)this.m_fieldPositions.get(this.m_fieldPositions.size() - 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return fieldPos;
    }

    private FieldPosition getFieldPosition(int fieldId) {
        FieldPosition fieldPos = null;
        for (FieldPosition curPos : this.m_fieldPositions) {
            if (curPos.getField() != fieldId) continue;
            fieldPos = curPos;
            break;
        }
        return fieldPos;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        WcmDateTimeEditor calendarEditor = new WcmDateTimeEditor(new Date());
        panel.add((Component)calendarEditor, "First");
        frame.setContentPane(panel);
        frame.pack();
        Dimension dim = frame.getToolkit().getScreenSize();
        frame.setLocation(dim.height / 2 - frame.getWidth() / 2, dim.width / 2 - frame.getHeight() / 2);
        frame.show();
    }

    private class DeleteAction
    extends TextAction {
        DeleteAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    private class EndAction
    extends TextAction {
        EndAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            FieldPosition fieldPos;
            JTextComponent textComponent = this.getTextComponent(evt);
            if (textComponent != null && (fieldPos = WcmDateTimeEditor.this.getLastField()) != null) {
                textComponent.setCaretPosition(fieldPos.getBeginIndex());
            }
        }
    }

    private class HomeAction
    extends TextAction {
        HomeAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            FieldPosition fieldPos;
            JTextComponent textComponent = this.getTextComponent(evt);
            if (textComponent != null && (fieldPos = WcmDateTimeEditor.this.getFirstField()) != null) {
                textComponent.setCaretPosition(fieldPos.getBeginIndex());
            }
        }
    }

    private class RightAction
    extends TextAction {
        RightAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent textComponent = this.getTextComponent(evt);
            if (textComponent != null) {
                FieldPosition fieldPos = WcmDateTimeEditor.this.getNextField(textComponent.getCaretPosition());
                if (fieldPos != null) {
                    textComponent.setCaretPosition(fieldPos.getBeginIndex());
                } else {
                    fieldPos = WcmDateTimeEditor.this.getFirstField();
                    if (fieldPos != null) {
                        textComponent.setCaretPosition(fieldPos.getBeginIndex());
                    }
                }
                textComponent.getCaret().setMagicCaretPosition(null);
            }
        }
    }

    private class LeftAction
    extends TextAction {
        LeftAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent textComponent = this.getTextComponent(evt);
            if (textComponent != null) {
                int caretPos = textComponent.getCaretPosition();
                FieldPosition fieldPos = null;
                if (caretPos > 0) {
                    fieldPos = WcmDateTimeEditor.this.getPrevField(caretPos);
                    if (fieldPos != null) {
                        textComponent.setCaretPosition(fieldPos.getBeginIndex());
                    }
                } else {
                    fieldPos = WcmDateTimeEditor.this.getLastField();
                    if (fieldPos != null) {
                        textComponent.setCaretPosition(fieldPos.getBeginIndex());
                    }
                }
                textComponent.getCaret().setMagicCaretPosition(null);
            }
        }
    }

    private class UpDownAction
    extends AbstractAction {
        int m_direction;

        UpDownAction(int direction, String name) {
            super(name);
            this.m_direction = direction;
        }

        public void actionPerformed(ActionEvent evt) {
            this.updateDateTimeValue();
        }

        private void updateDateTimeValue() {
            boolean dateSet = true;
            WcmDateTimeEditor.this.m_bInitEditor = true;
            if (WcmDateTimeEditor.this.m_clear) {
                WcmDateTimeEditor.this.initDate(new Date());
                WcmDateTimeEditor.this.m_clear = false;
                WcmDateTimeEditor.this.fireDateChanged(WcmDateTimeEditor.this.m_date);
                WcmDateTimeEditor.this.fireButtonStateChanged(true);
                return;
            }
            String textVal = WcmDateTimeEditor.this.m_textField.getText();
            if (textVal == null || textVal.length() <= 0) {
                WcmDateTimeEditor.this.initDate(new Date());
                WcmDateTimeEditor.this.fireDateChanged(WcmDateTimeEditor.this.m_date);
                return;
            }
            Calendar timeCal = Calendar.getInstance();
            timeCal.setTime(WcmDateTimeEditor.this.m_date);
            switch (WcmDateTimeEditor.this.m_curField) {
                case 14: {
                    if (timeCal.get(9) == 0) {
                        timeCal.add(9, 1);
                        break;
                    }
                    timeCal.add(9, -1);
                    break;
                }
                case 3: {
                    WcmDateTimeEditor.this.m_calendar.add(5, this.m_direction);
                    break;
                }
                case 9: {
                    WcmDateTimeEditor.this.m_calendar.add(7, this.m_direction);
                    break;
                }
                case 11: {
                    WcmDateTimeEditor.this.m_calendar.add(8, this.m_direction);
                    break;
                }
                case 10: {
                    WcmDateTimeEditor.this.m_calendar.add(6, this.m_direction);
                    break;
                }
                case 0: {
                    dateSet = false;
                    break;
                }
                case 15: 
                case 16: {
                    timeCal.roll(10, this.m_direction);
                    break;
                }
                case 4: 
                case 5: {
                    timeCal.roll(11, this.m_direction);
                    break;
                }
                case 8: {
                    timeCal.add(14, this.m_direction);
                    break;
                }
                case 6: {
                    timeCal.roll(12, this.m_direction);
                    break;
                }
                case 2: {
                    WcmDateTimeEditor.this.m_calendar.add(2, this.m_direction);
                    break;
                }
                case 7: {
                    timeCal.roll(13, this.m_direction);
                    break;
                }
                case 13: {
                    WcmDateTimeEditor.this.m_calendar.add(4, this.m_direction);
                    break;
                }
                case 12: {
                    WcmDateTimeEditor.this.m_calendar.add(3, this.m_direction);
                    break;
                }
                case 1: {
                    WcmDateTimeEditor.this.m_calendar.add(1, this.m_direction);
                    break;
                }
                default: {
                    dateSet = false;
                }
            }
            if (dateSet) {
                int fieldId = WcmDateTimeEditor.this.m_curField;
                WcmDateTimeEditor.this.m_calendar.set(11, timeCal.get(11));
                WcmDateTimeEditor.this.m_calendar.set(12, timeCal.get(12));
                WcmDateTimeEditor.this.m_calendar.set(13, timeCal.get(13));
                WcmDateTimeEditor.this.m_calendar.set(14, timeCal.get(14));
                WcmDateTimeEditor.this.m_date = WcmDateTimeEditor.this.m_calendar.getTime();
                WcmDateTimeEditor.this.initDate(WcmDateTimeEditor.this.m_date);
                FieldPosition fieldPos = WcmDateTimeEditor.this.getFieldPosition(fieldId);
                if (fieldPos != null) {
                    WcmDateTimeEditor.this.m_caret.setDot(fieldPos.getBeginIndex());
                }
                WcmDateTimeEditor.this.m_textField.requestFocus();
                WcmDateTimeEditor.this.repaint();
                WcmDateTimeEditor.this.fireDateChanged(WcmDateTimeEditor.this.m_date);
            }
        }
    }
}

