/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.Choice;
import com.filenet.wcm.api.ChoiceList;
import com.filenet.wcm.api.Marking;
import com.filenet.wcm.api.MarkingSet;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionDateTime;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionFloat64;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionInteger32;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionString;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class WcmCtrlFactoryUtil {
    public static String toString(String clsName, VerbosePropertyDescription verbosePropertyDesc) {
        String propName = null;
        int dataType = -1;
        if (verbosePropertyDesc != null) {
            propName = verbosePropertyDesc.getName();
            dataType = verbosePropertyDesc.getDataType();
        }
        return "[Component: " + clsName + ", Property Name: " + propName + ", Data Type: " + dataType + "]";
    }

    public static WcmException checkStringLength(VerbosePropertyDescription data, String strValue) {
        Integer maxLength;
        if (strValue != null && data.getDataType() == 8 && (maxLength = ((VerbosePropertyDescriptionString)data).getMaximumLengthString()) != null && maxLength != -1 && strValue.length() > maxLength) {
            return new WcmException("client.WcmCtrlFactoryUtil.ValidateStringLengthError", "Length of string {0} is longer than {1}", (Object)strValue, (Object)maxLength);
        }
        return null;
    }

    public static WcmException checkFolderName(VerbosePropertyDescription data, String strValue) {
        if (strValue != null && data.getDataType() == 8) {
            char[] folderName = strValue.toCharArray();
            String invalidStrings = new String("\\/:*?\"<>|");
            char[] invalidChars = invalidStrings.toCharArray();
            for (int i = folderName.length - 1; i >= 0; --i) {
                for (int j = invalidChars.length - 1; j >= 0; --j) {
                    if (folderName[i] != invalidChars[j]) continue;
                    return new WcmException("client.WcmCtrlFactoryUtil.ValidateFolderNameError", "String \"{0}\" contains invalid characters ({1})", (Object)strValue, (Object)invalidStrings);
                }
            }
        }
        return null;
    }

    public static WcmException checkGUIDFormat(VerbosePropertyDescription data, String strValue) {
        if (strValue != null && strValue.length() != 0 && data.getDataType() == 5) {
            int guidLen = strValue.length();
            if (guidLen == 38 || guidLen == 36) {
                char[] guid = strValue.toCharArray();
                int dash1 = 8;
                int dash2 = 13;
                int dash3 = 18;
                int dash4 = 23;
                boolean success = true;
                if (guidLen == 38) {
                    if (guid[0] == '{' && guid[37] == '}') {
                        ++dash1;
                        ++dash2;
                        ++dash3;
                        ++dash4;
                        --guidLen;
                    } else {
                        success = false;
                    }
                }
                if (success && guid[dash1] == '-' && guid[dash2] == '-' && guid[dash3] == '-' && guid[dash4] == '-') {
                    int idx;
                    for (idx = guidLen - 1; idx > 0; --idx) {
                        if (idx == dash4 || idx == dash3 || idx == dash2 || idx == dash1) {
                            --idx;
                        }
                        if (!(guid[idx] >= 'a' && guid[idx] <= 'f' || guid[idx] >= 'A' && guid[idx] <= 'F' || guid[idx] >= '0' && guid[idx] <= '9')) break;
                    }
                    if (idx == 0) {
                        return null;
                    }
                }
            }
            return new WcmException("client.WcmCtrlFactoryUtil.ValidateGUIDFormatError", "String {0} is not a valid GUID", (Object)strValue);
        }
        return null;
    }

    public static WcmException checkIntegerRange(VerbosePropertyDescription data, String value) {
        if (data.getDataType() == 6) {
            Integer minValue = ((VerbosePropertyDescriptionInteger32)data).getPropertyMinimumInteger32();
            Integer maxValue = ((VerbosePropertyDescriptionInteger32)data).getPropertyMaximumInteger32();
            if (maxValue != null && minValue != null && (Integer.valueOf(value) < minValue || Integer.valueOf(value) > maxValue)) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateIntegerRangeError", "The value is not within the range of {0} to {1}.", minValue, (Object)maxValue);
            }
            if (minValue != null && Integer.valueOf(value) < minValue) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateMinIntegerError", "Value {0} is less than {1}", (Object)value, (Object)minValue);
            }
            if (maxValue != null && Integer.valueOf(value) > maxValue) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateMaxIntegerError", "Value {0} is greater than {1}.", (Object)value, (Object)maxValue);
            }
        }
        return null;
    }

    public static WcmException checkDoubleRange(VerbosePropertyDescription data, String value) {
        if (data.getDataType() == 4) {
            Double minValue = ((VerbosePropertyDescriptionFloat64)data).getPropertyMinimumFloat64();
            Double maxValue = ((VerbosePropertyDescriptionFloat64)data).getPropertyMaximumFloat64();
            if (maxValue != null && minValue != null && (Double.valueOf(value) < minValue || Double.valueOf(value) > maxValue)) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateDoubleRangeError", "The value is not within the range of {0} to {1}.", minValue, (Object)maxValue);
            }
            if (minValue != null && Double.valueOf(value) < minValue) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateMinDoubleError", "Value {0} is less than {1}.", (Object)value, (Object)minValue);
            }
            if (maxValue != null && Double.valueOf(value) > maxValue) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateMaxDoubleError", "Value {0} is greater than {1}.", (Object)value, (Object)maxValue);
            }
        }
        return null;
    }

    public static WcmException checkMinMaxDate(VerbosePropertyDescription data, Date value) {
        if (data.getDataType() == 3 && value != null) {
            Date minValue = ((VerbosePropertyDescriptionDateTime)data).getPropertyMinimumDateTime();
            Date maxValue = ((VerbosePropertyDescriptionDateTime)data).getPropertyMaximumDateTime();
            if (maxValue != null && minValue != null && (value.before(minValue) || value.after(maxValue))) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateDateRangeError", "The value is not within the range of {0} to {1}.", minValue, (Object)maxValue);
            }
            if (minValue != null && value.before(minValue)) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateMinDateError", "Value {0} is less than {1}", value, (Object)minValue);
            }
            if (maxValue != null && value.after(maxValue)) {
                return new WcmException("client.WcmCtrlFactoryUtil.ValidateMaxDateError", "Value {0} is greater than {1}.", value, (Object)maxValue);
            }
        }
        return null;
    }

    public static Object getListElement(Object value) {
        Object listElem = value;
        if (listElem instanceof Value) {
            listElem = ((Value)value).getValue();
        }
        if (listElem instanceof Date) {
            listElem = DateFormat.getDateTimeInstance().format((Date)listElem);
        }
        return listElem;
    }

    public static Object getObject(VerbosePropertyDescription data, Object value) {
        Object objValue = value;
        try {
            if (data.getDataType() == 6) {
                objValue = PropertyUtil.getInteger(value);
            } else if (data.getDataType() == 4) {
                objValue = PropertyUtil.getDouble(value);
            } else if (data.getDataType() == 2) {
                objValue = PropertyUtil.getBoolean(value);
            } else if (data.getDataType() == 3) {
                objValue = PropertyUtil.getDate(value);
            }
        }
        catch (WcmException ex) {
            System.out.println("ControlFactoryUtil:getObject:WcmException : " + ex.getMessage());
        }
        catch (NumberFormatException ex) {
            System.out.println("ControlFactoryUtil:getObject:NumberFormatException : " + ex.getMessage());
        }
        return objValue;
    }

    public static Object getObject(VerbosePropertyDescription data, String value) {
        return WcmCtrlFactoryUtil.getObject(data, (Object)value);
    }

    public static Object[] getChoiceItems(VerbosePropertyDescription property) {
        Object[] values = null;
        ChoiceList choiceList = null;
        try {
            PropertyDescription propDesc = property.getPropertyDescription();
            choiceList = propDesc.getChoices(0);
        }
        catch (Exception e) {
            System.out.println("Control Factory Util:getSingleLevelChoiceException: " + e.getLocalizedMessage());
        }
        if (choiceList != null) {
            Object value = WcmCtrlFactoryUtil.populateChoiceItems(choiceList, property);
            values = value == null ? new Object[]{new String("")} : (Object[])value;
        } else {
            System.out.println("Control Factory Util:getChoiceListValues: null choice list");
        }
        return values;
    }

    public static boolean hasMarkingItemRemoveRight(VerbosePropertyDescription property, String markingItemValue) {
        Object markingValues = null;
        MarkingSet mSet = null;
        Values vals = null;
        if (markingItemValue == null || markingItemValue.length() == 0) {
            return true;
        }
        try {
            mSet = property.getMarkingSet();
            if (mSet == null) {
                mSet = (MarkingSet)property.getPropertyDescription().getPropertyValue("MarkingSet");
            }
            if (mSet != null) {
                vals = mSet.getPropertyValuesValue("Markings");
            }
        }
        catch (Exception e) {
            return true;
        }
        if (vals != null) {
            for (Value vMarking : vals) {
                Marking marking = (Marking)vMarking.getValue();
                if (marking.getMarkingValue().compareTo(markingItemValue) != 0) continue;
                int nAccessMask = marking.getAccessMask();
                return (nAccessMask & 0x4000000) != 0;
            }
        }
        return true;
    }

    public static Object[] getMarkingItems(VerbosePropertyDescription property, boolean bFilterAccess) {
        String[] markingValues = null;
        MarkingSet mSet = null;
        Values vals = null;
        try {
            mSet = property.getMarkingSet();
            if (mSet == null) {
                mSet = (MarkingSet)property.getPropertyDescription().getPropertyValue("MarkingSet");
            }
            if (mSet != null) {
                vals = mSet.getPropertyValuesValue("Markings");
            }
        }
        catch (Exception e) {
            System.out.println("Control Factory Util:getMarkingSetItemsException: " + e.getLocalizedMessage());
        }
        if (vals != null) {
            if (vals.size() == 0) {
                markingValues = new String[]{""};
            } else {
                int nMarkingItemNum = 0;
                if (bFilterAccess) {
                    for (Value vMarking : vals) {
                        Marking marking = (Marking)vMarking.getValue();
                        int nAccessMask = marking.getAccessMask();
                        if ((nAccessMask & 0x2000000) == 0 || (nAccessMask & 0x4000000) == 0 || (nAccessMask & 0x8000000) == 0) continue;
                        ++nMarkingItemNum;
                    }
                } else {
                    nMarkingItemNum = vals.size();
                }
                if (nMarkingItemNum == 0) {
                    markingValues = new String[]{""};
                } else {
                    markingValues = new String[nMarkingItemNum];
                    int idx = 0;
                    for (Value vMarking : vals) {
                        Marking marking = (Marking)vMarking.getValue();
                        int nAccessMask = marking.getAccessMask();
                        if (bFilterAccess) {
                            if ((nAccessMask & 0x2000000) == 0 || (nAccessMask & 0x4000000) == 0 || (nAccessMask & 0x8000000) == 0) continue;
                            markingValues[idx++] = marking.getMarkingValue();
                            continue;
                        }
                        markingValues[idx++] = marking.getMarkingValue();
                    }
                }
            }
        } else {
            System.out.println("Control Factory Util:getMarkingSetItems: null marking set.");
        }
        return markingValues;
    }

    private static Object populateChoiceItems(ChoiceList cList, VerbosePropertyDescription property) {
        String[] cValues = null;
        if (cList != null && cList.size() > 0) {
            cValues = new String[cList.size()];
            Iterator it = cList.iterator();
            int i = 0;
            while (it.hasNext()) {
                Choice choice = (Choice)it.next();
                if (property.getDataType() == 8) {
                    cValues[i++] = choice.getStringValue();
                    continue;
                }
                if (property.getDataType() != 6) continue;
                cValues[i++] = choice.getValue().toString();
            }
        }
        return cValues;
    }

    public static String getChoiceTitle(VerbosePropertyDescription propDesc, boolean prefix) {
        ChoiceList cList;
        String title = "";
        if (prefix) {
            title = WcmUIComponentResource.ChoiceTitle;
        }
        if (propDesc != null && (cList = propDesc.getPropertyDescription().getChoices(0)) != null && cList.size() > 0) {
            title = title + cList.getName();
        }
        return title;
    }

    public static Object[] getSelectedItems(WcmMVCtrl mvCtrl) {
        Object objValue = mvCtrl.getValue();
        Object[] arrayItems = null;
        if (objValue != null) {
            if (objValue instanceof Date) {
                arrayItems = new Object[]{WcmCtrlFactoryUtil.getListElement(objValue)};
            } else if (objValue instanceof Object[]) {
                Object[] values = (Object[])objValue;
                arrayItems = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    arrayItems[i] = WcmCtrlFactoryUtil.getListElement(values[i]);
                }
            } else if (objValue instanceof List) {
                List values = (List)objValue;
                arrayItems = new Object[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    arrayItems[i] = WcmCtrlFactoryUtil.getListElement(values.get(i));
                }
            } else {
                arrayItems = new Object[]{WcmCtrlFactoryUtil.getListElement(objValue)};
            }
        }
        return arrayItems;
    }

    public static void fireEditingStopped(EventListenerList listenerList, JComponent comp, ActionEvent evt) {
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WcmCtrlfActionListener.class) continue;
            ((WcmCtrlfActionListener)listeners[i + 1]).ctrlEditingStopped(comp, evt);
        }
    }
}

