/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.Choice;
import com.filenet.wcm.api.ChoiceList;
import com.filenet.wcm.api.ChoiceLists;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionFactory;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionOperators;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionString;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmComboBox;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmListPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmNumericTextField;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmSVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmStringTextField;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmTextAreaPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUserComponent;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.Container;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class WcmCtrlFactory {
    private Container parentContainer;
    private VerbosePropertyDescription property;
    private SearchPropertyDescription searchPropDesc;
    private int mode = 0;
    private int flag;
    private boolean m_bFilterMarkings = true;
    private Object m_valueForComponent = null;
    private int m_objType = 0;
    private String defaultOS;
    private static final String CREATOR = "Creator";
    private static final String LAST_MODIFIER = "LastModifier";
    private static final String LOCK_OWNER = "LockOwner";
    private static final WcmString wsDelim = new WcmString("client.WcmCtrlFactory.delimitor", " > ");

    public void setMode(int mode, int flag) throws WcmException {
        if (mode != 0 && mode != 1) {
            throw new WcmException("client.WcmCtrlFactory.setModeError", "Expecting SIMPLE_UI or COMPLEX_UI mode value ");
        }
        this.mode = mode;
        this.flag = flag;
    }

    public void setDefaultOS(String newDefaultOS) {
        this.defaultOS = newDefaultOS;
    }

    public void setMarkingFilterMode(boolean bMarkingFilterMode) {
        this.m_bFilterMarkings = bMarkingFilterMode;
    }

    public boolean getMarkingFilterMode() {
        return this.m_bFilterMarkings;
    }

    public WcmUIComponent getUIComponent(Container frame, PropertyDescription propertyDescr) throws WcmException {
        if (frame == null || propertyDescr == null) {
            throw new WcmException("client.WcmCtrlFactory.getUIComponent", "Parameters cannot be null");
        }
        WcmUIComponent theComponent = null;
        theComponent = this.initComponent(frame, propertyDescr);
        return theComponent;
    }

    public WcmUIComponent getUIComponent(Container frame, PropertyDescription propertyDescr, Object objectValue) throws WcmException {
        this.m_valueForComponent = objectValue;
        return this.getUIComponent(frame, propertyDescr);
    }

    public WcmUIComponent getSingleLineTextComponent(Container frame, PropertyDescription propertyDescr, boolean isFldrObj) throws WcmException {
        if (frame == null || propertyDescr == null) {
            throw new WcmException("client.WcmCtrlFactory.Parameterscannotbenull", "Parameters cannot be null");
        }
        WcmStringTextField theComponent = null;
        try {
            this.parentContainer = frame;
            this.property = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription(propertyDescr);
            if (this.property.getDataType() != 8) {
                throw new WcmException("client.WcmCtrlFactory.Invaliddatatype", "Invalid data type");
            }
            theComponent = new WcmStringTextField(this.property, isFldrObj);
            if (theComponent != null) {
                ((JTextComponent)theComponent).setEditable(this.isEditable());
            }
        }
        catch (Exception ex) {
            throw new WcmException("client.WcmCtrlFactory.Errorencountered", "Error {0} encountered", (Object)ex.getMessage());
        }
        return theComponent;
    }

    public WcmUIComponent getUIComponent(Container frame, SearchPropertyDescription propertyDescr) throws WcmException {
        if (frame == null || propertyDescr == null) {
            throw new WcmException("client.WcmCtrlFactory.getUIComponent", "Parameters cannot be null");
        }
        WcmUIComponent theComponent = null;
        this.searchPropDesc = propertyDescr;
        this.setMarkingFilterMode(false);
        theComponent = this.initComponent(this.parentContainer, (PropertyDescription)propertyDescr);
        return theComponent;
    }

    public WcmUIComponent getUIComponent(Container frame, SearchPropertyDescription propertyDescr, int objType) throws WcmException {
        this.m_objType = objType;
        if (frame == null || propertyDescr == null) {
            throw new WcmException("client.WcmCtrlFactory.getUIComponent", "Parameters cannot be null");
        }
        WcmUIComponent theComponent = null;
        this.searchPropDesc = propertyDescr;
        this.setMarkingFilterMode(false);
        theComponent = this.initComponent(this.parentContainer, (PropertyDescription)propertyDescr);
        return theComponent;
    }

    public WcmUIComponent getUIComponent(Container frame, Property inProperty, PropertyDescription propertyDescr, boolean addIsEqualForOVP) throws WcmException {
        if (frame == null || inProperty == null || propertyDescr == null) {
            throw new WcmException("client.WcmCtrlFactory.getUIComponent", "Parameters cannot be null");
        }
        WcmComboBox theComponent = null;
        Object[] values = null;
        try {
            if (!inProperty.getName().equals("QueryOperatorDescriptions")) {
                throw new WcmException("client.WcmCtrlFactory.unsupportedproperty", "Unsupported property");
            }
            VerbosePropertyDescription propDesc = new VerbosePropertyDescription(propertyDescr);
            values = this.getQueryOperatorValues(propDesc, addIsEqualForOVP);
            this.parentContainer = frame;
            this.property = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription(propertyDescr);
        }
        catch (Exception ex) {
            throw new WcmException("client.WcmCtrlFactory.getverbosepropdesc", "Error {0} encountered", (Object)ex.getMessage());
        }
        theComponent = new WcmComboBox(values);
        return theComponent;
    }

    private WcmUIComponent initComponent(Container frame, PropertyDescription propertyDescr) throws WcmException {
        WcmUIComponent theComponent = null;
        try {
            this.parentContainer = frame;
            this.property = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription(propertyDescr);
            theComponent = this.mode == 1 ? this.getComplexUI() : this.getSimpleUI();
        }
        catch (RuntimeException ex) {
            throw new WcmException("client.WcmCtrlFactory.initComponent", "Error {0} encountered", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            throw new WcmException("client.WcmCtrlFactory.initComponent", "Error {0} encountered", (Object)ex.getMessage());
        }
        return theComponent;
    }

    private TreeMap getBooleanMap() throws Exception {
        TreeMap<String, String> choiceMap = new TreeMap<String, String>();
        choiceMap.put(WcmUIComponentResource.falseString, "false");
        choiceMap.put(WcmUIComponentResource.trueString, "true");
        return choiceMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WcmUIComponent getSimpleUI() {
        WcmUIComponent theComponent = null;
        if (this.property == null) return theComponent;
        if (this.property.getDataType() == 2) {
            try {
                return this.getComboBoxComponent(this.getBooleanMap());
            }
            catch (Exception e) {
                return this.getComboBoxComponent(WcmUIComponentResource.boolStrings);
            }
        }
        if (this.property.getDataType() == 3) {
            return this.getSVCtrl();
        }
        if (this.property.getHasCVL()) {
            return this.getChoiceComponent();
        }
        if (this.property.getHasMarkingSet(this.m_objType)) {
            return this.getMarkingSetComponent();
        }
        if (this.property.getName().compareToIgnoreCase(WcmResourceString.s_versionStatusSymbolicName) == 0) {
            return this.getVersionStatusComponent();
        }
        if (this.property.getName().compareToIgnoreCase(CREATOR) == 0) return this.getSVCtrl();
        if (this.property.getName().compareToIgnoreCase(LAST_MODIFIER) == 0) return this.getSVCtrl();
        if (this.property.getName().compareToIgnoreCase(LOCK_OWNER) != 0) return this.getTextFieldComponent();
        return this.getSVCtrl();
    }

    private WcmUIComponent getComplexUI() {
        WcmUIComponent theComponent = null;
        if (this.property != null) {
            if (this.property.getCardinality() == 0) {
                if (this.isEditable()) {
                    theComponent = this.getSimpleUI();
                } else {
                    if (this.property.getDataType() == 8 && ((VerbosePropertyDescriptionString)this.property).getMaximumLengthString() != null && ((VerbosePropertyDescriptionString)this.property).getMaximumLengthString() > 80) {
                        theComponent = this.getTextAreaComponent();
                        ((WcmTextAreaPanel)theComponent).applyComponentOrientation(this.parentContainer.getComponentOrientation());
                    } else {
                        theComponent = new WcmStringTextField(this.property);
                    }
                    if (theComponent != null) {
                        if (theComponent instanceof JTextComponent) {
                            ((JTextComponent)((Object)theComponent)).setEditable(false);
                        } else {
                            ((JComponent)((Object)theComponent)).setEnabled(false);
                        }
                    }
                }
            } else if (this.property.getCardinality() == 2 || this.property.getCardinality() == 1) {
                if (!this.isEditable()) {
                    theComponent = this.getListComponent();
                    ((JComponent)((Object)theComponent)).setEnabled(false);
                } else {
                    theComponent = this.getMVCtrl();
                }
            } else {
                theComponent = this.getTextFieldComponent();
                if (theComponent != null) {
                    ((JTextComponent)((Object)theComponent)).setEditable(this.isEditable());
                }
            }
        }
        return theComponent;
    }

    private WcmUIComponent getTextFieldComponent() {
        WcmUIComponent theComponent = null;
        if (this.property.getDataType() == 8 || this.property.getDataType() == 5) {
            if (this.mode == 1 && this.property.getDataType() == 8 && ((VerbosePropertyDescriptionString)this.property).getMaximumLengthString() != null && ((VerbosePropertyDescriptionString)this.property).getMaximumLengthString() > 80) {
                theComponent = this.getTextAreaComponent();
                ((WcmTextAreaPanel)theComponent).applyComponentOrientation(this.parentContainer.getComponentOrientation());
            } else {
                theComponent = new WcmStringTextField(this.property);
            }
        } else if (this.property.getDataType() == 4 || this.property.getDataType() == 6) {
            theComponent = new WcmNumericTextField(this.property);
            DecimalFormat format = new DecimalFormat();
            if (this.property.getDataType() == 4) {
                format.setParseIntegerOnly(false);
            } else {
                format.setParseIntegerOnly(true);
            }
            ((WcmNumericTextField)theComponent).setFormat(format);
        } else {
            System.out.println("Control Factory:getTextFieldComponent:Unhandled data type exception (" + this.property.getDataType() + ")");
        }
        return theComponent;
    }

    private WcmUIComponent getTextAreaComponent() {
        return new WcmTextAreaPanel(this.property);
    }

    private WcmUIComponent getListComponent() {
        return new WcmListPanel(this.property);
    }

    private WcmUIComponent getComboBoxComponent(Object[] values) {
        WcmComboBox theComponent = null;
        theComponent = new WcmComboBox(this.property, values);
        return theComponent;
    }

    private WcmUIComponent getComboBoxComponent(TreeMap values) {
        WcmComboBox theComponent = null;
        theComponent = new WcmComboBox(this.property, values);
        return theComponent;
    }

    private WcmUIComponent getSVCtrl() {
        return new WcmSVCtrl(this.parentContainer, this.property);
    }

    private WcmUIComponent getMVCtrl() {
        return new WcmMVCtrl(this.parentContainer, this.property);
    }

    private boolean isEditable() {
        boolean bEditable = false;
        if ((this.flag & 2) != 0) {
            bEditable = false;
        } else {
            int settability = this.property.getSettability();
            switch (settability) {
                case 1: {
                    if ((this.flag & 1) == 0 && (this.flag & 4) == 0) break;
                    bEditable = true;
                    break;
                }
                case 2: {
                    if ((this.flag & 1) == 0) break;
                    bEditable = true;
                    break;
                }
                case 3: {
                    bEditable = false;
                    break;
                }
                case 0: {
                    bEditable = true;
                    break;
                }
                default: {
                    bEditable = true;
                }
            }
        }
        return bEditable;
    }

    private WcmUIComponent getVersionStatusComponent() {
        try {
            return this.getComboBoxComponent(this.getVersionStatusMap());
        }
        catch (Exception e) {
            return null;
        }
    }

    private TreeMap getVersionStatusMap() throws Exception {
        TreeMap<String, String> choiceMap = new TreeMap<String, String>();
        choiceMap.put(WcmResourceString.s_versionStatusReleased, "1");
        choiceMap.put(WcmResourceString.s_versionStatusInProcess, "2");
        choiceMap.put(WcmResourceString.s_versionStatusReserved, "3");
        choiceMap.put(WcmResourceString.s_versionStatusSuperseded, "4");
        return choiceMap;
    }

    private WcmUIComponent getCreatorComponent() {
        WcmUserComponent theComponent = new WcmUserComponent(this.searchPropDesc);
        return theComponent;
    }

    private WcmUIComponent getChoiceComponent() {
        WcmUIComponent theComponent = null;
        theComponent = this.searchPropDesc != null ? this.getComboBoxComponent(this.getSearchScopeChoice()) : (this.property.getIsHierarchicalCVL() ? this.getSVCtrl() : this.getComboBoxComponent(WcmCtrlFactoryUtil.getChoiceItems(this.property)));
        return theComponent;
    }

    private WcmUIComponent getReadOnlyMarkingSetComponent() {
        WcmStringTextField theComponent = null;
        theComponent = new WcmStringTextField(this.property);
        if (theComponent != null) {
            ((JTextComponent)theComponent).setEditable(false);
        }
        return theComponent;
    }

    private WcmUIComponent getMarkingSetComponent() {
        WcmUIComponent theComponent = null;
        theComponent = false == this.m_bFilterMarkings || true == WcmCtrlFactoryUtil.hasMarkingItemRemoveRight(this.property, (String)this.m_valueForComponent) ? this.getComboBoxComponent(WcmCtrlFactoryUtil.getMarkingItems(this.property, this.m_bFilterMarkings)) : this.getReadOnlyMarkingSetComponent();
        return theComponent;
    }

    private ChoiceList getChoiceList(String objectStoreID, String cvlValueID, int depth) throws Exception {
        Session sess = this.searchPropDesc.getSession();
        ObjectStore os = ObjectFactory.getObjectStore((String)objectStoreID, (Session)sess);
        Vector<String> vec = new Vector<String>();
        vec.add(cvlValueID);
        ChoiceLists choices = os.getChoiceLists(vec, depth);
        ChoiceList myChoiceList = null;
        if (choices.size() > 0) {
            myChoiceList = (ChoiceList)choices.get(0);
        }
        return myChoiceList;
    }

    private TreeMap getChoiceMap(ChoiceList chList, Locale locale) throws Exception {
        TreeMap<String, String> choiceMap = new TreeMap<String, String>(new ComparatorWithNum());
        if (chList != null) {
            this.doChoiceList(chList, null, choiceMap, locale);
            return choiceMap;
        }
        choiceMap.put("", "");
        return choiceMap;
    }

    protected void doChoiceList(ChoiceList o, String parentValue, TreeMap choiceMap, Locale locale) throws Exception {
        int size = o.size();
        for (int i = 0; i < size; ++i) {
            Choice c = (Choice)o.get(i);
            this.doChoice(c, parentValue, choiceMap, locale);
        }
    }

    private void doChoice(Choice parentChoice, String parentValue, TreeMap choiceMap, Locale locale) throws PropertyNotFoundException, Exception {
        String parentLabel = parentChoice.getLabel();
        if (parentChoice.hasContainedChoices()) {
            ChoiceList choiceList = parentChoice.getContainedChoices();
            if (parentValue == null) {
                this.doChoiceList(choiceList, parentLabel, choiceMap, locale);
            } else {
                String label = parentValue + wsDelim.toString(locale) + parentLabel;
                this.doChoiceList(choiceList, label, choiceMap, locale);
            }
        } else {
            String stringValue = parentChoice.getStringValue();
            if (stringValue == null) {
                stringValue = "null";
            }
            String label = parentLabel;
            if (parentValue != null) {
                label = parentValue + wsDelim.toString(locale) + label;
            }
            choiceMap.put(label, stringValue);
        }
    }

    private TreeMap getSearchScopeChoice() {
        if (this.searchPropDesc != null) {
            Object id = null;
            try {
                VerbosePropertyDescription vProp = new VerbosePropertyDescription((PropertyDescription)this.searchPropDesc);
                vProp.setDefaultOS(this.defaultOS);
                PropertyDescription pDesc = vProp.getStandardPropDescr(this.searchPropDesc, 0);
                ChoiceList choiceList = pDesc.getChoices(-1);
                return this.getChoiceMap(choiceList, Locale.getDefault());
            }
            catch (Exception e) {
                System.out.println("Control Factory:getChoiceListValuesException: " + e.getLocalizedMessage());
            }
        }
        return null;
    }

    private Object[] TJLgetSearchScopeChoice() {
        Object[] values = null;
        if (this.searchPropDesc != null) {
            ChoiceList choiceList = null;
            try {
                VerbosePropertyDescription vProp = new VerbosePropertyDescription((PropertyDescription)this.searchPropDesc);
                PropertyDescription pDesc = vProp.getStandardPropDescr(this.searchPropDesc, 0);
                choiceList = pDesc.getChoices(1);
            }
            catch (Exception e) {
                System.out.println("Control Factory:getChoiceListValuesException: " + e.getLocalizedMessage());
            }
            if (choiceList != null && choiceList.size() > 0) {
                values = new String[choiceList.size()];
                Iterator it = choiceList.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Choice choice = (Choice)it.next();
                    values[i++] = choice.getStringValue();
                }
            }
        }
        if (values == null) {
            values = new Object[]{new String("")};
        }
        return values;
    }

    private Object[] getQueryOperatorValues(VerbosePropertyDescription propDesc, boolean addIsEqualForOVP) throws Exception {
        Object[] values = null;
        ArrayList<String> valuesList = new ArrayList<String>();
        boolean bOVP = false;
        if (propDesc.getDataType() == 7) {
            bOVP = true;
        }
        Properties queryProps = null;
        queryProps = propDesc.getQueryOperatorDescriptions();
        VerbosePropertyDescriptionOperators vpdo = new VerbosePropertyDescriptionOperators(queryProps);
        if (vpdo.supportsEqual() || addIsEqualForOVP && bOVP) {
            valuesList.add(new String(WcmResourceString.s_equalStr));
        }
        if (vpdo.supportsNotEqual()) {
            valuesList.add(new String(WcmResourceString.s_notEqualStr));
        }
        if (vpdo.supportsGreaterThanOrEqual()) {
            valuesList.add(new String(WcmResourceString.s_greaterThanEqualStr));
        }
        if (vpdo.supportsGreaterThen()) {
            valuesList.add(new String(WcmResourceString.s_greaterThanStr));
        }
        if (vpdo.supportsLessnThanOrEqual()) {
            valuesList.add(new String(WcmResourceString.s_lessThanEqualStr));
        }
        if (vpdo.supportsLessThan()) {
            valuesList.add(new String(WcmResourceString.s_lessThanStr));
        }
        if (vpdo.supportsIsNull()) {
            if (bOVP) {
                valuesList.add(new String(WcmResourceString.s_isDefinedStr));
            } else {
                valuesList.add(new String(WcmResourceString.s_isNullStr));
            }
        }
        if (vpdo.supportsNotNull()) {
            if (bOVP) {
                valuesList.add(new String(WcmResourceString.s_isNotDefinedStr));
            } else {
                valuesList.add(new String(WcmResourceString.s_isNotNullStr));
            }
        }
        if (vpdo.supportsLike()) {
            valuesList.add(new String(WcmResourceString.s_likeStr));
        }
        if (vpdo.supportsNotLike()) {
            valuesList.add(new String(WcmResourceString.s_notLikeStr));
        }
        if (vpdo.supportsIn() && propDesc.getCardinality() == 2) {
            valuesList.add(new String(WcmResourceString.s_inStr));
        }
        values = valuesList.toArray();
        return values;
    }

    private static class ComparatorWithNum
    implements Comparator {
        private ComparatorWithNum() {
        }

        public int compare(Object element1, Object element2) {
            String str1 = element1.toString();
            String str2 = element2.toString();
            try {
                Integer Int1 = Integer.valueOf(str1);
                Integer Int2 = Integer.valueOf(str2);
                return Int2.compareTo(Int1);
            }
            catch (Exception ex) {
                return str1.compareTo(str2);
            }
        }
    }
}

