/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.apps.client.search.ui.BidiComboBoxRenderer;
import com.filenet.wcm.apps.client.util.WcmCtrlfActionListener;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;

public class WcmComboBox
extends JComboBox
implements WcmUIComponent,
ActionListener {
    protected VerbosePropertyDescription data = null;
    protected DefaultComboBoxModel model;
    private EventListenerList listenerList = new EventListenerList();
    private String curValue = new String(" ");
    private TreeMap listMap = null;

    public WcmComboBox(VerbosePropertyDescription theData, Object[] values) {
        this(values);
        this.data = theData;
        this.model.insertElementAt(" ", 0);
        this.model.setSelectedItem(this.model.getElementAt(0));
    }

    public WcmComboBox(VerbosePropertyDescription theData, TreeMap values) {
        this(values);
        this.data = theData;
        this.model.insertElementAt(" ", 0);
        this.model.setSelectedItem(this.model.getElementAt(0));
    }

    public WcmComboBox(Object[] values) {
        this.model = new DefaultComboBoxModel();
        this.setModel(this.model);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.model.addElement(values[i]);
            }
        }
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.setEditable(false);
        this.addActionListener(this);
        this.setRenderer(new BidiComboBoxRenderer());
    }

    public WcmComboBox(TreeMap map) {
        this.listMap = map;
        Object values = null;
        this.model = new DefaultComboBoxModel();
        this.setModel(this.model);
        for (Map.Entry entry : map.entrySet()) {
            String choiceLabel = (String)entry.getKey();
            this.model.addElement(choiceLabel);
            String choiceValue = (String)entry.getValue();
        }
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.setEditable(false);
        this.addActionListener(this);
        this.setRenderer(new BidiComboBoxRenderer());
    }

    public Object getDisplayValue() {
        if (this.data == null) {
            return this.getSelectedIndex() >= 0 ? this.getSelectedItem().toString() : null;
        }
        if (this.getSelectedIndex() <= 0) {
            return null;
        }
        String val = this.getSelectedItem().toString();
        try {
            Integer propInt32 = Integer.valueOf(val);
        }
        catch (Exception ex) {
            return val;
        }
        return WcmCtrlFactoryUtil.getObject(this.data, val);
    }

    public Object getValue() {
        if (this.data == null) {
            return this.getSelectedIndex() >= 0 ? this.getSelectedItem().toString() : null;
        }
        if (this.getSelectedIndex() <= 0) {
            return null;
        }
        String regularval = this.getSelectedItem().toString();
        String val = null;
        if (this.listMap != null) {
            for (Map.Entry entry : this.listMap.entrySet()) {
                String choiceLabel = (String)entry.getKey();
                String choiceValue = (String)entry.getValue();
                if (choiceLabel == null || choiceLabel.compareTo(regularval) != 0) continue;
                val = choiceValue;
            }
        } else {
            val = regularval;
        }
        try {
            Integer propInt32 = Integer.valueOf(val);
        }
        catch (Exception ex) {
            return val;
        }
        return WcmCtrlFactoryUtil.getObject(this.data, val);
    }

    public WcmException validateValue() {
        return null;
    }

    public void setValue(Object value) throws WcmException {
        if (value != null && value instanceof Object) {
            if (this.listMap == null) {
                this.model.setSelectedItem(value.toString());
                this.curValue = value.toString();
            } else {
                for (Map.Entry entry : this.listMap.entrySet()) {
                    String choiceLabel = (String)entry.getKey();
                    String choiceValue = (String)entry.getValue();
                    if (choiceValue == null || choiceValue.compareTo(value.toString()) != 0) continue;
                    this.model.setSelectedItem(choiceLabel);
                    this.curValue = choiceLabel;
                }
            }
        }
    }

    public boolean isMultiLine() {
        return false;
    }

    public boolean isModified() {
        return !this.getSelectedItem().equals(this.curValue);
    }

    public void addEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void removeEditingStoppedListener(WcmCtrlfActionListener listener) {
        this.listenerList.add(WcmCtrlfActionListener.class, listener);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this) {
            this.hidePopup();
        }
        WcmCtrlFactoryUtil.fireEditingStopped(this.listenerList, this, evt);
    }

    public String toString() {
        return WcmCtrlFactoryUtil.toString(this.getClass().getName(), this.data);
    }
}

