/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.api.Choice;
import com.filenet.wcm.api.ChoiceList;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WcmChoiceListPanel
extends JPanel {
    DefaultMutableTreeNode rootNode;
    DefaultTreeModel treeModel;
    JTree tree;
    DefaultTreeCellRenderer renderer;
    VerbosePropertyDescription propDesc;

    public WcmChoiceListPanel(VerbosePropertyDescription propDesc) {
        this.propDesc = propDesc;
        String choiceName = WcmCtrlFactoryUtil.getChoiceTitle(propDesc, false);
        this.rootNode = new DefaultMutableTreeNode(choiceName);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        TreeUI ui = this.tree.getUI();
        if (ui instanceof BasicTreeUI) {
            ((BasicTreeUI)ui).setCollapsedIcon(WcmImageLoader.createImageIcon("action/Collapse16.gif"));
            ((BasicTreeUI)ui).setExpandedIcon(WcmImageLoader.createImageIcon("action/Expand16.gif"));
        }
        this.renderer = new DefaultTreeCellRenderer();
        this.renderer.setOpenIcon(null);
        this.renderer.setClosedIcon(null);
        this.renderer.setLeafIcon(WcmImageLoader.createImageIcon("action/Choices16.gif"));
        this.tree.setCellRenderer(this.renderer);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.initTree();
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add((Component)scrollPane, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                WcmChoiceListPanel.this.tree.setSelectionRow(0);
                WcmChoiceListPanel.this.tree.requestFocus();
            }
        });
    }

    public Object getValue() {
        Object objValue = null;
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node != null && node.isLeaf()) {
                objValue = node.getUserObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objValue;
    }

    private DefaultMutableTreeNode addObject(Object child) {
        DefaultMutableTreeNode parentNode = null;
        TreePath parentPath = this.tree.getSelectionPath();
        boolean isVisible = false;
        if (parentPath == null) {
            parentNode = this.rootNode;
            isVisible = true;
        } else {
            parentNode = (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        }
        return this.addObject(parentNode, child, isVisible);
    }

    private DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child) {
        return this.addObject(parent, child, true);
    }

    private DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean isVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (isVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    private void initTree() {
        ChoiceList cList;
        if (this.propDesc != null && (cList = this.propDesc.getPropertyDescription().getChoices(9)) != null && cList.size() > 0) {
            this.populateChoiceItems(this.rootNode, cList, true);
        }
    }

    private void populateChoiceItems(DefaultMutableTreeNode ParentNode, ChoiceList cList, boolean isVisible) {
        if (cList != null && cList.size() > 0) {
            for (Choice choice : cList) {
                DefaultMutableTreeNode node = this.addObject(ParentNode, choice.getName(), isVisible);
                if (!choice.hasContainedChoices()) continue;
                cList = choice.getContainedChoices();
                this.populateChoiceItems(node, cList, false);
            }
        }
    }
}

