/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmChoiceListPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmSVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class WcmChoiceListDialog
extends JDialog
implements WcmDialogComponent,
ActionListener {
    private JTextField textField;
    private JLabel selLabel;
    private JLabel choiceLabel;
    private WcmChoiceListPanel choiceListPanel;
    private JButton addButton;
    private JButton clearButton;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel okCancelPanel;
    private static int status = 1;
    private VerbosePropertyDescription data;
    private WcmSVCtrl svCtrl;

    public WcmChoiceListDialog(Frame parent, VerbosePropertyDescription propDescr, WcmSVCtrl svCtrl) {
        super(parent, true);
        this.init(parent, propDescr, svCtrl);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                WcmChoiceListDialog.this.choiceListPanel.requestFocus();
            }
        });
    }

    public WcmChoiceListDialog(Dialog parent, VerbosePropertyDescription propDescr, WcmSVCtrl svCtrl) {
        super(parent, true);
        this.init(parent, propDescr, svCtrl);
    }

    private void init(Container parent, VerbosePropertyDescription propDescr, WcmSVCtrl svCtrl) {
        try {
            this.data = propDescr;
            this.svCtrl = svCtrl;
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            Dimension dimension = WcmStringUtil.stringToDimension(WcmUIComponentResource.SVChoiceListDiaglogDim);
            if (dimension == null) {
                dimension = new Dimension(300, 300);
            }
            this.setSize(dimension);
            this.setLocationRelativeTo(parent);
            this.setTitle(WcmCtrlFactoryUtil.getChoiceTitle(this.data, true));
            this.createControls();
            this.layoutComponents();
            this.textField.setText(svCtrl.getValue().toString());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    WcmChoiceListDialog.this.setVisible(false);
                }
            });
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public int showDialog() {
        this.show();
        return status;
    }

    public Object getData() {
        return WcmCtrlFactoryUtil.getObject(this.data, this.textField.getText());
    }

    protected void createControls() {
        this.selLabel = new JLabel(WcmUIComponentResource.SELECTED_CHOICE);
        this.textField = new JTextField(18);
        this.textField.setEditable(false);
        this.textField.addActionListener(new AddActionListener());
        this.addButton = new JButton(WcmUIComponentResource.SET);
        this.addButton.setMargin(new Insets(1, 3, 1, 3));
        this.addButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.setMonic));
        this.addButton.addActionListener(new AddActionListener());
        this.choiceLabel = new JLabel(WcmUIComponentResource.AVAILABLE_CHOICE);
        this.choiceListPanel = new WcmChoiceListPanel(this.data);
        this.clearButton = new JButton(WcmUIComponentResource.CLEAR);
        this.clearButton.setMargin(new Insets(1, 3, 1, 3));
        this.clearButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.clearMonic));
        this.clearButton.addActionListener(new RemoveActionListener());
        this.okCancelPanel = this.createButtonPanel();
    }

    protected void layoutComponents() {
        GridBagConstraints gbCons = null;
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(3, 1, 1, 1);
        cp.add((Component)this.selLabel, gbCons);
        ++gbCons.gridy;
        gbCons.weightx = 0.9;
        cp.add((Component)this.textField, gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 0.1;
        cp.add((Component)this.clearButton, gbCons);
        ++gbCons.gridy;
        gbCons.gridx = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(6, 1, 1, 1);
        cp.add((Component)this.choiceLabel, gbCons);
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weightx = 0.9;
        gbCons.weighty = 1.0;
        cp.add((Component)this.choiceListPanel, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 0.1;
        gbCons.weighty = 0.0;
        cp.add((Component)this.addButton, gbCons);
        ++gbCons.gridy;
        gbCons.gridx = 0;
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.gridwidth = 0;
        cp.add((Component)this.okCancelPanel, gbCons);
        this.applyComponentOrientation(this.getParent().getComponentOrientation());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.getData();
            status = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            status = 1;
            this.setVisible(false);
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            this.createButtons(buttonPanel);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buttonPanel;
    }

    private void createButtons(JPanel p) {
        GridBagConstraints gbCons = new GridBagConstraints();
        this.initGridBagConstraints(gbCons);
        this.okButton = new JButton(WcmUIComponentResource.OK);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.okMonic));
        p.add((Component)this.okButton, gbCons);
        ++gbCons.gridx;
        this.cancelButton = new JButton(WcmUIComponentResource.CANCEL);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.cancelMonic));
        p.add((Component)this.cancelButton, gbCons);
    }

    private void initGridBagConstraints(GridBagConstraints gbCons) {
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
    }

    class AddActionListener
    implements ActionListener {
        AddActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object objValue = WcmChoiceListDialog.this.choiceListPanel.getValue();
            if (objValue != null) {
                WcmChoiceListDialog.this.textField.setText(objValue.toString());
                WcmChoiceListDialog.this.clearButton.setEnabled(true);
            }
        }
    }

    class RemoveActionListener
    implements ActionListener {
        RemoveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            WcmChoiceListDialog.this.textField.setText("");
            WcmChoiceListDialog.this.clearButton.setEnabled(false);
        }
    }
}

