/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.toolkit.client.ui.ctrlf.CalendarPanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.DatePanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDateTimeEditor;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class WcmCalendarPanel
extends JPanel {
    private WcmDateTimeEditor dateEditor;
    private WcmDateTimeEditor timeEditor;
    private DatePanel datePanel;
    private CalendarPanel calPanel;
    private EventListenerList listenerList;
    private JLabel timeLabel;
    private JLabel dateLabel;

    public WcmCalendarPanel(Container parent) {
        Dimension dim;
        if (parent != null) {
            this.setComponentOrientation(parent.getComponentOrientation());
        }
        if ((dim = WcmStringUtil.stringToDimension(WcmUIComponentResource.CalendarDiaglogDim)) == null) {
            dim = new Dimension(300, 380);
        }
        this.setPreferredSize(dim);
        this.createComponents();
        this.layoutComponents();
        this.initTodayDate();
        this.setupListeners();
    }

    public WcmDateTimeEditor getDateEditor() {
        return this.dateEditor;
    }

    private void setupListeners() {
        this.calPanel.addDateTimeChangeListener(this.datePanel);
        this.calPanel.addDateTimeChangeListener(this.dateEditor);
        this.calPanel.addDateTimeChangeListener(this.timeEditor);
        this.datePanel.addDateTimeChangeListener(this.calPanel);
        this.datePanel.addDateTimeChangeListener(this.dateEditor);
        this.datePanel.addDateTimeChangeListener(this.timeEditor);
        this.dateEditor.addDateTimeChangeListener(this.calPanel);
        this.dateEditor.addDateTimeChangeListener(this.datePanel);
        this.dateEditor.addDateTimeChangeListener(this.timeEditor);
        this.timeEditor.addDateTimeChangeListener(this.calPanel);
        this.timeEditor.addDateTimeChangeListener(this.datePanel);
        this.timeEditor.addDateTimeChangeListener(this.dateEditor);
    }

    private void createComponents() {
        this.timeLabel = new JLabel(WcmUIComponentResource.SELECT_A_TIME);
        this.timeEditor = new WcmDateTimeEditor();
        this.dateLabel = new JLabel(WcmUIComponentResource.SELECT_A_DATE);
        this.dateEditor = new WcmDateTimeEditor();
        this.datePanel = new DatePanel(this);
        this.calPanel = new CalendarPanel(this);
    }

    private void layoutComponents() {
        JPanel timeDatePanel = new JPanel();
        timeDatePanel.setLayout(new GridLayout(4, 1));
        timeDatePanel.add(this.timeLabel);
        timeDatePanel.add(this.timeEditor);
        timeDatePanel.add(this.dateLabel);
        timeDatePanel.add(this.dateEditor);
        JPanel dateCalPanel = new JPanel(new BorderLayout());
        dateCalPanel.add((Component)this.datePanel, "First");
        dateCalPanel.add((Component)this.calPanel, "Center");
        dateCalPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel timeDateCalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        timeDateCalPanel.add((Component)timeDatePanel, gbCons);
        gbCons.anchor = 10;
        gbCons.fill = 1;
        gbCons.insets = new Insets(3, 0, 0, 0);
        ++gbCons.gridy;
        gbCons.weighty = 1.0;
        timeDateCalPanel.add((Component)dateCalPanel, gbCons);
        this.setLayout(new BorderLayout());
        this.add((Component)timeDateCalPanel, "Center");
    }

    private void initTodayDate() {
        Date todaydate = new Date();
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(todaydate);
        this.datePanel.setDate(gc);
        this.calPanel.setDate(gc);
        this.timeEditor.setDateTimeFormat(0);
        this.timeEditor.initDate(todaydate);
        this.dateEditor.setDateTimeFormat(1);
        this.dateEditor.initDate(todaydate);
    }

    public void setDateTime(Date date) {
        this.timeEditor.initDate(date);
        this.dateEditor.initDate(date);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        this.datePanel.setDate(gc);
        this.calPanel.setDate(gc);
    }

    public void setDate(Date date) {
        this.timeEditor.initEditor(false);
        this.timeEditor.initDate(date);
        this.dateEditor.initDate(date);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        this.datePanel.setDate(gc);
        this.calPanel.setDate(gc);
    }

    public Object getValue() {
        return this.calPanel.getValue();
    }

    public Date getDateTime() {
        if (this.timeEditor.getDate() != null && this.dateEditor.getDate() != null) {
            GregorianCalendar gcTime = new GregorianCalendar();
            gcTime.setTime(this.timeEditor.getDate());
            GregorianCalendar gcDate = new GregorianCalendar();
            gcDate.setTime(this.dateEditor.getDate());
            GregorianCalendar gcDateTime = (GregorianCalendar)gcTime.clone();
            gcDateTime.set(gcDate.get(1), gcDate.get(2), gcDate.get(5));
            return gcDateTime.getTime();
        }
        return null;
    }

    public Date getDate() {
        return this.dateEditor.getDate();
    }

    public boolean isTimeSet() {
        return this.timeEditor.isEditorInitialized();
    }

    public void clear() {
        this.timeEditor.clear();
        this.dateEditor.clear();
        this.datePanel.clear();
        this.calPanel.clear();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        WcmCalendarPanel calendarPanel = new WcmCalendarPanel(panel);
        panel.add((Component)calendarPanel, "First");
        frame.setContentPane(panel);
        frame.pack();
        Dimension dim = frame.getToolkit().getScreenSize();
        frame.setLocation(dim.height / 2 - frame.getWidth() / 2, dim.width / 2 - frame.getHeight() / 2);
        frame.show();
    }
}

