/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMouseActionListener;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMouseAdapter;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WcmAddRemovePanel
extends JPanel
implements ListSelectionListener,
ActionListener,
WcmMouseActionListener {
    JLabel availableLabel;
    JLabel selectedLabel;
    JList availableList;
    JList selectedList;
    JButton addAllButton;
    JButton addButton;
    JButton removeAllButton;
    JButton removeButton;

    public WcmAddRemovePanel(Container parent) {
        if (parent != null) {
            this.setComponentOrientation(parent.getComponentOrientation());
        }
        try {
            this.setLayout(new GridBagLayout());
            this.addControls();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addControls() {
        GridBagConstraints gbCons = null;
        try {
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 3, 3);
            this.availableLabel = new JLabel();
            this.availableLabel.setText(WcmUIComponentResource.AVAILABLE_CHOICE);
            this.add((Component)this.availableLabel, gbCons);
            gbCons.fill = 1;
            ++gbCons.gridy;
            gbCons.weighty = 1.0;
            this.availableList = new JList(new DefaultListModel());
            this.availableList.addListSelectionListener(this);
            this.availableList.addMouseListener(new WcmMouseAdapter(this));
            this.add((Component)new JScrollPane(this.availableList), gbCons);
            gbCons.fill = 3;
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
            gbCons.fill = 2;
            ++gbCons.gridx;
            gbCons.gridy = 0;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            this.selectedLabel = new JLabel();
            this.selectedLabel.setText(WcmUIComponentResource.SELECTED_CHOICES);
            this.add((Component)this.selectedLabel, gbCons);
            gbCons.fill = 1;
            ++gbCons.gridy;
            gbCons.weighty = 1.0;
            this.selectedList = new JList(new DefaultListModel());
            this.selectedList.addListSelectionListener(this);
            this.selectedList.addMouseListener(new WcmMouseAdapter(this));
            this.add((Component)new JScrollPane(this.selectedList), gbCons);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JPanel createAddRemoveButtonPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 1, 1, 0);
            ComponentOrientation o = this.getComponentOrientation();
            this.addAllButton = new JButton(WcmImageLoader.createImageIcon(o.isLeftToRight() ? "action/ArrowRR.gif" : "action/ArrowRR_RTL.gif"));
            this.addAllButton.setToolTipText(WcmUIComponentResource.ADD_ALL);
            this.addAllButton.setMargin(new Insets(1, 1, 1, 1));
            this.addAllButton.addActionListener(this);
            panel.add((Component)this.addAllButton, gbCons);
            this.addButton = new JButton(WcmImageLoader.createImageIcon(o.isLeftToRight() ? "action/ArrowR.gif" : "action/ArrowR_RTL.gif"));
            this.addButton.setToolTipText(WcmUIComponentResource.ADD);
            this.addButton.setMargin(new Insets(1, 1, 1, 1));
            this.addButton.addActionListener(this);
            panel.add((Component)this.addButton, gbCons);
            this.removeButton = new JButton(WcmImageLoader.createImageIcon(o.isLeftToRight() ? "action/ArrowL.gif" : "action/ArrowL_RTL.gif"));
            this.removeButton.setToolTipText(WcmUIComponentResource.REMOVE);
            this.removeButton.setMargin(new Insets(1, 1, 1, 1));
            this.removeButton.addActionListener(this);
            panel.add((Component)this.removeButton, gbCons);
            this.removeAllButton = new JButton(WcmImageLoader.createImageIcon(o.isLeftToRight() ? "action/ArrowLL.gif" : "action/ArrowLL_RTL.gif"));
            this.removeAllButton.setToolTipText(WcmUIComponentResource.REMOVE_ALL);
            this.removeAllButton.setMargin(new Insets(1, 1, 1, 1));
            this.removeAllButton.addActionListener(this);
            panel.add((Component)this.removeAllButton, gbCons);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return panel;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.availableList) {
            this.selectedList.removeListSelectionListener(this);
            this.selectedList.clearSelection();
            this.selectedList.addListSelectionListener(this);
            this.updateMainButtonsState();
        } else if (event.getSource() == this.selectedList) {
            this.availableList.removeListSelectionListener(this);
            this.availableList.clearSelection();
            this.availableList.addListSelectionListener(this);
            this.updateMainButtonsState();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.addAllButton && this.addAllButton.isEnabled()) {
            DefaultListModel listModel = (DefaultListModel)this.availableList.getModel();
            this.availableList.removeListSelectionListener(this);
            this.availableList.setSelectionInterval(0, listModel.getSize() - 1);
            this.availableList.addListSelectionListener(this);
            this.addSelectedItems();
        } else if (object == this.addButton && this.addButton.isEnabled()) {
            this.addSelectedItems();
        } else if (object == this.removeButton && this.removeButton.isEnabled()) {
            this.removeSelectedItems();
        } else if (object == this.removeAllButton && this.removeAllButton.isEnabled()) {
            DefaultListModel listModel = (DefaultListModel)this.selectedList.getModel();
            this.selectedList.removeListSelectionListener(this);
            this.selectedList.setSelectionInterval(0, listModel.getSize() - 1);
            this.selectedList.addListSelectionListener(this);
            this.removeSelectedItems();
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        Object object = event.getSource();
        if (object == this.availableList && this.addButton.isEnabled()) {
            this.addSelectedItems();
        } else if (object == this.selectedList && this.removeButton.isEnabled()) {
            this.removeSelectedItems();
        }
    }

    protected void updateMainButtonsState() {
        int[] selectedIndices = null;
        selectedIndices = this.availableList.getSelectedIndices();
        this.addButton.setEnabled(selectedIndices.length > 0);
        selectedIndices = this.selectedList.getSelectedIndices();
        this.removeButton.setEnabled(selectedIndices.length > 0);
    }

    protected void updateAllButtonsState() {
        DefaultListModel listModel = null;
        listModel = (DefaultListModel)this.availableList.getModel();
        this.addAllButton.setEnabled(listModel.getSize() > 0);
        listModel = (DefaultListModel)this.selectedList.getModel();
        this.removeAllButton.setEnabled(listModel.getSize() > 0);
    }

    protected void addSelectedItems() {
        Object[] items = null;
        items = this.removeSelectedItems(this.availableList);
        if (items == null) {
            return;
        }
        this.onAddItemsAction(items);
        this.addSelectedItems(items, this.selectedList);
        this.addButton.setEnabled(false);
        this.updateAllButtonsState();
    }

    protected void addSelectedItems(Object[] items, JList list) {
        DefaultListModel listModel = null;
        int[] indices = null;
        try {
            if (items.length == 0) {
                return;
            }
            listModel = (DefaultListModel)list.getModel();
            indices = new int[items.length];
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                listModel.addElement(items[i]);
                indices[i] = listModel.getSize() - 1;
            }
            list.setSelectedIndices(indices);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void removeSelectedItems() {
        Object[] items = null;
        items = this.removeSelectedItems(this.selectedList);
        if (items == null) {
            return;
        }
        this.onRemoveItemsAction(items);
        this.addSelectedItems(items, this.availableList);
        this.removeButton.setEnabled(false);
        this.updateAllButtonsState();
    }

    protected Object[] removeSelectedItems(JList list) {
        int[] indices = null;
        Object[] items = null;
        DefaultListModel listModel = null;
        try {
            indices = list.getSelectedIndices();
            if (indices.length == 0) {
                return items;
            }
            items = new Object[indices.length];
            listModel = (DefaultListModel)list.getModel();
            for (int i = indices.length - 1; i >= 0; --i) {
                items[i] = listModel.getElementAt(indices[i]);
                listModel.removeElementAt(indices[i]);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return items;
    }

    protected void onAddItemsAction(Object[] items) {
    }

    protected void onRemoveItemsAction(Object[] items) {
    }

    public Object[] getSelectedItems() {
        ListModel listModel = null;
        Object[] items = null;
        try {
            listModel = this.selectedList.getModel();
            items = new Object[listModel.getSize()];
            for (int i = 0; i < listModel.getSize(); ++i) {
                items[i] = listModel.getElementAt(i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items;
    }

    public String[] getSelectedStringItems() {
        ListModel listModel = null;
        String[] items = null;
        try {
            listModel = this.selectedList.getModel();
            int size = listModel.getSize();
            if (size > 0) {
                items = new String[size];
                for (int i = 0; i < size; ++i) {
                    items[i] = listModel.getElementAt(i).toString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items;
    }

    public void initializeLists(Object[] availableItems, Object[] selectedItems) {
        try {
            this.setSelectedItems(selectedItems);
            this.setAvailableItems(availableItems, selectedItems);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelectedItems(Object[] items) {
        DefaultListModel<Object> listModel = null;
        try {
            listModel = new DefaultListModel<Object>();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    listModel.addElement(items[i]);
                }
            }
            this.selectedList.setModel(listModel);
            this.updateAllButtonsState();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        if (listCellRenderer == null) {
            return;
        }
        if (this.availableList != null) {
            this.availableList.setCellRenderer(listCellRenderer);
        }
        if (this.selectedList != null) {
            this.selectedList.setCellRenderer(listCellRenderer);
        }
    }

    public void setEnabled(boolean enable) {
        try {
            this.availableList.setEnabled(enable);
            this.selectedList.setEnabled(enable);
            this.addButton.setEnabled(enable);
            this.removeButton.setEnabled(enable);
            if (enable) {
                this.updateAllButtonsState();
            } else {
                this.addAllButton.setEnabled(false);
                this.removeAllButton.setEnabled(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAvailableItems(Object[] availableItems, Object[] selectedItems) {
        DefaultListModel<Object> listModel = null;
        try {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            listModel = new DefaultListModel<Object>();
            if (availableItems != null) {
                if (selectedItems == null) {
                    for (int i = 0; i < availableItems.length; ++i) {
                        listModel.addElement(availableItems[i]);
                    }
                } else {
                    for (int i = 0; i < availableItems.length; ++i) {
                        if (this.isInArray(availableItems[i], selectedItems)) continue;
                        listModel.addElement(availableItems[i]);
                    }
                }
            }
            this.availableList.setModel(listModel);
            this.updateAllButtonsState();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private boolean isInArray(Object item, Object[] items) {
        String itemName = null;
        if (item == null || items == null) {
            return false;
        }
        itemName = item.toString();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || WcmString.compareIgnoreCase(itemName, items[i].toString()) != 0) continue;
            return true;
        }
        return false;
    }

    public void updateItem(Object oldItem, Object newItem) {
        try {
            Object obj;
            int i;
            DefaultListModel availableListModel = (DefaultListModel)this.availableList.getModel();
            DefaultListModel selectedListModel = (DefaultListModel)this.selectedList.getModel();
            int availableListLen = availableListModel.getSize();
            int selectedListLen = selectedListModel.getSize();
            for (i = 0; i < availableListLen; ++i) {
                obj = availableListModel.getElementAt(i);
                if (!obj.equals(oldItem)) continue;
                availableListModel.setElementAt(newItem, i);
                break;
            }
            for (i = 0; i < selectedListLen; ++i) {
                obj = selectedListModel.getElementAt(i);
                if (!obj.equals(oldItem)) continue;
                selectedListModel.setElementAt(newItem, i);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

