/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmAddRemovePanel;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactoryUtil;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDialogComponent;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponentResource;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

class WcmAddRemoveDialog
extends JDialog
implements WcmDialogComponent,
ActionListener {
    private WcmAddRemovePanel addRemovePanel;
    private JPanel okCancelPanel;
    private JButton okButton;
    private JButton cancelButton;
    static int status = 1;
    private VerbosePropertyDescription data;
    private Container parentContainer;
    private WcmMVCtrl mvCtrl;

    public WcmAddRemoveDialog(Frame parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        super(parent, true);
        this.init(parent, propDescr, mvCtrl);
    }

    public WcmAddRemoveDialog(Dialog parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        super(parent, true);
        this.init(parent, propDescr, mvCtrl);
    }

    private void init(Container parent, VerbosePropertyDescription propDescr, WcmMVCtrl mvCtrl) {
        this.data = propDescr;
        this.parentContainer = parent;
        this.mvCtrl = mvCtrl;
        Dimension dim = WcmStringUtil.stringToDimension(WcmUIComponentResource.MVAddRemoveDialogDim);
        if (dim == null) {
            dim = new Dimension(400, 250);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        if (this.data.getHasMarkingSet()) {
            this.setTitle(WcmUIComponentResource.ChoiceMarkingTitle);
        } else {
            this.setTitle(WcmCtrlFactoryUtil.getChoiceTitle(this.data, true));
        }
        this.createControls();
        this.layoutControls();
        this.initLists();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WcmAddRemoveDialog.this.setVisible(false);
            }
        });
    }

    public int showDialog() {
        this.show();
        return status;
    }

    public Object getData() {
        return this.addRemovePanel.getSelectedItems();
    }

    private void createControls() {
        this.addRemovePanel = new WcmAddRemovePanel(this.parentContainer);
        this.okCancelPanel = this.createButtonPanel();
    }

    private void layoutControls() {
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 19;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
        cp.add((Component)this.addRemovePanel, gbCons);
        ++gbCons.gridy;
        gbCons.anchor = 10;
        gbCons.fill = 0;
        cp.add((Component)this.okCancelPanel, gbCons);
        this.applyComponentOrientation(this.parentContainer.getComponentOrientation());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            status = 0;
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            status = 1;
            this.setVisible(false);
        }
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            this.createButtons(buttonPanel);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buttonPanel;
    }

    private void createButtons(JPanel p) {
        GridBagConstraints gbCons = new GridBagConstraints();
        this.initGridBagConstraints(gbCons);
        this.okButton = new JButton(WcmUIComponentResource.OK);
        this.okButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.okMonic));
        p.add((Component)this.okButton, gbCons);
        ++gbCons.gridx;
        this.cancelButton = new JButton(WcmUIComponentResource.CANCEL);
        this.cancelButton.setMnemonic(WcmStringUtil.stringToMnemonic(WcmUIComponentResource.cancelMonic));
        p.add((Component)this.cancelButton, gbCons);
    }

    private void initGridBagConstraints(GridBagConstraints gbCons) {
        gbCons.anchor = 22;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
    }

    private void initLists() {
        if (this.data.getHasMarkingSet()) {
            this.addRemovePanel.initializeLists(WcmCtrlFactoryUtil.getMarkingItems(this.data, true), WcmCtrlFactoryUtil.getSelectedItems(this.mvCtrl));
        } else {
            this.addRemovePanel.initializeLists(WcmCtrlFactoryUtil.getChoiceItems(this.data), WcmCtrlFactoryUtil.getSelectedItems(this.mvCtrl));
        }
    }
}

