/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDateTimeChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicArrowButton;

class DatePanel
extends JPanel
implements WcmDateTimeChangeListener {
    protected BasicArrowButton rightButton;
    protected BasicArrowButton leftButton;
    protected JLabel date;
    protected int thisMonth;
    protected int thisYear;
    private GregorianCalendar thisCalendar;
    private boolean clear;

    public DatePanel() {
        this.createControl();
    }

    public DatePanel(Container parent) {
        if (parent != null) {
            this.setComponentOrientation(parent.getComponentOrientation());
        }
        this.createControl();
    }

    public void setDate(GregorianCalendar gc) {
        this.thisCalendar = gc;
        this.thisMonth = gc.get(2);
        this.thisYear = gc.get(1);
        String monthString = this.getMonth(this.thisMonth);
        String temp = monthString + " ";
        temp = temp + Integer.toString(this.thisYear);
        this.date.setText(temp);
    }

    public void clear() {
        this.clear = true;
    }

    private String getMonth(int month) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM");
        GregorianCalendar gc = new GregorianCalendar(2001, 0 + month, 3);
        Date dt = gc.getTime();
        String monthstring = sdf.format(dt);
        return monthstring;
    }

    private void createControl() {
        ComponentOrientation o = this.getComponentOrientation();
        this.setLayout(new BorderLayout());
        this.leftButton = new BasicArrowButton(o.isLeftToRight() ? 7 : 3);
        this.rightButton = new BasicArrowButton(o.isLeftToRight() ? 3 : 7);
        this.date = new JLabel("Center-aligned", 0);
        this.add((Component)this.rightButton, "After");
        this.add((Component)this.date, "Center");
        this.add((Component)this.leftButton, "Before");
        this.rightButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DatePanel.this.incrCalendar();
            }
        });
        this.leftButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DatePanel.this.decrCalendar();
            }
        });
    }

    public void dateTimeChanged(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        this.setDate(gc);
    }

    public void dateChanged(Date date) {
        this.dateTimeChanged(date);
    }

    public void timeChanged(Date date) {
    }

    private void incrCalendar() {
        ++this.thisMonth;
        if (this.thisMonth > 11) {
            this.thisMonth = 0;
            ++this.thisYear;
        }
        this.thisCalendar.add(2, 1);
        this.setDate(this.thisCalendar);
        this.fireDateChanged(this.thisCalendar.getTime());
    }

    private void decrCalendar() {
        --this.thisMonth;
        if (this.thisMonth < 0) {
            this.thisMonth = 11;
            --this.thisYear;
        }
        this.thisCalendar.add(2, -1);
        this.setDate(this.thisCalendar);
        this.fireDateChanged(this.thisCalendar.getTime());
    }

    public void addDateTimeChangeListener(WcmDateTimeChangeListener dateTimeListener) {
        this.listenerList.add(WcmDateTimeChangeListener.class, dateTimeListener);
    }

    public void removeDateTimeChangeListener(WcmDateTimeChangeListener dateTimeListener) {
        this.listenerList.remove(WcmDateTimeChangeListener.class, dateTimeListener);
    }

    private void fireDateChanged(Date date) {
        if (date == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WcmDateTimeChangeListener.class) continue;
            ((WcmDateTimeChangeListener)listeners[i + 1]).dateChanged(date);
        }
    }
}

