/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui.ctrlf;

import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmDateTimeChangeListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

class CalendarPanel
extends JPanel
implements WcmDateTimeChangeListener {
    static final int LEFTGAP = 5;
    static final int RIGHTGAP = 5;
    static final int BOTTOMGAP = 5;
    static final int TOPGAP = 15;
    static final byte BGCOLOR = 0;
    static final byte WKEND_BGCOLOR = 1;
    static final byte NEIGHBOR_MONTH_DATE = 2;
    static final byte HIGHLIGHT = 3;
    static final byte MAXCOLOR = 4;
    static final int NUMOFCELLS = 42;
    private String weekNames;
    private Color[] calColor = new Color[4];
    private Date[] cell = new Date[42];
    private int cellWidth;
    private int cellHeight;
    private int calWidth;
    private int calHeight;
    private byte highlightedCell = (byte)-1;
    protected EventListenerList listenerList = new EventListenerList();
    private int thisMo;
    private int thisDate;
    private int thisYr;
    private boolean clear;

    public CalendarPanel(Container parent) {
        if (parent != null) {
            this.setComponentOrientation(parent.getComponentOrientation());
        }
        this.weekNames = this.getDayofWeekChars();
        this.createControl();
    }

    public void dateTimeChanged(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        this.setDate(gc);
    }

    public void dateChanged(Date date) {
        this.dateTimeChanged(date);
    }

    public void timeChanged(Date date) {
    }

    private String getDayofWeekChars() {
        String DayChars = new String("");
        SimpleDateFormat sdf = new SimpleDateFormat("E");
        boolean bUseEng = false;
        for (int i = 0; i < 7; ++i) {
            int day = this.getComponentOrientation().isLeftToRight() ? i : 6 - i;
            GregorianCalendar gc = new GregorianCalendar(2001, 11, 2 + day);
            Date dt = gc.getTime();
            String DayNames = sdf.format(dt);
            if (DayNames != null && DayNames.length() > 0) {
                DayChars = DayChars + DayNames.substring(0, 1).toUpperCase();
                if (i == 6) continue;
                DayChars = DayChars + " ";
                continue;
            }
            bUseEng = true;
            break;
        }
        if (bUseEng) {
            DayChars = new String("S M T W T F S");
        }
        return DayChars;
    }

    public void clear() {
        this.clear = true;
    }

    public void addDateTimeChangeListener(WcmDateTimeChangeListener dateTimeListener) {
        this.listenerList.add(WcmDateTimeChangeListener.class, dateTimeListener);
    }

    public void removeDateTimeChangeListener(WcmDateTimeChangeListener dateTimeListener) {
        this.listenerList.remove(WcmDateTimeChangeListener.class, dateTimeListener);
    }

    private void fireDateChanged(Date date) {
        if (date == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WcmDateTimeChangeListener.class) continue;
            ((WcmDateTimeChangeListener)listeners[i + 1]).dateChanged(date);
        }
    }

    private void createControl() {
        this.initCalColor();
        this.initCellData();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                byte cellClicked = CalendarPanel.this.getCellNumber(x, y);
                Date selectedDate = CalendarPanel.this.cell[cellClicked];
                if (x > 5 && x < CalendarPanel.this.calWidth + 5 && y > 15 && y < y + CalendarPanel.this.calHeight) {
                    if (CalendarPanel.this.getDate(selectedDate, 2) == CalendarPanel.this.thisMo && CalendarPanel.this.getDate(selectedDate, 1) == CalendarPanel.this.thisYr) {
                        CalendarPanel.this.thisDate = CalendarPanel.this.getDate(selectedDate, 5);
                        CalendarPanel.this.highlightCell(CalendarPanel.this.highlightedCell, CalendarPanel.this.calColor[0]);
                        CalendarPanel.this.highlightedCell = cellClicked;
                        CalendarPanel.this.highlightCell(CalendarPanel.this.highlightedCell, CalendarPanel.this.calColor[3]);
                    } else {
                        GregorianCalendar gc = new GregorianCalendar();
                        gc.setTime(selectedDate);
                        CalendarPanel.this.setDate(gc);
                    }
                    CalendarPanel.this.fireDateChanged((Date)CalendarPanel.this.getValue());
                }
            }
        });
    }

    private void initCalColor() {
        this.calColor[0] = new Color(Color.lightGray.getRGB());
        this.calColor[1] = new Color(this.calColor[0].getRGB());
        this.calColor[2] = new Color(Color.gray.getRGB());
        this.calColor[3] = new Color(Color.red.getRGB());
    }

    private void initCellData() {
        for (int i = 0; i < 42; ++i) {
            this.cell[i] = null;
        }
    }

    public void setDate(GregorianCalendar c) {
        int i;
        this.thisMo = c.get(2);
        this.thisYr = c.get(1);
        this.thisDate = c.get(5);
        GregorianCalendar gc = new GregorianCalendar(this.thisYr, this.thisMo, 1);
        int dayoffirst = gc.get(7);
        int iCell = 0;
        int month = this.thisMo - 1;
        int year = this.thisYr;
        if (month < 0) {
            month = 11;
            year = this.thisYr - 1;
        }
        int dayspermonth = this.getDaysPerMonth(month, year);
        for (i = dayspermonth - dayoffirst + 2; i < dayspermonth + 1; ++i) {
            this.cell[iCell] = this.getTime(year, month, i);
            ++iCell;
        }
        dayspermonth = this.getDaysPerMonth(this.thisMo, this.thisYr);
        for (i = 1; i < dayspermonth + 1; ++i) {
            this.cell[iCell] = this.getTime(this.thisYr, this.thisMo, i);
            if (i == this.thisDate) {
                this.highlightedCell = (byte)iCell;
            }
            ++iCell;
        }
        year = this.thisYr;
        month = this.thisMo + 1;
        if (month > 11) {
            month = 0;
            year = this.thisYr + 1;
        }
        i = 1;
        while (iCell < 42) {
            this.cell[iCell] = this.getTime(year, month, i);
            ++iCell;
            ++i;
        }
        this.repaint();
    }

    private int getDaysPerMonth(int month, int year) {
        int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int days = month == 1 && this.isLeapYear(year) ? 29 : daysInMonth[month];
        return days;
    }

    private boolean isLeapYear(int yr) {
        int tempYear = yr;
        boolean leapYear = false;
        if (tempYear % 4 == 0) {
            leapYear = tempYear % 100 != 0 || tempYear % 400 == 0;
        }
        return leapYear;
    }

    private Date getTime(int year, int month, int date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(year, month, date);
        return gc.getTime();
    }

    private int getDate(Date date, int myd) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        return gc.get(myd);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension d = this.getSize();
        this.cellWidth = (d.width - 5 - 5) / 7;
        this.cellHeight = (d.height - 15 - 5) / 6;
        this.calWidth = this.cellWidth * 7;
        this.calHeight = this.cellHeight * 6;
        Font fontWeeknames = new Font("Helvetica", 0, 12);
        g.setFont(fontWeeknames);
        FontMetrics fm = g.getFontMetrics();
        StringTokenizer names = new StringTokenizer(this.weekNames, " ");
        int i = 0;
        while (names.hasMoreTokens()) {
            String buffer = names.nextToken();
            int offset = fm.stringWidth(buffer) / 2;
            g.setColor(Color.white);
            g.drawString(buffer, 5 + i * this.cellWidth + this.cellWidth / 2 - offset, 12);
            g.setColor(this.calColor[0].darker());
            g.drawString(buffer, 5 + i * this.cellWidth + this.cellWidth / 2 + 1 - offset, 13);
            ++i;
        }
        g.setColor(this.calColor[0].darker());
        i = 0;
        g.drawLine(5, 15 + i * this.cellHeight, 5 + this.calWidth - 1, 15 + i * this.cellHeight);
        i = 6;
        g.drawLine(5, 15 + i * this.cellHeight, 5 + this.calWidth - 1, 15 + i * this.cellHeight);
        Font fontDates = new Font("Helvetica", 1, (int)((double)this.cellHeight * 0.7));
        g.setFont(fontDates);
        this.drawDates(g);
        this.highlightCell(this.highlightedCell, this.calColor[3]);
    }

    private void drawDates(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int verticalOffset = fm.getHeight() / 2 - fm.getMaxDescent();
        for (int i = 0; i < 42; ++i) {
            String stringBuf = String.valueOf(this.getDate(this.cell[i], 5));
            int horizontalOffset = fm.stringWidth(stringBuf) / 2;
            if (this.getDate(this.cell[i], 2) != this.thisMo) {
                g.setColor(this.calColor[2]);
            } else {
                g.setColor(Color.black);
            }
            int x = 5 + (this.getComponentOrientation().isLeftToRight() ? i % 7 : 6 - i % 7) * this.cellWidth + this.cellWidth / 2 - horizontalOffset;
            int y = 15 + i / 7 * this.cellHeight + this.cellHeight / 2 + verticalOffset;
            g.drawString(stringBuf, x, y);
        }
    }

    private void highlightCell(int cell, Color highlight) {
        int row = cell / 7;
        int col = cell % 7;
        int x = col * this.cellWidth + 2 + 5;
        int y = row * this.cellHeight + 2 + 15;
        Graphics g = this.getGraphics();
        g.setColor(highlight);
        g.drawLine(x, y, x + this.cellWidth - 4, y);
        g.drawLine(x + this.cellWidth - 4, y, x + this.cellWidth - 4, y + this.cellHeight - 4);
        g.drawLine(x + this.cellWidth - 4, y + this.cellHeight - 4, x, y + this.cellHeight - 4);
        g.drawLine(x, y + this.cellHeight - 4, x, y);
        g.dispose();
    }

    private byte getCellNumber(int x, int y) {
        int col = (x - 5) / this.cellWidth;
        int row = (y - 15) / this.cellHeight;
        return (byte)(row * 7 + col);
    }

    public Object getValue() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(this.thisYr, this.thisMo, this.thisDate);
        return gc.getTime();
    }
}

