/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui;

import com.filenet.wcm.api.BaseObject;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyDescriptions;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.ValueObject;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionFactory;
import com.filenet.wcm.toolkit.client.ui.DescribedValue;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactory;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmMVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmSVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.client.util.WcmErrorUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.text.JTextComponent;

public class WcmPropertiesGridPanel
extends JPanel
implements FocusListener {
    public static final int GETPROPSOPT_ALL = 1;
    public static final int GETPROPSOPT_ONLYSETTABLE = 2;
    @Deprecated
    public static final int GETPROPSOPT_EMPTYSTRINGASNULL = 4;
    public static final int GETPROPSOPT_INCLUDENULLVALUES = 8;
    public static final int MODE_CREATE = 1;
    public static final int MODE_NOMODIFY = 2;
    public static final int MODE_CHECKIN = 4;
    public static final int MODE_DEFAULTOVERRIDESNULL = 8;
    public static final int MODE_EMPTYSTRINGASNULL = 16;
    public static final int MODE_ONLYSPECIFIED = 32;
    public static final int MODE_MARKING_NO_FILTER = 64;
    private String[] specifiedNames = new String[]{"DocumentTitle", "Description"};
    private String[] filteredOutNames = new String[]{"MimeType", "CompoundDocumentState"};
    protected static final int NUMCOLUMNS = 25;
    protected static final int MULTILINENUMLINES = 4;
    private static final String errorTitle = WcmString.localize("client.WcmPropertiesGridPanel.errorTitle", "Properties Error");
    private String gridLabel;
    private int mode;
    private String nameProperty;
    private boolean isFolderObj;
    private Container parentFrame;
    private ArrayList propsData;
    private WcmCtrlFactory ctrlf;
    private ImageIcon requiredIcon;
    private ImageIcon blankIcon;
    private JLabel propsLabel;
    private JPanel propsPanel;
    private JScrollPane gridScrollPane;
    private JPanel gridPanel;
    private int defaultWidth = 0;
    private int multiLineHeight = 0;
    private boolean debugOutput;

    public WcmPropertiesGridPanel(Container frame) {
        this.init(frame);
    }

    public WcmPropertiesGridPanel() {
        this.init(null);
    }

    public void setGridLabel(String label) {
        this.gridLabel = label;
        if (this.propsLabel != null) {
            this.propsLabel.setText(this.gridLabel);
        }
    }

    public void setMode(int mode) {
        if (this.propsData == null) {
            this.mode = mode;
        }
    }

    public void setNameProperty(String name, boolean isFldrObj) {
        if (this.propsData == null) {
            this.nameProperty = name;
            this.isFolderObj = isFldrObj;
        }
    }

    public void loadCustomProperties(ClassDescription classDesc, Properties props) throws WcmException, Exception {
        this.loadProperties(classDesc, props, true);
    }

    public void loadSystemProperties(ClassDescription classDesc, Properties props) throws WcmException, Exception {
        this.loadProperties(classDesc, props, false);
    }

    public void loadProperties(ClassDescription classDesc, Properties props, boolean skipSystemGenerated) throws WcmException, Exception {
        Property prop;
        ArrayList<PropInfo> data = new ArrayList<PropInfo>();
        if (classDesc == null) {
            if (props == null) {
                throw new RuntimeException("Neither class desc nor properties collection passed in!");
            }
            ListIterator it = props.listIterator();
            while (it.hasNext()) {
                prop = (Property)it.next();
                if (prop.getName().compareToIgnoreCase("ClassDescription") != 0) continue;
                classDesc = (ClassDescription)prop.getValue();
                break;
            }
            if (classDesc == null) {
                throw new RuntimeException("No class description in properties collection!");
            }
        }
        PropertyDescriptions propDescs = classDesc.getPropertyDescriptions(false);
        ListIterator it = propDescs.listIterator();
        while (it.hasNext()) {
            PropertyDescription propDesc = (PropertyDescription)it.next();
            VerbosePropertyDescription vpropDesc = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription(propDesc);
            if (this.isPropFilteredOut(vpropDesc) || vpropDesc.getIsSystemGenerated() & skipSystemGenerated || !vpropDesc.getIsSystemGenerated() & !skipSystemGenerated || vpropDesc.getIsHidden() || vpropDesc.getDataType() == 7 || vpropDesc.getDataType() == 1) continue;
            Object val = null;
            if (props != null && props.size() != 0) {
                ListIterator it2 = props.listIterator();
                while (it2.hasNext()) {
                    prop = (Property)it2.next();
                    if (prop.getName().compareToIgnoreCase(vpropDesc.getName()) != 0) continue;
                    val = prop.getValue();
                    val = this.adjustInitialPropValue(vpropDesc, val);
                }
            } else if ((this.mode & 8) != 0) {
                val = this.adjustInitialPropValue(vpropDesc, null);
            }
            PropInfo info = new PropInfo(vpropDesc, val);
            data.add(info);
        }
        this.propsData = data;
        this.initLayout();
    }

    public void loadProperties(DescribedValue[] vals) throws WcmException, Exception {
        ArrayList<PropInfo> data = new ArrayList<PropInfo>();
        for (int i = 0; i < vals.length; ++i) {
            VerbosePropertyDescription vpropDesc = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription(vals[i].propDesc);
            if (vpropDesc.getDataType() == 1 || vpropDesc.getDataType() == 7) continue;
            PropInfo info = new PropInfo(vpropDesc, vals[i].value);
            info.propValue = this.adjustInitialPropValue(vpropDesc, info.propValue);
            data.add(info);
        }
        this.propsData = data;
        this.initLayout();
    }

    public boolean validateProperties() {
        boolean isValid = true;
        ListIterator it = this.propsData.listIterator();
        while (it.hasNext()) {
            PropInfo info = (PropInfo)it.next();
            if (!this.isPropEditable(info.vpropDesc)) continue;
            if (info.wcmUiComponent != null) {
                WcmException ex = info.wcmUiComponent.validateValue();
                if (ex != null) {
                    String errMsg = WcmString.localize("client.WcmPropertiesGridPanel.invalidPropVal", "The value for property \"{0}\" is invalid.  The error is: {1}", (Object)info.vpropDesc.getName(), (Object)ex.getLocalizedMessage());
                    WcmErrorUtil.showErrorMessage(this, errMsg, errorTitle);
                    isValid = false;
                    break;
                }
                info.propValue = info.wcmUiComponent.getValue();
                info.propValue = this.adjustFinalPropValue(info.vpropDesc, info.propValue);
            }
            if (!info.vpropDesc.getIsValueRequired()) continue;
            boolean missingVal = false;
            if (info.propValue == null) {
                missingVal = true;
            } else if (info.vpropDesc.getCardinality() == 2) {
                if (info.propValue instanceof Values) {
                    Values vals = (Values)info.propValue;
                    if (vals.size() == 0) {
                        missingVal = true;
                    }
                } else {
                    System.out.println("Unexpected: multi-value not instanceof Values!");
                    missingVal = true;
                }
            }
            if (!missingVal) continue;
            String missingValMsg = WcmString.localize("client.WcmPropertiesGridPanel.missingPropVal", "A value is required for property \"{0}\"", (Object)info.vpropDesc.getName());
            WcmErrorUtil.showErrorMessage(this, missingValMsg, errorTitle);
            isValid = false;
            break;
        }
        return isValid;
    }

    public boolean isPropertyValueModified() {
        boolean isModified = false;
        if (this.propsData != null) {
            ListIterator it = this.propsData.listIterator();
            while (it.hasNext()) {
                PropInfo info = (PropInfo)it.next();
                if (!this.isPropEditable(info.vpropDesc) || info.wcmUiComponent == null || !(isModified = info.wcmUiComponent.isModified())) continue;
                break;
            }
        }
        return isModified;
    }

    public Properties getProperties(int option) throws WcmException {
        if ((option & 4) != 0) {
            this.mode |= 0x10;
        }
        Properties props = null;
        if (this.propsData != null) {
            PropInfo info;
            ListIterator it = this.propsData.listIterator();
            while (it.hasNext()) {
                info = (PropInfo)it.next();
                if (!this.isPropEditable(info.vpropDesc) || info.wcmUiComponent == null) continue;
                WcmException ex = info.wcmUiComponent.validateValue();
                if (ex != null) {
                    throw ex;
                }
                info.propValue = info.wcmUiComponent.getValue();
                if (info.propValue != null) {
                    this.tempTrace("WcmUIComponent.geValue() for " + info.vpropDesc.getName() + " returned: " + info.propValue.getClass().getName() + ": " + info.propValue);
                } else {
                    this.tempTrace("WcmUIComponent.getValue() for " + info.vpropDesc.getName() + " returned null");
                }
                info.propValue = this.adjustFinalPropValue(info.vpropDesc, info.propValue);
            }
            props = ObjectFactory.getProperties();
            it = this.propsData.listIterator();
            while (it.hasNext()) {
                JTextComponent jtc;
                info = (PropInfo)it.next();
                if ((option & 2) != 0 && (!this.isPropEditable(info.vpropDesc) || info.editComponent instanceof JTextComponent && info.vpropDesc.getHasMarkingSet() && (jtc = (JTextComponent)info.editComponent) != null && !jtc.isEditable()) || (option & 8) == 0 && info.propValue == null) continue;
                Property prop = ObjectFactory.getProperty((String)info.vpropDesc.getName());
                if (info.propValue != null) {
                    if (info.propValue instanceof Integer) {
                        this.tempTrace("Calling setValue with an integer");
                        prop.setValue((Integer)info.propValue);
                    } else if (info.propValue instanceof String) {
                        this.tempTrace("Calling setValue with a string");
                        prop.setValue((String)info.propValue);
                    } else if (info.propValue instanceof Double) {
                        this.tempTrace("Calling setValue with a double");
                        prop.setValue((Double)info.propValue);
                    } else if (info.propValue instanceof Values) {
                        this.tempTrace("Calling setValue with a Values");
                        prop.setValue((ValueObject)((Values)info.propValue));
                    } else if (info.propValue instanceof BaseObject) {
                        this.tempTrace("Calling setValue with a WcmObject");
                        prop.setValue((ValueObject)((BaseObject)info.propValue));
                    } else if (info.propValue instanceof Date) {
                        this.tempTrace("Calling setValue with a Date");
                        prop.setValue((Date)info.propValue);
                    } else if (info.propValue instanceof Boolean) {
                        this.tempTrace("Calling setValue with a Boolean");
                        prop.setValue((Boolean)info.propValue);
                    } else {
                        System.out.println("Unexpected: value isn't a recognized type to set on Property");
                    }
                }
                props.add((Object)prop);
            }
        }
        return props;
    }

    public void clear() {
        this.gridLabel = WcmString.localize("client.WcmPropertiesGridPanel.defaultGridLabel", "Properties:");
        this.mode = 9;
        this.propsData = null;
        this.nameProperty = null;
        this.isFolderObj = false;
        this.initLayout();
    }

    public void clearModified() {
        if (this.propsData != null && this.propsData.size() > 0) {
            try {
                for (int i = 0; i < this.propsData.size(); ++i) {
                    PropInfo info = (PropInfo)this.propsData.get(i);
                    if (info.wcmUiComponent == null || info == null) continue;
                    info.wcmUiComponent.setValue(info.wcmUiComponent.getValue());
                }
            }
            catch (WcmException ex) {
                System.out.println("Error trying to set value in control factory component! " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public boolean isLoaded() {
        return this.propsData != null;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(true);
        }
        if (this.propsData != null) {
            for (PropInfo info : this.propsData) {
                if (info.editComponent == null) continue;
                info.editComponent.setEnabled(enabled);
            }
        }
        if (!enabled) {
            super.setEnabled(false);
        }
    }

    protected Object adjustInitialPropValue(VerbosePropertyDescription vpropDesc, Object propValue) {
        String tempStr;
        if (propValue instanceof String && (tempStr = (String)propValue).length() == 0) {
            propValue = null;
        }
        List mvals = null;
        if (propValue instanceof List) {
            mvals = (List)propValue;
        }
        if ((this.mode & 8) != 0 && (propValue == null || mvals != null && mvals.size() == 0)) {
            Object defVal = vpropDesc.getDefaultValue();
            if (defVal instanceof String && (tempStr = (String)defVal).length() == 0) {
                defVal = null;
            }
            if (defVal != null) {
                if (propValue == null) {
                    propValue = defVal;
                } else {
                    Value val = ObjectFactory.getValue();
                    PropertyUtil.setValueObjectValue(val, defVal);
                    mvals.add(val);
                }
            }
        }
        try {
            if (propValue != null && vpropDesc.getCardinality() != 2) {
                switch (vpropDesc.getDataType()) {
                    case 2: {
                        propValue = PropertyUtil.getBoolean(propValue);
                        break;
                    }
                    case 3: {
                        propValue = PropertyUtil.getDate(propValue);
                        break;
                    }
                    case 4: {
                        propValue = PropertyUtil.getDouble(propValue);
                        break;
                    }
                    case 6: {
                        propValue = PropertyUtil.getInteger(propValue);
                        break;
                    }
                    case 8: {
                        propValue = PropertyUtil.getString(propValue);
                        break;
                    }
                    case 5: {
                        String guidStr = PropertyUtil.getString(propValue);
                        if (guidStr != null && guidStr.length() == 0) {
                            guidStr = null;
                        }
                        propValue = guidStr;
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error calling PropertyUtil conversion!");
            ex.printStackTrace();
            propValue = null;
        }
        return propValue;
    }

    protected Object adjustFinalPropValue(VerbosePropertyDescription vpropDesc, Object propValue) {
        if (propValue != null && propValue instanceof String && (this.mode & 0x10) != 0 && vpropDesc.getDataType() == 8 && propValue.toString().equalsIgnoreCase("")) {
            propValue = null;
        }
        try {
            if (propValue != null && vpropDesc.getCardinality() != 2) {
                switch (vpropDesc.getDataType()) {
                    case 2: {
                        propValue = PropertyUtil.getBoolean(propValue);
                        break;
                    }
                    case 3: {
                        propValue = PropertyUtil.getDate(propValue);
                        break;
                    }
                    case 4: {
                        propValue = PropertyUtil.getDouble(propValue);
                        break;
                    }
                    case 6: {
                        propValue = PropertyUtil.getInteger(propValue);
                        break;
                    }
                    case 8: {
                        propValue = PropertyUtil.getString(propValue);
                        break;
                    }
                    case 5: {
                        String guidStr = PropertyUtil.getString(propValue);
                        if (guidStr != null && guidStr.length() == 0) {
                            guidStr = null;
                        }
                        propValue = guidStr;
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error calling PropertyUtil conversion!");
            ex.printStackTrace();
            propValue = null;
        }
        return propValue;
    }

    protected void init(Container parent) {
        this.parentFrame = parent == null ? this : parent;
        this.requiredIcon = WcmImageLoader.createImageIcon("state/Required16.gif");
        if (this.requiredIcon == null) {
            throw new RuntimeException("Required16.gif not found!");
        }
        this.blankIcon = WcmImageLoader.createImageIcon("state/None16.gif");
        if (this.blankIcon == null) {
            throw new RuntimeException("None16.gif not found!");
        }
        this.clear();
    }

    protected void initLayout() {
        this.removeAll();
        this.setLayout(new GridLayout(1, 1, 5, 5));
        this.propsPanel = new JPanel();
        this.propsPanel.setLayout(new GridBagLayout());
        this.propsPanel.setBorder(new BevelBorder(1));
        this.propsLabel = new JLabel(this.gridLabel);
        this.propsPanel.add((Component)this.propsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(8, 8, 0, 12), 0, 0));
        this.gridPanel = new JPanel();
        this.gridPanel.setLayout(new GridBagLayout());
        if (this.propsData != null && this.propsData.size() > 0) {
            for (int i = 0; i < this.propsData.size(); ++i) {
                JButton jbut;
                PropInfo info = (PropInfo)this.propsData.get(i);
                ImageIcon imgicon = info.vpropDesc.getIsValueRequired() ? this.requiredIcon : this.blankIcon;
                JLabel label = new JLabel(info.vpropDesc.getLabel(), imgicon, 2);
                this.gridPanel.add((Component)label, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 23, 0, new Insets(4, 8, 4, 4), 0, 0));
                if (info.editComponent == null) {
                    this.loadCellComponent(info);
                }
                if (info.editComponent instanceof WcmSVCtrl) {
                    WcmSVCtrl svCtrl = (WcmSVCtrl)info.editComponent;
                    jbut = svCtrl.getMoreButton();
                    if (jbut != null) {
                        jbut.addFocusListener(this);
                    }
                } else if (info.editComponent instanceof WcmMVCtrl) {
                    WcmMVCtrl mvCtrl = (WcmMVCtrl)info.editComponent;
                    jbut = mvCtrl.getMoreButton();
                    if (jbut != null) {
                        jbut.addFocusListener(this);
                    }
                } else {
                    info.editComponent.addFocusListener(this);
                }
                this.gridPanel.add((Component)info.editComponent, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 12), 0, 0));
                label.setLabelFor(info.editComponent);
            }
            this.gridPanel.add((Component)new JLabel(this.blankIcon), new GridBagConstraints(0, this.propsData.size(), 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 8, 8, 12), 0, 0));
        } else {
            JLabel label = new JLabel("", this.blankIcon, 2);
            this.gridPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 12), 0, 0));
        }
        this.gridScrollPane = new JScrollPane(this.gridPanel, 20, 30);
        this.propsPanel.add((Component)this.gridScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.propsPanel);
        SwingUtilities.updateComponentTreeUI(this);
        this.applyComponentOrientation(this.getComponentOrientation());
    }

    protected int getDefaultWidth() {
        if (this.defaultWidth == 0) {
            FontMetrics m = this.propsLabel.getFontMetrics(this.propsLabel.getFont());
            this.defaultWidth = 25 * m.charWidth('m');
        }
        return this.defaultWidth;
    }

    protected int getMultiLineHeight() {
        if (this.multiLineHeight == 0) {
            FontMetrics m = this.propsLabel.getFontMetrics(this.propsLabel.getFont());
            this.multiLineHeight = 4 * m.getHeight();
        }
        return this.multiLineHeight;
    }

    protected void loadCtrlf() throws WcmException {
        WcmCtrlFactory tempCtrlf = new WcmCtrlFactory();
        int cfflags = 0;
        if ((this.mode & 2) != 0) {
            cfflags |= 2;
        } else if ((this.mode & 1) != 0) {
            cfflags |= 1;
        } else if ((this.mode & 4) != 0) {
            cfflags |= 4;
        }
        tempCtrlf.setMode(1, cfflags);
        this.ctrlf = tempCtrlf;
    }

    protected void loadCellComponent(PropInfo info) {
        Object ourContainer = null;
        if (this.ctrlf == null) {
            try {
                this.loadCtrlf();
            }
            catch (Exception ex) {
                System.out.println("Error trying to load control factory!");
                ex.printStackTrace();
            }
        }
        WcmUIComponent tempWcmUiComp = null;
        JComponent tempComp = null;
        if (this.ctrlf != null) {
            try {
                if (this.nameProperty != null && info.vpropDesc.getDataType() == 8 && info.vpropDesc.getSymbolicName().compareToIgnoreCase(this.nameProperty) == 0) {
                    tempWcmUiComp = this.ctrlf.getSingleLineTextComponent(this.parentFrame, info.vpropDesc.getPropertyDescription(), this.isFolderObj);
                } else {
                    if (info.vpropDesc.getHasMarkingSet() && (this.mode & 0x40) != 0) {
                        this.ctrlf.setMarkingFilterMode(false);
                    }
                    tempWcmUiComp = info.vpropDesc.getHasMarkingSet() && info.propValue != null ? this.ctrlf.getUIComponent(this.parentFrame, info.vpropDesc.getPropertyDescription(), info.propValue) : this.ctrlf.getUIComponent(this.parentFrame, info.vpropDesc.getPropertyDescription());
                }
                tempComp = (JComponent)((Object)tempWcmUiComp);
                if (info.propValue != null) {
                    tempWcmUiComp.setValue(info.propValue);
                }
            }
            catch (WcmException ex) {
                System.out.println("Error trying to get/initialize ctrl fact UI component! " + ex.getMessage());
                ex.printStackTrace();
                tempComp = null;
                tempWcmUiComp = null;
            }
        }
        if (tempComp == null) {
            System.out.println("Input not supported for property: " + info.vpropDesc.getSymbolicName());
            tempComp = new JLabel("");
        }
        if (tempWcmUiComp != null && tempWcmUiComp.isMultiLine()) {
            Dimension dim = new Dimension(this.getDefaultWidth(), this.getMultiLineHeight());
            tempComp.setPreferredSize(dim);
        } else {
            Dimension dim = tempComp.getPreferredSize();
            dim.width = this.getDefaultWidth();
            tempComp.setPreferredSize(dim);
        }
        info.editComponent = tempComp;
        info.wcmUiComponent = tempWcmUiComp;
    }

    private boolean isPropEditable(VerbosePropertyDescription vpropDesc) {
        boolean bEditable = false;
        if ((this.mode & 2) != 0) {
            bEditable = false;
        } else {
            int settability = vpropDesc.getSettability();
            switch (settability) {
                case 1: {
                    if ((this.mode & 1) == 0 && (this.mode & 4) == 0) break;
                    bEditable = true;
                    break;
                }
                case 2: {
                    if ((this.mode & 1) == 0) break;
                    bEditable = true;
                    break;
                }
                case 3: {
                    bEditable = false;
                    break;
                }
                case 0: {
                    bEditable = true;
                    break;
                }
                default: {
                    bEditable = true;
                }
            }
        }
        return bEditable;
    }

    private boolean isPropSpecified(VerbosePropertyDescription vpropDesc) {
        for (int i = 0; i < this.specifiedNames.length; ++i) {
            if (!vpropDesc.getSymbolicName().equalsIgnoreCase(this.specifiedNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isPropFilteredOut(VerbosePropertyDescription vpropDesc) {
        for (int i = 0; i < this.filteredOutNames.length; ++i) {
            if (!vpropDesc.getSymbolicName().equalsIgnoreCase(this.filteredOutNames[i])) continue;
            return true;
        }
        return false;
    }

    public void focusGained(FocusEvent e) {
        if (this.gridScrollPane != null && e.getSource() instanceof JComponent) {
            JComponent jcomp = (JComponent)e.getSource();
            Container jParent = jcomp.getParent();
            Rectangle scrollTo = jParent != null && (jParent instanceof WcmMVCtrl || jParent instanceof WcmSVCtrl) ? jParent.getBounds() : jcomp.getBounds();
            JViewport vport = this.gridScrollPane.getViewport();
            scrollTo.y -= vport.getViewPosition().y;
            vport.scrollRectToVisible(scrollTo);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    private void tempTrace(String msg) {
        if (this.debugOutput) {
            System.out.println(msg);
        }
    }

    protected static class PropInfo {
        public VerbosePropertyDescription vpropDesc;
        public boolean isMultiLine;
        public Object propValue;
        public WcmUIComponent wcmUiComponent;
        public JComponent editComponent;

        public PropInfo(VerbosePropertyDescription vpropDesc, Object propValue) {
            this.vpropDesc = vpropDesc;
            this.propValue = propValue;
        }
    }
}

