/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.CustomObject;
import com.filenet.wcm.api.Document;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyDescriptions;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.ReadableMetadataObject;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.api.VersionSeries;
import com.filenet.wcm.api.util.Name;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.util.WcmException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class WcmItemProperty {
    private static Hashtable versionStatusLabelMap;

    private WcmItemProperty() {
    }

    public static void setObjStoreItemProperty(WcmDlgItemImpl item) throws WcmException {
        try {
            ObjectStore objStore = (ObjectStore)item.getWcmObject();
            Properties props = objStore.getProperties(WcmItemProperty.getPropNames(WcmItemProperty.createObjStorePropDescs()));
            WcmItemProperty.initObjStoreProps(item, props);
        }
        catch (Exception e) {
            System.out.println("ObjectStore WcmItemProperty got Exception! " + e.toString());
            System.out.println("Encountered bad ObjectStore.  Skip adding this ObjectStore.");
            throw new WcmException("client.WcmItemProperty.EncounteredBadObjectStore", "Encountered Bad ObjectStore.");
        }
    }

    public static void setFolderItemProperty(WcmDlgItemImpl item, WcmDlgItemImpl objStoreItem) throws WcmException, PropertyNotFoundException {
        Folder fldr = (Folder)item.getWcmObject();
        try {
            String name = objStoreItem.getFolderNamePropName();
            item.setLabel(fldr.getPropertyStringValue(name));
        }
        catch (Exception e) {
            System.out.println("Folder WcmItemProperty got Exception! " + e.toString());
            throw new WcmException("client.WcmItemProperty.FailGetName", "Failed getting name. Exception {0}.", (Object)e.getMessage());
        }
        Properties props = null;
        PropertyDescriptions propDescs = null;
        try {
            propDescs = objStoreItem.getFolderBasePropDescs();
            props = fldr.getProperties(WcmItemProperty.getPropNames(propDescs));
            WcmItemProperty.initFolderBaseProps(item, props, objStoreItem);
        }
        catch (Exception e) {
            System.out.println("Folder WcmItemProperty got Exception! " + e.toString());
            throw new WcmException("client.WcmItemProperty.FailGetProps", "Failed getting properties. Exception {0}.", (Object)e.getMessage());
        }
        try {
            propDescs = objStoreItem.getFolderDetailPropDescs();
            props = fldr.getProperties(WcmItemProperty.getPropNames(propDescs));
            WcmItemProperty.initFolderDetailProps(item, props, objStoreItem);
        }
        catch (Exception e) {
            propDescs = objStoreItem.getFolderDefaultDetailPropDescs();
            try {
                props = fldr.getProperties(WcmItemProperty.getPropNames(propDescs));
            }
            catch (Exception ex) {
                propDescs = ObjectFactory.getPropertyDescriptions((String[])new String[]{"Creator"});
                try {
                    props = fldr.getProperties(WcmItemProperty.getPropNames(propDescs));
                }
                catch (Exception ex1) {
                    props = ObjectFactory.getProperties();
                }
            }
            WcmItemProperty.initFolderDetailProps(item, props, objStoreItem);
        }
    }

    public static void setDocItemProperty(WcmDlgItemImpl item, WcmDlgItemImpl objStoreItem) throws WcmException, PropertyNotFoundException {
        ReadableMetadataObject doc = item.getWcmObject();
        try {
            String name = objStoreItem.getDocumentNamePropName();
            item.setLabel(doc.getPropertyStringValue(name));
        }
        catch (Exception e) {
            System.out.println("Document WcmItemProperty got Exception! " + e.toString());
            throw new WcmException("client.WcmItemProperty.FailGetName", "Failed getting name. Exception {0}.", (Object)e.getMessage());
        }
        Properties props = null;
        PropertyDescriptions propDescs = null;
        try {
            propDescs = objStoreItem.getDocumentBasePropDescs();
            props = ((Document)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            WcmItemProperty.initDocumentBaseProps(item, props, objStoreItem);
        }
        catch (Exception e) {
            System.out.println("Document WcmItemProperty got Exception! " + e.toString());
        }
        try {
            propDescs = objStoreItem.getDocumentDetailPropDescs();
            props = ((Document)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            WcmItemProperty.initDocumentDetailProps(item, props, objStoreItem);
        }
        catch (Exception e) {
            propDescs = objStoreItem.getDocumentDefaultDetailPropDescs();
            try {
                props = ((Document)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            }
            catch (Exception ex) {
                propDescs = ObjectFactory.getPropertyDescriptions((String[])new String[]{"ContentSize", "Creator", "MajorVersionNumber"});
                try {
                    props = ((Document)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
                }
                catch (Exception ex1) {
                    props = ObjectFactory.getProperties();
                }
            }
            WcmItemProperty.initDocumentDetailProps(item, props, objStoreItem);
        }
    }

    public static void setVersionItemProperty(WcmDlgItemImpl item, WcmDlgItemImpl objStoreItem) throws WcmException, PropertyNotFoundException {
        ReadableMetadataObject doc = item.getWcmObject();
        Properties props = null;
        PropertyDescriptions propDescs = null;
        try {
            propDescs = objStoreItem.getDocumentVersionsPropDescs();
            props = ((Document)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            WcmItemProperty.initDocumentVersionsProps(item, props, objStoreItem);
        }
        catch (Exception e) {
            propDescs = objStoreItem.getDocumentDefaultVersionsPropDescs();
            try {
                props = ((Document)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            }
            catch (Exception ex) {
                props = ObjectFactory.getProperties();
            }
            WcmItemProperty.initDocumentVersionsProps(item, props, objStoreItem);
        }
    }

    public static void setCustomObjProperty(WcmDlgItemImpl item, WcmDlgItemImpl objStoreItem) throws WcmException, PropertyNotFoundException {
        ReadableMetadataObject doc = item.getWcmObject();
        try {
            item.setLabel(doc.getPropertyStringValue("ID"));
        }
        catch (Exception e) {
            System.out.println("Document WcmItemProperty got Exception! " + e.toString());
            throw new WcmException("client.WcmItemProperty.FailGetName", "Failed getting name. Exception {0}.", (Object)e.getMessage());
        }
        Properties props = null;
        PropertyDescriptions propDescs = null;
        try {
            propDescs = ObjectFactory.getPropertyDescriptions((String[])new String[]{"ClassDescription"});
            props = ((CustomObject)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            WcmItemProperty.initDocumentBaseProps(item, props, objStoreItem);
        }
        catch (Exception e) {
            System.out.println("Document WcmItemProperty got Exception! " + e.toString());
        }
        try {
            propDescs = ObjectFactory.getPropertyDescriptions((String[])new String[]{"Creator", "LastModifier", "DateLastModified"});
            props = ((CustomObject)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            WcmItemProperty.initDocumentDetailProps(item, props, objStoreItem);
        }
        catch (Exception e) {
            propDescs = ObjectFactory.getPropertyDescriptions((String[])new String[]{"Creator", "LastModifier", "DateLastModified"});
            try {
                props = ((CustomObject)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
            }
            catch (Exception ex) {
                propDescs = ObjectFactory.getPropertyDescriptions((String[])new String[]{"Creator", "LastModifier", "DateLastModified"});
                try {
                    props = ((CustomObject)doc).getProperties(WcmItemProperty.getPropNames(propDescs));
                }
                catch (Exception ex1) {
                    props = ObjectFactory.getProperties();
                }
            }
            WcmItemProperty.initDocumentDetailProps(item, props, objStoreItem);
        }
    }

    public static String getClassDescDisplayName(ClassDescription cd) throws WcmException {
        try {
            String dispName = cd.getPropertyStringValue("DisplayName");
            return dispName;
        }
        catch (Exception e) {
            System.out.println("ClassDesc WcmItemProperty got Exception! " + e.toString());
            e.printStackTrace();
            throw new WcmException("client.WcmItemProperty.FailGetProps", "Failed getting properties. Exception {0}.", (Object)e.getMessage());
        }
    }

    private static void initObjStoreProps(WcmDlgItemImpl item, Properties props) {
        int cnt = props.size();
        for (int i = 0; i < cnt; ++i) {
            Property prop = (Property)props.get(i);
            Object propVal = prop.getValue();
            if (!prop.getName().equalsIgnoreCase("DisplayName")) continue;
            item.setLabel((String)propVal);
            break;
        }
    }

    private static PropertyDescriptions createObjStorePropDescs() {
        return ObjectFactory.getPropertyDescriptions((String[])new String[]{"DisplayName"});
    }

    private static void initFolderBaseProps(WcmDlgItemImpl item, Properties props, WcmDlgItemImpl objStoreItem) throws WcmException {
        int cnt = props.size();
        for (int i = 0; i < cnt; ++i) {
            Property prop = (Property)props.get(i);
            Object propVal = prop.getValue();
            if (!prop.getName().equalsIgnoreCase("ClassDescription")) continue;
            item.setClassDescription((ClassDescription)propVal);
        }
    }

    private static void initFolderDetailProps(WcmDlgItemImpl item, Properties props, WcmDlgItemImpl objStoreItem) throws WcmException {
        String[] detailedNames = objStoreItem.getDetailedNames();
        String[] detailedValues = new String[detailedNames.length];
        for (int i = 0; i < detailedNames.length; ++i) {
            detailedValues[i] = "";
        }
        int cnt = props.size();
        block3: for (int i = 0; i < cnt; ++i) {
            Property prop = (Property)props.get(i);
            Object propVal = prop.getValue();
            for (int j = 0; j < detailedNames.length; ++j) {
                if (!prop.getName().equalsIgnoreCase(detailedNames[j])) continue;
                try {
                    detailedValues[j] = PropertyUtil.getStringValue(propVal, true);
                }
                catch (Exception ex) {}
                continue block3;
            }
        }
        item.setDetailedValues(detailedValues);
    }

    private static void initDocumentBaseProps(WcmDlgItemImpl item, Properties props, WcmDlgItemImpl objStoreItem) throws WcmException {
        int cnt = props.size();
        for (int i = 0; i < cnt; ++i) {
            Property prop = (Property)props.get(i);
            Object propVal = prop.getValue();
            try {
                if (prop.getName().equalsIgnoreCase("ClassDescription")) {
                    item.setClassDescription((ClassDescription)propVal);
                    continue;
                }
                if (prop.getName().equalsIgnoreCase("MimeType")) {
                    item.setMimeType((String)propVal);
                    continue;
                }
                if (prop.getName().equalsIgnoreCase("IsReserved")) {
                    item.setIsReserved((Boolean)propVal);
                    continue;
                }
                if (prop.getName().equalsIgnoreCase("CompoundDocumentState")) {
                    item.setIsCompoundDocument((Integer)propVal != 0);
                    continue;
                }
                if (prop.getName().equalsIgnoreCase("CurrentState")) {
                    item.setCurrentLifecycleState((String)propVal);
                    continue;
                }
                if (prop.getName().equalsIgnoreCase("VersionStatus")) {
                    item.setIsReservation((Integer)propVal == 3);
                    continue;
                }
                if (prop.getName().equalsIgnoreCase("VersionSeries")) {
                    item.setVersionSeries((VersionSeries)propVal);
                    continue;
                }
                if (prop.getName().equalsIgnoreCase("MajorVersionNumber")) {
                    item.setMajorVersionNumber(((Integer)propVal).toString());
                    continue;
                }
                if (!prop.getName().equalsIgnoreCase("MinorVersionNumber")) continue;
                item.setMinorVersionNumber(((Integer)propVal).toString());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void initDocumentDetailProps(WcmDlgItemImpl item, Properties props, WcmDlgItemImpl objStoreItem) throws WcmException {
        String[] detailedNames = objStoreItem.getDetailedNames();
        String[] detailedValues = new String[detailedNames.length];
        for (int i = 0; i < detailedNames.length; ++i) {
            detailedValues[i] = "";
        }
        int cnt = props.size();
        block3: for (int i = 0; i < cnt; ++i) {
            Property prop = (Property)props.get(i);
            Object propVal = prop.getValue();
            if (propVal == null) continue;
            try {
                for (int j = 0; j < detailedNames.length; ++j) {
                    if (!prop.getName().equalsIgnoreCase(detailedNames[j])) continue;
                    detailedValues[j] = PropertyUtil.getStringValue(propVal, true);
                    continue block3;
                }
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception on " + prop.getName() + " " + ex.getMessage());
            }
        }
        item.setDetailedValues(detailedValues);
    }

    private static void initDocumentVersionsProps(WcmDlgItemImpl item, Properties props, WcmDlgItemImpl objStoreItem) throws WcmException, PropertyNotFoundException {
        String[] versionStatusLabels = WcmItemProperty.getVersionStatusLookups(objStoreItem);
        String[] versionsNames = objStoreItem.getVersionsNames();
        String[] versionsValues = new String[versionsNames.length];
        for (int i = 0; i < versionsNames.length; ++i) {
            versionsValues[i] = "";
        }
        int cnt = props.size();
        block3: for (int i = 0; i < cnt; ++i) {
            Property prop = (Property)props.get(i);
            Object propVal = prop.getValue();
            if (propVal == null) continue;
            try {
                for (int j = 0; j < versionsNames.length; ++j) {
                    if (!prop.getName().equalsIgnoreCase(versionsNames[j])) continue;
                    if (prop.getName().equalsIgnoreCase("VersionStatus")) {
                        versionsValues[j] = versionStatusLabels[(Integer)propVal - 1];
                        continue block3;
                    }
                    versionsValues[j] = propVal.toString();
                    continue block3;
                }
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception on " + prop.getName() + " " + ex.getMessage());
            }
        }
        item.setVersionsValues(versionsValues);
    }

    private static String getDisplayName(Properties props) {
        int cnt = props.size();
        for (int i = 0; i < cnt; ++i) {
            Property prop = (Property)props.get(i);
            String str = prop.getName();
            if (str == null || !str.equalsIgnoreCase("DisplayName")) continue;
            Object propVal = prop.getValue();
            String name = (String)propVal;
            return name;
        }
        System.out.println(" No Display Name found in properties.");
        return null;
    }

    public static String convertObjectTypeToName(int objType) {
        switch (objType) {
            case 1: {
                return WcmResourceString.s_document;
            }
            case -100: {
                return WcmResourceString.s_search;
            }
            case -101: {
                return WcmResourceString.s_publishTemplate;
            }
            case 1160: {
                return WcmResourceString.s_processDefinition;
            }
        }
        String sObjType = Name.objectTypeAsName((int)objType);
        return WcmResourceString.w_BaseObjectOf.toString(sObjType);
    }

    public static String[] getVersionStatusLookups(WcmDlgItemImpl objStoreItem) throws WcmException, PropertyNotFoundException {
        WcmItemProperty.checkParam(objStoreItem);
        String objectStoreID = objStoreItem.getId();
        if (versionStatusLabelMap == null) {
            versionStatusLabelMap = new Hashtable();
        }
        String[] list = new String[]{"1", "2", "3", "4"};
        if (versionStatusLabelMap.containsKey(objectStoreID)) {
            list = (String[])versionStatusLabelMap.get(objectStoreID);
        } else {
            Properties props;
            String id = "{BFF36187-91DF-4F90-BAC5-CD5B3F3C6D8A}";
            CustomObject custObj = (CustomObject)ObjectFactory.getObjectStore((String)objectStoreID, (Session)objStoreItem.getSession()).getObject(15, id);
            if (custObj != null && (props = custObj.getProperties(new String[]{"LookupList"})) != null) {
                Property prop = (Property)props.get(0);
                Values values = prop.getValuesValue();
                if (values != null && values.size() > 0) {
                    int count = values.size();
                    ArrayList<String> a = new ArrayList<String>();
                    for (int i = 0; i < count; ++i) {
                        a.add(((Value)values.get(i)).getStringValue());
                    }
                    list = new String[count];
                    a.toArray(list);
                }
                versionStatusLabelMap.put(objectStoreID, list);
            }
        }
        return list;
    }

    private static boolean checkParam(Object o) throws WcmException {
        String str;
        if (o == null) {
            throw new WcmException("client.WcmItemProperty.InvalidParameter", "Invalid parameter.");
        }
        if (o instanceof String && (str = (String)o).length() == 0) {
            throw new WcmException("client.WcmItemProperty.InvalidParameter", "Invalid parameter.");
        }
        return true;
    }

    private static String[] getPropNames(PropertyDescriptions propDescs) throws WcmException {
        String[] sPropNames;
        if (propDescs != null) {
            sPropNames = new String[propDescs.size()];
            Iterator iter = propDescs.iterator();
            int i = 0;
            while (iter.hasNext()) {
                PropertyDescription pd = null;
                pd = (PropertyDescription)iter.next();
                String sName = pd.getId();
                try {
                    sName = pd.getPropertyStringValue("SymbolicName");
                }
                catch (Exception e) {
                    // empty catch block
                }
                sPropNames[i++] = sName;
            }
        } else {
            sPropNames = new String[]{};
        }
        return sPropNames;
    }
}

