/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui;

import com.filenet.wcm.toolkit.client.ui.WcmDocIconInfo;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;

public final class WcmDlgIcons {
    public static final String ADD_DOCUMENT = "action/button/AddDocument32.gif";
    public static final String ADD_FOLDER = "action/button/AddFolder32.gif";
    public static final String BORDER = "misc/Border.gif";
    public static final String UP_ONE_LEVEL = "action/button/UpOneLevel16.gif";
    public static final String HOME = "action/button/Home16.gif";
    public static final String VERSION_LIST = "action/button/VersionList16.gif";
    public static final String VIEW_LIST = "action/button/ViewList16.gif";
    public static final String VIEW_DETAILS = "action/button/ViewDetails16.gif";
    public static final String NEW_FOLDER = "action/button/NewFolder16.gif";
    public static final String DELETE = "action/Delete16.gif";
    public static final String PROPERTIES = "action/Properties16.gif";
    public static final String REFRESH = "action/button/Refresh16.gif";
    public static final String OPEN_FOLDER = "action/OpenFolder16.gif";
    public static final String COLLAPSE = "action/Collapse16.gif";
    public static final String EXPAND = "action/Expand16.gif";
    public static final String CHOICES = "action/Choices16.gif";
    public static final String SEARCH = "action/button/Search16.gif";
    public static final String ERROR = "state/Error16.gif";
    public static final String ExternalDocument = "type/ExternalDocument";
    public static final String CompoundDocument = "state/CompoundDocument";
    public static final int INDEX_DEFAULT_DOC_ICON = 4;
    public static final int INDEX_CUSTOMOBJ_ICON = 5;
    public static final int INDEX_OBJSTORE_ERROR_ICON = 6;
    public static final int INDEX_CHECKEDOUT_ICON = 7;
    public static final int INDEX_DRAFTCHECK_ICON = 8;
    public static final int INDEX_MAJORDRAFTCHECK_ICON = 9;
    public static final int INDEX_DRAFT_ICON = 10;
    public static final int INDEX_MAJORDRAFT_ICON = 11;
    public static final int INDEX_BLANK_ICON = 12;
    private static String[] g_smallTypIconPaths = new String[]{"mime/Default16.gif", "type/Network16.gif", "type/ObjectStore16.gif", "type/Folder16.gif", "mime/Default16.gif", "type/CustomObject16.gif", "type/ObjectStoreError16.gif", "state/CheckedOut16.gif", "state/DraftCheck16.gif", "state/MajorDraftCheck16.gif", "state/Draft16.gif", "state/MajorDraft16.gif", "type/Blank32.gif"};
    private static String[] g_bigTypIconPaths = new String[]{"mime/Default32.gif", "type/Network32.gif", "type/ObjectStore32.gif", "type/Folder32.gif", "mime/Default32.gif", "type/CustomObject32.gif", "mime/Default32.gif", "type/Check32.gif", "type/Blank32.gif"};
    private static ImageIcon[] g_smallTypIconCache = null;
    private static ImageIcon[] g_bigTypIconCache = null;
    private static int g_nTypIcons = 13;
    private static final Map oIconInfo = new Hashtable();
    private static boolean bDocIconsInitialized;
    private static String sDefaultIcon;
    private static String sDefaultSmallIcon;
    private static String sDefaultLargeIcon;
    private static ImageIcon[] g_smallDocIconCache;
    private static ImageIcon[] g_bigDocIconCache;
    private static int g_nDocIcons;

    private WcmDlgIcons() {
    }

    public static void loadDocIconPropertyFile(URL sFilePath) {
        Properties oIcons = new Properties();
        try {
            InputStream in = sFilePath.openStream();
            oIcons.load(in);
            in.close();
            g_nDocIcons = oIcons.size();
        }
        catch (Exception e) {
            // empty catch block
        }
        g_smallDocIconCache = new ImageIcon[g_nDocIcons];
        g_bigDocIconCache = new ImageIcon[g_nDocIcons];
        sDefaultIcon = oIcons.getProperty("default", "mime/Default");
        sDefaultSmallIcon = sDefaultIcon + "16.gif";
        sDefaultLargeIcon = sDefaultIcon + "32.gif";
        int i = 0;
        for (Map.Entry<Object, Object> entry : oIcons.entrySet()) {
            String key = (String)entry.getKey();
            key = key.toLowerCase();
            WcmDocIconInfo iconInfo = new WcmDocIconInfo((String)entry.getValue(), i);
            oIconInfo.put(key, iconInfo);
            ++i;
        }
        bDocIconsInitialized = true;
    }

    public static boolean isDocIconsInitialized() {
        return bDocIconsInitialized;
    }

    public static ImageIcon getSmallTypIcon(int typ) {
        if (g_smallTypIconCache == null) {
            g_smallTypIconCache = new ImageIcon[g_nTypIcons];
        }
        if (g_smallTypIconCache[typ] == null) {
            WcmDlgIcons.g_smallTypIconCache[typ] = WcmImageLoader.createImageIcon(g_smallTypIconPaths[typ]);
        }
        return g_smallTypIconCache[typ];
    }

    public static ImageIcon getBigTypIcon(int typ) {
        if (g_bigTypIconCache == null) {
            g_bigTypIconCache = new ImageIcon[g_nTypIcons];
        }
        if (g_bigTypIconCache[typ] == null) {
            WcmDlgIcons.g_bigTypIconCache[typ] = WcmImageLoader.createImageIcon(g_bigTypIconPaths[typ]);
        }
        return g_bigTypIconCache[typ];
    }

    public static ImageIcon getSmallDocIcon(String sMimeType, boolean m_isCompoundDocument) {
        WcmDocIconInfo iconInfo;
        if (m_isCompoundDocument) {
            return WcmImageLoader.createImageIcon("state/CompoundDocument16.gif");
        }
        if (sMimeType == null) {
            return WcmImageLoader.createImageIcon("type/ExternalDocument16.gif");
        }
        if (!WcmDlgIcons.isDocIconsInitialized()) {
            WcmDlgIcons.loadDocIconPropertyFile(WcmDlgIcons.class.getResource("icons.properties"));
        }
        if ((iconInfo = (WcmDocIconInfo)oIconInfo.get(sMimeType.toLowerCase())) == null) {
            return WcmImageLoader.createImageIcon(sDefaultSmallIcon);
        }
        int idx = iconInfo.getIdx();
        if (g_smallDocIconCache[idx] == null) {
            WcmDlgIcons.g_smallDocIconCache[idx] = WcmImageLoader.createImageIcon(iconInfo.getPath() + "16.gif");
        }
        return g_smallDocIconCache[idx];
    }

    public static ImageIcon getBigDocIcon(String sMimeType) {
        WcmDocIconInfo iconInfo;
        if (sMimeType == null) {
            return WcmImageLoader.createImageIcon("type/ExternalDocument32.gif");
        }
        if (!WcmDlgIcons.isDocIconsInitialized()) {
            WcmDlgIcons.loadDocIconPropertyFile(WcmDlgIcons.class.getResource("icons.properties"));
        }
        if ((iconInfo = (WcmDocIconInfo)oIconInfo.get(sMimeType.toLowerCase())) == null) {
            return WcmImageLoader.createImageIcon(sDefaultLargeIcon);
        }
        int idx = iconInfo.getIdx();
        if (g_bigDocIconCache[idx] == null) {
            WcmDlgIcons.g_bigDocIconCache[idx] = WcmImageLoader.createImageIcon(iconInfo.getPath() + "32.gif");
        }
        return g_bigDocIconCache[idx];
    }

    static {
        g_smallDocIconCache = null;
        g_bigDocIconCache = null;
        g_nDocIcons = 0;
    }
}

