/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.toolkit.client.ui;

import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.util.WcmStringUtil;
import com.filenet.wcm.toolkit.util.WcmBuildStamp;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class WcmAboutBox
extends JDialog
implements ActionListener {
    private Container m_contentPane;
    private Frame m_parentFrame;
    private JTextPane m_text = new JTextPane();
    private JPanel m_mainPanel = new JPanel(new GridBagLayout());
    private JPanel m_msgPanel = new JPanel(new GridLayout(6, 1));
    private Font m_copyrightFont = null;
    private JButton m_OKButton = new JButton(WcmResourceString.ok_wouthkey);

    public WcmAboutBox(Frame parent) {
        super(parent, true);
        this.m_parentFrame = parent;
    }

    public void init(String title, String applicationName, ImageIcon icon) {
        this.m_contentPane = this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout(10, 10));
        this.setTitle(title);
        Dimension dim = WcmStringUtil.stringToDimension(WcmResourceString.s_aboutDlgDim);
        if (dim == null) {
            dim = new Dimension(475, 350);
        }
        this.setSize(dim);
        this.setVisible(false);
        GridBagConstraints standard = new GridBagConstraints();
        standard.gridx = 1;
        standard.gridy = 1;
        standard.anchor = 21;
        standard.insets = new Insets(10, 10, 0, 0);
        standard.weightx = 0.7;
        GridBagConstraints iconValues = new GridBagConstraints();
        iconValues.gridx = 0;
        iconValues.gridy = 1;
        iconValues.anchor = 21;
        iconValues.insets = new Insets(0, 20, 0, 0);
        iconValues.weightx = 0.1;
        GridBagConstraints textWin = new GridBagConstraints();
        textWin.gridx = 1;
        textWin.gridy = 2;
        textWin.anchor = 21;
        textWin.fill = 1;
        textWin.insets = new Insets(0, 50, 0, 0);
        textWin.weightx = 0.7;
        textWin.weighty = 0.3;
        JLabel iconLabel = new JLabel(icon);
        this.m_mainPanel.add((Component)iconLabel, iconValues);
        JLabel companyLabel = new JLabel("IBM FileNet Corporation");
        JLabel appletLabel = new JLabel(applicationName + "  " + "1.1.5");
        JLabel versionLabel = new JLabel("[orion115.237 - " + WcmBuildStamp.buildDate.toString() + "]");
        JLabel copyrightLabel = new JLabel(WcmBuildStamp.companyCopyrightString.toString());
        companyLabel.setForeground(Color.black);
        appletLabel.setForeground(Color.black);
        versionLabel.setForeground(Color.black);
        copyrightLabel.setForeground(Color.black);
        this.m_msgPanel.add((Component)companyLabel, 0);
        this.m_msgPanel.add((Component)new JLabel(), 1);
        this.m_msgPanel.add((Component)appletLabel, 2);
        this.m_msgPanel.add((Component)versionLabel, 3);
        this.m_msgPanel.add((Component)new JLabel(), 4);
        this.m_msgPanel.add((Component)copyrightLabel, 5);
        this.m_mainPanel.add((Component)this.m_msgPanel, standard);
        this.m_contentPane.add("First", this.m_mainPanel);
        JPanel m_scrollPanel = new JPanel(new GridBagLayout());
        this.m_text.setText(WcmStringUtil.getAllCopyrightStrings());
        this.m_text.setCaretPosition(0);
        try {
            if (this.m_copyrightFont == null) {
                this.m_copyrightFont = this.createFont(WcmResourceString.s_aboutDlgFont, new Integer(WcmResourceString.s_aboutDlgFontSize));
            }
            this.m_text.setFont(this.m_copyrightFont);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_text.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.m_text);
        scroller.setMaximumSize(new Dimension(200, 160));
        m_scrollPanel.add((Component)scroller, textWin);
        this.m_contentPane.add("Center", m_scrollPanel);
        this.m_contentPane.add("After", new JPanel());
        this.m_contentPane.add("Before", new JPanel());
        JPanel buttonPanel = new JPanel();
        this.m_OKButton.setSelected(true);
        this.m_OKButton.setMnemonic(WcmResourceString.okMonic.charAt(0));
        buttonPanel.add(this.m_OKButton);
        this.getRootPane().setDefaultButton(this.m_OKButton);
        this.m_contentPane.add("Last", buttonPanel);
        this.m_OKButton.addActionListener(this);
        this.setLocationRelativeTo(this.m_parentFrame);
        this.applyComponentOrientation(this.m_parentFrame.getComponentOrientation());
    }

    public void setFont(Font newFont) {
        if (newFont != null) {
            this.m_copyrightFont = newFont;
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_OKButton) {
            this.setVisible(false);
        }
    }

    private Font createFont(String name, int size) throws WcmException {
        try {
            Font newFont;
            if (name.length() > 0 && size > 0 && (newFont = new Font(name, 0, size)) != null) {
                return newFont;
            }
            newFont = new Font(this.m_text.getFont().getName(), 0, 10);
            return newFont;
        }
        catch (Exception e) {
            System.out.println("Error occurred creating copyright font: " + e.getMessage());
            throw new WcmException("client.WcmAboutBox.invalidFont", "An error occurred creating the font: {0}, {1}", (Object)name, (Object)new Integer(size).toString());
        }
    }
}

