/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.server.util.prefs;

import com.filenet.wcm.apps.server.util.prefs.WcmBasePrefs;
import com.filenet.wcm.apps.server.util.prefs.WcmObjectStorePrefs;
import com.filenet.wcm.toolkit.server.util.prefs.WcmPrefsObject;
import com.filenet.wcm.toolkit.util.WcmEncodingUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WcmSitePrefs
extends WcmBasePrefs {
    public static final String ADVANCED_AUTHOR = "advancedAuthor";
    protected String startPage;
    protected String defaultObjectStoreName;
    protected int navigationRowSize;
    protected int choiceListSize;
    protected int filterDocumentMaxResults;
    protected int filterFolderMaxResults;
    protected int filterCustomObjectMaxResults;
    protected int absoluteMaxResults;
    protected boolean addAsMajorVersion;
    protected boolean annotUseSecurity;
    protected boolean checkinAsMajorVersion;
    protected boolean requireFolderSelection;
    protected boolean enableFileTracking;
    protected String defaultDocDir;
    protected String appendedPath;
    protected boolean deleteLocalCopy;
    protected boolean deleteLocalCopyReadOnly;
    protected boolean webContentManagementInstalled;
    protected boolean recordsManagementInstalled;
    protected boolean eformsInstalled;
    protected boolean showFolderFilterAlways;
    protected boolean showCustomObjects;
    protected boolean showLinkObjects;
    protected boolean showBrowseTreeview;
    protected boolean useFolderCaching;
    protected boolean defineFolderInheritance;
    protected boolean showSecurityPage;
    protected boolean usePathBasedURLs;
    protected int keepAliveInterval;
    protected int keepFolderCacheInterval;
    protected String mailHost;
    protected String mailUser;
    protected String mailPassword;
    protected String connectionPoint;
    protected String simulatorEngineHost;
    protected int stepMilestoneLevel;
    protected int granteeMaximumFilterSize;
    protected List registeredPalettes = new ArrayList();
    protected List referenceServices = new ArrayList();
    protected List authorPageLinks = new ArrayList();
    protected List registeredPortlets = new ArrayList();
    protected List portalPlaces = new ArrayList();
    protected String homePageMasterGroup;
    protected String homePageMasterGroupId;
    private String[] pageOrder;
    private String[] rmPageOrder;
    protected List outlookProfiles = new ArrayList();
    protected boolean showTime = false;
    protected Set rmRecordTemplateRoles = new HashSet();
    protected Set multiSelectRoles = new HashSet();
    protected Set multiDownloadRoles = new HashSet();
    protected Set multiSaveRoles = new HashSet();
    protected Set defineFolderInheritanceRoles = new HashSet();
    protected String workplaceBaseURL;
    protected String rMbaseURL;
    protected String wcmBaseURL;
    protected String wcmEJBServer;
    protected String wcmInitialContextFactory;
    private boolean showTasksFilter;
    private boolean showFooterLinks;
    private boolean showTabBar = true;
    private int taskFilterThreshold;
    protected String defaultFilePlanObjectStoreName;
    protected String defaultFilePlan;
    protected String defaultFilePlanId;
    protected String reportServerPath;
    protected int chap4Properties;
    protected Map objectStoreSettings = new Hashtable();
    protected Map inboxSettings = new Hashtable();
    protected Map restrictedFeatures = new Hashtable();
    protected Map compoundDocumentObjectStoreSettings = new Hashtable();

    public boolean getShowTabBar() {
        return this.showTabBar;
    }

    public void setShowTabBar(boolean showTabBar) {
        this.showTabBar = showTabBar;
    }

    public boolean getShowFooterLinks() {
        return this.showFooterLinks;
    }

    public void setShowFooterLinks(boolean showFooterLinks) {
        this.showFooterLinks = showFooterLinks;
    }

    public String[] getPageOrder() {
        return this.pageOrder;
    }

    public void setPageOrder(String[] pageOrder) {
        this.pageOrder = pageOrder;
    }

    public String getWorkplaceBaseURL() {
        return this.workplaceBaseURL;
    }

    public void setWorkplaceBaseURL(String baseURL) {
        this.workplaceBaseURL = baseURL;
    }

    public String getRMbaseURL() {
        return this.rMbaseURL;
    }

    public void setRMbaseURL(String RMbaseURL) {
        this.rMbaseURL = RMbaseURL;
    }

    public String getWcmBaseURL() {
        return this.wcmBaseURL;
    }

    public void setWcmBaseURL(String url) {
        this.wcmBaseURL = url;
    }

    public String getWCMBaseURL() {
        return this.wcmBaseURL;
    }

    public void setWCMBaseURL(String url) {
        this.wcmBaseURL = url;
    }

    public void setWCMEJBServer(String url) {
        this.wcmEJBServer = url;
    }

    public String getWCMEJBServer() {
        return this.wcmEJBServer;
    }

    public void setWCMInitialContextFactory(String initialContextFactory) {
        this.wcmInitialContextFactory = initialContextFactory;
    }

    public String getWCMInitialContextFactory() {
        return this.wcmInitialContextFactory;
    }

    public String[] getRMPageOrder() {
        return this.rmPageOrder;
    }

    public void setRMPageOrder(String[] pageOrder) {
        this.rmPageOrder = pageOrder;
    }

    public boolean getIsWebContentManagementInstalled() {
        return this.webContentManagementInstalled && this.wcmBaseURL != null;
    }

    public void setIsWebContentManagementInstalled(boolean on) {
        this.webContentManagementInstalled = on;
    }

    public boolean getIsRecordsManagementInstalled() {
        return this.recordsManagementInstalled;
    }

    public void setIsRecordsManagementInstalled(boolean on) {
        this.recordsManagementInstalled = on;
    }

    public String getDefaultFilePlanName() {
        return this.defaultFilePlan;
    }

    public void setDefaultFilePlanName(String filePlan) {
        this.defaultFilePlan = filePlan;
    }

    public String getDefaultFilePlanId() {
        return this.defaultFilePlanId;
    }

    public void setDefaultFilePlanId(String Id) {
        this.defaultFilePlanId = Id;
    }

    public String getDefaultFilePlanObjectStoreName() {
        return this.defaultFilePlanObjectStoreName;
    }

    public void setDefaultFilePlanObjectStoreName(String name) {
        this.defaultFilePlanObjectStoreName = name;
    }

    public Map getObjectStoreSettingsMap() {
        return Collections.unmodifiableMap(this.objectStoreSettings);
    }

    public Map getCompoundDocumentObjectStoreSettingsMap() {
        return Collections.unmodifiableMap(this.compoundDocumentObjectStoreSettings);
    }

    public Map getInboxSettingMap() {
        return Collections.unmodifiableMap(this.inboxSettings);
    }

    public Map getFilePlanObjectStoreMap() {
        Hashtable<String, String> resultMap = new Hashtable<String, String>();
        Set keySet = this.objectStoreSettings.keySet();
        for (String objectStoreName : keySet) {
            WcmObjectStorePrefs d = (WcmObjectStorePrefs)this.objectStoreSettings.get(objectStoreName);
            if (d == null || !d.getSupportFilePlan()) continue;
            resultMap.put(objectStoreName, objectStoreName);
        }
        return resultMap;
    }

    public void setCanClassifyRecord(int value) {
        this.chap4Properties = value;
    }

    public int getCanClassifyRecord() {
        return this.chap4Properties;
    }

    public void setReportServerPath(String newPath) {
        this.reportServerPath = newPath;
    }

    public String getReportServerPath() {
        return this.reportServerPath;
    }

    public boolean getIsEformsInstalled() {
        return this.eformsInstalled;
    }

    public void setIsEformsInstalled(boolean on) {
        this.eformsInstalled = on;
    }

    public void setHomePage(String newHomePage) {
        this.startPage = newHomePage;
    }

    public String getHomePage() {
        return this.startPage;
    }

    public void setDefaultObjectStoreName(String defaultObjectStoreName) {
        this.defaultObjectStoreName = defaultObjectStoreName;
    }

    public String getDefaultObjectStoreName() {
        return this.defaultObjectStoreName != null && this.defaultObjectStoreName.length() > 0 ? this.defaultObjectStoreName : null;
    }

    public void setFilterDocumentMaxResults(int newFilterDocumentMaxResults) {
        this.filterDocumentMaxResults = newFilterDocumentMaxResults;
    }

    public void setFilterFolderMaxResults(int newFilterFolderMaxResults) {
        this.filterFolderMaxResults = newFilterFolderMaxResults;
    }

    public int getFilterDocumentMaxResults() {
        return this.filterDocumentMaxResults;
    }

    public int getFilterFolderMaxResults() {
        return this.filterFolderMaxResults;
    }

    public void setFilterCustomObjectMaxResults(int newFilterCustomObjectMaxResults) {
        this.filterCustomObjectMaxResults = newFilterCustomObjectMaxResults;
    }

    public int getFilterCustomObjectMaxResults() {
        return this.filterCustomObjectMaxResults;
    }

    public int getAbsoluteMaxResults() {
        return this.absoluteMaxResults;
    }

    public void setAbsoluteMaxResults(int absoluteMaxResults) {
        this.absoluteMaxResults = absoluteMaxResults;
    }

    public void setDesignerToolsGroups(String[] groups) {
    }

    public String[] getDesignerToolsGroups() {
        return null;
    }

    public void setNavigationRowSize(int newNavigationRowSize) {
        this.navigationRowSize = newNavigationRowSize;
    }

    public int getNavigationRowSize() {
        return this.navigationRowSize;
    }

    public void setChoiceListSize(int newChoiceListSize) {
        this.choiceListSize = newChoiceListSize;
    }

    public int getChoiceListSize() {
        return this.choiceListSize;
    }

    public void setAddAsMajorVersion(boolean newAddAsMajorVersion) {
        this.addAsMajorVersion = newAddAsMajorVersion;
    }

    public boolean getAddAsMajorVersion() {
        return this.addAsMajorVersion;
    }

    public void setAnnotUseSecurity(boolean newAnnotUseSecurity) {
        this.annotUseSecurity = newAnnotUseSecurity;
    }

    public boolean getAnnotUseSecurity() {
        return this.annotUseSecurity;
    }

    public void setCheckinAsMajorVersion(boolean newCheckinAsMajorVersion) {
        this.checkinAsMajorVersion = newCheckinAsMajorVersion;
    }

    public boolean getCheckinAsMajorVersion() {
        return this.checkinAsMajorVersion;
    }

    public void setRequireFolderSelection(boolean newRequireFolderSelection) {
        this.requireFolderSelection = newRequireFolderSelection;
    }

    public boolean getRequireFolderSelection() {
        return this.requireFolderSelection;
    }

    public void setEnableFileTracking(boolean newEnableFileTracking) {
        this.enableFileTracking = newEnableFileTracking;
    }

    public boolean getEnableFileTracking() {
        return this.enableFileTracking;
    }

    public String getDefaultDocumentDirectory() {
        return this.defaultDocDir;
    }

    public void setDefaultDocumentDirectory(String newDefaultDocDir) {
        this.defaultDocDir = newDefaultDocDir;
    }

    public String getAppendedPath() {
        return this.appendedPath;
    }

    public void setAppendedPath(String newAppendedPath) {
        this.appendedPath = newAppendedPath;
    }

    public boolean getDeleteLocalCopy() {
        return this.deleteLocalCopy;
    }

    public void setDeleteLocalCopy(boolean newDeleteLocalCopy) {
        this.deleteLocalCopy = newDeleteLocalCopy;
    }

    public boolean getDeleteLocalCopyReadOnly() {
        return this.deleteLocalCopyReadOnly;
    }

    public void setDeleteLocalCopyReadOnly(boolean deleteLocalCopyReadOnly) {
        this.deleteLocalCopyReadOnly = deleteLocalCopyReadOnly;
    }

    public void setShowSecurityPage(boolean newShowSecurityPage) {
        this.showSecurityPage = newShowSecurityPage;
    }

    public boolean getShowSecurityPage() {
        return this.showSecurityPage;
    }

    public boolean getShowCustomObjects() {
        return this.showCustomObjects;
    }

    public void setShowCustomObjects(boolean newShowCustomObjects) {
        this.showCustomObjects = newShowCustomObjects;
    }

    public boolean getShowLinkObjects() {
        return this.showLinkObjects;
    }

    public void setShowLinkObjects(boolean newShowLinkObjects) {
        this.showLinkObjects = newShowLinkObjects;
    }

    public boolean getShowBrowseTreeview() {
        return this.showBrowseTreeview;
    }

    public void setShowBrowseTreeview(boolean newShowBrowseTreeview) {
        this.showBrowseTreeview = newShowBrowseTreeview;
    }

    public boolean getUseFolderCaching() {
        return this.useFolderCaching;
    }

    public void setUseFolderCaching(boolean newUseFolferCaching) {
        this.useFolderCaching = newUseFolferCaching;
    }

    public boolean getDefineFolderInheritance() {
        return this.defineFolderInheritance;
    }

    public void setDefineFolderInheritance(boolean newDefineFolderInheritance) {
        this.defineFolderInheritance = newDefineFolderInheritance;
    }

    public boolean getShowFolderFilterAlways() {
        return this.showFolderFilterAlways;
    }

    public void setShowFolderFilterAlways(boolean newShowFolderFilterAlways) {
        this.showFolderFilterAlways = newShowFolderFilterAlways;
    }

    public void setShowDesignerTools(boolean newShowDesignerTools) {
    }

    public boolean getShowDesignerTools() {
        return true;
    }

    public void setUsePathBasedURLs(boolean newUsePathBasedURLs) {
        this.usePathBasedURLs = newUsePathBasedURLs;
    }

    public boolean getUsePathBasedURLs() {
        return this.usePathBasedURLs;
    }

    public void setKeepAliveInterval(int newKeepAliveInterval) {
        this.keepAliveInterval = newKeepAliveInterval;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepFolderCacheInterval(int newKeepFolderCacheInterval) {
        this.keepFolderCacheInterval = newKeepFolderCacheInterval;
    }

    public int getKeepFolderCacheInterval() {
        return this.keepFolderCacheInterval;
    }

    public void setShowTasksFilter(boolean newValue) {
        this.showTasksFilter = newValue;
    }

    public boolean getShowTasksFilter() {
        return this.showTasksFilter;
    }

    public void setTasksFilterThreshold(int newValue) {
        this.taskFilterThreshold = newValue;
    }

    public int getTasksFilterThreshold() {
        return this.taskFilterThreshold;
    }

    public void setRouterHost(String newRouterHost) {
        this.connectionPoint = newRouterHost;
    }

    public String getRouterHost() {
        return this.connectionPoint;
    }

    public void setConnectionPoint(String newConnectionPoint) {
        this.connectionPoint = newConnectionPoint;
    }

    public String getConnectionPoint() {
        return this.connectionPoint;
    }

    public void setMailHost(String newMailHost) {
        this.mailHost = newMailHost;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailUser(String newMail) {
        this.mailUser = newMail;
    }

    public String getMailUser() {
        return this.mailUser;
    }

    private static String encode(String input) {
        try {
            return WcmEncodingUtil.encodeBase64(input);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String decode(String input) {
        try {
            return WcmEncodingUtil.decodeBase64(input);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setMailPassword(String newMail) {
        this.mailPassword = WcmSitePrefs.encode(newMail);
    }

    public String getMailPassword() {
        return WcmSitePrefs.decode(this.mailPassword);
    }

    public String getMailPasswordForUpgrade() {
        return this.mailPassword;
    }

    public void setStepMilestoneLevel(int newStepMilestoneLevel) {
        this.stepMilestoneLevel = newStepMilestoneLevel;
    }

    public int getStepMilestoneLevel() {
        return this.stepMilestoneLevel;
    }

    public void setGranteeMaximumFilterSize(int newGranteeMaximumFilterSize) {
        this.granteeMaximumFilterSize = newGranteeMaximumFilterSize;
    }

    public int getGranteeMaximumFilterSize() {
        return this.granteeMaximumFilterSize;
    }

    public WcmObjectStorePrefs getDefaultObjectStorePrefs() {
        return this.defaultPrefsObjects.getDefaultObjectStorePrefs();
    }

    public List getReferenceServices() {
        return this.referenceServices;
    }

    public String getHomePageMasterGroup() {
        return this.homePageMasterGroup;
    }

    public void setHomePageMasterGroup(String group) {
        this.homePageMasterGroup = group;
    }

    public String getHomePageMasterGroupId() {
        return this.homePageMasterGroupId;
    }

    public void setHomePageMasterGroupId(String id) {
        this.homePageMasterGroupId = id;
    }

    public WcmObjectStorePrefs getObjectStorePrefs(String objectStoreName) {
        if (objectStoreName == null || objectStoreName.length() == 0) {
            return this.getDefaultObjectStorePrefs();
        }
        WcmObjectStorePrefs d = (WcmObjectStorePrefs)this.objectStoreSettings.get(objectStoreName);
        if (d == null) {
            d = (WcmObjectStorePrefs)this.getDefaultObjectStorePrefs().clone();
            d.setObjectStoreName(objectStoreName);
            this.objectStoreSettings.put(objectStoreName, d);
        }
        return d;
    }

    public RestrictedFeature getRestrictedFeature(String pageId) {
        if (pageId == null) {
            return new RestrictedFeature();
        }
        RestrictedFeature p = (RestrictedFeature)this.restrictedFeatures.get(pageId);
        if (p == null) {
            p = new RestrictedFeature();
            p.id = pageId;
            this.restrictedFeatures.put(pageId, p);
        }
        return p;
    }

    public Map getRestrictedFeatureMap() {
        return this.restrictedFeatures;
    }

    protected void saveToXML(Writer w) throws IOException {
        super.saveToXML(w);
        ArrayList lstObjectStoreSettings = new ArrayList(this.objectStoreSettings.values());
        ArrayList lstInboxSettings = new ArrayList(this.inboxSettings.values());
        ArrayList lstRestrictedFeatures = new ArrayList(this.restrictedFeatures.values());
        this.writeSetting(w, "startPage", this.startPage);
        this.writeSetting(w, "defaultObjectStoreName", this.defaultObjectStoreName);
        this.writeSetting(w, "navigationRowSize", this.navigationRowSize);
        this.writeSetting(w, "filterDocumentMaxResults", this.filterDocumentMaxResults);
        this.writeSetting(w, "filterFolderMaxResults", this.filterFolderMaxResults);
        this.writeSetting(w, "filterCustomObjectMaxResults", this.filterCustomObjectMaxResults);
        this.writeSetting(w, "absoluteMaxResults", this.absoluteMaxResults);
        this.writeSetting(w, "choiceListSize", this.choiceListSize);
        this.writeSetting(w, "addAsMajorVersion", this.addAsMajorVersion);
        this.writeSetting(w, "checkinAsMajorVersion", this.checkinAsMajorVersion);
        this.writeSetting(w, "annotUseSecurity", this.annotUseSecurity);
        this.writeSetting(w, "requireFolderSelection", this.requireFolderSelection);
        this.writeSetting(w, "enableFileTracking", this.enableFileTracking);
        this.writeSetting(w, "defaultDocumentDirectory", this.defaultDocDir);
        this.writeSetting(w, "appendedPath", this.appendedPath);
        this.writeSetting(w, "deleteLocalCopy", this.deleteLocalCopy);
        this.writeSetting(w, "deleteLocalCopyReadOnly", this.deleteLocalCopyReadOnly);
        this.writeSetting(w, "showCustomObjects", this.showCustomObjects);
        this.writeSetting(w, "showLinkObjects", this.showLinkObjects);
        this.writeSetting(w, "showBrowseTreeview", this.showBrowseTreeview);
        this.writeSetting(w, "useFolderCaching", this.useFolderCaching);
        this.writeSetting(w, "defineFolderInheritance", this.defineFolderInheritance);
        this.writeSetting(w, "showFolderFilterAlways", this.showFolderFilterAlways);
        this.writeSetting(w, "showSecurityPage", this.showSecurityPage);
        this.writeSetting(w, "webContentManagementInstalled", this.webContentManagementInstalled);
        this.writeSetting(w, "recordsManagementInstalled", this.recordsManagementInstalled);
        this.writeSetting(w, "defaultFilePlan", this.defaultFilePlan);
        this.writeSetting(w, "defaultFilePlanId", this.defaultFilePlanId);
        this.writeSetting(w, "defaultFilePlanObjectStoreName", this.defaultFilePlanObjectStoreName);
        this.writeSetting(w, "reportServerPath", this.reportServerPath);
        this.writeSetting(w, "eformsInstalled", this.eformsInstalled);
        this.writeSetting(w, "showTime", this.showTime);
        this.writeSetting(w, "usePathBasedURLs", this.usePathBasedURLs);
        this.writeSetting(w, "keepAliveInterval", this.keepAliveInterval);
        this.writeSetting(w, "keepFolderCacheInterval", this.keepFolderCacheInterval);
        this.writeSetting(w, "connectionPoint", this.connectionPoint);
        this.writeSetting(w, "mailHost", this.mailHost);
        this.writeSetting(w, "mailUser", this.mailUser);
        this.writeSetting(w, "mailPassword", this.mailPassword);
        this.writeSetting(w, "simulatorEngineHost", this.simulatorEngineHost);
        this.writeSetting(w, "stepMilestoneLevel", this.stepMilestoneLevel);
        this.writeSetting(w, "granteeMaximumFilterSize", this.granteeMaximumFilterSize);
        this.writeSetting(w, "objectStoreSettings", lstObjectStoreSettings);
        this.writeSetting(w, "restrictedFeatures", lstRestrictedFeatures);
        this.writeSetting(w, "referenceServices", this.referenceServices);
        this.writeSetting(w, "registeredPalettes", this.registeredPalettes);
        this.writeSetting(w, "authorPageLinks", this.authorPageLinks);
        this.writeSetting(w, "registeredPortlets", this.registeredPortlets);
        this.writeSetting(w, "portalPlaces", this.portalPlaces);
        this.writeSetting(w, "homePageMasterGroup", this.homePageMasterGroup);
        this.writeSetting(w, "homePageMasterGroupId", this.homePageMasterGroupId);
        this.writeSetting(w, "pageOrder", this.pageOrder);
        this.writeSetting(w, "rmPageOrder", this.rmPageOrder);
        this.writeSetting(w, "outlookProfiles", this.outlookProfiles);
        this.writeSetting(w, "workplaceBaseURL", this.workplaceBaseURL);
        this.writeSetting(w, "RMBaseURL", this.rMbaseURL);
        this.writeSetting(w, "WCMBaseURL", this.wcmBaseURL);
        this.writeSetting(w, "WCMEJBServer", this.wcmEJBServer);
        this.writeSetting(w, "inboxSettings", lstInboxSettings);
        this.writeSetting(w, "showTasksFilter", this.showTasksFilter);
        this.writeSetting(w, "taskFilterThreshold", this.taskFilterThreshold);
        this.writeSetting(w, "showFooterLinks", this.showFooterLinks);
        this.writeSetting(w, "showTabBar", this.showTabBar);
        ArrayList lstCDObjectStoreSettings = new ArrayList(this.compoundDocumentObjectStoreSettings.values());
        this.writeSetting(w, "compoundDocumentObjectStoreSettings", lstCDObjectStoreSettings);
        String[] rmRecordTemplateRolesArray = new String[this.rmRecordTemplateRoles.size()];
        this.rmRecordTemplateRoles.toArray(rmRecordTemplateRolesArray);
        this.writeSetting(w, "rmRecordTemplateRoles", rmRecordTemplateRolesArray);
        String[] multiSelectRolesArray = new String[this.multiSelectRoles.size()];
        this.multiSelectRoles.toArray(multiSelectRolesArray);
        this.writeSetting(w, "multiSelectRoles", multiSelectRolesArray);
        String[] downloadRolesArray = new String[this.multiDownloadRoles.size()];
        this.multiDownloadRoles.toArray(downloadRolesArray);
        this.writeSetting(w, "multiDownloadRoles", downloadRolesArray);
        String[] multiSaveRolesArray = new String[this.multiSaveRoles.size()];
        this.multiSaveRoles.toArray(multiSaveRolesArray);
        this.writeSetting(w, "multiSaveRoles", multiSaveRolesArray);
        String[] defineFolderInheritanceRolesArray = new String[this.defineFolderInheritanceRoles.size()];
        this.defineFolderInheritanceRoles.toArray(defineFolderInheritanceRolesArray);
        this.writeSetting(w, "defineFolderInheritanceRolesArray", defineFolderInheritanceRolesArray);
    }

    protected void initialize() {
        String[] roles;
        String key;
        WcmPrefsObject o;
        int i;
        int len;
        super.initialize();
        Object value = this.remove("startPage");
        if (value != null) {
            this.startPage = (String)value;
        }
        if ((value = this.remove("defaultObjectStoreName")) != null) {
            this.defaultObjectStoreName = (String)value;
        }
        this.filterDocumentMaxResults = (value = this.remove("filterDocumentMaxResults")) != null ? WcmSitePrefs.convertToInt(value) : 100;
        value = this.remove("filterFolderMaxResults");
        this.filterFolderMaxResults = value != null ? WcmSitePrefs.convertToInt(value) : 100;
        value = this.remove("absoluteMaxResults");
        this.absoluteMaxResults = value != null ? WcmSitePrefs.convertToInt(value) : 500;
        value = this.remove("filterCustomObjectMaxResults");
        this.filterCustomObjectMaxResults = value != null ? WcmSitePrefs.convertToInt(value) : 100;
        value = this.remove("navigationRowSize");
        if (value != null) {
            this.navigationRowSize = WcmSitePrefs.convertToInt(value);
        }
        if ((value = this.remove("choiceListSize")) != null) {
            this.choiceListSize = WcmSitePrefs.convertToInt(value);
        }
        if ((value = this.remove("addAsMajorVersion")) != null) {
            this.addAsMajorVersion = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("annotUseSecurity")) != null) {
            this.annotUseSecurity = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("checkinAsMajorVersion")) != null) {
            this.checkinAsMajorVersion = WcmSitePrefs.convertToBoolean(value);
        }
        this.requireFolderSelection = (value = this.remove("requireFolderSelection")) != null ? WcmSitePrefs.convertToBoolean(value) : true;
        value = this.remove("enableFileTracking");
        this.enableFileTracking = value != null ? WcmSitePrefs.convertToBoolean(value) : false;
        this.appendedPath = (String)this.remove("appendedPath");
        value = this.remove("deleteLocalCopy");
        this.deleteLocalCopy = value != null ? WcmSitePrefs.convertToBoolean(value) : false;
        value = this.remove("deleteLocalCopyReadOnly");
        this.deleteLocalCopyReadOnly = value != null ? WcmSitePrefs.convertToBoolean(value) : false;
        value = this.remove("showCustomObjects");
        if (value != null) {
            this.showCustomObjects = WcmSitePrefs.convertToBoolean(value);
        }
        this.showLinkObjects = (value = this.remove("showLinkObjects")) != null ? WcmSitePrefs.convertToBoolean(value) : false;
        value = this.remove("showBrowseTreeview");
        if (value != null) {
            this.showBrowseTreeview = WcmSitePrefs.convertToBoolean(value);
        }
        this.useFolderCaching = (value = this.remove("useFolderCaching")) != null ? WcmSitePrefs.convertToBoolean(value) : true;
        value = this.remove("defineFolderInheritance");
        if (value != null) {
            this.defineFolderInheritance = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("showFolderFilterAlways")) != null) {
            this.showFolderFilterAlways = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("showSecurityPage")) != null) {
            this.showSecurityPage = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("showFooterLinks")) != null) {
            this.showFooterLinks = WcmSitePrefs.convertToBoolean(value);
        }
        this.showTabBar = (value = this.remove("showTabBar")) != null ? WcmSitePrefs.convertToBoolean(value) : true;
        value = this.remove("usePathBasedURLs");
        if (value != null) {
            this.usePathBasedURLs = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("webContentManagementInstalled")) != null) {
            this.webContentManagementInstalled = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("recordsManagementInstalled")) != null) {
            this.recordsManagementInstalled = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("defaultFilePlan")) != null) {
            this.defaultFilePlan = (String)value;
        }
        if ((value = this.remove("defaultFilePlanId")) != null) {
            this.defaultFilePlanId = (String)value;
        }
        if ((value = this.remove("defaultFilePlanObjectStoreName")) != null) {
            this.defaultFilePlanObjectStoreName = (String)value;
        }
        if ((value = this.remove("reportServerPath")) != null) {
            this.reportServerPath = (String)value;
        }
        if ((value = this.remove("eformsInstalled")) != null) {
            this.eformsInstalled = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("useServerTimezone")) != null && this.timeZoneID == null) {
            String string = this.timeZoneID = WcmSitePrefs.convertToBoolean(value) ? "useServerTimeZone" : "useClientTimeZone";
        }
        if ((value = this.remove("showTime")) != null) {
            this.showTime = WcmSitePrefs.convertToBoolean(value);
        }
        if ((value = this.remove("keepAliveInterval")) != null) {
            this.keepAliveInterval = WcmSitePrefs.convertToInt(value);
        }
        this.keepFolderCacheInterval = (value = this.remove("keepFolderCacheInterval")) != null ? WcmSitePrefs.convertToInt(value) : 15;
        value = this.remove("stepMilestoneLevel");
        if (value != null) {
            this.stepMilestoneLevel = WcmSitePrefs.convertToInt(value);
        }
        this.granteeMaximumFilterSize = (value = this.remove("granteeMaximumFilterSize")) != null ? WcmSitePrefs.convertToInt(value) : 500;
        value = this.remove("connectionPoint");
        if (value != null) {
            this.connectionPoint = (String)value;
        }
        if ((value = this.remove("mailHost")) != null) {
            this.mailHost = (String)value;
        }
        if ((value = this.remove("mailUser")) != null) {
            this.mailUser = (String)value;
        }
        if ((value = this.remove("mailPassword")) != null) {
            this.mailPassword = (String)value;
        }
        if ((value = this.remove("simulatorEngineHost")) != null) {
            this.simulatorEngineHost = (String)value;
        }
        if ((value = this.remove("referenceServices")) != null) {
            this.referenceServices = (List)value;
        }
        if ((value = this.remove("objectStoreSettings")) != null) {
            List lstObjectStoreSettings = (List)value;
            len = lstObjectStoreSettings.size();
            this.objectStoreSettings.clear();
            for (i = 0; i < len; ++i) {
                o = (WcmObjectStorePrefs)lstObjectStoreSettings.get(i);
                key = o.getObjectStoreName();
                if (key == null || key.length() == 0) continue;
                this.objectStoreSettings.put(key, o);
            }
        }
        if ((value = this.remove("registeredPalettes")) != null) {
            this.registeredPalettes = (List)value;
        }
        if ((value = this.remove("authorPageLinks")) != null) {
            this.authorPageLinks = (List)value;
        }
        if ((value = this.remove("registeredPortlets")) != null) {
            this.registeredPortlets = (List)value;
        }
        if ((value = this.remove("portalPlaces")) != null) {
            this.portalPlaces = (List)value;
        }
        if ((value = this.remove("homePageMasterGroup")) != null) {
            this.homePageMasterGroup = (String)value;
        }
        if ((value = this.remove("homePageMasterGroupId")) != null) {
            this.homePageMasterGroupId = (String)value;
        }
        if ((value = this.remove("restrictedFeatures")) != null) {
            List pages = (List)value;
            len = pages.size();
            for (i = 0; i < len; ++i) {
                o = (RestrictedFeature)pages.get(i);
                key = ((RestrictedFeature)o).id;
                this.restrictedFeatures.put(key, o);
            }
        }
        if ((value = this.remove("rmRecordTemplateRoles")) != null) {
            roles = (String[])value;
            this.rmRecordTemplateRoles = new HashSet<String>(Arrays.asList(roles));
        } else {
            this.rmRecordTemplateRoles = new HashSet();
        }
        value = this.remove("multiSelectRoles");
        if (value != null) {
            roles = (String[])value;
            this.multiSelectRoles = new HashSet<String>(Arrays.asList(roles));
        } else {
            this.multiSelectRoles = new HashSet();
        }
        value = this.remove("multiDownloadRoles");
        if (value != null) {
            roles = (String[])value;
            this.multiDownloadRoles = new HashSet<String>(Arrays.asList(roles));
        }
        if ((value = this.remove("multiSaveRoles")) != null) {
            roles = (String[])value;
            this.multiSaveRoles = new HashSet<String>(Arrays.asList(roles));
        }
        if ((value = this.remove("defineFolderInheritanceRoles")) != null) {
            roles = (String[])value;
            this.defineFolderInheritanceRoles = new HashSet<String>(Arrays.asList(roles));
        } else {
            this.defineFolderInheritanceRoles = new HashSet();
        }
        value = this.remove("workplaceBaseURL");
        if (value != null) {
            this.workplaceBaseURL = (String)value;
        }
        if ((value = this.remove("RMBaseURL")) != null) {
            this.rMbaseURL = (String)value;
        }
        if ((value = this.remove("WCMBaseURL")) != null) {
            this.wcmBaseURL = (String)value;
        }
        if ((value = this.remove("WCMEJBServer")) != null) {
            this.wcmEJBServer = (String)value;
        }
        this.showTasksFilter = (value = this.remove("showTasksFilter")) != null ? WcmSitePrefs.convertToBoolean(value) : true;
        value = this.remove("taskFilterThreshold");
        this.taskFilterThreshold = value != null ? WcmSitePrefs.convertToInt(value) : 100;
    }

    public String getNameProperty(String objectStoreName, int objectType) {
        WcmObjectStorePrefs osp = this.getObjectStorePrefs(objectStoreName);
        switch (objectType) {
            case -101: 
            case -100: 
            case 1: 
            case 1160: {
                return osp.getDocumentNameProperty();
            }
            case 15: {
                return osp.getCustomObjectNameProperty();
            }
            case 2: {
                return osp.getFolderNameProperty();
            }
            case 4: {
                return "DisplayName";
            }
            case 1166: 
            case 1170: {
                return "Name";
            }
        }
        return "Id";
    }

    public List getAuthorPageLinks() {
        return this.authorPageLinks;
    }

    public List getRegisteredPalettes() {
        return this.registeredPalettes;
    }

    public List getOutlookProfiles() {
        return this.outlookProfiles;
    }

    public void setRMAuthorRecordTemplateAccess(Set recordTemplateAccess) {
        this.rmRecordTemplateRoles = recordTemplateAccess;
    }

    public Set getRMAuthorRecordTemplateAccess() {
        return this.rmRecordTemplateRoles;
    }

    public Set getMultiSelectRoles() {
        return this.multiSelectRoles;
    }

    public void setMultiSelectRoles(Set multiSelectRoles) {
        this.multiSelectRoles = multiSelectRoles;
    }

    public Set getMultiDownloadAccessRoles() {
        return this.multiDownloadRoles;
    }

    public void setMultiDownloadAccessRoles(Set multiSelectRoles) {
        this.multiDownloadRoles = multiSelectRoles;
    }

    public Set getMultiSaveAccessRoles() {
        return this.multiSaveRoles;
    }

    public void setMultiSaveAccessRoles(Set multiSelectRoles) {
        this.multiSaveRoles = multiSelectRoles;
    }

    public Set getDefineFolderInheritanceRoles() {
        return this.defineFolderInheritanceRoles;
    }

    public void setDefineFolderInheritanceRoles(Set defineFolderInheritanceRoles) {
        this.defineFolderInheritanceRoles = defineFolderInheritanceRoles;
    }

    public List getRegisteredPortlets() {
        return this.registeredPortlets;
    }

    public List getPortalPlaces() {
        return this.portalPlaces;
    }

    public String getSimulatorEngineHost() {
        return this.simulatorEngineHost;
    }

    public void setSimulatorEngineHost(String newSimulatorEngineHost) {
        this.simulatorEngineHost = newSimulatorEngineHost;
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public static class RestrictedFeature
    extends WcmPrefsObject {
        String id;
        String[] roles;
        boolean visibility = true;

        protected void initialize() {
            this.id = (String)this.remove("id");
            this.roles = (String[])this.remove("roles");
            String sVisible = (String)this.remove("visibility");
            this.visibility = sVisible == null || !sVisible.equals("false");
        }

        protected void saveToXML(Writer w) throws IOException {
            this.writeSetting(w, "id", this.id);
            this.writeSetting(w, "roles", this.roles);
            this.writeSetting(w, "visibility", this.visibility);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String[] getRoles() {
            return this.roles;
        }

        public void setRoles(String[] roles) {
            this.roles = roles;
        }

        public boolean getVisibility() {
            return this.visibility;
        }

        public void setVisibility(boolean visibility) {
            this.visibility = visibility;
        }
    }

    public static class Palette
    extends WcmPrefsObject {
        String fileName;
        String fileVersion;
        String[] files;

        protected void initialize() {
            this.fileName = (String)this.remove("fileName");
            this.fileVersion = (String)this.remove("fileVersion");
            this.files = (String[])this.remove("files");
        }

        protected void saveToXML(Writer w) throws IOException {
            this.writeSetting(w, "fileName", this.fileName);
            this.writeSetting(w, "fileVersion", this.fileVersion);
            this.writeSetting(w, "files", this.files);
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileVersion() {
            return this.fileVersion;
        }

        public void setFileVersion(String fileVersion) {
            this.fileVersion = fileVersion;
        }

        public String[] getFiles() {
            return this.files;
        }

        public void setFiles(String[] files) {
            this.files = files;
        }
    }
}

