/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.server.util.prefs;

import com.filenet.wcm.toolkit.server.util.prefs.PrefsLabel;
import com.filenet.wcm.toolkit.server.util.prefs.WcmPrefsObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class WcmObjectStorePrefs
extends WcmPrefsObject
implements Cloneable {
    private String objectStoreName;
    private String documentNameProperty;
    private String customObjectNameProperty;
    private String folderNameProperty;
    private PrefsLabel magazineFormatString;
    private String[] magazineProps;
    private String[] magazinePropsCustomObject;
    private String[] detailedProps;
    private String[] detailedPropsCustomObject;
    private String[] versionProps;
    private boolean supportFilePlan;
    private boolean supportDeclareRecords;
    private String defaultFilePlan;
    private String defaultFilePlanId;
    private Set rmPropertyViewRoles = new HashSet();
    private boolean webContentManagementEnabled;
    private boolean customObjectTypeEnabled;
    private String[] detailedQueryProps;
    private String[] magazineQueryProps;
    private String[] versionQueryProps;
    protected int allowedRMContainees;
    private String[] linkClassNames;
    private String[] linkClassIDs;
    private boolean[] includeLinkSubclasses;
    private boolean[] allowCreate;
    private boolean[] allowModify;
    private boolean[] allowDelete;
    private Set objectStoreAccess = new HashSet();

    public void calculateQueryProps() {
        this.detailedQueryProps = WcmObjectStorePrefs.addArrays(this.detailedProps, new String[]{this.documentNameProperty, this.folderNameProperty, this.customObjectNameProperty});
        this.magazineQueryProps = WcmObjectStorePrefs.addArrays(this.magazineProps, new String[]{this.documentNameProperty, this.folderNameProperty, this.customObjectNameProperty});
        this.versionQueryProps = WcmObjectStorePrefs.addToArray(this.versionProps, this.documentNameProperty);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private static String[] addArrays(String[] first, String[] second) {
        int i;
        HashSet<String> set = new HashSet<String>();
        if (first != null) {
            for (i = 0; i < first.length; ++i) {
                set.add(first[i]);
            }
        }
        if (second != null) {
            for (i = 0; i < second.length; ++i) {
                set.add(second[i]);
            }
        }
        String[] retVal = new String[set.size()];
        set.toArray(retVal);
        return retVal;
    }

    private static String[] addToArray(String[] array, String str) {
        String[] stringArray;
        if (str != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = str;
        } else {
            stringArray = null;
        }
        String[] second = stringArray;
        String[] retVal = WcmObjectStorePrefs.addArrays(array, second);
        return retVal;
    }

    public void setObjectStoreName(String newName) {
        this.objectStoreName = newName;
    }

    public String getObjectStoreName() {
        return this.objectStoreName;
    }

    public String getDocumentNameProperty() {
        return this.documentNameProperty;
    }

    public void setDocumentNameProperty(String newDocumentNameProperty) {
        this.documentNameProperty = newDocumentNameProperty;
    }

    public void setFolderNameProperty(String newFolderNameProperty) {
        this.folderNameProperty = newFolderNameProperty;
    }

    public String getFolderNameProperty() {
        return this.folderNameProperty;
    }

    public void setCustomObjectNameProperty(String newCustomObjectNameProperty) {
        this.customObjectNameProperty = newCustomObjectNameProperty;
    }

    public String getCustomObjectNameProperty() {
        return this.customObjectNameProperty;
    }

    public void setDetailedProps(String[] newDetailedProps) {
        this.detailedProps = newDetailedProps;
    }

    public void setDetailedPropsForCustomObject(String[] newDetailedProps) {
        this.detailedPropsCustomObject = newDetailedProps;
    }

    public String[] getDetailedProps() {
        return this.detailedProps;
    }

    public String[] getDetailedPropsForCustomObject() {
        return this.detailedPropsCustomObject;
    }

    public String[] getDetailedQueryProps() {
        return this.detailedQueryProps;
    }

    public void setMagazineFormatStringPrefsLabel(PrefsLabel newMagazineFormatString) {
        this.magazineFormatString = newMagazineFormatString;
        this.magazineFormatString.setFormatBundleResources(false);
    }

    public PrefsLabel getMagazineFormatStringPrefsLabel() {
        return this.magazineFormatString;
    }

    public String getMagazineFormatString(Locale locale) {
        return this.magazineFormatString.getResource(locale);
    }

    public void setMagazineProps(String[] newMagazineProps) {
        this.magazineProps = newMagazineProps;
    }

    public String[] getMagazineProps() {
        return this.magazineProps;
    }

    public void setMagazinePropsForCustomObject(String[] newMagazineProps) {
        this.magazinePropsCustomObject = newMagazineProps;
    }

    public String[] getMagazinePropsForCustomObject() {
        return this.magazinePropsCustomObject;
    }

    public String[] getMagazineQueryProps() {
        return this.magazineQueryProps;
    }

    public String[] getVersionQueryProps() {
        return this.versionQueryProps;
    }

    public void setVersionProps(String[] newVersionProps) {
        this.versionProps = newVersionProps;
    }

    public String[] getVersionProps() {
        return this.versionProps;
    }

    public boolean getSupportDeclareRecords() {
        return this.supportDeclareRecords;
    }

    public void setSupportDeclareRecords(boolean value) {
        this.supportDeclareRecords = value;
    }

    public boolean getSupportFilePlan() {
        return this.supportFilePlan;
    }

    public void setSupportFilePlan(boolean value) {
        this.supportFilePlan = value;
    }

    public String getDefaultFilePlan() {
        return this.defaultFilePlan;
    }

    public void setDefaultFilePlan(String filePlan) {
        this.defaultFilePlan = filePlan;
    }

    public String getDefaultFilePlanId() {
        return this.defaultFilePlanId;
    }

    public void setDefaultFilePlanId(String Id) {
        this.defaultFilePlanId = Id;
    }

    public boolean getCustomObjectTypeEnabled() {
        return this.customObjectTypeEnabled;
    }

    public void setAllowedRMContainees(int value) {
        this.allowedRMContainees = value;
    }

    public int getAllowedRMContainees() {
        return this.allowedRMContainees;
    }

    public void setCustomObjectTypeEnabled(boolean state) {
        this.customObjectTypeEnabled = state;
    }

    public boolean getWebContentManagementEnabled() {
        return this.webContentManagementEnabled;
    }

    public void setWebContentManagementEnabled(boolean state) {
        this.webContentManagementEnabled = state;
    }

    public String[] getLinkClassIDs() {
        return this.linkClassIDs;
    }

    public void setLinkClassIDs(String[] newLinkClassIDs) {
        this.linkClassIDs = newLinkClassIDs;
    }

    public void setincludeLinkSubclasses(boolean[] newincludeLinkSubclasses) {
        this.includeLinkSubclasses = newincludeLinkSubclasses;
    }

    public boolean[] getincludeLinkSubclasses() {
        return this.includeLinkSubclasses;
    }

    public boolean[] getAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean[] newAllowCreate) {
        this.allowCreate = newAllowCreate;
    }

    public boolean[] getAllowModify() {
        return this.allowModify;
    }

    public void setAllowModify(boolean[] newAllowModify) {
        this.allowModify = newAllowModify;
    }

    public boolean[] getAllowDelete() {
        return this.allowDelete;
    }

    public void setAllowDelete(boolean[] newAllowDelete) {
        this.allowDelete = newAllowDelete;
    }

    public void setObjectStoreAccess(Set objStoreAccess) {
        this.objectStoreAccess = objStoreAccess;
    }

    public Set getObjectStoreAccess() {
        return this.objectStoreAccess;
    }

    public void setRMPropertyViewAccess(Set propertyViewAccess) {
        this.rmPropertyViewRoles = propertyViewAccess;
    }

    public Set getRMPropertyViewAccess() {
        return this.rmPropertyViewRoles;
    }

    protected void initialize() {
        String[] roles;
        String[] allowDeleteStr;
        String[] allowModifyStr;
        String[] allowCreateStr;
        this.objectStoreName = (String)this.remove("objectStoreName");
        this.documentNameProperty = (String)this.remove("documentNameProperty");
        this.customObjectNameProperty = (String)this.remove("customObjectNameProperty");
        this.folderNameProperty = (String)this.remove("folderNameProperty");
        Object mfs = this.remove("magazineFormatString");
        this.magazineFormatString = WcmObjectStorePrefs.convertToPrefsLabel(mfs);
        this.magazineFormatString.setFormatBundleResources(false);
        this.magazineProps = (String[])this.remove("magazineProps");
        this.magazinePropsCustomObject = (String[])this.remove("magazinePropsCustomObject");
        this.detailedProps = (String[])this.remove("detailedProps");
        this.detailedPropsCustomObject = (String[])this.remove("detailedPropsCustomObject");
        this.versionProps = (String[])this.remove("versionProps");
        this.defaultFilePlan = (String)this.remove("defaultFilePlan");
        this.defaultFilePlanId = (String)this.remove("defaultFilePlanId");
        this.linkClassNames = (String[])this.remove("linkClassNames");
        this.linkClassIDs = (String[])this.remove("linkClassIDs");
        String[] includeLinkSubclassesStr = (String[])this.remove("includeLinkSubclasses");
        if (includeLinkSubclassesStr != null && includeLinkSubclassesStr.length > 0) {
            if (this.includeLinkSubclasses == null) {
                this.includeLinkSubclasses = new boolean[includeLinkSubclassesStr.length];
            }
            for (int i = 0; i < includeLinkSubclassesStr.length; ++i) {
                this.includeLinkSubclasses[i] = includeLinkSubclassesStr[i].equals("true");
            }
        }
        if ((allowCreateStr = (String[])this.remove("allowCreate")) != null && allowCreateStr.length > 0) {
            if (this.allowCreate == null) {
                this.allowCreate = new boolean[allowCreateStr.length];
            }
            for (int i = 0; i < allowCreateStr.length; ++i) {
                this.allowCreate[i] = allowCreateStr[i].equals("true");
            }
        }
        if ((allowModifyStr = (String[])this.remove("allowModify")) != null && allowModifyStr.length > 0) {
            if (this.allowModify == null) {
                this.allowModify = new boolean[allowModifyStr.length];
            }
            for (int i = 0; i < allowModifyStr.length; ++i) {
                this.allowModify[i] = allowModifyStr[i].equals("true");
            }
        }
        if ((allowDeleteStr = (String[])this.remove("allowDelete")) != null && allowDeleteStr.length > 0) {
            if (this.allowDelete == null) {
                this.allowDelete = new boolean[allowDeleteStr.length];
            }
            for (int i = 0; i < allowDeleteStr.length; ++i) {
                this.allowDelete[i] = allowDeleteStr[i].equals("true");
            }
        }
        this.customObjectTypeEnabled = true;
        Object o = this.remove("webContentManagementEnabled");
        this.webContentManagementEnabled = false;
        if (o != null) {
            this.webContentManagementEnabled = WcmObjectStorePrefs.convertToBoolean(o);
        }
        o = this.remove("supportFilePlan");
        this.supportFilePlan = false;
        if (o != null) {
            this.supportFilePlan = WcmObjectStorePrefs.convertToBoolean(o);
        }
        o = this.remove("supportDeclareRecords");
        this.supportDeclareRecords = false;
        if (o != null) {
            this.supportDeclareRecords = WcmObjectStorePrefs.convertToBoolean(o);
        }
        this.calculateQueryProps();
        o = this.remove("objectStoreAccess");
        if (o != null) {
            roles = (String[])o;
            this.objectStoreAccess = new HashSet<String>(Arrays.asList(roles));
        } else {
            this.objectStoreAccess = new HashSet();
        }
        o = this.remove("rmPropertyViewAccess");
        if (o != null) {
            roles = (String[])o;
            this.rmPropertyViewRoles = new HashSet<String>(Arrays.asList(roles));
        } else {
            this.rmPropertyViewRoles = new HashSet();
        }
    }

    protected void saveToXML(Writer w) throws IOException {
        this.writeSetting(w, "objectStoreName", this.objectStoreName);
        this.writeSetting(w, "documentNameProperty", this.documentNameProperty);
        this.writeSetting(w, "customObjectNameProperty", this.customObjectNameProperty);
        this.writeSetting(w, "folderNameProperty", this.folderNameProperty);
        this.writeSetting(w, "magazineFormatString", this.magazineFormatString);
        this.writeSetting(w, "magazineProps", this.magazineProps);
        this.writeSetting(w, "magazinePropsCustomObject", this.magazinePropsCustomObject);
        this.writeSetting(w, "detailedProps", this.detailedProps);
        this.writeSetting(w, "detailedPropsCustomObject", this.detailedPropsCustomObject);
        this.writeSetting(w, "versionProps", this.versionProps);
        this.writeSetting(w, "defaultFilePlan", this.defaultFilePlan);
        this.writeSetting(w, "defaultFilePlanId", this.defaultFilePlanId);
        this.writeSetting(w, "supportDeclareRecords", this.supportDeclareRecords);
        this.writeSetting(w, "supportFilePlan", this.supportFilePlan);
        this.writeSetting(w, "linkClassNames", this.linkClassNames);
        this.writeSetting(w, "linkClassIDs", this.linkClassIDs);
        this.writeSetting(w, "includeLinkSubclasses", this.includeLinkSubclasses);
        this.writeSetting(w, "allowCreate", this.allowCreate);
        this.writeSetting(w, "allowModify", this.allowModify);
        this.writeSetting(w, "allowDelete", this.allowDelete);
        this.writeSetting(w, "customObjectTypeEnabled", this.customObjectTypeEnabled);
        this.writeSetting(w, "webContentManagementEnabled", this.webContentManagementEnabled);
        String[] rmPropertyViewRolesArray = new String[this.rmPropertyViewRoles.size()];
        this.rmPropertyViewRoles.toArray(rmPropertyViewRolesArray);
        this.writeSetting(w, "rmPropertyViewAccess", rmPropertyViewRolesArray);
        String[] objectStoreAccessArray = new String[this.objectStoreAccess.size()];
        this.objectStoreAccess.toArray(objectStoreAccessArray);
        this.writeSetting(w, "objectStoreAccess", objectStoreAccessArray);
    }
}

