/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.StyleTemplate;
import java.util.List;

public class VerboseStyleTemplate {
    private String name;
    private String description;
    private StyleTemplate styleTempl;
    private List inputFormats;
    private String outputFormat;

    public VerboseStyleTemplate(StyleTemplate styleTempl) throws BaseException {
        this.initialize(styleTempl);
    }

    public void initialize(StyleTemplate styleTempl) throws BaseException {
        this.clear();
        this.styleTempl = styleTempl;
        this.loadProps();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.styleTempl.getId();
    }

    public StyleTemplate getStyleTemplate() {
        return this.styleTempl;
    }

    public String getDescription() {
        return this.description;
    }

    public List getInputFormats() {
        return this.inputFormats;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void refresh(boolean refreshStyleTempl) throws BaseException {
        this.clear();
        if (refreshStyleTempl) {
            try {
                this.styleTempl.refresh();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.loadProps();
    }

    private void clear() {
        this.name = null;
        this.description = null;
    }

    private void loadProps() throws BaseException {
        Properties propList = null;
        propList = this.styleTempl.getProperties(new String[]{"Title", "Description", "InputFormats", "OutputFormat"});
        for (Property tempProp : propList) {
            if (tempProp.getName().compareToIgnoreCase("Title") == 0) {
                this.name = (String)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("Description") == 0) {
                if (!(tempProp.getValue() instanceof String)) continue;
                this.description = (String)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("InputFormats") == 0) {
                if (!(tempProp.getValue() instanceof List)) continue;
                this.inputFormats = (List)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("OutputFormat") != 0 || !(tempProp.getValue() instanceof String)) continue;
            this.outputFormat = (String)tempProp.getValue();
        }
        if (this.name == null) {
            throw new RuntimeException("Name property not returned!");
        }
    }
}

