/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.Realm;
import java.util.StringTokenizer;

public class VerboseRealm {
    private Realm m_realm;
    private String m_name = "";
    private String m_id = "";
    private String m_formattedName = null;
    private String m_dispName = null;

    public VerboseRealm(Realm realm) {
        this.m_realm = realm;
        if (this.m_realm != null) {
            this.m_name = this.m_realm.getName();
            this.m_id = this.m_realm.getId();
        }
    }

    public Realm getRealm() {
        return this.m_realm;
    }

    public String getName() {
        return this.m_name;
    }

    public String getId() {
        return this.m_id;
    }

    public String getDispName() {
        this.getFormattedName();
        if (this.m_formattedName == null) {
            return null;
        }
        int nFirstDot = this.m_formattedName.indexOf(".");
        if (nFirstDot == -1) {
            return this.m_formattedName;
        }
        return this.m_formattedName.substring(0, nFirstDot);
    }

    public String getFormattedName() {
        if (this.m_formattedName == null && this.m_name != null) {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer st = new StringTokenizer(this.m_name, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token == null) continue;
                if (buffer.length() > 0) {
                    buffer.append(".");
                }
                int nIndex = token.indexOf("=");
                buffer.append(token.substring(nIndex + 1));
            }
            this.m_formattedName = buffer.toString();
        }
        return this.m_formattedName;
    }

    public String toString() {
        return this.getFormattedName();
    }

    public boolean isEqual(VerboseRealm vRealm) {
        if (vRealm == null) {
            return false;
        }
        String strId2 = vRealm.getId();
        return this.m_id.compareTo(strId2) == 0;
    }
}

