/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PublishTemplate;
import java.util.Iterator;

public class VerbosePublishTemplate {
    private String name;
    private String description;
    private boolean isReserved;
    private boolean isReservation;
    private boolean isCurrentVersion;
    private PublishTemplate pubTempl;
    private VerbosePublishTemplate reservation;

    public VerbosePublishTemplate(PublishTemplate pubTempl) throws BaseException {
        this.initialize(pubTempl);
    }

    public void initialize(PublishTemplate pubTempl) throws BaseException {
        this.clear();
        this.pubTempl = pubTempl;
        this.loadProps();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.pubTempl.getId();
    }

    public PublishTemplate getPublishTemplate() {
        return this.pubTempl;
    }

    public boolean getIsReserved() {
        return this.isReserved;
    }

    public boolean getIsReservation() {
        return this.isReservation;
    }

    public boolean getIsCurrentVersion() {
        return this.isCurrentVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public VerbosePublishTemplate getReservation() throws BaseException {
        if (this.isReservation) {
            return this;
        }
        if (this.isReserved && this.reservation == null) {
            PublishTemplate apiRes = (PublishTemplate)this.pubTempl.getReservation();
            this.reservation = new VerbosePublishTemplate(apiRes);
        }
        return this.reservation;
    }

    public void refresh(boolean refreshPubTempl) throws BaseException {
        this.clear();
        if (refreshPubTempl) {
            try {
                this.pubTempl.refresh();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.loadProps();
    }

    private void clear() {
        this.name = null;
        this.isReserved = false;
        this.isReservation = false;
        this.isCurrentVersion = false;
        this.reservation = null;
    }

    private void loadProps() throws BaseException {
        Properties propList = null;
        propList = this.pubTempl.getProperties(new String[]{"DocumentTitle", "Description", "IsReserved", "VersionStatus", "IsCurrentVersion"});
        Iterator it = propList.iterator();
        Boolean isReservedBool = null;
        Object isReservationBool = null;
        Boolean isCurrentVersionBool = null;
        Boolean reservationProp = null;
        while (it.hasNext()) {
            Property tempProp = (Property)it.next();
            if (tempProp.getName().compareToIgnoreCase("DocumentTitle") == 0) {
                this.name = (String)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("Description") == 0) {
                this.description = (String)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("IsReserved") == 0) {
                isReservedBool = (Boolean)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("VersionStatus") == 0) {
                reservationProp = Boolean.TRUE;
                if (tempProp.getIntValue() != 3) continue;
                this.isReservation = Boolean.TRUE;
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("IsCurrentVersion") != 0) continue;
            isCurrentVersionBool = (Boolean)tempProp.getValue();
        }
        if (isReservedBool == null) {
            throw new RuntimeException("IsReserved property not returned!");
        }
        this.isReserved = isReservedBool;
        if (reservationProp == null) {
            throw new RuntimeException("IsReservation property not returned!");
        }
        if (isCurrentVersionBool == null) {
            throw new RuntimeException("IsCurrentVersion property not returned!");
        }
        this.isCurrentVersion = isCurrentVersionBool;
    }
}

