/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import java.util.Map;

public class VerbosePropertyDescriptionString
extends VerbosePropertyDescription {
    protected static final int METAPROPNUM_PROPDEFAULTSTRING = 13;
    protected static final int METAPROPNUM_MAXLENGTHSTRING = 14;
    protected static final int METAPROPCOUNT_STRING = 15;
    private String propDefaultString;
    private Integer maxLengthString;

    public VerbosePropertyDescriptionString(PropertyDescription propDesc) throws Exception {
        super(propDesc);
    }

    public void initialize(PropertyDescription propDesc) throws Exception {
        this.propDefaultString = null;
        this.maxLengthString = null;
        super.initialize(propDesc);
        if (propDesc != null) {
            Object defVal;
            if (this.getDataType() != 8) {
                throw new RuntimeException("Unexpected: Trying to initialize VerbosePropertyDescriptionString with non-string prop. desc.");
            }
            if (this.propDefaultString == null && (defVal = this.getDefaultValue()) != null) {
                this.propDefaultString = (String)defVal;
            }
        }
    }

    public Object getDefaultValue() {
        return this.getPropertyDefaultString();
    }

    public String getPropertyDefaultString() {
        return this.propDefaultString;
    }

    public Integer getMaximumLengthString() {
        return this.maxLengthString;
    }

    public Integer getMaximumLength() {
        return this.getMaximumLengthString();
    }

    protected Map createMetaPropMap() {
        Map m = super.createMetaPropMap();
        m.put("PropertyDefaultString", new Integer(13));
        m.put("MaximumLengthString", new Integer(14));
        return m;
    }

    protected String[] getMetaProperties(PropertyDescription propDesc) {
        String[] result = null;
        int i = 0;
        try {
            String[] propdescs = super.getMetaProperties(propDesc);
            result = new String[propdescs.length + 2];
            for (i = 0; i < propdescs.length; ++i) {
                result[i] = propdescs[i];
            }
            result[i++] = "PropertyDefaultString";
            result[i++] = "MaximumLengthString";
        }
        catch (Exception ex) {
            System.out.println("Exception getting prop-desc properties from meta prop-descs");
            ex.printStackTrace();
        }
        return result;
    }

    protected int getMetaPropCount() {
        return 15;
    }

    protected void rememberMetaPropVal(int metaPropNum, Object metaPropVal) throws Exception {
        switch (metaPropNum) {
            case 13: {
                this.propDefaultString = (String)metaPropVal;
                break;
            }
            case 14: {
                if (metaPropVal instanceof Double) {
                    Double maxDbl = (Double)metaPropVal;
                    this.maxLengthString = new Integer(maxDbl.intValue());
                    break;
                }
                this.maxLengthString = (Integer)metaPropVal;
                break;
            }
            default: {
                super.rememberMetaPropVal(metaPropNum, metaPropVal);
            }
        }
    }
}

