/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import java.util.HashMap;
import java.util.Map;

public class VerbosePropertyDescriptionOperators {
    protected static final int METASUPPORTSNUM_EQUAL = 0;
    protected static final int METASUPPORTSNUM_GREATERTHANEQUAL = 1;
    protected static final int METASUPPORTSNUM_GREATERTHAN = 2;
    protected static final int METASUPPORTSNUM_NOTNULL = 3;
    protected static final int METASUPPORTSNUM_ISNULL = 4;
    protected static final int METASUPPORTSNUM_LESSTHANEQUAL = 5;
    protected static final int METASUPPORTSNUM_LESSTHAN = 7;
    protected static final int METASUPPORTSNUM_LIKE = 8;
    protected static final int METASUPPORTSNUM_NOTEQUAL = 9;
    protected static final int METASUPPORTSNUM_NOTLIKE = 10;
    protected static final int METASUPPORTSNUM_IN = 11;
    protected static final int METAPROPCOUNT_OPERATOR = 12;
    boolean supportsEqual;
    boolean supportsNotEqual;
    boolean supportsGreaterThan;
    boolean supportsGreaterThanOrEqual;
    boolean supportsLessThan;
    boolean supportsLessThanOrEqual;
    boolean supportsIsNull;
    boolean supportsNotNull;
    boolean supportsLike;
    boolean supportsNotLike;
    boolean supportsIn;

    public VerbosePropertyDescriptionOperators(Properties properties) throws Exception {
        this.initialize(properties);
    }

    public void initialize(Properties properties) throws Exception {
        this.supportsEqual = false;
        this.supportsNotEqual = false;
        this.supportsGreaterThan = false;
        this.supportsGreaterThanOrEqual = false;
        this.supportsLessThan = false;
        this.supportsLessThanOrEqual = false;
        this.supportsIsNull = false;
        this.supportsNotNull = false;
        this.supportsLike = false;
        this.supportsNotLike = false;
        this.supportsIn = false;
        if (properties != null) {
            int cnt = properties.size();
            Map m = this.createMetaPropMap();
            for (int i = 0; i < cnt; ++i) {
                Property metaProp = (Property)properties.get(i);
                Object metaPropNumFromMap = m.get(metaProp.getName());
                Object metaPropValue = metaProp.getValue();
                if (metaPropNumFromMap == null || metaPropValue == null) continue;
                int metaPropNum = (Integer)metaPropNumFromMap;
                this.rememberMetaPropVal(metaPropNum, metaPropValue);
            }
        }
    }

    public boolean supportsEqual() {
        return this.supportsEqual;
    }

    public boolean supportsNotEqual() {
        return this.supportsNotEqual;
    }

    public boolean supportsGreaterThen() {
        return this.supportsGreaterThan;
    }

    public boolean supportsGreaterThanOrEqual() {
        return this.supportsGreaterThanOrEqual;
    }

    public boolean supportsLessThan() {
        return this.supportsLessThan;
    }

    public boolean supportsLessnThanOrEqual() {
        return this.supportsGreaterThanOrEqual;
    }

    public boolean supportsLike() {
        return this.supportsLike;
    }

    public boolean supportsNotLike() {
        return this.supportsNotLike;
    }

    public boolean supportsIsNull() {
        return this.supportsIsNull;
    }

    public boolean supportsNotNull() {
        return this.supportsNotNull;
    }

    public boolean supportsIn() {
        return this.supportsIn;
    }

    private Map createMetaPropMap() {
        HashMap<String, Integer> m = new HashMap<String, Integer>(this.getMetaPropCount() + 1, 1.0f);
        m.put("SupportsEqual", new Integer(0));
        m.put("SupportsGreaterThanOrEqual", new Integer(1));
        m.put("SupportsGreaterThan", new Integer(2));
        m.put("SupportsNotNull", new Integer(3));
        m.put("SupportsIsNull", new Integer(4));
        m.put("SupportsLessThanOrEqual", new Integer(5));
        m.put("SupportsLessThan", new Integer(7));
        m.put("SupportsLike", new Integer(8));
        m.put("SupportsNotEqual", new Integer(9));
        m.put("SupportsNotLike", new Integer(10));
        m.put("SupportsIn", new Integer(11));
        return m;
    }

    private int getMetaPropCount() {
        return 12;
    }

    private void rememberMetaPropVal(int metaPropNum, Object metaPropVal) throws Exception {
        switch (metaPropNum) {
            case 0: {
                this.supportsEqual = (Boolean)metaPropVal;
                break;
            }
            case 9: {
                this.supportsNotEqual = (Boolean)metaPropVal;
                break;
            }
            case 2: {
                this.supportsGreaterThan = (Boolean)metaPropVal;
                break;
            }
            case 1: {
                this.supportsGreaterThanOrEqual = (Boolean)metaPropVal;
                break;
            }
            case 7: {
                this.supportsLessThan = (Boolean)metaPropVal;
                break;
            }
            case 5: {
                this.supportsLessThanOrEqual = (Boolean)metaPropVal;
                break;
            }
            case 4: {
                this.supportsIsNull = (Boolean)metaPropVal;
                this.supportsNotNull = (Boolean)metaPropVal;
                break;
            }
            case 3: {
                this.supportsNotNull = (Boolean)metaPropVal;
                break;
            }
            case 8: {
                this.supportsLike = (Boolean)metaPropVal;
                this.supportsNotLike = (Boolean)metaPropVal;
                break;
            }
            case 10: {
                this.supportsNotLike = (Boolean)metaPropVal;
                break;
            }
            case 11: {
                this.supportsIn = (Boolean)metaPropVal;
                break;
            }
        }
    }
}

