/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import java.util.Map;

public class VerbosePropertyDescriptionFloat64
extends VerbosePropertyDescription {
    protected static final int METAPROPNUM_PROPDEFAULTFLOAT64 = 13;
    protected static final int METAPROPNUM_PROPMINFLOAT64 = 14;
    protected static final int METAPROPNUM_PROPMAXFLOAT64 = 15;
    protected static final int METAPROPCOUNT_FLOAT64 = 16;
    private Double propDefaultFloat64;
    private Double propMinFloat64;
    private Double propMaxFloat64;

    public VerbosePropertyDescriptionFloat64(PropertyDescription propDesc) throws Exception {
        super(propDesc);
    }

    public void initialize(PropertyDescription propDesc) throws Exception {
        this.propDefaultFloat64 = null;
        this.propMinFloat64 = null;
        this.propMaxFloat64 = null;
        super.initialize(propDesc);
        if (propDesc != null) {
            Object defVal;
            if (this.getDataType() != 4) {
                throw new RuntimeException("Unexpected: Trying to initialize VerbosePropertyDescriptionFloat64 with non-float prop. desc.");
            }
            if (this.propDefaultFloat64 == null && (defVal = this.getDefaultValue()) != null) {
                this.propDefaultFloat64 = (Double)defVal;
            }
        }
    }

    public Object getDefaultValue() {
        return this.getPropertyDefaultFloat64();
    }

    public Double getPropertyDefaultFloat64() {
        return this.propDefaultFloat64;
    }

    public Double getPropertyMinimumFloat64() {
        return this.propMinFloat64;
    }

    public Double getPropertyMaximumFloat64() {
        return this.propMaxFloat64;
    }

    public Object getMinimumValue() {
        return this.getPropertyMinimumFloat64();
    }

    public Object getMaximumValue() {
        return this.getPropertyMaximumFloat64();
    }

    protected Map createMetaPropMap() {
        Map m = super.createMetaPropMap();
        m.put("PropertyDefaultFloat64", new Integer(13));
        m.put("PropertyMinimumFloat64", new Integer(14));
        m.put("PropertyMaximumFloat64", new Integer(15));
        return m;
    }

    protected String[] getMetaProperties(PropertyDescription propDesc) {
        String[] result = null;
        int i = 0;
        try {
            String[] propdescs = super.getMetaProperties(propDesc);
            result = new String[propdescs.length + 3];
            for (i = 0; i < propdescs.length; ++i) {
                result[i] = propdescs[i];
            }
            result[i++] = "PropertyDefaultFloat64";
            result[i++] = "PropertyMinimumFloat64";
            result[i++] = "PropertyMaximumFloat64";
        }
        catch (Exception ex) {
            System.out.println("Exception getting prop-desc properties from meta prop-descs");
            ex.printStackTrace();
        }
        return result;
    }

    protected int getMetaPropCount() {
        return 16;
    }

    protected void rememberMetaPropVal(int metaPropNum, Object metaPropVal) throws Exception {
        switch (metaPropNum) {
            case 13: {
                this.propDefaultFloat64 = PropertyUtil.getDouble(metaPropVal);
                break;
            }
            case 14: {
                this.propMinFloat64 = PropertyUtil.getDouble(metaPropVal);
                break;
            }
            case 15: {
                this.propMaxFloat64 = PropertyUtil.getDouble(metaPropVal);
                break;
            }
            default: {
                super.rememberMetaPropVal(metaPropNum, metaPropVal);
            }
        }
    }
}

