/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionBinary;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionBoolean;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionDateTime;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionFloat64;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionId;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionInteger32;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionObject;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionString;

public class VerbosePropertyDescriptionFactory {
    public static VerbosePropertyDescription createVerbosePropertyDescription(PropertyDescription propDesc) throws Exception {
        VerbosePropertyDescription vpd;
        Properties metaProps = propDesc.getProperties(new String[]{"DataType"});
        int cnt = metaProps.size();
        int dataType = 0;
        for (int i = 0; i < cnt; ++i) {
            Property metaProp = (Property)metaProps.get(i);
            if (!metaProp.getName().equals("DataType")) continue;
            Object metaPropVal = metaProp.getValue();
            if (metaPropVal instanceof Double) {
                Double dataDbl = (Double)metaPropVal;
                dataType = dataDbl.intValue();
                continue;
            }
            dataType = (Integer)metaPropVal;
        }
        if (dataType == 0) {
            throw new RuntimeException("PropertyDescription passed in with no data-type!");
        }
        switch (dataType) {
            case 1: {
                vpd = new VerbosePropertyDescriptionBinary(propDesc);
                break;
            }
            case 2: {
                vpd = new VerbosePropertyDescriptionBoolean(propDesc);
                break;
            }
            case 3: {
                vpd = new VerbosePropertyDescriptionDateTime(propDesc);
                break;
            }
            case 4: {
                vpd = new VerbosePropertyDescriptionFloat64(propDesc);
                break;
            }
            case 5: {
                vpd = new VerbosePropertyDescriptionId(propDesc);
                break;
            }
            case 6: {
                vpd = new VerbosePropertyDescriptionInteger32(propDesc);
                break;
            }
            case 7: {
                vpd = new VerbosePropertyDescriptionObject(propDesc);
                break;
            }
            case 8: {
                vpd = new VerbosePropertyDescriptionString(propDesc);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized data type!");
            }
        }
        return vpd;
    }

    private VerbosePropertyDescriptionFactory() {
    }
}

