/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.apps.client.util.ISODateUtil;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import java.util.Date;
import java.util.Map;

public class VerbosePropertyDescriptionDateTime
extends VerbosePropertyDescription {
    protected static final int METAPROPNUM_PROPDEFAULTDATETIME = 13;
    protected static final int METAPROPNUM_PROPMINDATETIME = 14;
    protected static final int METAPROPNUM_PROPMAXDATETIME = 15;
    protected static final int METAPROPCOUNT_DATETIME = 16;
    private Date propDefaultDateTime = null;
    private Date propMinDateTime = null;
    private Date propMaxDateTime = null;

    public VerbosePropertyDescriptionDateTime(PropertyDescription propDesc) throws Exception {
        super(propDesc);
    }

    public void initialize(PropertyDescription propDesc) throws Exception {
        this.propDefaultDateTime = null;
        this.propMinDateTime = null;
        this.propMaxDateTime = null;
        super.initialize(propDesc);
        if (propDesc != null) {
            String propMaxVal;
            String propVal;
            Object defVal;
            if (this.getDataType() != 3) {
                throw new RuntimeException("Unexpected: Trying to initialize VerbosePropertyDescriptionDateTime with non-date prop. desc.");
            }
            if (this.propDefaultDateTime == null && (defVal = this.getDefaultValue()) != null) {
                this.propDefaultDateTime = (Date)defVal;
            }
            if (this.propMinDateTime == null && (propVal = propDesc.getPropertyStringValue("PropertyMinimumDateTime")) != null && propVal.length() > 0) {
                this.propMinDateTime = ISODateUtil.convertISODateToDate(propVal);
            }
            if (this.propMaxDateTime == null && (propMaxVal = propDesc.getPropertyStringValue("PropertyMaximumDateTime")) != null && propMaxVal.length() > 0) {
                this.propMaxDateTime = ISODateUtil.convertISODateToDate(propMaxVal);
            }
        }
    }

    public Object getDefaultValue() {
        return this.getPropertyDefaultDateTime();
    }

    public Date getPropertyDefaultDateTime() {
        return this.propDefaultDateTime;
    }

    public Date getPropertyMinimumDateTime() {
        return this.propMinDateTime;
    }

    public Date getPropertyMaximumDateTime() {
        return this.propMaxDateTime;
    }

    public Object getMinimumValue() {
        return this.getPropertyMinimumDateTime();
    }

    public Object getMaximumValue() {
        return this.getPropertyMaximumDateTime();
    }

    protected Map createMetaPropMap() {
        Map m = super.createMetaPropMap();
        m.put("PropertyDefaultDateTime", new Integer(13));
        m.put("PropertyMinimumDateTime", new Integer(14));
        m.put("PropertyMaximumDateTime", new Integer(15));
        return m;
    }

    protected String[] getMetaProperties(PropertyDescription propDesc) {
        String[] result = null;
        int i = 0;
        try {
            String[] propdescs = super.getMetaProperties(propDesc);
            result = new String[propdescs.length + 3];
            for (i = 0; i < propdescs.length; ++i) {
                result[i] = propdescs[i];
            }
            result[i++] = "PropertyDefaultDateTime";
            result[i++] = "PropertyMinimumDateTime";
            result[i++] = "PropertyMaximumDateTime";
        }
        catch (Exception ex) {
            System.out.println("Exception getting prop-desc properties from meta prop-descs");
            ex.printStackTrace();
        }
        return result;
    }

    protected int getMetaPropCount() {
        return 16;
    }

    protected void rememberMetaPropVal(int metaPropNum, Object metaPropVal) throws Exception {
        switch (metaPropNum) {
            case 13: {
                this.propDefaultDateTime = PropertyUtil.getDate(metaPropVal);
                break;
            }
            case 14: {
                this.propMinDateTime = PropertyUtil.getDate(metaPropVal);
                break;
            }
            case 15: {
                this.propMaxDateTime = PropertyUtil.getDate(metaPropVal);
                break;
            }
            default: {
                super.rememberMetaPropVal(metaPropNum, metaPropVal);
            }
        }
    }
}

