/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.Choice;
import com.filenet.wcm.api.ChoiceList;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.MarkingSet;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyDescriptions;
import com.filenet.wcm.api.Search;
import com.filenet.wcm.api.SearchClassInfo;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.SearchPropertyDescriptions;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionFactory;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.HashMap;
import java.util.Map;

public class VerbosePropertyDescription {
    private PropertyDescription m_propDesc;
    private PropertyDescription m_stdPropDesc;
    private String m_symbolicName;
    private int m_dataType;
    private int m_cardinality;
    private boolean m_isSelectable;
    private boolean m_isSearchable;
    private boolean m_isOrderable;
    private boolean m_isSystemGenerated;
    private boolean m_isReadOnly;
    private boolean m_isValueRequired;
    private boolean m_isHidden;
    private String m_id;
    private Object m_defaultValue;
    private String m_displayName;
    private int m_settability;
    private Properties m_queryOperatorDescriptions;
    private MarkingSet m_markingSet = null;
    private String m_defaultOS;
    protected static final int METAPROPNUM_DATATYPE = 0;
    protected static final int METAPROPNUM_CARDINALITY = 1;
    protected static final int METAPROPNUM_ISSELECTABLE = 2;
    protected static final int METAPROPNUM_ISSEARCHABLE = 3;
    protected static final int METAPROPNUM_ISORDERABLE = 4;
    protected static final int METAPROPNUM_ISSYSTEMGENERATED = 5;
    protected static final int METAPROPNUM_ISREADONLY = 6;
    protected static final int METAPROPNUM_ISVALUEREQUIRED = 7;
    protected static final int METAPROPNUM_ISHIDDEN = 8;
    protected static final int METAPROPNUM_DISPLAYNAME = 9;
    protected static final int METAPROPNUM_QUERYOPERATORDESC = 10;
    protected static final int METAPROPNUM_SETTABILITY = 11;
    protected static final int METAPROPNUM_SYMBOLICNAME = 12;
    protected static final int METAPROPCOUNT = 13;

    public VerbosePropertyDescription(PropertyDescription propDesc) throws Exception {
        this.initialize(propDesc);
    }

    public void initialize(PropertyDescription propDesc) throws Exception {
        this.m_propDesc = null;
        this.m_dataType = 0;
        this.m_cardinality = 0;
        this.m_isSelectable = false;
        this.m_isSearchable = false;
        this.m_isOrderable = false;
        this.m_isSystemGenerated = true;
        this.m_isReadOnly = true;
        this.m_isValueRequired = false;
        this.m_isHidden = true;
        this.m_queryOperatorDescriptions = null;
        this.m_defaultValue = null;
        this.m_settability = 0;
        if (propDesc != null) {
            boolean success;
            this.m_id = propDesc.getId();
            Properties metaProps = null;
            String[] propList = this.getMetaProperties(propDesc);
            if (propList != null) {
                metaProps = propDesc.getProperties(propList);
            }
            if (metaProps == null) {
                metaProps = propDesc.getProperties();
            }
            if (success = this.parseMetaProperties(metaProps)) {
                this.m_propDesc = propDesc;
            }
        }
    }

    public void setDefaultOS(String newDefaultOS) {
        this.m_defaultOS = newDefaultOS;
    }

    protected boolean parseMetaProperties(Properties metaProps) {
        if (metaProps == null) {
            return false;
        }
        try {
            Map m = this.createMetaPropMap();
            for (Property metaProp : metaProps) {
                Object metaPropNumFromMap = m.get(metaProp.getName());
                Object metaPropVal = metaProp.getValue();
                if (metaPropNumFromMap == null || metaPropVal == null) continue;
                int metaPropNum = (Integer)metaPropNumFromMap;
                this.rememberMetaPropVal(metaPropNum, metaPropVal);
            }
        }
        catch (Exception e) {
            System.out.println("VerbosePropertyDescription: Failed to parse the meta properties");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public PropertyDescription getPropertyDescription() {
        return this.m_propDesc;
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public int getDataType() {
        return this.m_dataType;
    }

    public int getCardinality() {
        return this.m_cardinality;
    }

    public boolean getIsSelectable() {
        return this.m_isSelectable;
    }

    public boolean getIsSearchable() {
        return this.m_isSearchable;
    }

    public boolean getIsOrderable() {
        return this.m_isOrderable;
    }

    public boolean getIsSystemGenerated() {
        return this.m_isSystemGenerated;
    }

    public boolean getIsReadOnly() {
        return this.m_isReadOnly;
    }

    public boolean getIsValueRequired() {
        return this.m_isValueRequired;
    }

    public boolean getIsHidden() {
        return this.m_isHidden;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public int getSettability() {
        return this.m_settability;
    }

    public String getLabel() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.getSymbolicName();
    }

    public Properties getQueryOperatorDescriptions() {
        return this.m_queryOperatorDescriptions;
    }

    public boolean getHasCVL() {
        boolean hasCVL = false;
        if (this.m_propDesc != null) {
            Boolean haschoices = null;
            if (this.m_propDesc instanceof SearchPropertyDescription) {
                try {
                    Object objval = this.m_propDesc.getPropertyValue("HasChoices");
                    if (objval != null && objval instanceof Boolean) {
                        haschoices = (Boolean)objval;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (haschoices == null) {
                try {
                    ChoiceList choiceList = this.m_propDesc.getChoices(0);
                    hasCVL = choiceList != null;
                }
                catch (Exception ex) {
                    System.out.println("Exception from propDesc.getChoices() : " + ex.getMessage());
                    ex.printStackTrace();
                }
            } else {
                hasCVL = haschoices;
            }
        }
        return hasCVL;
    }

    public MarkingSet getMarkingSet() {
        return this.m_markingSet;
    }

    public PropertyDescription getStandardPropDescr(SearchPropertyDescription sDesc, int objType) {
        PropertyDescription propDesc = null;
        if (sDesc instanceof SearchPropertyDescription) {
            ObjectStore objStore = ObjectFactory.getObjectStore((String)sDesc.getObjectStoreId(), (Session)sDesc.getSession());
            propDesc = (PropertyDescription)objStore.getObject(24, sDesc.getId());
        }
        return propDesc;
    }

    public boolean getHasMarkingSet() {
        return this.getHasMarkingSet(0);
    }

    public boolean getHasMarkingSet(int objType) {
        if (this.m_propDesc != null) {
            try {
                int datatype = this.m_propDesc.getPropertyIntValue("DataType");
                if (datatype != 8) {
                    return false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        PropertyDescription propDesc = null;
        if (this.m_stdPropDesc != null) {
            propDesc = this.m_stdPropDesc;
        } else if (this.m_propDesc != null && this.m_propDesc instanceof SearchPropertyDescription) {
            propDesc = this.getStandardPropDescr((SearchPropertyDescription)this.m_propDesc, objType);
        }
        if (propDesc != null && propDesc instanceof PropertyDescription) {
            this.m_stdPropDesc = propDesc;
            try {
                this.m_markingSet = (MarkingSet)propDesc.getPropertyValue("MarkingSet");
                return this.m_markingSet != null;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public boolean getIsHierarchicalCVL() {
        boolean isHierarchicalCVL = false;
        ChoiceList cList = this.m_propDesc.getChoices(9);
        for (Choice choice : cList) {
            if (!choice.hasContainedChoices()) continue;
            isHierarchicalCVL = true;
            break;
        }
        return isHierarchicalCVL;
    }

    public String getId() {
        if (this.m_id != null) {
            return this.m_id;
        }
        if (this.m_propDesc != null) {
            return this.m_propDesc.getId();
        }
        return null;
    }

    public Integer getMaximumLength() {
        return null;
    }

    public Object getMinimumValue() {
        return null;
    }

    public Object getMaximumValue() {
        return null;
    }

    protected Map createMetaPropMap() {
        HashMap<String, Integer> m = new HashMap<String, Integer>(this.getMetaPropCount() + 1, 1.0f);
        m.put("DataType", new Integer(0));
        m.put("Cardinality", new Integer(1));
        m.put("IsSelectable", new Integer(2));
        m.put("IsSearchable", new Integer(3));
        m.put("IsOrderable", new Integer(4));
        m.put("IsSystemGenerated", new Integer(5));
        m.put("IsReadOnly", new Integer(6));
        m.put("IsValueRequired", new Integer(7));
        m.put("IsHidden", new Integer(8));
        m.put("DisplayName", new Integer(9));
        m.put("QueryOperatorDescriptions", new Integer(10));
        m.put("Settability", new Integer(11));
        m.put("SymbolicName", new Integer(12));
        return m;
    }

    protected String[] getMetaProperties(PropertyDescription propDesc) {
        try {
            String[] result = propDesc instanceof SearchPropertyDescription ? new String[]{"DataType", "Cardinality", "IsSelectable", "IsSearchable", "IsOrderable", "DisplayName", "SymbolicName", "QueryOperatorDescriptions"} : new String[]{"DataType", "Cardinality", "IsSelectable", "IsSearchable", "IsOrderable", "DisplayName", "SymbolicName", "Settability", "IsSystemGenerated", "IsReadOnly", "IsValueRequired", "IsHidden"};
            return result;
        }
        catch (Exception ex) {
            System.out.println("Exception getting prop-desc properties from meta prop-descs");
            ex.printStackTrace();
            return null;
        }
    }

    protected int getMetaPropCount() {
        return 13;
    }

    protected void rememberMetaPropVal(int metaPropNum, Object metaPropVal) throws Exception {
        switch (metaPropNum) {
            case 0: {
                if (metaPropVal instanceof Double) {
                    Double dataDbl = (Double)metaPropVal;
                    this.m_dataType = dataDbl.intValue();
                    break;
                }
                this.m_dataType = (Integer)metaPropVal;
                break;
            }
            case 1: {
                if (metaPropVal instanceof Double) {
                    Double cardDbl = (Double)metaPropVal;
                    this.m_cardinality = cardDbl.intValue();
                    break;
                }
                this.m_cardinality = (Integer)metaPropVal;
                break;
            }
            case 2: {
                this.m_isSelectable = (Boolean)metaPropVal;
                break;
            }
            case 3: {
                this.m_isSearchable = (Boolean)metaPropVal;
                break;
            }
            case 4: {
                this.m_isOrderable = (Boolean)metaPropVal;
                break;
            }
            case 5: {
                this.m_isSystemGenerated = (Boolean)metaPropVal;
                break;
            }
            case 6: {
                this.m_isReadOnly = (Boolean)metaPropVal;
                break;
            }
            case 7: {
                this.m_isValueRequired = (Boolean)metaPropVal;
                break;
            }
            case 8: {
                this.m_isHidden = (Boolean)metaPropVal;
                break;
            }
            case 9: {
                this.m_displayName = (String)metaPropVal;
                break;
            }
            case 12: {
                this.m_symbolicName = (String)metaPropVal;
                break;
            }
            case 10: {
                this.saveOperatorList((Values)metaPropVal);
                break;
            }
            case 11: {
                if (metaPropVal instanceof Double) {
                    Double setDbl = (Double)metaPropVal;
                    this.m_settability = setDbl.intValue();
                    break;
                }
                this.m_settability = (Integer)metaPropVal;
                break;
            }
            default: {
                throw new RuntimeException("Internal error");
            }
        }
    }

    private void saveOperatorList(Values valList) {
        Properties propList = ObjectFactory.getProperties();
        boolean isObjValProp = this.getDataType() == 7;
        for (Object blob : valList) {
            if (!(blob instanceof Property)) continue;
            Property item = (Property)blob;
            if (isObjValProp && WcmString.compareIgnoreCase(item.getName(), "SupportsEqual") == 0) continue;
            propList.add((Object)((Property)blob));
        }
        if (propList.size() > 0) {
            this.m_queryOperatorDescriptions = propList;
        }
    }

    public static void testForPublishDesigner() throws Exception {
        Session m_session = null;
        ObjectStore lib = ObjectFactory.getObjectStore((String)"MichelleOS_18", m_session);
        ClassDescriptions cColl = lib.getClassDescriptions();
        for (ClassDescription classDesc : cColl) {
            System.out.println("<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>");
            System.out.println("Getting properties from class: " + classDesc.getName());
            PropertyDescriptions sProps = classDesc.getPropertyDescriptions();
            PropertyDescription sProp2 = null;
            VerbosePropertyDescription vProp = null;
            for (PropertyDescription sProp2 : sProps) {
                vProp = new VerbosePropertyDescription(sProp2);
                System.out.println("================");
                System.out.println("Name: " + vProp.getName() + "; settability: " + vProp.getSettability());
            }
        }
    }

    public static void testForControlFactory() throws Exception {
        Session m_session = null;
        ObjectStores libs = ObjectFactory.getObjectStores();
        ObjectStore lib = ObjectFactory.getObjectStore((String)"MichelleOS_18", m_session);
        libs.add((Object)lib);
        Search searchObj = ObjectFactory.getSearch(m_session);
        SearchPropertyDescriptions sProps = searchObj.getPropertyDescriptions(libs, "union", 1, new SearchClassInfo[0]);
        SearchPropertyDescription sProp2 = null;
        VerbosePropertyDescription vProp = null;
        VerbosePropertyDescription tempVProp = null;
        for (SearchPropertyDescription sProp2 : sProps) {
            tempVProp = new VerbosePropertyDescription((PropertyDescription)sProp2);
            if (tempVProp.getDataType() != 2) continue;
            System.out.println("================");
            System.out.println("Name: " + tempVProp.getName() + "; datatype: " + tempVProp.getDataType());
            vProp = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription((PropertyDescription)sProp2);
            System.out.println("Factory produced: " + vProp.getName() + "; " + vProp.getDataType());
        }
    }

    public static void testForAddWizard() throws Exception {
        try {
            Session m_session = null;
            ObjectStore lib = ObjectFactory.getObjectStore((String)"MichelleOS_18", m_session);
            ClassDescriptions cColl = lib.getClassDescriptions();
            for (ClassDescription classDesc : cColl) {
                System.out.println("================================");
                System.out.println("Class: " + classDesc.getName());
                PropertyDescriptions propDescs = classDesc.getPropertyDescriptions();
                for (PropertyDescription propDesc : propDescs) {
                    System.out.println(propDesc.getName());
                    VerbosePropertyDescription vpropDesc = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription(propDesc);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred when getting property descriptions: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Begin testing...");
        try {
            System.out.println("==================");
            System.out.println("Publish Designer test");
            System.out.println("==================");
            VerbosePropertyDescription.testForPublishDesigner();
            System.out.println("==================");
            System.out.println("Control Factory test");
            System.out.println("==================");
            VerbosePropertyDescription.testForControlFactory();
            System.out.println("==================");
            System.out.println("Add Wizard test");
            System.out.println("==================");
            VerbosePropertyDescription.testForAddWizard();
        }
        catch (Exception e) {
            System.out.println("Error occurred when getting property descriptions: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Done testing...");
    }
}

