/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.EntireNetwork;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.client.util.api.VerboseClassDescription;
import com.filenet.wcm.apps.client.util.api.VerboseList;
import com.filenet.wcm.apps.client.util.api.VerboseListImpl;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.HashMap;
import java.util.Iterator;

public class VerboseLibrary {
    private static final String[] LIBRARY_PROPS = new String[]{"Id", "ObjectType", "SymbolicName", "DisplayName", "Name", "IsHidden"};
    private ObjectStore m_library;
    private String m_name = new String("");
    private VerboseList m_vdocClassDescs;
    private HashMap m_docClassDescsMapByName;
    private HashMap m_docClassDescsMapById;
    private boolean m_osAvail = true;
    private boolean m_hasBeenValidated = false;
    private boolean m_isValid = false;

    public VerboseLibrary(ObjectStore lib) throws Exception {
        this.initialize(lib);
    }

    public void initialize(ObjectStore lib) throws Exception {
        Object propList = null;
        this.m_library = lib;
        this.m_name = lib.getName();
        this.m_hasBeenValidated = false;
        this.m_isValid = false;
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getId() {
        return this.m_library.getId();
    }

    public ObjectStore getLibrary() {
        return this.m_library;
    }

    public boolean isValid() {
        if (!this.m_hasBeenValidated) {
            try {
                this.m_library.getRootFolder().getAccessMask();
                this.m_isValid = true;
            }
            catch (Exception ex) {
                this.m_isValid = false;
            }
            this.m_hasBeenValidated = true;
        }
        return this.m_isValid;
    }

    public boolean supportsContentSearching() {
        return this.m_library.supports(8);
    }

    public boolean isOracle() {
        try {
            String dbType = this.m_library.getPropertyStringValue("DatabaseType");
            if (dbType != null) {
                return WcmString.compareIgnoreCase(dbType, WcmResourceString.s_sqlDbTypeName) != 0;
            }
        }
        catch (Exception e) {
            System.out.println("Error in VerboseLibrary::isOracle(): " + e.getMessage());
        }
        return false;
    }

    public VerboseList getDocumentClassDescriptions() throws BaseException {
        if (this.m_vdocClassDescs == null) {
            this.loadDocClassDescs();
        }
        return this.m_vdocClassDescs;
    }

    public VerboseClassDescription getDocumentClassDescriptionFromName(String docClassName) throws BaseException {
        Object numFromMap;
        if (this.m_vdocClassDescs == null) {
            this.loadDocClassDescs();
        }
        if ((numFromMap = this.m_docClassDescsMapByName.get(docClassName)) == null) {
            return null;
        }
        return (VerboseClassDescription)this.m_vdocClassDescs.get((Integer)numFromMap);
    }

    public VerboseClassDescription getDocumentClassDescriptionFromId(String docClassId) throws BaseException {
        Object numFromMap;
        if (this.m_vdocClassDescs == null) {
            this.loadDocClassDescs();
        }
        if ((numFromMap = this.m_docClassDescsMapById.get(docClassId)) == null) {
            return null;
        }
        return (VerboseClassDescription)this.m_vdocClassDescs.get((Integer)numFromMap);
    }

    public boolean getIsOSAvailable() {
        return this.m_osAvail;
    }

    public void setOSAvailable(boolean avail) {
        this.m_osAvail = avail;
    }

    private void loadDocClassDescs() throws BaseException {
        if (this.m_vdocClassDescs == null) {
            ClassDescription cd = (ClassDescription)this.m_library.getObject(25, "Document");
            ClassDescriptions classDescs = ObjectFactory.getClassDescriptions();
            classDescs.add((Object)cd);
            ClassDescriptions docClassDescs = this.m_library.getClassDescriptions(classDescs, true, LIBRARY_PROPS);
            VerboseListImpl listImpl = new VerboseListImpl();
            HashMap<String, Integer> docClassDescsMapByName = new HashMap<String, Integer>(docClassDescs.size() + 1, 1.0f);
            HashMap<String, Integer> docClassDescsMapById = new HashMap<String, Integer>(docClassDescs.size() + 1, 1.0f);
            for (int i = 0; i < docClassDescs.size(); ++i) {
                VerboseClassDescription vclassDesc = new VerboseClassDescription((ClassDescription)docClassDescs.get(i));
                listImpl.add(vclassDesc);
                docClassDescsMapByName.put(vclassDesc.getName(), new Integer(i));
                docClassDescsMapById.put(vclassDesc.getId(), new Integer(i));
            }
            this.m_vdocClassDescs = listImpl;
            this.m_docClassDescsMapByName = docClassDescsMapByName;
            this.m_docClassDescsMapById = docClassDescsMapById;
        }
    }

    public static void main(String[] argv) {
        try {
            Session sess = null;
            sess.verify();
            EntireNetwork net = ObjectFactory.getEntireNetwork(sess);
            Object libs = null;
            VerboseLibrary vLib = null;
            Object testVector = null;
            Iterator it = libs.iterator();
            while (it.hasNext()) {
                try {
                    vLib = new VerboseLibrary((ObjectStore)it.next());
                    System.out.println("ObjectStore name = " + vLib.getName());
                    System.out.println("ObjectStore = " + vLib.getLibrary());
                }
                catch (Exception e) {}
            }
        }
        catch (Exception ex) {
            System.out.println("Error occurred testing VerboseLibrary: " + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

