/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;

public class VerboseFolder {
    private String name;
    private String id;
    private VerboseFolder parent;
    private Folder folder;

    public VerboseFolder(Folder folder) throws BaseException {
        this.initialize(folder);
    }

    public void initialize(Folder folder) throws BaseException {
        this.clear();
        this.folder = folder;
        this.loadProps();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public VerboseFolder getParent() throws BaseException {
        Folder apiParent;
        if (this.parent == null && (apiParent = this.folder.getParentFolder()) != null) {
            this.parent = new VerboseFolder(apiParent);
        }
        return this.parent;
    }

    public void refresh(boolean refreshFolder) throws BaseException {
        this.clear();
        if (refreshFolder) {
            try {
                this.folder.refresh();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.loadProps();
    }

    private void clear() {
        this.name = null;
        this.id = null;
        this.parent = null;
    }

    private void loadProps() throws BaseException {
        Properties propList = null;
        propList = this.folder.getProperties(new String[]{"FolderName", "Id"});
        for (Property tempProp : propList) {
            if (tempProp.getName().compareToIgnoreCase("FolderName") == 0) {
                this.name = (String)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("Id") != 0) continue;
            this.id = (String)tempProp.getValue();
        }
        if (this.id == null) {
            System.out.println("ID not contained as property, getting ID from buzz Folder");
            this.id = this.folder.getId();
        }
        if (this.id == null) {
            throw new RuntimeException("ID property not returned!");
        }
        if ((this.name == null || this.name.length() == 0) && this.id != null && this.id.compareToIgnoreCase("RootFolder") == 0) {
            throw new RuntimeException("Name property not returned!");
        }
    }
}

