/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.BaseException;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyDescriptions;
import com.filenet.wcm.apps.client.util.api.VerboseList;
import com.filenet.wcm.apps.client.util.api.VerboseListImpl;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescription;
import com.filenet.wcm.apps.client.util.api.VerbosePropertyDescriptionFactory;
import java.util.HashMap;

public class VerboseClassDescription {
    private ClassDescription classDesc;
    private String symbolicName;
    private String displayName;
    private VerboseList vpropDescs;
    private HashMap propDescsMapByName;
    private HashMap propDescsMapById;

    public VerboseClassDescription(ClassDescription classDesc) throws BaseException {
        this.initialize(classDesc);
    }

    public void initialize(ClassDescription classDesc) throws BaseException {
        this.clear();
        this.classDesc = classDesc;
        this.loadProps();
    }

    public ClassDescription getClassDescription() {
        return this.classDesc;
    }

    public String getName() {
        return this.getSymbolicName();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getLabel() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.classDesc.getId();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public VerboseList getPropertyDescriptions() throws BaseException, Exception {
        if (this.vpropDescs == null) {
            this.loadPropDescs();
        }
        return this.vpropDescs;
    }

    public VerbosePropertyDescription getPropertyDescriptionFromName(String propDescName) throws BaseException, Exception {
        Object numFromMap;
        if (this.vpropDescs == null) {
            this.loadPropDescs();
        }
        if ((numFromMap = this.propDescsMapByName.get(propDescName)) == null) {
            return null;
        }
        return (VerbosePropertyDescription)this.vpropDescs.get((Integer)numFromMap);
    }

    public VerbosePropertyDescription getPropertyDescriptionFromId(String propDescId) throws BaseException, Exception {
        Object numFromMap;
        if (this.vpropDescs == null) {
            this.loadPropDescs();
        }
        if ((numFromMap = this.propDescsMapById.get(propDescId)) == null) {
            return null;
        }
        return (VerbosePropertyDescription)this.vpropDescs.get((Integer)numFromMap);
    }

    private void loadPropDescs() throws BaseException, Exception {
        if (this.vpropDescs == null) {
            PropertyDescriptions propDescs = this.classDesc.getPropertyDescriptions(false);
            VerboseListImpl listImpl = new VerboseListImpl();
            HashMap<String, Integer> propDescsMapByName = new HashMap<String, Integer>(propDescs.size() + 1, 1.0f);
            HashMap<String, Integer> propDescsMapById = new HashMap<String, Integer>(propDescs.size() + 1, 1.0f);
            for (int i = 0; i < propDescs.size(); ++i) {
                VerbosePropertyDescription vpropDesc = VerbosePropertyDescriptionFactory.createVerbosePropertyDescription((PropertyDescription)propDescs.get(i));
                listImpl.add(vpropDesc);
                propDescsMapByName.put(vpropDesc.getSymbolicName(), new Integer(i));
                propDescsMapById.put(vpropDesc.getId(), new Integer(i));
            }
            this.vpropDescs = listImpl;
            this.propDescsMapByName = propDescsMapByName;
            this.propDescsMapById = propDescsMapById;
        }
    }

    private void clear() {
        this.symbolicName = null;
        this.displayName = null;
        this.vpropDescs = null;
        this.propDescsMapByName = null;
        this.propDescsMapById = null;
    }

    private void loadProps() throws BaseException {
        Properties propList = null;
        propList = this.classDesc.getProperties(new String[]{"SymbolicName", "DisplayName"});
        for (Property tempProp : propList) {
            if (tempProp.getName().compareToIgnoreCase("SymbolicName") == 0) {
                this.symbolicName = (String)tempProp.getValue();
                continue;
            }
            if (tempProp.getName().compareToIgnoreCase("DisplayName") != 0) continue;
            this.displayName = (String)tempProp.getValue();
        }
        if (this.symbolicName == null) {
            throw new RuntimeException("Symbolic Name property not returned!");
        }
    }
}

