/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util.api;

import com.filenet.wcm.api.BaseObject;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.Group;
import com.filenet.wcm.api.Groups;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.Permission;
import com.filenet.wcm.api.Permissions;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.SearchPropertyDescriptions;
import com.filenet.wcm.api.SecurityPolicies;
import com.filenet.wcm.api.SecurityPolicy;
import com.filenet.wcm.api.User;
import com.filenet.wcm.api.Users;
import com.filenet.wcm.api.Value;
import com.filenet.wcm.api.ValueObject;
import com.filenet.wcm.api.Values;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.toolkit.client.util.WcmDate;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class PropertyUtil {
    public static WcmDate getWcmDate(String strDate) {
        try {
            Date date = PropertyUtil.getDate(strDate);
            if (date != null) {
                DateFormat fmt;
                int i;
                Date parsedTime = null;
                Date parsedDate = null;
                ParsePosition ppos = new ParsePosition(0);
                int[] styles = new int[]{3, 2, 1, 0};
                for (i = 0; i < styles.length && (parsedDate = PropertyUtil.tryParseDate(fmt = DateFormat.getDateInstance(styles[i]), strDate, ppos)) == null; ++i) {
                }
                for (i = 0; i < styles.length && (parsedTime = PropertyUtil.tryParseDate(fmt = DateFormat.getTimeInstance(styles[i]), strDate, ppos)) == null; ++i) {
                }
                WcmDate wcmDate = new WcmDate(date);
                if (parsedTime != null) {
                    wcmDate.setUseDateOnly(false);
                } else {
                    wcmDate.setUseDateOnly(true);
                }
                return wcmDate;
            }
        }
        catch (WcmException e) {
            System.out.println("PropertyUtil:getWcmDate:Exception: " + e.getMessage());
        }
        return null;
    }

    public static Date getDate(Object metaPropVal) throws WcmException {
        Date propDateTime = null;
        if (metaPropVal instanceof Value) {
            Value wcmVal = (Value)metaPropVal;
            try {
                propDateTime = wcmVal.getDateValue();
            }
            catch (Exception ex) {
                System.out.println("Value couldn't return Date object");
            }
            if (propDateTime == null) {
                metaPropVal = wcmVal.getValue();
            }
        }
        if (propDateTime == null) {
            DateFormat df = DateFormat.getDateInstance();
            ParsePosition parsePos = new ParsePosition(0);
            if (metaPropVal instanceof Date) {
                propDateTime = (Date)metaPropVal;
            } else if (metaPropVal instanceof String) {
                String strDate = (String)metaPropVal;
                if (strDate.length() != 0) {
                    DateFormat fmt;
                    int i;
                    ParsePosition ppos = new ParsePosition(0);
                    Date parsedDate = null;
                    int[] styles = new int[]{3, 2, 1, 0};
                    for (i = 0; i < styles.length && (parsedDate = PropertyUtil.tryParseDate(fmt = DateFormat.getDateInstance(styles[i]), strDate, ppos)) == null; ++i) {
                    }
                    Date parsedTime = null;
                    for (i = 0; i < styles.length && (parsedTime = PropertyUtil.tryParseDate(fmt = DateFormat.getTimeInstance(styles[i]), strDate, ppos)) == null; ++i) {
                    }
                    if (parsedDate != null) {
                        if (parsedTime != null) {
                            Calendar dateCal = Calendar.getInstance();
                            dateCal.setTime(parsedDate);
                            Calendar timeCal = Calendar.getInstance();
                            timeCal.setTime(parsedTime);
                            dateCal.set(11, timeCal.get(11));
                            dateCal.set(12, timeCal.get(12));
                            dateCal.set(13, timeCal.get(13));
                            dateCal.set(14, timeCal.get(14));
                            propDateTime = dateCal.getTime();
                        } else {
                            propDateTime = parsedDate;
                        }
                    } else if (parsedTime != null) {
                        propDateTime = parsedTime;
                    }
                }
            } else {
                throw new WcmException("client.PropertyUtil.getDateError", "Don''t know how to parse date from {0}", metaPropVal.getClass());
            }
        }
        return propDateTime;
    }

    private static Date tryParseDate(DateFormat fmt, String sfmt, ParsePosition ppos) {
        Date rtnDate = null;
        try {
            rtnDate = fmt.parse(sfmt, ppos);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return rtnDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Boolean getBoolean(Object metaPropVal) throws WcmException {
        Boolean propBoolean = null;
        if (metaPropVal instanceof Value) {
            Value wcmVal = (Value)metaPropVal;
            try {
                propBoolean = new Boolean(wcmVal.getBooleanValue());
            }
            catch (Exception ex) {
                System.out.println("Value couldn't return Boolean object");
            }
            if (propBoolean == null) {
                metaPropVal = wcmVal.getValue();
            }
        }
        if (propBoolean != null) return propBoolean;
        if (metaPropVal instanceof Boolean) {
            return (Boolean)metaPropVal;
        }
        if (metaPropVal instanceof String) {
            if (((String)metaPropVal).length() == 0) return propBoolean;
            if (WcmString.compareIgnoreCase("true", ((String)metaPropVal).toString()) == 0) return Boolean.valueOf((String)metaPropVal);
            if (WcmString.compareIgnoreCase("false", ((String)metaPropVal).toString()) != 0) throw new WcmException("client.PropertyUtil.parseBooleanErrorBadString", "String does not contain a valid Boolean value: {0} ", (Object)((String)metaPropVal).toString());
            return Boolean.valueOf((String)metaPropVal);
        }
        if (!(metaPropVal instanceof Integer)) throw new WcmException("client.PropertyUtil.getBooleanErrorBadType", "Don''t know how to parse Boolean from {0}", metaPropVal.getClass());
        return Boolean.valueOf(((Integer)metaPropVal).toString());
    }

    public static Double getDouble(Object metaPropVal) throws WcmException {
        Double propDouble = null;
        if (metaPropVal instanceof Value) {
            Value wcmVal = (Value)metaPropVal;
            try {
                propDouble = new Double(wcmVal.getDoubleValue());
            }
            catch (Exception ex) {
                System.out.println("Value couldn't return Double object");
            }
            if (propDouble == null) {
                metaPropVal = wcmVal.getValue();
            }
        }
        if (propDouble == null) {
            if (metaPropVal instanceof Double) {
                propDouble = (Double)metaPropVal;
            } else if (metaPropVal instanceof String) {
                if (((String)metaPropVal).length() != 0) {
                    try {
                        propDouble = Double.valueOf((String)metaPropVal);
                    }
                    catch (NumberFormatException e) {
                        throw new WcmException("client.PropertyUtil.getDoubleErrorBadString", "String does not contain a parsable number : {0}", (Object)e.getMessage());
                    }
                }
            } else if (metaPropVal instanceof Integer) {
                propDouble = new Double(((Integer)metaPropVal).doubleValue());
            } else {
                throw new WcmException("client.PropertyUtil.getDoubleErrorBadType", "Don''t know how to parse double from {0}", metaPropVal.getClass());
            }
        }
        return propDouble;
    }

    public static Integer getInteger(Object metaPropVal) throws WcmException {
        Integer propInt32 = null;
        if (metaPropVal instanceof Value) {
            Value wcmVal = (Value)metaPropVal;
            try {
                propInt32 = new Integer(wcmVal.getIntValue());
            }
            catch (Exception ex) {
                System.out.println("Value couldn't return Integer object");
            }
            if (propInt32 == null) {
                metaPropVal = wcmVal.getValue();
            }
        }
        if (propInt32 == null) {
            if (metaPropVal instanceof Integer) {
                propInt32 = (Integer)metaPropVal;
            } else if (metaPropVal instanceof String) {
                if (((String)metaPropVal).length() != 0) {
                    try {
                        propInt32 = Integer.valueOf((String)metaPropVal);
                    }
                    catch (NumberFormatException e) {
                        throw new WcmException("client.PropertyUtil.getIntegerErrorBadString", "String does not contain a parsable number : {0}", (Object)e.getMessage());
                    }
                }
            } else {
                throw new WcmException("client.PropertyUtil.getIntegerErrorBadType", "Don''t know how to parse Integer from {0}", metaPropVal.getClass());
            }
        }
        return propInt32;
    }

    public static String getString(Object metaPropVal) throws WcmException {
        String propString = null;
        if (metaPropVal instanceof Value) {
            Value wcmVal = (Value)metaPropVal;
            try {
                propString = wcmVal.getStringValue();
            }
            catch (Exception ex) {
                System.out.println("Value couldn't return String object");
            }
            if (propString == null) {
                metaPropVal = wcmVal.getValue();
            }
        }
        if (propString == null) {
            propString = metaPropVal instanceof String ? (String)metaPropVal : metaPropVal.toString();
        }
        return propString;
    }

    public static boolean setValueObjectValue(Value valObj, Object val) {
        boolean validVal = true;
        if (val instanceof Integer) {
            valObj.setValue((Integer)val);
        } else if (val instanceof String) {
            valObj.setValue((String)val);
        } else if (val instanceof Double) {
            valObj.setValue((Double)val);
        } else if (val instanceof Values) {
            valObj.setValue((ValueObject)((Values)val));
        } else if (val instanceof Date) {
            valObj.setValue((Date)val);
        } else if (val instanceof Boolean) {
            valObj.setValue((Boolean)val);
        } else if (val instanceof BaseObject) {
            valObj.setValue((ValueObject)((BaseObject)val));
        } else {
            System.out.println("PropertyUtil.setValueObjectValue: Unrecognized value type!");
            validVal = false;
        }
        return validVal;
    }

    public static boolean setPropertyValue(Property prop, Object val) {
        boolean validVal = true;
        if (val instanceof Integer) {
            prop.setValue((Integer)val);
        } else if (val instanceof String) {
            prop.setValue((String)val);
        } else if (val instanceof Double) {
            prop.setValue((Double)val);
        } else if (val instanceof Values) {
            prop.setValue((ValueObject)((Values)val));
        } else if (val instanceof Date) {
            prop.setValue((Date)val);
        } else if (val instanceof Boolean) {
            prop.setValue((Boolean)val);
        } else if (val instanceof BaseObject) {
            prop.setValue((ValueObject)((BaseObject)val));
        } else {
            System.out.println("PropertyUtil.setPropertyValue: Unrecognized value type!");
            validVal = false;
        }
        return validVal;
    }

    public static User findUser(String userName, Users usersList) throws WcmException {
        String userSubString = null;
        String userObjname = null;
        for (User myUser : usersList) {
            try {
                userObjname = myUser.getPropertyStringValue("ShortName");
            }
            catch (Exception e) {
                userObjname = myUser.getName();
            }
            if (WcmString.compareIgnoreCase(userName, userSubString = userName.length() < userObjname.length() ? new String(userObjname.substring(0, userName.length())) : userObjname) != 0) continue;
            return myUser;
        }
        throw new WcmException("client.PropertyUtil.notFound", "Could not find the value: {0}", (Object)userName);
    }

    public static ClassDescription findClassDesc(String className, ClassDescriptions classList) throws WcmException {
        String classSubString = null;
        for (ClassDescription myClass : classList) {
            classSubString = className.length() < myClass.getName().length() ? new String(myClass.getName().substring(0, className.length())) : myClass.getName();
            if (WcmString.compareIgnoreCase(className, classSubString) != 0) continue;
            return myClass;
        }
        throw new WcmException("client.PropertyUtil.notFound", "Could not find the value: {0}", (Object)className);
    }

    public static SearchPropertyDescriptions sort(SearchPropertyDescriptions list) throws Exception {
        CompareSearchPropDescs comparer = new CompareSearchPropDescs();
        Collections.sort(list, comparer);
        return list;
    }

    public static Vector sort(Vector list) throws Exception {
        CompareWrappedPropDescs comparer = new CompareWrappedPropDescs();
        Collections.sort(list, comparer);
        return list;
    }

    public static ObjectStores sort(ObjectStores list) throws Exception {
        CompareLibraries comparer = new CompareLibraries();
        Collections.sort(list, comparer);
        return list;
    }

    public static ClassDescriptions sort(ClassDescriptions list) throws Exception {
        CompareClassDescs comparer = new CompareClassDescs();
        Collections.sort(list, comparer);
        return list;
    }

    public static void sort(Groups list) {
        CompareGroups comparer = new CompareGroups();
        Collections.sort(list, comparer);
    }

    public static void sortByDispName(Groups list) {
        CompareGroupsDispName comparer = new CompareGroupsDispName();
        Collections.sort(list, comparer);
    }

    public static void sort(SecurityPolicies list) {
        CompareSecurityPolicies comparer = new CompareSecurityPolicies();
        Collections.sort(list, comparer);
    }

    public static void sort(List list) {
        CompareItems comparer = new CompareItems();
        Collections.sort(list, comparer);
    }

    public static void sort(Users list) {
        CompareUsers comparer = new CompareUsers();
        Collections.sort(list, comparer);
    }

    public static void sortByDispName(Users list) {
        CompareUsersDispName comparer = new CompareUsersDispName();
        Collections.sort(list, comparer);
    }

    public static void sort(Permissions perms) {
        CompareGrantees comparer = new CompareGrantees();
        Collections.sort(perms, comparer);
    }

    public static String getStringValue(Object value, boolean shortDateFormat) {
        String stringValue = null;
        stringValue = value instanceof Integer ? ((Integer)value).toString() : (value instanceof Double ? ((Double)value).toString() : (value instanceof Boolean ? ((Boolean)value).toString() : (value instanceof Date ? (shortDateFormat ? DateFormat.getInstance().format((Date)value) : DateFormat.getDateTimeInstance().format((Date)value)) : (String)value)));
        return stringValue;
    }

    public static class CompareGrantees
    implements Comparator {
        public boolean equals(Object obj) {
            return obj != null && obj instanceof Permission;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof Permission && obj2 instanceof Permission) {
                Permission userObj1 = (Permission)obj1;
                Permission userObj2 = (Permission)obj2;
                return WcmString.compare(userObj1.getGranteeName(), userObj2.getGranteeName());
            }
            return 1;
        }
    }

    public static class CompareUsersDispName
    implements Comparator {
        public boolean equals(Object obj) {
            return obj != null && obj instanceof User;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof User && obj2 instanceof User) {
                User userObj1 = (User)obj1;
                User userObj2 = (User)obj2;
                String dispNameUserObj1 = "";
                String dispNameUserObj2 = "";
                try {
                    dispNameUserObj1 = userObj1.getPropertyStringValue("DisplayName");
                }
                catch (PropertyNotFoundException pnfe) {
                    dispNameUserObj1 = userObj1.getName();
                }
                try {
                    dispNameUserObj2 = userObj2.getPropertyStringValue("DisplayName");
                }
                catch (PropertyNotFoundException pnfe) {
                    dispNameUserObj2 = userObj2.getName();
                }
                return WcmString.compare(dispNameUserObj1, dispNameUserObj2);
            }
            return 1;
        }
    }

    public static class CompareUsers
    implements Comparator {
        public boolean equals(Object obj) {
            return obj != null && obj instanceof User;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof User && obj2 instanceof User) {
                User userObj1 = (User)obj1;
                User userObj2 = (User)obj2;
                return WcmString.compare(userObj1.getName(), userObj2.getName());
            }
            return 1;
        }
    }

    public static class CompareItems
    implements Comparator {
        public boolean equals(Object obj) {
            return obj != null;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null) {
                return WcmString.compare(obj1.toString(), obj2.toString());
            }
            return 1;
        }
    }

    public static class CompareSecurityPolicies
    implements Comparator {
        public boolean equals(Object obj) {
            return obj != null && obj instanceof SecurityPolicy;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof SecurityPolicy && obj2 instanceof SecurityPolicy) {
                SecurityPolicy secObj1 = (SecurityPolicy)obj1;
                SecurityPolicy secObj2 = (SecurityPolicy)obj2;
                return WcmString.compare(secObj1.getName(), secObj2.getName());
            }
            return 1;
        }
    }

    public static class CompareGroupsDispName
    implements Comparator {
        public boolean equals(Object obj) {
            return obj != null && obj instanceof Group;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof Group && obj2 instanceof Group) {
                Group groupObj1 = (Group)obj1;
                Group groupObj2 = (Group)obj2;
                String dispNameGroupObj1 = "";
                String dispNameGroupObj2 = "";
                try {
                    dispNameGroupObj1 = groupObj1.getPropertyStringValue("DisplayName");
                }
                catch (PropertyNotFoundException pnfe) {
                    dispNameGroupObj1 = groupObj1.getName();
                }
                try {
                    dispNameGroupObj2 = groupObj2.getPropertyStringValue("DisplayName");
                }
                catch (PropertyNotFoundException pnfe) {
                    dispNameGroupObj2 = groupObj2.getName();
                }
                return WcmString.compare(dispNameGroupObj1, dispNameGroupObj2);
            }
            return 1;
        }
    }

    public static class CompareGroups
    implements Comparator {
        public boolean equals(Object obj) {
            return obj != null && obj instanceof Group;
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null && obj1 instanceof Group && obj2 instanceof Group) {
                Group grpObj1 = (Group)obj1;
                Group grpObj2 = (Group)obj2;
                return WcmString.compare(grpObj1.getName(), grpObj2.getName());
            }
            return 1;
        }
    }

    public static class CompareClassDescs
    implements Comparator {
        public int compare(Object o1, Object o2) {
            ClassDescription p1 = (ClassDescription)o1;
            ClassDescription p2 = (ClassDescription)o2;
            String name1 = "";
            String name2 = "";
            try {
                name1 = p1.getPropertyStringValue("DisplayName");
                name2 = p2.getPropertyStringValue("DisplayName");
            }
            catch (Exception e) {
                System.out.println("Failing to sort class descriptions: " + e.getMessage());
            }
            return WcmString.compare(name1, name2);
        }
    }

    public static class CompareLibraries
    implements Comparator {
        public int compare(Object o1, Object o2) {
            ObjectStore p1 = (ObjectStore)o1;
            ObjectStore p2 = (ObjectStore)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            try {
                name1 = p1.getPropertyStringValue("DisplayName");
                name2 = p2.getPropertyStringValue("DisplayName");
            }
            catch (Exception e) {
                System.out.println("Failing to sort libraries: " + e.getMessage());
            }
            return WcmString.compare(name1, name2);
        }
    }

    public static class CompareWrappedPropDescs
    implements Comparator {
        public int compare(Object o1, Object o2) {
            WcmWrappedPD p1 = (WcmWrappedPD)o1;
            WcmWrappedPD p2 = (WcmWrappedPD)o2;
            String name1 = "";
            String name2 = "";
            try {
                name1 = p1.getDisplayName();
                name2 = p2.getDisplayName();
            }
            catch (Exception e) {
                System.out.println("Failing to sort wrapped property descriptions: " + e.getMessage());
            }
            return WcmString.compare(name1, name2);
        }
    }

    public static class CompareSearchPropDescs
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SearchPropertyDescription p1 = (SearchPropertyDescription)o1;
            SearchPropertyDescription p2 = (SearchPropertyDescription)o2;
            String name1 = "";
            String name2 = "";
            try {
                name1 = p1.getPropertyStringValue("DisplayName");
                name2 = p2.getPropertyStringValue("DisplayName");
            }
            catch (Exception e) {
                System.out.println("Failing to sort property descriptions: " + e.getMessage());
            }
            return WcmString.compare(name1, name2);
        }
    }
}

