/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.text.AttributedString;

public final class StringUtil {
    public static final String ELLIPSIS = "...";

    public static String truncateText(String text, int availableWidth, Component component) {
        int textWidth;
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        availableWidth -= fontMetrics.stringWidth(ELLIPSIS);
        if (text == null) {
            text = "";
        } else if (availableWidth <= 0) {
            text = ELLIPSIS;
        } else if (text.length() > 0 && availableWidth > 0 && (textWidth = fontMetrics.stringWidth(text)) > availableWidth) {
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            AttributedString attribString = new AttributedString(text);
            LineBreakMeasurer measurer = new LineBreakMeasurer(attribString.getIterator(), fontRenderContext);
            int offset = measurer.nextOffset(availableWidth);
            text = text.substring(0, offset) + ELLIPSIS;
        }
        return text;
    }
}

