/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.util;

import com.filenet.wcm.apps.client.util.BooleanRef;
import com.filenet.wcm.toolkit.util.WcmException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ISODateUtil {
    public static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");
    private static final int nMilliSeconsPerHour = 3600000;
    private static final int nMilliSeconsPerMinute = 60000;
    private static int[] longForm = new int[]{0, 4, 5, 7, 8, 10, 11, 13, 14, 16, 17, 19, 16, 19};
    private static int[] shortForm = new int[]{0, 4, 4, 6, 6, 8, 9, 11, 11, 13, 13, 15, 16, 14};

    public static Date convertISODateToDate(Object metaPropVal) throws WcmException {
        Date retDate = null;
        if (metaPropVal instanceof Date) {
            retDate = (Date)metaPropVal;
        } else if (metaPropVal instanceof String) {
            String strInput = (String)metaPropVal;
            try {
                String subStr = strInput.substring(0, 15);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
                formatter.setLenient(false);
                formatter.setTimeZone(TIME_ZONE_GMT);
                Date dt = formatter.parse(subStr, new ParsePosition(0));
                if (dt == null) {
                    int year = Integer.parseInt(subStr.substring(0, 4));
                    int month = Integer.parseInt(subStr.substring(4, 6));
                    int date = Integer.parseInt(subStr.substring(6, 8));
                    if (!ISODateUtil.isLeapYear(year) && month == 2 && date == 29) {
                        ISODateUtil.throwInvalidLeapYearBadString(year);
                    } else {
                        ISODateUtil.throwConvertDateFromISODateErrorBadString();
                    }
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(dt);
                if (strInput.charAt(15) == ',') {
                    subStr = strInput.substring(16, strInput.length() - 1);
                    int intVal = Integer.parseInt(subStr);
                    cal.set(14, intVal);
                    if (strInput.charAt(strInput.length() - 1) != 'Z') {
                        ISODateUtil.throwConvertDateFromISODateErrorBadString();
                    }
                } else if (strInput.length() != 16 || strInput.charAt(15) != 'Z') {
                    ISODateUtil.throwConvertDateFromISODateErrorBadString();
                }
                retDate = cal.getTime();
            }
            catch (IndexOutOfBoundsException ibe) {
                ISODateUtil.throwConvertDateFromISODateErrorBadString();
            }
            catch (NumberFormatException nfe) {
                ISODateUtil.throwConvertDateFromISODateErrorBadString();
            }
        } else {
            throw new WcmException("client.ISODateUtil.convertDateFromISODateErrorBadType", "Don''t know how to parse date from {0}", metaPropVal.getClass());
        }
        return retDate;
    }

    public static String convertDateToISODate(Date metaPropVal) {
        String strISOTime = "";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TIME_ZONE_GMT);
        cal.setTime(metaPropVal);
        strISOTime = strISOTime + cal.get(1);
        int nMonth = cal.get(2) - 0 + 1;
        strISOTime = nMonth < 10 ? strISOTime + "0" + nMonth : strISOTime + nMonth;
        strISOTime = cal.get(5) < 10 ? strISOTime + "0" + cal.get(5) : strISOTime + cal.get(5);
        strISOTime = strISOTime + "T";
        strISOTime = cal.get(11) < 10 ? strISOTime + "0" + cal.get(11) : strISOTime + cal.get(11);
        strISOTime = cal.get(12) < 10 ? strISOTime + "0" + cal.get(12) : strISOTime + cal.get(12);
        strISOTime = cal.get(13) < 10 ? strISOTime + "0" + cal.get(13) : strISOTime + cal.get(13);
        if (cal.get(14) > 0) {
            strISOTime = strISOTime + "," + cal.get(14);
        }
        strISOTime = strISOTime + "Z";
        return strISOTime;
    }

    private static void throwConvertDateFromISODateErrorBadString() throws WcmException {
        throw new WcmException("client.ISODateUtil.convertDateFromISODateErrorBadString", "Don''t know how to parse date from input. The String input must be in ''YYYYMMDDThhmmss[,f]Z'' format.");
    }

    private static void throwConvertDateFromW3CDateErrorBadString() throws WcmException {
        throw new WcmException("client.ISODateUtil.convertDateFromW3CDateErrorBadString", "Don''t know how to parse input data. The input format must be ''YYYY-MM-DDThh:mm:ss[.ss][Z|((+|-)hh:mm)]'' or ''YYYY-MM-DD[Z|((+|-)hh:mm)]''.");
    }

    private static void throwInvalidLeapYearBadString(int yr) throws WcmException {
        throw new WcmException("client.ISODateUtil.invalidLeapYearBadString", "The input String is invalid because " + yr + " is not a leap year.");
    }

    private static boolean isLeapYear(int yr) {
        boolean bLeapYear = false;
        if (yr % 4 == 0) {
            bLeapYear = yr % 100 != 0 || yr % 400 == 0;
        }
        return bLeapYear;
    }

    public static String convertDateToW3CDate(Date metaPropVal, boolean bDateOnly) {
        int offset;
        Calendar cal = Calendar.getInstance();
        cal.setTime(metaPropVal);
        StringBuilder sb = new StringBuilder(30);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        sb.append(year);
        sb.append('-');
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        if (dayOfMonth < 10) {
            sb.append('0');
        }
        sb.append(dayOfMonth);
        if (!bDateOnly) {
            int hour = cal.get(11);
            int min = cal.get(12);
            int sec = cal.get(13);
            int msec = cal.get(14);
            sb.append('T');
            if (hour < 10) {
                sb.append('0');
            }
            sb.append(hour);
            sb.append(':');
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min);
            sb.append(':');
            if (sec < 10) {
                sb.append('0');
            }
            sb.append(sec);
            if (msec != 0) {
                sb.append('.');
                sb.append(msec);
            }
        }
        if ((offset = cal.get(15) + cal.get(16)) < 0) {
            offset = -offset;
            sb.append('-');
        } else {
            sb.append('+');
        }
        int offsetHour = offset / 3600000;
        int offsetMin = (offset - 3600000 * offsetHour) / 60000;
        if (offsetHour < 10) {
            sb.append('0');
        }
        sb.append(offsetHour);
        sb.append(':');
        if (offsetMin < 10) {
            sb.append('0');
        }
        sb.append(offsetMin);
        return sb.toString();
    }

    public static Date convertW3CDateToDate(Object metaPropVal, BooleanRef bDateOnlyVal) throws WcmException {
        Date retDate = null;
        if (metaPropVal instanceof Date) {
            retDate = (Date)metaPropVal;
        } else if (metaPropVal instanceof String) {
            retDate = ISODateUtil.convertW3CDateToCalendar((String)metaPropVal, true, null).getTime();
        } else {
            throw new WcmException("client.ISODateUtil.convertDateFromW3CDateErrorBadType", "Don''t know how to parse date from {0}", metaPropVal.getClass());
        }
        return retDate;
    }

    public static Calendar convertW3CDateToCalendar(String str, boolean hyphenated, TimeZone defaultTimeZone) {
        int signPosition;
        char sign;
        TimeZone tz;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int msec = 0;
        int[] form = hyphenated ? longForm : shortForm;
        int len = str.length();
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        int year = Integer.parseInt(str.substring(form[0], form[1]));
        int month = Integer.parseInt(str.substring(form[2], form[3]));
        int day = Integer.parseInt(str.substring(form[4], form[5]));
        if (len >= form[13]) {
            hour = Integer.parseInt(str.substring(form[6], form[7]));
            min = Integer.parseInt(str.substring(form[8], form[9]));
            sec = Integer.parseInt(str.substring(form[10], form[11]));
            if (hyphenated) {
                msec = ISODateUtil.parseMilliseconds(str, len);
            }
        }
        TimeZone timeZone = tz = defaultTimeZone == null ? TimeZone.getDefault() : defaultTimeZone;
        if (str.charAt(len - 1) == 'Z') {
            tz = TIME_ZONE_GMT;
        } else if (len >= form[12] && ((sign = str.charAt(signPosition = len - 6)) == '+' || sign == '-')) {
            String timeZone2 = str.substring(signPosition);
            tz = TimeZone.getTimeZone("GMT" + timeZone2);
        }
        cal.setTimeZone(tz);
        cal.set(year, month - 1, day, hour, min, sec);
        cal.set(14, msec);
        return cal;
    }

    private static int parseMilliseconds(String str, int len) {
        int d;
        int msec = 0;
        if (len >= 21 && str.charAt(19) == '.' && (d = Character.digit(str.charAt(20), 10)) != -1) {
            msec = d * 100;
            if (len >= 22 && (d = Character.digit(str.charAt(21), 10)) != -1) {
                msec += d * 10;
                if (len >= 23 && (d = Character.digit(str.charAt(22), 10)) != -1) {
                    msec += d;
                }
            }
        }
        return msec;
    }
}

