/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.ae.util.search.CBRSearchTerm;
import com.filenet.wcm.api.ChoiceList;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.MarkingSet;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.WcmColumnHeader;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchFolder;
import com.filenet.wcm.apps.client.search.ui.WcmSearchLibrary;
import com.filenet.wcm.apps.client.search.ui.WcmSearchOptionsRec;
import com.filenet.wcm.apps.client.search.ui.WcmSubClass;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.server.util.xml.WcmXMLUtil;
import com.filenet.wcm.toolkit.util.CBRSearchParser;
import com.filenet.wcm.toolkit.util.CBRSearchType;
import com.filenet.wcm.toolkit.util.CBRSearchXMLUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.WcmXMLEncode;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WcmXMLTransformer {
    private static final String DTD_VER = "3.0";
    private static final String SEARCHOBJ_VER = "3";
    private static final String PROD_NAME = "Search Designer";
    private static final String PROD_VER = "3.0";
    private static final String NAMESPACE = "http://filenet.com/namespaces/wcm/apps/1.0";
    private static final String DEF_MAXRESULTS = "100";
    private static final String DEF_FROMCLAUSE = "Document";
    private static final String XML_HEADER = "<?xml version=\"1.0\"?>\r\n";
    public static final String SEARCH = "search";
    public static final String TEMPLATE = "template";
    private static final String ALIGNMENT = "alignment";
    private static final String ALL = "all";
    private static final String ALLVERSIONS = "allversions";
    private static final String AND = "and";
    private static final String ANY = "any";
    private static final String BASE64 = "base64";
    private static final String CHOICEID = "choiceId";
    private static final String CLASS = "class";
    private static final String COMMON = "common";
    private static final String COMMONPLACEHOLDER = "commonplaceholder";
    private static final String CONTENT = "content";
    private static final String CONTENTSUMMARY = "contentsummary";
    private static final String CURRENTVERSION = "currentversion";
    private static final String CUSTOMOBJECT = "customobject";
    private static final String DATAENCODING = "dataencoding";
    private static final String DATATYPE = "datatype";
    private static final String DOCUMENT = "document";
    private static final String DTD = "dtd";
    private static final String EDITPROPERTY = "editproperty";
    private static final String EQ = "eq";
    private static final String FALSE = "false";
    private static final String FOLDER = "folder";
    private static final String FOLDERS = "folders";
    private static final String FROM = "from";
    private static final String FULLOUTER = "fullouter";
    private static final String GROUPACTION = "groupaction";
    private static final String GT = "gt";
    private static final String GTE = "gte";
    private static final String HASCHOICELIST = "haschoices";
    private static final String HASMARKINGS = "hasmarkings";
    private static final String ID = "id";
    private static final String INNER = "inner";
    private static final String INTERSECTION = "intersection";
    private static final String IN_ZONE = "in zone";
    private static final String ISDEFINED = "isdefined";
    private static final String ISNOTDEFINED = "isnotdefined";
    private static final String ISNOTNULL = "isnotnull";
    private static final String ISNULL = "isnull";
    private static final String ITEMID = "itemid";
    private static final String JOINTYPE = "jointype";
    private static final String LEFT = "left";
    private static final String LIBRARIES = "objectstores";
    private static final String LIBRARY = "objectstore";
    private static final String LIKE = "like";
    private static final String LITERAL = "literal";
    private static final String LT = "lt";
    private static final String LTE = "lte";
    private static final String MAXRECORDS = "maxrecords";
    private static final String MERGEOPTION = "mergeoption";
    private static final String NAME = "name";
    private static final String NEAR = "near";
    private static final String NEARITEMS = "nearitems";
    private static final String NEQ = "neq";
    private static final String NONE = "none";
    private static final String NOTLIKE = "notlike";
    private static final String IN = "in";
    private static final String OBJECTTYPE = "objecttype";
    private static final String OPTIONS = "options";
    private static final String OR = "or";
    private static final String PARAGRAPH = "paragraph";
    private static final String PATHNAME = "pathname";
    private static final String PRODUCT = "product";
    private static final String PROPDESC = "propdesc";
    private static final String RANK = "rank";
    private static final String RELEASEDVERSION = "releasedversion";
    private static final String SEARCHALLVERSIONS = "searchallversions";
    private static final String SEARCHCLAUSES = "searchclauses";
    private static final String SEARCHCLAUSE = "searchclause";
    private static final String SEARCHCRITERIA = "searchcriteria";
    private static final String SEARCHOBJECT = "searchobject";
    private static final String SEARCHSPEC = "searchspec";
    private static final String SEARCHSUBFOLDERS = "searchsubfolders";
    private static final String SEARCHTYPE = "searchtype";
    private static final String SELECT = "select";
    private static final String SELECTPROP = "selectprop";
    private static final String SELECTPROPALL = "selectpropall";
    private static final String SELECTPROPS = "selectprops";
    private static final String SENTENCE = "sentence";
    private static final String SHOWANDORCONDITIONS = "showandorconditions";
    private static final String SHOWMAXRECORDS = "showmaxrecords";
    private static final String SHOWOPERATORS = "showoperators";
    private static final String SORTORDER = "sortorder";
    private static final String SORTLEVEL = "sortlevel";
    private static final String STOREDSEARCH = "storedsearch";
    private static final String SUBCLASS = "subclass";
    private static final String SUBCLASSES = "subclasses";
    private static final String SYMNAME = "symname";
    private static final String TRUE = "true";
    private static final String TYPEBINARY = "typebinary";
    private static final String TYPEBOOLEAN = "typeboolean";
    private static final String TYPEDATE = "typedate";
    private static final String TYPEDOUBLE = "typedouble";
    private static final String TYPEGUID = "typeguid";
    private static final String TYPELONG = "typelong";
    private static final String TYPEOBJECT = "typeobject";
    private static final String TYPESTRING = "typestring";
    private static final String UNION = "union";
    private static final String VERSION = "version";
    private static final String VERSIONSELECTION = "versionselection";
    private static final String VIEW = "view";
    private static final String VQL = "vql";
    private static final String WHERE = "where";
    private static final String WHEREPROP = "whereprop";
    private static final String XMLNS = "xmlns";
    private static final int COMMON_CLAUSE = 0;
    private static final int DOCUMENT_CLAUSE = 1;
    private static final int FOLDER_CLAUSE = 2;
    private static final int CUSTOMOBJECT_CLAUSE = 3;
    private Document document = null;
    private Node rootNode = null;
    private NodeList m_topLevelNodeList = null;
    private NodeList m_searchCriteriaNodeList = null;
    private NodeList m_searchClausesNodeList = null;
    private WcmSearchOptionsRec m_searchOptions = new WcmSearchOptionsRec();
    private Vector m_libraries = null;
    private Vector m_folders = null;
    private Vector m_subClasses = null;
    private String m_searchType = "search";
    private String m_version = "3.0";
    private String m_maxResults = "100";
    private Vector m_selectClause = null;
    private boolean[] m_fromClause = new boolean[3];
    private Node m_commonWhereClause = null;
    private Node m_documentWhereClause = null;
    private Node m_folderWhereClause = null;
    private Node m_customObjWhereClause = null;
    private Node m_contentClause = null;
    private String m_namespace = "http://filenet.com/namespaces/wcm/apps/1.0";
    private boolean m_foundContentSummary = false;
    private boolean m_hasMarkingSet = false;
    private HashMap idMap = null;
    private Frame m_parentFrame = null;
    private CBRSearchType cbrSearchType;

    public WcmXMLTransformer(Frame pframe, CBRSearchType cbrSearchType) {
        this.cbrSearchType = cbrSearchType;
        try {
            this.m_parentFrame = pframe;
            this.document = WcmXMLUtil.getNewDocument();
            this.rewriteDocument();
            this.idMap = new HashMap(25);
            this.rootNode = this.document.getDocumentElement();
            NodeList nodeList = null;
            nodeList = this.rootNode.getChildNodes();
            Node searchSpecNode = this.getNodeNamed(nodeList, SEARCHSPEC);
            this.m_topLevelNodeList = searchSpecNode.getChildNodes();
            Node searchCriteriaNode = this.getNodeNamed(this.m_topLevelNodeList, SEARCHCRITERIA);
            this.m_searchCriteriaNodeList = searchCriteriaNode.getChildNodes();
            this.readAllData();
        }
        catch (Exception e) {
            System.out.println("Error in constructor: " + e.getMessage());
        }
    }

    public WcmXMLTransformer(FileInputStream fileInputStream, Frame pframe, CBRSearchType defaultCBRSearchType) throws Exception {
        this(new InputSource(fileInputStream), pframe, defaultCBRSearchType);
    }

    public WcmXMLTransformer(InputStream inputStream, Frame pframe, CBRSearchType defaultCBRSearchType) throws Exception {
        this(new InputSource(inputStream), pframe, defaultCBRSearchType);
    }

    public WcmXMLTransformer(InputSource inputSource, Frame pframe, CBRSearchType defaultCBRSearchType) throws Exception {
        this.m_parentFrame = pframe;
        this.document = WcmXMLUtil.getDocumentFromInputSource(inputSource);
        this.idMap = new HashMap(25);
        this.rootNode = this.document.getDocumentElement();
        NodeList nodeList = null;
        nodeList = this.rootNode.getChildNodes();
        Node searchSpecNode = this.getNodeNamed(nodeList, SEARCHSPEC);
        this.m_topLevelNodeList = searchSpecNode.getChildNodes();
        Node searchCriteriaNode = this.getNodeNamed(this.m_topLevelNodeList, SEARCHCRITERIA);
        this.m_searchCriteriaNodeList = searchCriteriaNode.getChildNodes();
        this.readAllData();
        this.cbrSearchType = this.m_contentClause != null ? (this.m_contentClause.getNodeName().equals(CONTENT) ? CBRSearchType.CASCADE : CBRSearchType.VERITY) : defaultCBRSearchType;
    }

    public void setCBRSearchType(CBRSearchType cbrSearchType) {
        this.cbrSearchType = cbrSearchType;
    }

    public CBRSearchType getCBRSearchType() {
        return this.cbrSearchType;
    }

    private Integer getUniqueID(Integer newKey) {
        int key = newKey;
        if (this.idMap == null) {
            this.idMap = new HashMap(25);
        }
        boolean unique = false;
        while (!unique) {
            if (this.idMap.containsKey("" + key)) {
                ++key;
                continue;
            }
            this.idMap.put("" + key, "" + key);
            unique = true;
        }
        return new Integer(key);
    }

    public String toString() {
        try {
            StringWriter xmlStringWriter = new StringWriter();
            xmlStringWriter.write(XML_HEADER);
            WcmXMLUtil.writeXML(xmlStringWriter, (Node)this.document);
            return xmlStringWriter.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void readAllData() {
        try {
            this.readFolders();
            this.readLibraries();
            this.readSearchType();
            this.readMaxResults();
            this.readNamespace();
            this.readVersion();
            this.readSearchClauses();
            this.readSearchOptions();
        }
        catch (Exception e) {
            System.out.println("Failed to read the XML file: " + e.getMessage());
        }
    }

    public void readSearchClauses() {
        Node node = null;
        try {
            Node searchClausesNode = this.getNodeNamed(this.m_searchCriteriaNodeList, SEARCHCLAUSES);
            this.m_searchClausesNodeList = searchClausesNode.getChildNodes();
            this.m_selectClause = new Vector();
            this.m_subClasses = new Vector();
            block8: for (int i = 0; i < this.m_searchClausesNodeList.getLength(); ++i) {
                node = this.m_searchClausesNodeList.item(i);
                if (WcmString.compareIgnoreCase(node.getNodeName(), SEARCHCLAUSE) != 0) continue;
                int type = this.readFromClause(node);
                switch (type) {
                    case 0: {
                        this.readSelectClause(node);
                        this.m_commonWhereClause = this.readWhereClause(node);
                        continue block8;
                    }
                    case 1: {
                        this.readSelectClause(node);
                        this.m_documentWhereClause = this.readWhereClause(node);
                        this.readContentClause(node);
                        this.m_fromClause[0] = true;
                        this.readSubClasses(node);
                        continue block8;
                    }
                    case 2: {
                        this.readSelectClause(node);
                        this.m_folderWhereClause = this.readWhereClause(node);
                        this.m_fromClause[1] = true;
                        this.readSubClasses(node);
                        continue block8;
                    }
                    case 3: {
                        this.readSelectClause(node);
                        this.m_customObjWhereClause = this.readWhereClause(node);
                        this.m_fromClause[2] = true;
                        this.readSubClasses(node);
                        continue block8;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to read the Search Clauses: " + e.getMessage());
        }
    }

    public void rewriteDocument() {
        Object attrNode = null;
        Object al = null;
        if (this.rootNode != null) {
            this.document.removeChild(this.rootNode);
        }
        this.rootNode = this.document.createElement(STOREDSEARCH);
        this.document.appendChild(this.rootNode);
        this.setNodeAttribute(this.rootNode, XMLNS, NAMESPACE);
        this.rootNode.appendChild(this.document.createTextNode("\n"));
        Node versionNode = this.createNodeNamed(this.rootNode, VERSION);
        this.setNodeAttribute(versionNode, DTD, "3.0");
        this.setNodeAttribute(versionNode, SEARCHOBJECT, SEARCHOBJ_VER);
        Node productNode = this.createNodeNamed(this.rootNode, PRODUCT);
        this.setNodeAttribute(productNode, NAME, PROD_NAME);
        this.setNodeAttribute(productNode, VERSION, "3.0");
        Node searchSpecNode = this.createNodeNamed(this.rootNode, SEARCHSPEC);
        int versionSel = this.m_searchOptions.m_versionSelection;
        if (versionSel == 0) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, NONE);
        } else if (versionSel == 1) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, CURRENTVERSION);
        } else if (versionSel == 2) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, RELEASEDVERSION);
        } else if (versionSel == 3) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, ALLVERSIONS);
        }
        searchSpecNode.appendChild(this.document.createTextNode("\n"));
        this.writeSearchType(searchSpecNode);
        this.writeLibraries(searchSpecNode);
        this.writeSearchClauses(searchSpecNode);
        Node optionsNode = this.createNodeNamed(searchSpecNode, OPTIONS);
        this.setNodeAttribute(optionsNode, MAXRECORDS, this.m_maxResults);
    }

    private void writeSearchType(Node parentNode) {
        Node searchNode = null;
        Node searchTypeNode = this.createNodeNamed(parentNode, SEARCHTYPE);
        searchTypeNode.appendChild(this.document.createTextNode("\n"));
        if (WcmString.compareIgnoreCase(this.m_searchType, TEMPLATE) == 0) {
            searchNode = this.createNodeNamed(searchTypeNode, TEMPLATE);
            this.setNodeAttribute(searchNode, SHOWOPERATORS, new Boolean(this.m_searchOptions.m_showOperators).toString());
            this.setNodeAttribute(searchNode, SHOWMAXRECORDS, new Boolean(this.m_searchOptions.m_showMaxReturned).toString());
            this.setNodeAttribute(searchNode, SHOWANDORCONDITIONS, new Boolean(this.m_searchOptions.m_showLogicalOperators).toString());
        } else {
            searchNode = this.createNodeNamed(searchTypeNode, SEARCH);
        }
    }

    private void writeLibraries(Node parentNode) {
        Node libraryNode = null;
        Node librariesNode = this.createNodeNamed(parentNode, LIBRARIES);
        librariesNode.appendChild(this.document.createTextNode("\n"));
        if (this.m_searchOptions.m_union) {
            this.setNodeAttribute(librariesNode, MERGEOPTION, UNION);
        } else {
            this.setNodeAttribute(librariesNode, MERGEOPTION, INTERSECTION);
        }
        if (this.m_libraries != null) {
            for (Object libObj : this.m_libraries) {
                WcmXMLEncode.XmlEncodeResult encodeName;
                WcmXMLEncode.XmlEncodeResult encodeId;
                if (libObj instanceof WcmSearchLibrary) {
                    WcmSearchLibrary sLib = (WcmSearchLibrary)libObj;
                    if (sLib == null) continue;
                    libraryNode = this.createNodeNamed(librariesNode, LIBRARY);
                    encodeId = WcmXMLEncode.encodeForXml(sLib.getId(), null);
                    this.setNodeAttribute(libraryNode, ID, encodeId.outString);
                    encodeName = WcmXMLEncode.encodeForXml(sLib.getName(), null);
                    this.setNodeAttribute(libraryNode, NAME, encodeName.outString);
                    continue;
                }
                if (libObj instanceof VerboseLibrary) {
                    VerboseLibrary vLib = (VerboseLibrary)libObj;
                    if (vLib == null) continue;
                    libraryNode = this.createNodeNamed(librariesNode, LIBRARY);
                    encodeId = WcmXMLEncode.encodeForXml(vLib.getId(), null);
                    this.setNodeAttribute(libraryNode, ID, encodeId.outString);
                    encodeName = WcmXMLEncode.encodeForXml(vLib.getName(), null);
                    this.setNodeAttribute(libraryNode, NAME, encodeName.outString);
                    continue;
                }
                System.out.println("WcmXMLTransformer::writeLibraries():  Unknown object store type");
            }
        }
    }

    private void writeSearchClauses(Node parentNode) {
        Node searchClauseNode;
        Node searchCriteriaNode = this.createNodeNamed(parentNode, SEARCHCRITERIA);
        searchCriteriaNode.appendChild(this.document.createTextNode("\n"));
        this.writeFoldersNode(searchCriteriaNode);
        Node searchClausesNode = this.createNodeNamed(searchCriteriaNode, SEARCHCLAUSES);
        searchClausesNode.appendChild(this.document.createTextNode("\n"));
        if (this.m_commonWhereClause != null) {
            searchClauseNode = this.createNodeNamed(searchClausesNode, SEARCHCLAUSE);
            searchClauseNode.appendChild(this.document.createTextNode("\n"));
            this.writeCommonFromNode(searchClauseNode);
            this.writeCommonWhereNode(searchClauseNode);
        }
        if (this.m_documentWhereClause != null && this.m_fromClause[0]) {
            searchClauseNode = this.createNodeNamed(searchClausesNode, SEARCHCLAUSE);
            searchClauseNode.appendChild(this.document.createTextNode("\n"));
            this.writeDocumentSelectNode(searchClauseNode);
            this.writeDocumentFromNode(searchClauseNode);
            this.writeDocumentWhereNode(searchClauseNode);
            this.writeContentNode(searchClauseNode);
            this.writeDocumentSubClassesNode(searchClauseNode);
        } else if (this.m_fromClause[0]) {
            searchClauseNode = this.createNodeNamed(searchClausesNode, SEARCHCLAUSE);
            searchClauseNode.appendChild(this.document.createTextNode("\n"));
            this.writeDocumentSelectNode(searchClauseNode);
            this.writeDocumentFromNode(searchClauseNode);
            this.writeContentNode(searchClauseNode);
            this.writeDocumentSubClassesNode(searchClauseNode);
        }
        if (this.m_folderWhereClause != null && this.m_fromClause[1]) {
            searchClauseNode = this.createNodeNamed(searchClausesNode, SEARCHCLAUSE);
            searchClauseNode.appendChild(this.document.createTextNode("\n"));
            this.writeFolderSelectNode(searchClauseNode);
            this.writeFolderFromNode(searchClauseNode);
            this.writeFolderWhereNode(searchClauseNode);
            this.writeFolderSubClassesNode(searchClauseNode);
        } else if (this.m_fromClause[1]) {
            searchClauseNode = this.createNodeNamed(searchClausesNode, SEARCHCLAUSE);
            searchClauseNode.appendChild(this.document.createTextNode("\n"));
            this.writeFolderSelectNode(searchClauseNode);
            this.writeFolderFromNode(searchClauseNode);
            this.writeFolderSubClassesNode(searchClauseNode);
        }
        if (this.m_customObjWhereClause != null && this.m_fromClause[2]) {
            searchClauseNode = this.createNodeNamed(searchClausesNode, SEARCHCLAUSE);
            searchClauseNode.appendChild(this.document.createTextNode("\n"));
            this.writeCustomObjSelectNode(searchClauseNode);
            this.writeCustomObjFromNode(searchClauseNode);
            this.writeCustomObjWhereNode(searchClauseNode);
            this.writeCustomObjSubClassesNode(searchClauseNode);
        } else if (this.m_fromClause[2]) {
            searchClauseNode = this.createNodeNamed(searchClausesNode, SEARCHCLAUSE);
            searchClauseNode.appendChild(this.document.createTextNode("\n"));
            this.writeCustomObjSelectNode(searchClauseNode);
            this.writeCustomObjFromNode(searchClauseNode);
            this.writeCustomObjSubClassesNode(searchClauseNode);
        }
    }

    private void writeDocumentSelectNode(Node parentNode) {
        int nodeCount = 0;
        Node selectNode = this.createNodeNamed(parentNode, SELECT);
        selectNode.appendChild(this.document.createTextNode("\n"));
        if (!(this.m_selectClause != null && this.m_selectClause.size() != 0 || this.m_searchOptions.m_docSummary)) {
            Node allNode = this.createNodeNamed(selectNode, SELECTPROPALL);
        } else {
            if (this.m_selectClause != null || this.m_selectClause.size() > 0) {
                Node selectPropsNode = null;
                for (WcmColumnHeader item : this.m_selectClause) {
                    if (item != null && item.getPropertyName() != null && item.getPropertyDescription() != null && (item.getPropertyDescription().getObjType() == 1 || item.getPropertyDescription().getObjType() == 0)) {
                        if (selectPropsNode == null) {
                            selectPropsNode = this.createNodeNamed(selectNode, SELECTPROPS);
                            selectPropsNode.appendChild(this.document.createTextNode("\n"));
                        }
                        ++nodeCount;
                        this.writeSelectPropNode(selectPropsNode, item);
                        continue;
                    }
                    if (item == null || item.getPropertyName() == null || item.getPropertyDescription() != null) continue;
                    if (selectPropsNode == null) {
                        selectPropsNode = this.createNodeNamed(selectNode, SELECTPROPS);
                        selectPropsNode.appendChild(this.document.createTextNode("\n"));
                    }
                    ++nodeCount;
                    item.setObjType(1);
                    this.writeSelectPropNode(selectPropsNode, item);
                }
            }
            if (nodeCount == 0) {
                Node allNode = this.createNodeNamed(selectNode, SELECTPROPALL);
            }
        }
    }

    private void writeFolderSelectNode(Node parentNode) {
        int nodeCount = 0;
        Node selectNode = this.createNodeNamed(parentNode, SELECT);
        selectNode.appendChild(this.document.createTextNode("\n"));
        if (!(this.m_selectClause != null && this.m_selectClause.size() != 0 || this.m_searchOptions.m_docSummary)) {
            Node allNode = this.createNodeNamed(selectNode, SELECTPROPALL);
        } else {
            if (this.m_selectClause != null || this.m_selectClause.size() > 0) {
                Node selectPropsNode = null;
                for (WcmColumnHeader item : this.m_selectClause) {
                    if (item != null && item.getPropertyName() != null && item.getPropertyDescription() != null && (item.getPropertyDescription().getObjType() == 2 || item.getPropertyDescription().getObjType() == 0)) {
                        if (selectPropsNode == null) {
                            selectPropsNode = this.createNodeNamed(selectNode, SELECTPROPS);
                            selectPropsNode.appendChild(this.document.createTextNode("\n"));
                        }
                        ++nodeCount;
                        this.writeSelectPropNode(selectPropsNode, item);
                        continue;
                    }
                    if (item == null || item.getPropertyName() == null || item.getPropertyDescription() != null) continue;
                    if (selectPropsNode == null) {
                        selectPropsNode = this.createNodeNamed(selectNode, SELECTPROPS);
                        selectPropsNode.appendChild(this.document.createTextNode("\n"));
                    }
                    ++nodeCount;
                    item.setObjType(2);
                    this.writeSelectPropNode(selectPropsNode, item);
                }
            }
            if (nodeCount == 0) {
                Node allNode = this.createNodeNamed(selectNode, SELECTPROPALL);
            }
        }
    }

    private void writeCustomObjSelectNode(Node parentNode) {
        int nodeCount = 0;
        Node selectNode = this.createNodeNamed(parentNode, SELECT);
        selectNode.appendChild(this.document.createTextNode("\n"));
        if (!(this.m_selectClause != null && this.m_selectClause.size() != 0 || this.m_searchOptions.m_docSummary)) {
            Node allNode = this.createNodeNamed(selectNode, SELECTPROPALL);
        } else {
            if (this.m_selectClause != null || this.m_selectClause.size() > 0) {
                Node selectPropsNode = null;
                for (WcmColumnHeader item : this.m_selectClause) {
                    if (item != null && item.getPropertyName() != null && item.getPropertyDescription() != null && (item.getPropertyDescription().getObjType() == 15 || item.getPropertyDescription().getObjType() == 0)) {
                        if (selectPropsNode == null) {
                            selectPropsNode = this.createNodeNamed(selectNode, SELECTPROPS);
                            selectPropsNode.appendChild(this.document.createTextNode("\n"));
                        }
                        ++nodeCount;
                        this.writeSelectPropNode(selectPropsNode, item);
                        continue;
                    }
                    if (item == null || item.getPropertyName() == null || item.getPropertyDescription() != null) continue;
                    if (selectPropsNode == null) {
                        selectPropsNode = this.createNodeNamed(selectNode, SELECTPROPS);
                        selectPropsNode.appendChild(this.document.createTextNode("\n"));
                    }
                    ++nodeCount;
                    item.setObjType(15);
                    this.writeSelectPropNode(selectPropsNode, item);
                }
            }
            if (nodeCount == 0) {
                Node allNode = this.createNodeNamed(selectNode, SELECTPROPALL);
            }
        }
    }

    private void writeSelectPropNode(Node parentNode, WcmColumnHeader item) {
        try {
            Node propNode = this.createNodeNamed(parentNode, SELECTPROP);
            int itemID = item.getItemId();
            this.setNodeAttribute(propNode, ITEMID, this.getUniqueID(new Integer(itemID)).toString());
            if (item.getPropertyDescription() == null) {
                this.setNodeAttribute(propNode, OBJECTTYPE, this.makeObjectType(item.getObjType()));
            } else {
                this.setNodeAttribute(propNode, OBJECTTYPE, this.makeObjectType(item.getPropertyDescription()));
            }
            if (item.getPropertyName() != null) {
                this.setNodeAttribute(propNode, SYMNAME, item.getPropertyName());
            }
            if (item.getPropertyLabel() != null) {
                this.setNodeAttribute(propNode, NAME, item.getPropertyLabel());
            }
            if (item.getXMLAlignment() != null) {
                this.setNodeAttribute(propNode, ALIGNMENT, item.getXMLAlignment());
            }
            if (item.getXMLOrder() != null) {
                this.setNodeAttribute(propNode, SORTORDER, item.getXMLOrder());
            }
            this.setNodeAttribute(propNode, SORTLEVEL, new Integer(item.getSortPriority()).toString());
        }
        catch (Exception e) {
            System.out.println("Error in writeSelectPropNode(): " + e.getMessage());
        }
    }

    private void writeFromNode(Node grandparent, int clauseType) {
        switch (clauseType) {
            case 0: {
                this.writeCommonFromNode(grandparent);
                break;
            }
            case 1: {
                this.writeDocumentFromNode(grandparent);
                break;
            }
            case 2: {
                this.writeFolderFromNode(grandparent);
                break;
            }
            case 3: {
                this.writeCustomObjFromNode(grandparent);
                break;
            }
            default: {
                this.writeDocumentFromNode(grandparent);
            }
        }
    }

    private void writeCommonFromNode(Node parentNode) {
        Node fromNode = this.createNodeNamed(parentNode, FROM);
        fromNode.appendChild(this.document.createTextNode("\n"));
        Node classNode = this.createNodeNamed(fromNode, CLASS);
        this.setNodeAttribute(classNode, SYMNAME, COMMON);
    }

    private void writeDocumentFromNode(Node parentNode) {
        Node fromNode = this.createNodeNamed(parentNode, FROM);
        fromNode.appendChild(this.document.createTextNode("\n"));
        Node classNode = this.createNodeNamed(fromNode, CLASS);
        this.setNodeAttribute(classNode, SYMNAME, DOCUMENT);
    }

    private void writeFolderFromNode(Node parentNode) {
        Node fromNode = this.createNodeNamed(parentNode, FROM);
        fromNode.appendChild(this.document.createTextNode("\n"));
        Node classNode = this.createNodeNamed(fromNode, CLASS);
        this.setNodeAttribute(classNode, SYMNAME, FOLDER);
    }

    private void writeCustomObjFromNode(Node parentNode) {
        Node fromNode = this.createNodeNamed(parentNode, FROM);
        fromNode.appendChild(this.document.createTextNode("\n"));
        Node classNode = this.createNodeNamed(fromNode, CLASS);
        this.setNodeAttribute(classNode, SYMNAME, CUSTOMOBJECT);
    }

    private void writeCommonWhereNode(Node parentNode) {
        if (this.m_commonWhereClause != null) {
            parentNode.appendChild(this.m_commonWhereClause);
            parentNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeDocumentWhereNode(Node parentNode) {
        if (this.m_documentWhereClause != null) {
            parentNode.appendChild(this.m_documentWhereClause);
            parentNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeFolderWhereNode(Node parentNode) {
        if (this.m_folderWhereClause != null) {
            parentNode.appendChild(this.m_folderWhereClause);
            parentNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeCustomObjWhereNode(Node parentNode) {
        if (this.m_customObjWhereClause != null) {
            parentNode.appendChild(this.m_customObjWhereClause);
            parentNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeContentNode(Node parentNode) {
        if (this.m_contentClause != null) {
            parentNode.appendChild(this.m_contentClause);
            parentNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeFoldersNode(Node parentNode) {
        if (this.m_folders != null) {
            Node foldersNode = this.createNodeNamed(parentNode, FOLDERS);
            String libName = null;
            Node folder = null;
            Node libraryNode = null;
            for (WcmSearchFolder folderItem : this.m_folders) {
                folder = this.createNodeNamed(foldersNode, FOLDER);
                if (folderItem.getId() != null) {
                    WcmXMLEncode.XmlEncodeResult encodeId = WcmXMLEncode.encodeForXml(folderItem.getId(), null);
                    this.setNodeAttribute(folder, ID, encodeId.outString);
                }
                this.setNodeAttribute(folder, PATHNAME, folderItem.getFolder());
                this.setNodeAttribute(folder, ITEMID, this.getUniqueID(new Integer(folderItem.getItemID())).toString());
                this.setNodeAttribute(folder, VIEW, folderItem.getInternalViewStr());
                this.setNodeAttribute(folder, SEARCHSUBFOLDERS, new Boolean(folderItem.getIncludeSubfolders()).toString());
                libName = folderItem.getLibraryName();
                if (libName == null || WcmString.compareIgnoreCase(libName, "") == 0) continue;
                libraryNode = this.createNodeNamed(folder, LIBRARY);
                WcmXMLEncode.XmlEncodeResult encodeLibName = WcmXMLEncode.encodeForXml(libName, null);
                this.setNodeAttribute(libraryNode, ID, encodeLibName.outString);
            }
            foldersNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeDocumentSubClassesNode(Node parentNode) {
        if (this.m_subClasses != null) {
            Node subClassesNode = this.createNodeNamed(parentNode, SUBCLASSES);
            Node subClass = null;
            for (WcmSubClass classItem : this.m_subClasses) {
                try {
                    int nObjType = -1;
                    ClassDescription sCd = classItem.getSingleClassDescription();
                    nObjType = sCd.getPropertyIntValue("InstanceType");
                    if (nObjType != 1) continue;
                    subClass = this.createNodeNamed(subClassesNode, SUBCLASS);
                    this.setNodeAttribute(subClass, ITEMID, this.getUniqueID(new Integer(classItem.getItemId())).toString());
                    this.setNodeAttribute(subClass, SYMNAME, classItem.getClassName());
                    this.setNodeAttribute(subClass, NAME, classItem.getClassLabel());
                    if (classItem.getViewStr().length() > 0) {
                        this.setNodeAttribute(subClass, EDITPROPERTY, classItem.getViewStr());
                    }
                    this.setNodeAttribute(subClass, OBJECTTYPE, DOCUMENT);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, new String(WcmResource.s_unknownObjType.toString(classItem.getClassName())));
                }
            }
            subClassesNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeFolderSubClassesNode(Node parentNode) {
        if (this.m_subClasses != null) {
            Node subClassesNode = this.createNodeNamed(parentNode, SUBCLASSES);
            Node subClass = null;
            for (WcmSubClass classItem : this.m_subClasses) {
                int nObjType = -1;
                try {
                    ClassDescription sCd = classItem.getSingleClassDescription();
                    nObjType = sCd.getPropertyIntValue("InstanceType");
                    if (nObjType != 2) continue;
                    subClass = this.createNodeNamed(subClassesNode, SUBCLASS);
                    this.setNodeAttribute(subClass, ITEMID, this.getUniqueID(new Integer(classItem.getItemId())).toString());
                    this.setNodeAttribute(subClass, SYMNAME, classItem.getClassName());
                    this.setNodeAttribute(subClass, NAME, classItem.getClassLabel());
                    if (classItem.getViewStr().length() > 0) {
                        this.setNodeAttribute(subClass, EDITPROPERTY, classItem.getViewStr());
                    }
                    this.setNodeAttribute(subClass, OBJECTTYPE, FOLDER);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, new String(WcmResource.s_unknownObjType.toString(classItem.getClassName())));
                }
            }
            subClassesNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeCustomObjSubClassesNode(Node parentNode) {
        if (this.m_subClasses != null) {
            Node subClassesNode = this.createNodeNamed(parentNode, SUBCLASSES);
            Node subClass = null;
            for (WcmSubClass classItem : this.m_subClasses) {
                int nObjType = -1;
                try {
                    ClassDescription sCd = classItem.getSingleClassDescription();
                    nObjType = sCd.getPropertyIntValue("InstanceType");
                    if (nObjType != 15) continue;
                    subClass = this.createNodeNamed(subClassesNode, SUBCLASS);
                    this.setNodeAttribute(subClass, ITEMID, this.getUniqueID(new Integer(classItem.getItemId())).toString());
                    this.setNodeAttribute(subClass, SYMNAME, classItem.getClassName());
                    this.setNodeAttribute(subClass, NAME, classItem.getClassLabel());
                    if (classItem.getViewStr().length() > 0) {
                        this.setNodeAttribute(subClass, EDITPROPERTY, classItem.getViewStr());
                    }
                    this.setNodeAttribute(subClass, OBJECTTYPE, CUSTOMOBJECT);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.m_parentFrame, new String(WcmResource.s_unknownObjType.toString(classItem.getClassName())));
                }
            }
            subClassesNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    public WcmSearchOptionsRec getSearchOptions() throws WcmException {
        this.readSearchOptions();
        return this.m_searchOptions;
    }

    public void readSearchOptions() throws WcmException {
        this.m_searchOptions = new WcmSearchOptionsRec();
        try {
            NodeList nodeList;
            String versionSelection;
            String val;
            Node node = this.getNodeNamed(this.m_topLevelNodeList, LIBRARIES);
            if (node != null) {
                val = this.getAttributeNamed(node, MERGEOPTION);
                this.m_searchOptions.m_union = WcmString.compareIgnoreCase(val, INTERSECTION) != 0;
            }
            if ((node = this.m_contentClause) != null) {
                val = this.getAttributeNamed(node, JOINTYPE);
                this.m_searchOptions.m_interGridAnd = WcmString.compareIgnoreCase(val, FULLOUTER) != 0;
                String rank = this.getAttributeNamed(node, RANK);
                this.m_searchOptions.m_rankContent = rank.length() > 0 ? new Boolean(rank) : false;
                String contentSummary = this.getAttributeNamed(node, CONTENTSUMMARY);
                this.m_searchOptions.m_docSummary = contentSummary.length() > 0 ? new Boolean(contentSummary) : false;
            }
            if ((versionSelection = this.getAttributeNamed(node = this.getNodeNamed(nodeList = this.rootNode.getChildNodes(), SEARCHSPEC), VERSIONSELECTION)).length() > 0) {
                if (WcmString.compareIgnoreCase(versionSelection, CURRENTVERSION) == 0) {
                    this.m_searchOptions.m_versionSelection = 1;
                } else if (WcmString.compareIgnoreCase(versionSelection, RELEASEDVERSION) == 0) {
                    this.m_searchOptions.m_versionSelection = 2;
                } else if (WcmString.compareIgnoreCase(versionSelection, ALLVERSIONS) == 0) {
                    this.m_searchOptions.m_versionSelection = 3;
                } else if (WcmString.compareIgnoreCase(versionSelection, NONE) == 0) {
                    this.m_searchOptions.m_versionSelection = 0;
                }
            } else {
                String allVersions = this.getAttributeNamed(node, SEARCHALLVERSIONS);
                this.m_searchOptions.m_versionSelection = allVersions.length() > 0 ? (new Boolean(allVersions).booleanValue() ? 3 : 1) : 2;
            }
            if (WcmString.compareIgnoreCase(this.getSearchType(), TEMPLATE) == 0 && (node = this.getNodeNamed(this.m_topLevelNodeList, SEARCHTYPE)) != null) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node itemNode = nodeList.item(i);
                    if (itemNode.getNodeType() != 1) continue;
                    String val2 = new String("");
                    val2 = this.getAttributeNamed(itemNode, SHOWANDORCONDITIONS);
                    this.m_searchOptions.m_showLogicalOperators = val2.length() > 0 ? new Boolean(val2) : false;
                    val2 = this.getAttributeNamed(itemNode, SHOWMAXRECORDS);
                    this.m_searchOptions.m_showMaxReturned = val2.length() > 0 ? new Boolean(val2) : false;
                    val2 = this.getAttributeNamed(itemNode, SHOWOPERATORS);
                    this.m_searchOptions.m_showOperators = val2.length() > 0 ? new Boolean(val2) : false;
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.searchOptions", "Failed to retrieve search options: {0}", (Object)e.getMessage());
        }
    }

    public Vector getLibraries() throws WcmException {
        if (this.m_libraries == null) {
            this.readLibraries();
        }
        return this.m_libraries;
    }

    public void readLibraries() throws WcmException {
        try {
            this.m_libraries = new Vector();
            Node node = this.getNodeNamed(this.m_topLevelNodeList, LIBRARIES);
            if (node != null) {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    WcmSearchLibrary lib = new WcmSearchLibrary();
                    lib.setId(this.getAttributeNamed(node, ID));
                    lib.setName(this.getAttributeNamed(node, NAME));
                    this.m_libraries.addElement(lib);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.readLibraries", "Failed to get object stores: {0}", (Object)e.getMessage());
        }
    }

    public Vector getFolders() throws WcmException {
        if (this.m_folders == null) {
            this.readFolders();
        }
        return this.m_folders;
    }

    public void readFolders() throws WcmException {
        try {
            this.m_folders = new Vector();
            Node node = null;
            NodeList nodeList = null;
            node = this.getNodeNamed(this.m_searchCriteriaNodeList, FOLDERS);
            if (node != null) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    WcmSearchFolder folder = new WcmSearchFolder();
                    folder.setId(this.getAttributeNamed(node, ID));
                    folder.setFolder(this.getAttributeNamed(node, PATHNAME));
                    folder.setItemID(new Integer(this.getAttributeNamed(node, ITEMID)));
                    String view = this.getAttributeNamed(node, VIEW);
                    if (view.length() > 0) {
                        folder.setView(view);
                    } else {
                        folder.setView(1);
                    }
                    String subFolders = this.getAttributeNamed(node, SEARCHSUBFOLDERS);
                    if (subFolders.length() > 0) {
                        folder.setIncludeSubfolders(new Boolean(subFolders));
                    } else {
                        folder.setIncludeSubfolders(false);
                    }
                    NodeList childNodeList = node.getChildNodes();
                    for (int j = 0; j < childNodeList.getLength(); ++j) {
                        Node childNode = childNodeList.item(j);
                        if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(LIBRARY)) continue;
                        folder.setLibraryName(this.getAttributeNamed(childNode, ID));
                    }
                    Node libraryNode = this.getNodeNamed(nodeList, SEARCHSPEC);
                    this.m_folders.addElement(folder);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.readFolders", "Failed to get folders: {0}", (Object)e.getMessage());
        }
    }

    public Vector getSubClasses() throws WcmException {
        if (this.m_subClasses == null) {
            this.readSearchClauses();
        }
        return this.m_subClasses;
    }

    public void readSubClasses(Node searchClause) throws WcmException {
        try {
            Node node = null;
            NodeList nodeList = null;
            node = this.getNodeNamed(searchClause.getChildNodes(), SUBCLASSES);
            if (node != null) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    WcmSubClass subClass = new WcmSubClass();
                    subClass.setItemId(new Integer(this.getAttributeNamed(node, ITEMID)));
                    subClass.setClassName(this.getAttributeNamed(node, SYMNAME));
                    subClass.setClassLabel(this.getAttributeNamed(node, NAME));
                    String view = this.getAttributeNamed(node, EDITPROPERTY);
                    if (view.length() > 0) {
                        subClass.setView(view);
                    } else {
                        subClass.setView(4);
                    }
                    this.m_subClasses.addElement(subClass);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.readSubClasses", "Failed to get subClasses: {0}", (Object)e.getMessage());
        }
    }

    public String getSearchType() {
        if (this.m_searchType == null) {
            this.readSearchType();
        }
        return this.m_searchType;
    }

    public void readSearchType() {
        this.m_searchType = new String("");
        Node node = this.getNodeNamed(this.m_topLevelNodeList, SEARCHTYPE);
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            if ((node = this.getNodeNamed(nodeList, SEARCH)) != null) {
                this.m_searchType = SEARCH;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node itemNode = nodeList.item(i);
                if (itemNode.getNodeType() != 1) continue;
                this.m_searchType = itemNode.getNodeName();
                break;
            }
        }
    }

    public String getNamespace() {
        if (this.m_namespace == null) {
            this.readNamespace();
        }
        return this.m_namespace;
    }

    public void readNamespace() {
        if (this.rootNode != null) {
            this.m_namespace = this.getAttributeNamed(this.rootNode, XMLNS);
        }
    }

    public String getVersion() {
        if (this.m_version == null) {
            this.readVersion();
        }
        return this.m_version;
    }

    public void readVersion() {
        Node node = this.getNodeNamed(this.rootNode.getChildNodes(), PRODUCT);
        if (node != null) {
            this.m_version = this.getAttributeNamed(node, VERSION);
        }
    }

    public String getMaxResults() {
        if (this.m_maxResults == null) {
            this.readMaxResults();
        }
        return this.m_maxResults;
    }

    public void readMaxResults() {
        Node node = this.getNodeNamed(this.m_topLevelNodeList, OPTIONS);
        if (node != null) {
            String maxResults = this.getAttributeNamed(node, MAXRECORDS);
            this.m_maxResults = maxResults.length() > 0 ? maxResults : DEF_MAXRESULTS;
        }
    }

    public Vector getSelectClause() throws WcmException {
        if (this.m_selectClause == null) {
            this.readSearchClauses();
        }
        return this.m_selectClause;
    }

    public void readSelectClause(Node searchClause) throws WcmException {
        String propName = new String();
        try {
            NodeList nodeList;
            Node node = this.getNodeNamed(searchClause.getChildNodes(), SELECT);
            if (node != null && (node = this.getNodeNamed(nodeList = node.getChildNodes(), SELECTPROPALL)) == null && (node = this.getNodeNamed(nodeList, SELECTPROPS)) != null) {
                NodeList propList = node.getChildNodes();
                for (int k = 0; k < propList.getLength(); ++k) {
                    WcmColumnHeader colHeader;
                    if (propList.item(k).getNodeType() != 1 || (colHeader = this.makeProperty(propList.item(k))) == null) continue;
                    this.m_selectClause.addElement(colHeader);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.readSelectClauseFailed", "Failed to get the select clause from XML: {0}", (Object)e.getMessage());
        }
    }

    public boolean[] getFromClause() {
        if (this.m_fromClause == null) {
            this.readSearchClauses();
        }
        return this.m_fromClause;
    }

    public int readFromClause(Node searchClause) {
        String fromClause = new String("");
        Node node = this.getNodeNamed(searchClause.getChildNodes(), FROM);
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            Node classNode = this.getNodeNamed(nodeList, CLASS);
            fromClause = this.getAttributeNamed(classNode, SYMNAME);
            if (WcmString.compareIgnoreCase(COMMON, fromClause) == 0) {
                return 0;
            }
            if (WcmString.compareIgnoreCase(DOCUMENT, fromClause) == 0) {
                return 1;
            }
            if (WcmString.compareIgnoreCase(FOLDER, fromClause) == 0) {
                return 2;
            }
            if (WcmString.compareIgnoreCase(CUSTOMOBJECT, fromClause) == 0) {
                return 3;
            }
        }
        return -1;
    }

    public Node getCommonWhereClause() throws WcmException {
        if (this.m_commonWhereClause == null) {
            this.readSearchClauses();
        }
        return this.m_commonWhereClause;
    }

    public Node getDocumentWhereClause() throws WcmException {
        if (this.m_documentWhereClause == null) {
            this.readSearchClauses();
        }
        return this.m_documentWhereClause;
    }

    public Node getFolderWhereClause() throws WcmException {
        if (this.m_folderWhereClause == null) {
            this.readSearchClauses();
        }
        return this.m_folderWhereClause;
    }

    public Node getCustomObjWhereClause() throws WcmException {
        if (this.m_customObjWhereClause == null) {
            this.readSearchClauses();
        }
        return this.m_customObjWhereClause;
    }

    public Node readWhereClause(Node searchClause) throws WcmException {
        try {
            Node node = this.getNodeNamed(searchClause.getChildNodes(), WHERE);
            return node;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.readWhereClauseFailed", "Failed to get the where clause from XML: {0}", (Object)e.getMessage());
        }
    }

    public Node getContentClause() throws WcmException {
        if (this.m_contentClause == null) {
            this.readSearchClauses();
        }
        return this.m_contentClause;
    }

    public void readContentClause(Node searchClause) throws WcmException {
        try {
            this.m_contentClause = this.getNodeNamed(searchClause.getChildNodes(), "veritycontent");
            if (this.m_contentClause == null) {
                this.m_contentClause = this.getNodeNamed(searchClause.getChildNodes(), CONTENT);
            }
            if (this.m_contentClause == null) {
                this.m_contentClause = this.getNodeNamed(searchClause.getChildNodes(), CONTENT);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.readContentClauseFailed", "Failed to get the content clause from XML: {0}", (Object)e.getMessage());
        }
    }

    public void setSearchOptions(WcmSearchOptionsRec options) {
        this.m_searchOptions = options;
    }

    public void setLibraries(Vector libraryList) {
        this.m_libraries = libraryList;
    }

    public void setFolders(Vector folderList) {
        this.m_folders = folderList;
    }

    public void setSearchType(String searchType) {
        this.m_searchType = searchType;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void setMaxResults(String maxResults) {
        this.m_maxResults = maxResults;
    }

    public void setSelectClause(Vector selectClause) {
        this.m_selectClause = selectClause;
    }

    public void setFromClause(boolean[] fromClause) {
        this.m_fromClause = fromClause;
    }

    public void setSubClasses(Vector subClasses) {
        this.m_subClasses = subClasses;
    }

    public void setCommonWhereClause(Node whereClause) {
        if (whereClause != null) {
            this.m_commonWhereClause = this.document.importNode(whereClause, true);
        }
    }

    public void setDocumentWhereClause(Node whereClause) {
        if (whereClause != null) {
            this.m_documentWhereClause = this.document.importNode(whereClause, true);
        }
    }

    public void setFolderWhereClause(Node whereClause) {
        if (whereClause != null) {
            this.m_folderWhereClause = this.document.importNode(whereClause, true);
        }
    }

    public void setCustomObjWhereClause(Node whereClause) {
        if (whereClause != null) {
            this.m_customObjWhereClause = this.document.importNode(whereClause, true);
        }
    }

    public void setCommonWhereClause(WcmQTree tree) {
        if (tree != null) {
            this.m_commonWhereClause = this.parseWhereClause(tree, this.m_commonWhereClause, 0);
        }
    }

    public void setDocumentWhereClause(WcmQTree tree) {
        if (tree != null) {
            this.m_documentWhereClause = this.parseWhereClause(tree, this.m_documentWhereClause, 1);
        }
    }

    public void setFolderWhereClause(WcmQTree tree) {
        if (tree != null) {
            this.m_folderWhereClause = this.parseWhereClause(tree, this.m_folderWhereClause, 2);
        }
    }

    public void setCustomObjWhereClause(WcmQTree tree) {
        if (tree != null) {
            this.m_customObjWhereClause = this.parseWhereClause(tree, this.m_customObjWhereClause, 3);
        }
    }

    public Node parseWhereClause(WcmQTree tree, Node whereClause, int clauseType) {
        try {
            Node parent = null;
            DefaultMutableTreeNode root = tree.getRoot();
            if (root.getChildCount() == 0) {
                whereClause = null;
                return null;
            }
            if (whereClause != null) {
                NodeList children = whereClause.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    whereClause.removeChild(child);
                }
                parent = whereClause.getParentNode();
                parent.removeChild(whereClause);
                whereClause = null;
            }
            whereClause = this.document.createElement(WHERE);
            whereClause.appendChild(this.document.createTextNode("\n"));
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getFirstChild();
            this.createWhereClauseFromQTree(whereClause, node, clauseType);
        }
        catch (Exception e) {
            System.out.println("Error occurred in setWhereClause(): " + e.getMessage());
        }
        return whereClause;
    }

    public void setContentClause(Node contentClause) {
        if (contentClause != null) {
            this.m_contentClause = this.document.importNode(contentClause, true);
        }
    }

    public void setContentClause(WcmQTree tree) {
        boolean isVerity = this.cbrSearchType == CBRSearchType.VERITY;
        try {
            Object parent = null;
            DefaultMutableTreeNode root = tree.getRoot();
            if (root.getChildCount() == 0) {
                this.m_contentClause = null;
                return;
            }
            if (this.m_contentClause != null) {
                NodeList children = this.m_contentClause.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    this.m_contentClause.removeChild(child);
                }
                this.m_contentClause = null;
            }
            this.m_contentClause = this.document.createElement(isVerity ? "veritycontent" : CONTENT);
            if (!isVerity) {
                this.setNodeAttribute(this.m_contentClause, "dialect", "lucene");
            }
            if (this.m_searchOptions.m_interGridAnd) {
                this.setNodeAttribute(this.m_contentClause, JOINTYPE, INNER);
            } else {
                this.setNodeAttribute(this.m_contentClause, JOINTYPE, FULLOUTER);
            }
            if (this.m_searchOptions.m_rankContent) {
                this.setNodeAttribute(this.m_contentClause, RANK, TRUE);
            } else {
                this.setNodeAttribute(this.m_contentClause, RANK, FALSE);
            }
            if (this.m_searchOptions.m_docSummary) {
                this.setNodeAttribute(this.m_contentClause, CONTENTSUMMARY, TRUE);
            } else {
                this.setNodeAttribute(this.m_contentClause, CONTENTSUMMARY, FALSE);
            }
            this.m_contentClause.appendChild(this.document.createTextNode("\n"));
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getFirstChild();
            this.createContentClauseFromQTree(this.m_contentClause, node);
        }
        catch (Exception e) {
            System.out.println("Error occurred in setContentClause(): " + e.getMessage());
        }
    }

    private void createContentClauseFromQTree(Node parent, DefaultMutableTreeNode node) throws WcmException {
        boolean isVerity = this.cbrSearchType == CBRSearchType.VERITY;
        try {
            Node newNode = null;
            WcmCondition nodeObj = (WcmCondition)node.getUserObject();
            if (WcmString.compare(nodeObj.getProperty(), "AND") == 0 && nodeObj.getView() == 0) {
                newNode = this.createNodeNamed(parent, isVerity ? "verityand" : AND);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else if (WcmString.compare(nodeObj.getProperty(), "OR") == 0 && nodeObj.getView() == 0) {
                newNode = this.createNodeNamed(parent, isVerity ? "verityor" : OR);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else {
                newNode = this.createContentCondition(parent, node);
                return;
            }
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                this.createContentClauseFromQTree(newNode, child);
                if (node.getChildCount() > 2) {
                    DefaultMutableTreeNode logicalNode = new DefaultMutableTreeNode(nodeObj);
                    for (int i = 1; i < node.getChildCount(); ++i) {
                        child = child.getNextSibling();
                        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(child.getUserObject());
                        this.addAllGrandchildren(child, newChild);
                        logicalNode.add(newChild);
                    }
                    this.createContentClauseFromQTree(newNode, logicalNode);
                } else if (node.getChildCount() == 2) {
                    child = child.getNextSibling();
                    this.createContentClauseFromQTree(newNode, child);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmXMLTransformer::createContentClauseFromQTree(): " + e.getMessage());
        }
    }

    private Node createContentCondition(Node parent, DefaultMutableTreeNode node) throws WcmException {
        Node newNode = null;
        boolean isVerity = this.cbrSearchType == CBRSearchType.VERITY;
        try {
            String zone;
            WcmCondition nodeObj = (WcmCondition)node.getUserObject();
            newNode = this.createNodeNamed(parent, isVerity ? "verityitem" : "item");
            this.setNodeAttribute(newNode, ITEMID, this.getUniqueID(new Integer(nodeObj.getID())).toString());
            String viewStr = nodeObj.getViewStr();
            if (viewStr != null && viewStr.length() > 0) {
                this.setNodeAttribute(newNode, EDITPROPERTY, nodeObj.getViewStr());
            }
            String userText = nodeObj.getProperty();
            if (isVerity) {
                Node userNode = this.createNodeNamed(newNode, "usertext");
                if (userText.length() > 0) {
                    userNode.appendChild(this.document.createTextNode(userText.trim()));
                }
            }
            String operator = nodeObj.getOperator();
            String mod = CBRSearchXMLUtil.convertToInternalModifier(nodeObj.getOperator());
            if (mod.length() > 0) {
                if (WcmString.compareIgnoreCase(mod, "All") == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, ALL);
                } else if (WcmString.compareIgnoreCase(mod, "Any") == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, ANY);
                } else if (isVerity) {
                    if (WcmString.compareIgnoreCase(mod, "None") == 0) {
                        this.setNodeAttribute(newNode, GROUPACTION, NONE);
                    } else if (WcmString.compareIgnoreCase(mod, "Near") == 0) {
                        this.setNodeAttribute(newNode, GROUPACTION, NEAR);
                    } else if (WcmString.compareIgnoreCase(mod, "Paragraph") == 0) {
                        this.setNodeAttribute(newNode, GROUPACTION, PARAGRAPH);
                    } else if (WcmString.compareIgnoreCase(mod, "Sentence") == 0) {
                        this.setNodeAttribute(newNode, GROUPACTION, SENTENCE);
                    } else if (WcmString.compareIgnoreCase(mod, "VQL") == 0) {
                        this.setNodeAttribute(newNode, GROUPACTION, VQL);
                    } else if (WcmString.compareIgnoreCase(mod, "In Zone") == 0) {
                        this.setNodeAttribute(newNode, GROUPACTION, IN);
                    }
                } else if (WcmString.compareIgnoreCase(mod, "None") == 0) {
                    CBRSearchTerm term = CBRSearchTerm.fromString((String)userText);
                    if (term.isProhibited()) {
                        this.setNodeAttribute(newNode, "requiredstate", "prohibited");
                    }
                } else if (WcmString.compareIgnoreCase(mod, "Near") == 0) {
                    this.setNodeAttribute(newNode, "searchmodifier", "proximity");
                    this.setNodeAttribute(newNode, "searchmodifierrange", String.valueOf(1024));
                }
            }
            HashMap<String, String> attributes = null;
            if (isVerity && (zone = nodeObj.getZone()) != null && zone.length() > 0) {
                attributes = new HashMap<String, String>();
                attributes.put("zoneName", zone);
                operator = "In Zone";
            }
            CBRSearchParser parser = CBRSearchXMLUtil.getCBRSearchParser(this.cbrSearchType, this.document);
            parser.parse(userText, operator, newNode, attributes);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error occurred in createContentCondition(): " + e.getMessage());
        }
        return newNode;
    }

    private void createWhereClauseFromQTree(Node parent, DefaultMutableTreeNode node, int clauseType) throws WcmException {
        try {
            Node newNode = null;
            WcmCondition nodeObj = (WcmCondition)node.getUserObject();
            if (WcmString.compareIgnoreCase(nodeObj.getProperty(), AND) == 0) {
                newNode = this.createNodeNamed(parent, AND);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else if (WcmString.compareIgnoreCase(nodeObj.getProperty(), OR) == 0) {
                newNode = this.createNodeNamed(parent, OR);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else {
                newNode = this.createWhereCondition(parent, node, clauseType);
                return;
            }
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                this.createWhereClauseFromQTree(newNode, child, clauseType);
                if (node.getChildCount() > 2) {
                    DefaultMutableTreeNode logicalNode = new DefaultMutableTreeNode(nodeObj);
                    for (int i = 1; i < node.getChildCount(); ++i) {
                        child = child.getNextSibling();
                        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(child.getUserObject());
                        this.addAllGrandchildren(child, newChild);
                        logicalNode.add(newChild);
                    }
                    this.createWhereClauseFromQTree(newNode, logicalNode, clauseType);
                } else if (node.getChildCount() == 2) {
                    child = child.getNextSibling();
                    this.createWhereClauseFromQTree(newNode, child, clauseType);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmXMLTransformer::createWhereClauseFromQTree(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void addAllGrandchildren(DefaultMutableTreeNode child, DefaultMutableTreeNode newChild) {
        try {
            if (child.getChildCount() > 0) {
                for (int j = 0; j < child.getChildCount() - 1; ++j) {
                    DefaultMutableTreeNode grandChild = (DefaultMutableTreeNode)child.getChildAt(j);
                    DefaultMutableTreeNode newGrandChild = new DefaultMutableTreeNode(grandChild.getUserObject());
                    if (grandChild.getChildCount() > 0) {
                        this.addAllGrandchildren(grandChild, newGrandChild);
                    }
                    newChild.add(newGrandChild);
                }
                DefaultMutableTreeNode grandChild = (DefaultMutableTreeNode)child.getLastChild();
                DefaultMutableTreeNode newGrandChild = new DefaultMutableTreeNode(grandChild.getUserObject());
                if (grandChild.getChildCount() > 0) {
                    this.addAllGrandchildren(grandChild, newGrandChild);
                }
                newChild.add(newGrandChild);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmXMLTransformer::addAllGrandchildren(): " + e.getMessage());
        }
    }

    private Node createWhereCondition(Node parent, DefaultMutableTreeNode node, int clauseType) throws WcmException {
        Node newNode = null;
        WcmCondition nodeObj = (WcmCondition)node.getUserObject();
        if ((nodeObj.isCommonCondition() || nodeObj.getPropDesc() == null) && clauseType != 0) {
            newNode = this.createNodeNamed(parent, COMMONPLACEHOLDER);
            return newNode;
        }
        String op = nodeObj.getOperator();
        String internalOp = null;
        if (WcmString.compareIgnoreCase(op, WcmResourceString.s_equalStr) == 0) {
            internalOp = EQ;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_notEqualStr) == 0) {
            internalOp = NEQ;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_lessThanStr) == 0) {
            internalOp = LT;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_greaterThanStr) == 0) {
            internalOp = GT;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_lessThanEqualStr) == 0) {
            internalOp = LTE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_greaterThanEqualStr) == 0) {
            internalOp = GTE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_likeStr) == 0) {
            internalOp = LIKE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_notLikeStr) == 0) {
            internalOp = NOTLIKE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_isNullStr) == 0) {
            internalOp = ISNULL;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_isNotNullStr) == 0) {
            internalOp = ISNOTNULL;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_isDefinedStr) == 0) {
            internalOp = ISNOTNULL;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_isNotDefinedStr) == 0) {
            internalOp = ISNULL;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_inStr) == 0) {
            internalOp = IN;
        } else {
            throw new WcmException("client.WcmXMLTransformer.invalidOperator", "operator is invalid: {0}", (Object)op);
        }
        newNode = this.createNodeNamed(parent, internalOp);
        newNode.appendChild(this.document.createTextNode("\n"));
        Node whereProp = this.createNodeNamed(newNode, WHEREPROP);
        if (nodeObj.getProperty().length() > 0) {
            this.setNodeAttribute(whereProp, SYMNAME, nodeObj.getProperty());
        }
        if (nodeObj.getPropertyLabel().length() > 0) {
            this.setNodeAttribute(whereProp, NAME, nodeObj.getPropertyLabel().trim());
        }
        this.setNodeAttribute(whereProp, ITEMID, this.getUniqueID(new Integer(nodeObj.getID())).toString());
        if (nodeObj.isCommonCondition()) {
            this.setNodeAttribute(whereProp, OBJECTTYPE, COMMON);
        } else {
            this.setNodeAttribute(whereProp, OBJECTTYPE, this.makeObjectType(nodeObj.getPropDesc()));
        }
        if (nodeObj.getViewStr().length() > 0) {
            this.setNodeAttribute(whereProp, EDITPROPERTY, nodeObj.getViewStr());
        }
        whereProp.appendChild(this.document.createTextNode("\n"));
        Node propDesc = this.createNodeNamed(whereProp, PROPDESC);
        if (nodeObj.getProperty().length() > 0) {
            this.setNodeAttribute(propDesc, SYMNAME, nodeObj.getProperty());
        }
        this.setNodeAttribute(propDesc, DATATYPE, this.makeDataType(nodeObj));
        this.setNodeAttribute(propDesc, HASCHOICELIST, this.getCVLInfo(nodeObj));
        String id = this.getCVLID(nodeObj);
        if (id.length() > 0) {
            this.setNodeAttribute(propDesc, CHOICEID, id);
        }
        this.setNodeAttribute(propDesc, HASMARKINGS, this.getMarkingsInfo(nodeObj));
        if (WcmString.compareIgnoreCase(internalOp, ISNULL) != 0 && WcmString.compareIgnoreCase(internalOp, ISNOTNULL) != 0) {
            String valStr = nodeObj.getValue();
            Node literal = this.createNodeNamed(newNode, LITERAL);
            if (valStr != null && valStr.length() > 0) {
                literal.appendChild(this.document.createTextNode(valStr.trim()));
            }
        }
        return newNode;
    }

    private String makeDataType(WcmCondition node) throws WcmException {
        try {
            SearchPropertyDescription vProp = null;
            vProp = node.getPropDesc().getPropertyDesc();
            if (vProp != null) {
                switch (vProp.getPropertyIntValue("DataType")) {
                    case 1: {
                        return TYPEBINARY;
                    }
                    case 2: {
                        return TYPEBOOLEAN;
                    }
                    case 3: {
                        return TYPEDATE;
                    }
                    case 4: {
                        return TYPEDOUBLE;
                    }
                    case 5: {
                        return TYPEGUID;
                    }
                    case 6: {
                        return TYPELONG;
                    }
                    case 7: {
                        return TYPEOBJECT;
                    }
                    case 8: {
                        return TYPESTRING;
                    }
                }
                return new String("");
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.getDataType", "{0}", (Object)e.getMessage());
        }
        return new String("");
    }

    private String makeObjectType(WcmWrappedPD node) throws WcmException {
        try {
            int objType = node.getObjType();
            switch (objType) {
                case 1: {
                    return DOCUMENT;
                }
                case 2: {
                    return FOLDER;
                }
                case 15: {
                    return CUSTOMOBJECT;
                }
                case 0: {
                    return COMMON;
                }
            }
            return new String("");
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.makeObjectType", "{0}", (Object)e.getMessage());
        }
    }

    private String makeObjectType(int objType) throws WcmException {
        try {
            switch (objType) {
                case 1: {
                    return DOCUMENT;
                }
                case 2: {
                    return FOLDER;
                }
                case 15: {
                    return CUSTOMOBJECT;
                }
                case 0: {
                    return COMMON;
                }
            }
            return new String("");
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.makeObjectType", "{0}", (Object)e.getMessage());
        }
    }

    private String getMarkingsInfo(WcmCondition node) throws WcmException {
        if (this.m_hasMarkingSet) {
            return TRUE;
        }
        return FALSE;
    }

    private String getCVLInfo(WcmCondition node) throws WcmException {
        try {
            SearchPropertyDescription vProp = null;
            vProp = node.getPropDesc().getPropertyDesc();
            if (vProp != null) {
                try {
                    if (vProp.getPropertyBooleanValue("HasChoices")) {
                        return TRUE;
                    }
                    return FALSE;
                }
                catch (PropertyNotFoundException e) {
                    return FALSE;
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.getCVLFailed", "{0}", (Object)e.getMessage());
        }
        return new String("");
    }

    private String getCVLID(WcmCondition node) throws WcmException {
        try {
            String id = new String("");
            SearchPropertyDescription sProp = null;
            PropertyDescription vProp = null;
            sProp = node.getPropDesc().getPropertyDesc();
            if (sProp != null) {
                String osID = sProp.getObjectStoreId();
                if (osID == null && !this.m_libraries.isEmpty()) {
                    Iterator it = this.m_libraries.iterator();
                    Object libObj = this.m_libraries.firstElement();
                    if (libObj instanceof WcmSearchLibrary) {
                        WcmSearchLibrary sLib = (WcmSearchLibrary)libObj;
                        if (sLib != null) {
                            osID = sLib.getId();
                        }
                    } else if (libObj instanceof VerboseLibrary) {
                        VerboseLibrary vLib = (VerboseLibrary)libObj;
                        if (vLib != null) {
                            osID = vLib.getId();
                        }
                    } else {
                        System.out.println("WcmXMLTransformer::writeLibraries():  Unknown object store type");
                    }
                }
                if (osID == null) {
                    this.m_hasMarkingSet = false;
                    return id;
                }
                Session sess = sProp.getSession();
                ObjectStore lib = ObjectFactory.getObjectStore((String)osID, (Session)sess);
                vProp = (PropertyDescription)lib.getObject(24, sProp.getId());
                try {
                    if (sProp.getPropertyBooleanValue("HasChoices")) {
                        ChoiceList cList = vProp.getChoices(1);
                        id = cList.getId();
                    }
                }
                catch (PropertyNotFoundException e) {
                    // empty catch block
                }
                try {
                    MarkingSet mSet = (MarkingSet)vProp.getPropertyValue("MarkingSet");
                    this.m_hasMarkingSet = mSet != null;
                }
                catch (Exception e) {
                    this.m_hasMarkingSet = false;
                }
            }
            return id;
        }
        catch (Exception e) {
            return "";
        }
    }

    private WcmColumnHeader makeProperty(Node node) throws WcmException {
        String attrib = null;
        WcmColumnHeader property = new WcmColumnHeader();
        try {
            attrib = this.getAttributeNamed(node, SYMNAME);
            if (WcmString.compareIgnoreCase(attrib, CONTENTSUMMARY) == 0) {
                this.m_foundContentSummary = true;
                return null;
            }
            if (attrib.length() != 0) {
                property.setPropertyName(attrib);
            }
            if ((attrib = this.getAttributeNamed(node, ITEMID)).length() != 0) {
                property.setItemId(new Integer(attrib));
            }
            if ((attrib = this.getAttributeNamed(node, NAME)).length() != 0) {
                property.setPropertyLabel(attrib);
            }
            if ((attrib = this.getAttributeNamed(node, ALIGNMENT)).length() != 0) {
                property.setXMLAlignment(attrib);
            } else {
                property.setXMLAlignment(LEFT);
            }
            attrib = this.getAttributeNamed(node, SORTORDER);
            this.setPropertyOrder(property, attrib);
            attrib = this.getAttributeNamed(node, SORTLEVEL);
            this.setPropertyLevel(property, attrib);
            attrib = this.getAttributeNamed(node, OBJECTTYPE);
            this.setObjectType(property, attrib);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLTransformer.makePropertyFailed", "Failed to retrieve property info from XML: {0}", (Object)e.getMessage());
        }
        return property;
    }

    private void setPropertyOrder(WcmColumnHeader prop, String attrib) throws WcmException {
        try {
            if (attrib != null && attrib.length() != 0) {
                prop.setXMLOrder(attrib);
            } else {
                prop.setXMLOrder(NONE);
            }
        }
        catch (Exception e) {
            if (this.m_parentFrame != null) {
                String msg = WcmResource.s_invalidPropertySort4.toString(prop.getPropertyLabel());
                JOptionPane.showMessageDialog(this.m_parentFrame, msg);
                try {
                    prop.setXMLOrder(NONE);
                }
                catch (Exception ex) {}
            }
            throw new WcmException("client.WcmXMLTransformer.setPropertyOrder", "Failed to retrieve property info from XML: {0}", (Object)e.getMessage());
        }
    }

    private void setObjectType(WcmColumnHeader prop, String attrib) throws WcmException {
        if (attrib != null && attrib.length() != 0) {
            if (WcmString.compareIgnoreCase(attrib, DOCUMENT) == 0) {
                prop.setObjType(1);
            } else if (WcmString.compareIgnoreCase(attrib, FOLDER) == 0) {
                prop.setObjType(2);
            } else if (WcmString.compareIgnoreCase(attrib, CUSTOMOBJECT) == 0) {
                prop.setObjType(15);
            } else if (WcmString.compareIgnoreCase(attrib, COMMON) == 0) {
                prop.setObjType(0);
            }
        }
    }

    private void setPropertyLevel(WcmColumnHeader prop, String attrib) throws WcmException {
        try {
            if (attrib != null && attrib.length() != 0) {
                prop.setSortPriority(new Integer(attrib));
            }
        }
        catch (Exception e) {
            if (this.m_parentFrame != null) {
                String msg = WcmResource.s_invalidPropertySort3.toString(prop.getPropertyLabel());
                JOptionPane.showMessageDialog(this.m_parentFrame, msg);
                prop.setSortPriority(0);
            }
            throw new WcmException("client.WcmXMLTransformer.setPropertyLevel", "Failed to retrieve property info from XML: {0}", (Object)e.getMessage());
        }
    }

    private String getAttributeNamed(Node item, String name) {
        String result = new String("");
        if (item.getNodeType() == 1) {
            NamedNodeMap al = item.getAttributes();
            for (int i = 0; i < al.getLength(); ++i) {
                if (WcmString.compareIgnoreCase(al.item(i).getNodeName(), name) != 0) continue;
                result = al.item(i).getNodeValue();
            }
        }
        return result;
    }

    private Node createNodeNamed(Node parentNode, String name) {
        Element newNode = this.document.createElement(name);
        parentNode.appendChild(newNode);
        parentNode.appendChild(this.document.createTextNode("\n"));
        return newNode;
    }

    private void setNodeAttribute(Node node, String attrName, String attrValue) {
        NamedNodeMap al = node.getAttributes();
        if (al != null) {
            Attr attrNode = this.document.createAttribute(attrName);
            attrNode.setNodeValue(attrValue);
            al.setNamedItem(attrNode);
        }
    }

    private Node getNodeNamed(NodeList nodeList, String name) {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (name.compareTo(node.getNodeName()) != 0) continue;
                return node;
            }
        }
        return null;
    }

    private String formatNode(Node n) {
        short nodeType = n.getNodeType();
        String formatted = null;
        if (nodeType == 3) {
            String nodeValue = n.getNodeValue();
            if (nodeValue.length() > 0) {
                formatted = new String("Text: '" + nodeValue + "'");
            }
        } else if (nodeType == 2) {
            formatted = new String("Attribute: " + n.getNodeName() + " = " + n.getNodeValue());
        } else if (nodeType == 1) {
            formatted = new String("Element: " + n.getNodeName());
            NamedNodeMap al = n.getAttributes();
            for (int i = 0; i < al.getLength(); ++i) {
                formatted = formatted + " [" + al.item(i).getNodeName() + "=" + al.item(i).getNodeValue() + "]";
            }
        } else {
            formatted = new String(n.getNodeName() + " (value=" + n.getNodeValue() + ") [nodeType=" + nodeType + "] ");
            switch (nodeType) {
                case 4: {
                    formatted = formatted + "CDATA_SECTION_NODE";
                    break;
                }
                case 8: {
                    formatted = formatted + "COMMENT_NODE";
                    break;
                }
                case 11: {
                    formatted = formatted + "DOCUMENT_FRAGMENT_NODE";
                    break;
                }
                case 9: {
                    formatted = formatted + "DOCUMENT_NODE";
                    break;
                }
                case 10: {
                    formatted = formatted + "DOCUMENT_TYPE_NODE";
                    break;
                }
                case 6: {
                    formatted = formatted + "ENTITY_NODE";
                    break;
                }
                case 5: {
                    formatted = formatted + "ENTITY_REFERENCE_NODE";
                    break;
                }
                case 12: {
                    formatted = formatted + "NOTATION_NODE";
                    break;
                }
                case 7: {
                    formatted = formatted + "PROCESSING_INSTRUCTION_NODE";
                }
            }
        }
        return formatted;
    }
}

