/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.ui.WcmColumnHeader;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchFolder;
import com.filenet.wcm.apps.client.search.ui.WcmSearchLibrary;
import com.filenet.wcm.apps.client.search.ui.WcmSearchOptionsRec;
import com.filenet.wcm.apps.client.search.ui.WcmSubClass;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.server.util.xml.WcmXMLUtil;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.WcmVerityParser;
import com.filenet.wcm.toolkit.util.WcmXMLEncode;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WcmXMLLegacy {
    private static final String DTD_VER = "2.0";
    private static final String SEARCHOBJ_VER = "2";
    private static final String PROD_NAME = "Search Designer";
    private static final String PROD_VER = "3.0";
    private static final String NAMESPACE = "http://filenet.com/namespaces/wcm/apps/1.0";
    private static final String DEF_MAXRESULTS = "100";
    private static final String DEF_FROMCLAUSE = "Document";
    private static final String XML_HEADER = "<?xml version=\"1.0\"?>\r\n";
    public static final String SEARCH = "search";
    public static final String TEMPLATE = "template";
    private static final String ALIGNMENT = "alignment";
    private static final String ALL = "all";
    private static final String ALLVERSIONS = "allversions";
    private static final String AND = "and";
    private static final String ANY = "any";
    private static final String BASE64 = "base64";
    private static final String CLASS = "class";
    private static final String CONTENT = "content";
    private static final String CONTENTSUMMARY = "ContentSummary";
    private static final String CURRENTVERSION = "currentversion";
    public static final String CUSTOMOBJECT = "customobject";
    private static final String DATAENCODING = "dataencoding";
    private static final String DATATYPE = "datatype";
    public static final String DOCUMENT = "document";
    private static final String DTD = "dtd";
    private static final String EDITPROPERTY = "editproperty";
    private static final String EQ = "eq";
    private static final String FALSE = "false";
    public static final String FOLDER = "folder";
    private static final String FOLDERS = "folders";
    private static final String FROM = "from";
    private static final String FULLOUTER = "fullouter";
    private static final String GROUPACTION = "groupaction";
    private static final String GT = "gt";
    private static final String GTE = "gte";
    private static final String HASCHOICELIST = "haschoices";
    private static final String ID = "id";
    private static final String INNER = "inner";
    private static final String INTERSECTION = "intersection";
    private static final String IN_ZONE = "in zone";
    private static final String ISNOTNULL = "isnotnull";
    private static final String ISNULL = "isnull";
    private static final String ITEMID = "itemid";
    private static final String JOINTYPE = "jointype";
    private static final String LEFT = "left";
    private static final String LIBRARIES = "objectstores";
    private static final String LIBRARY = "objectstore";
    private static final String LIKE = "like";
    private static final String LITERAL = "literal";
    private static final String LT = "lt";
    private static final String LTE = "lte";
    private static final String MAXRECORDS = "maxrecords";
    private static final String MERGEOPTION = "mergeoption";
    private static final String NAME = "name";
    private static final String NEAR = "near";
    private static final String NEARITEMS = "nearitems";
    private static final String NEQ = "neq";
    private static final String NONE = "none";
    private static final String NOTLIKE = "notlike";
    private static final String IN = "in";
    private static final String OPTIONS = "options";
    private static final String OR = "or";
    private static final String PARAGRAPH = "paragraph";
    private static final String PATHNAME = "pathname";
    private static final String PRODUCT = "product";
    private static final String PROPDESC = "propdesc";
    private static final String RANK = "rank";
    private static final String RELEASEDVERSION = "releasedversion";
    private static final String SEARCHALLVERSIONS = "searchallversions";
    private static final String SEARCHCLAUSES = "searchclauses";
    private static final String SEARCHOBJECT = "searchobject";
    private static final String SEARCHSPEC = "searchspec";
    private static final String SEARCHSUBFOLDERS = "searchsubfolders";
    private static final String SEARCHTYPE = "searchtype";
    private static final String SELECT = "select";
    private static final String SELECTPROP = "selectprop";
    private static final String SELECTPROPALL = "selectpropall";
    private static final String SELECTPROPS = "selectprops";
    private static final String SENTENCE = "sentence";
    private static final String SHOWANDORCONDITIONS = "showandorconditions";
    private static final String SHOWMAXRECORDS = "showmaxrecords";
    private static final String SHOWOPERATORS = "showoperators";
    private static final String SORTORDER = "sortorder";
    private static final String SORTLEVEL = "sortlevel";
    private static final String STOREDSEARCH = "storedsearch";
    private static final String SUBCLASS = "subclass";
    private static final String SUBCLASSES = "subclasses";
    private static final String SYMNAME = "symname";
    private static final String TRUE = "true";
    private static final String TYPEBINARY = "typebinary";
    private static final String TYPEBOOLEAN = "typeboolean";
    private static final String TYPEDATE = "typedate";
    private static final String TYPEDOUBLE = "typedouble";
    private static final String TYPEGUID = "typeguid";
    private static final String TYPELONG = "typelong";
    private static final String TYPEOBJECT = "typeobject";
    private static final String TYPESTRING = "typestring";
    private static final String UNION = "union";
    private static final String USERTEXT = "usertext";
    private static final String VERITY_CONTENT = "veritycontent";
    private static final String VERITY_AND = "verityand";
    private static final String VERITY_ITEM = "verityitem";
    private static final String VERITY_OR = "verityor";
    private static final String VERSION = "version";
    private static final String VERSIONSELECTION = "versionselection";
    private static final String VQL = "vql";
    private static final String WHERE = "where";
    private static final String WHEREPROP = "whereprop";
    private static final String XMLNS = "xmlns";
    private Document document = null;
    private Node rootNode = null;
    private NodeList m_topLevelNodeList = null;
    private NodeList m_searchClausesNodeList = null;
    private WcmSearchOptionsRec m_searchOptions = new WcmSearchOptionsRec();
    private Vector m_libraries = null;
    private Vector m_folders = null;
    private Vector m_subClasses = null;
    private String m_searchType = "search";
    private String m_version = "3.0";
    private String m_maxResults = "100";
    private Vector m_selectClause = null;
    private String m_fromClause = "Document";
    private Node m_whereClause = null;
    private Node m_contentClause = null;
    private String m_namespace = "http://filenet.com/namespaces/wcm/apps/1.0";
    private boolean m_foundContentSummary = false;
    private Frame m_parentFrame = null;
    private WcmVerityParser m_verityItem = null;

    public WcmXMLLegacy() {
        try {
            this.document = WcmXMLUtil.getNewDocument();
            this.m_verityItem = new WcmVerityParser(this.document, true);
            this.rewriteDocument();
            this.rootNode = this.document.getDocumentElement();
            NodeList nodeList = null;
            nodeList = this.rootNode.getChildNodes();
            Node searchSpecNode = this.getNodeNamed(nodeList, SEARCHSPEC);
            this.m_topLevelNodeList = searchSpecNode.getChildNodes();
            Node searchClausesNode = this.getNodeNamed(this.m_topLevelNodeList, SEARCHCLAUSES);
            this.m_searchClausesNodeList = searchClausesNode.getChildNodes();
            this.readAllData();
        }
        catch (Exception e) {
            System.out.println("Error in constructor: " + e.getMessage());
        }
    }

    public WcmXMLLegacy(Frame pframe) {
        try {
            this.m_parentFrame = pframe;
            this.document = WcmXMLUtil.getNewDocument();
            this.m_verityItem = new WcmVerityParser(this.document, true);
            this.rewriteDocument();
            this.rootNode = this.document.getDocumentElement();
            NodeList nodeList = null;
            nodeList = this.rootNode.getChildNodes();
            Node searchSpecNode = this.getNodeNamed(nodeList, SEARCHSPEC);
            this.m_topLevelNodeList = searchSpecNode.getChildNodes();
            Node searchClausesNode = this.getNodeNamed(this.m_topLevelNodeList, SEARCHCLAUSES);
            this.m_searchClausesNodeList = searchClausesNode.getChildNodes();
            this.readAllData();
        }
        catch (Exception e) {
            System.out.println("Error in constructor: " + e.getMessage());
        }
    }

    public WcmXMLLegacy(FileInputStream fileInputStream) throws Exception {
        this(new InputSource(fileInputStream), null);
    }

    public WcmXMLLegacy(InputStream inputStream) throws Exception {
        this(new InputSource(inputStream), null);
    }

    public WcmXMLLegacy(String inputString) throws Exception {
        this(new InputSource(new StringReader(inputString)), null);
    }

    public WcmXMLLegacy(FileInputStream fileInputStream, Frame pframe) throws Exception {
        this(new InputSource(fileInputStream), pframe);
    }

    public WcmXMLLegacy(InputStream inputStream, Frame pframe) throws Exception {
        this(new InputSource(inputStream), pframe);
    }

    public WcmXMLLegacy(String inputString, Frame pframe) throws Exception {
        this(new InputSource(new StringReader(inputString)), pframe);
    }

    public WcmXMLLegacy(InputSource inputSource, Frame pframe) throws Exception {
        this.m_parentFrame = pframe;
        this.document = WcmXMLUtil.getDocumentFromInputSource(inputSource);
        this.rootNode = this.document.getDocumentElement();
        this.m_verityItem = new WcmVerityParser(this.document, true);
        NodeList nodeList = null;
        nodeList = this.rootNode.getChildNodes();
        Node searchSpecNode = this.getNodeNamed(nodeList, SEARCHSPEC);
        this.m_topLevelNodeList = searchSpecNode.getChildNodes();
        Node searchClausesNode = this.getNodeNamed(this.m_topLevelNodeList, SEARCHCLAUSES);
        this.m_searchClausesNodeList = searchClausesNode.getChildNodes();
        this.readAllData();
    }

    public String toString() {
        try {
            StringWriter xmlStringWriter = new StringWriter();
            xmlStringWriter.write(XML_HEADER);
            WcmXMLUtil.writeXML(xmlStringWriter, (Node)this.document);
            return xmlStringWriter.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isLegacy() {
        try {
            Node dtdNode = this.getNodeNamed(this.rootNode.getChildNodes(), VERSION);
            String dtdVer = this.getAttributeNamed(dtdNode, DTD);
            if (WcmString.compareIgnoreCase(dtdVer, DTD_VER) == 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void readAllData() {
        try {
            this.readContentClause();
            this.readFolders();
            this.readFromClause();
            this.readLibraries();
            this.readMaxResults();
            this.readNamespace();
            this.readSearchOptions();
            this.readSearchType();
            this.readSelectClause();
            this.readVersion();
            this.readWhereClause();
            this.readSubClasses();
        }
        catch (Exception e) {
            System.out.println("Failed to read the XML file: " + e.getMessage());
        }
    }

    public void rewriteDocument() {
        Object attrNode = null;
        Object al = null;
        if (this.rootNode != null) {
            this.document.removeChild(this.rootNode);
        }
        this.rootNode = this.document.createElement(STOREDSEARCH);
        this.document.appendChild(this.rootNode);
        this.setNodeAttribute(this.rootNode, XMLNS, NAMESPACE);
        this.rootNode.appendChild(this.document.createTextNode("\n"));
        Node versionNode = this.createNodeNamed(this.rootNode, VERSION);
        this.setNodeAttribute(versionNode, DTD, DTD_VER);
        this.setNodeAttribute(versionNode, SEARCHOBJECT, SEARCHOBJ_VER);
        Node productNode = this.createNodeNamed(this.rootNode, PRODUCT);
        this.setNodeAttribute(productNode, NAME, PROD_NAME);
        this.setNodeAttribute(productNode, VERSION, PROD_VER);
        Node searchSpecNode = this.createNodeNamed(this.rootNode, SEARCHSPEC);
        int versionSel = this.m_searchOptions.m_versionSelection;
        if (versionSel == 0) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, NONE);
        } else if (versionSel == 1) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, CURRENTVERSION);
        } else if (versionSel == 2) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, RELEASEDVERSION);
        } else if (versionSel == 3) {
            this.setNodeAttribute(searchSpecNode, VERSIONSELECTION, ALLVERSIONS);
        }
        searchSpecNode.appendChild(this.document.createTextNode("\n"));
        this.writeSearchType(searchSpecNode);
        this.writeLibraries(searchSpecNode);
        this.writeSearchClauses(searchSpecNode);
        Node optionsNode = this.createNodeNamed(searchSpecNode, OPTIONS);
        this.setNodeAttribute(optionsNode, MAXRECORDS, this.m_maxResults);
    }

    private void writeSearchType(Node parentNode) {
        Node searchNode = null;
        Node searchTypeNode = this.createNodeNamed(parentNode, SEARCHTYPE);
        searchTypeNode.appendChild(this.document.createTextNode("\n"));
        if (WcmString.compareIgnoreCase(this.m_searchType, TEMPLATE) == 0) {
            searchNode = this.createNodeNamed(searchTypeNode, TEMPLATE);
            this.setNodeAttribute(searchNode, SHOWOPERATORS, new Boolean(this.m_searchOptions.m_showOperators).toString());
            this.setNodeAttribute(searchNode, SHOWMAXRECORDS, new Boolean(this.m_searchOptions.m_showMaxReturned).toString());
            this.setNodeAttribute(searchNode, SHOWANDORCONDITIONS, new Boolean(this.m_searchOptions.m_showLogicalOperators).toString());
        } else {
            searchNode = this.createNodeNamed(searchTypeNode, SEARCH);
        }
    }

    private void writeLibraries(Node parentNode) {
        Node libraryNode = null;
        Node librariesNode = this.createNodeNamed(parentNode, LIBRARIES);
        librariesNode.appendChild(this.document.createTextNode("\n"));
        if (this.m_searchOptions.m_union) {
            this.setNodeAttribute(librariesNode, MERGEOPTION, UNION);
        } else {
            this.setNodeAttribute(librariesNode, MERGEOPTION, INTERSECTION);
        }
        if (this.m_libraries != null) {
            for (VerboseLibrary vLib : this.m_libraries) {
                if (vLib == null) continue;
                libraryNode = this.createNodeNamed(librariesNode, LIBRARY);
                WcmXMLEncode.XmlEncodeResult encodeId = WcmXMLEncode.encodeForXml(vLib.getId(), null);
                this.setNodeAttribute(libraryNode, ID, encodeId.outString);
                WcmXMLEncode.XmlEncodeResult encodeName = WcmXMLEncode.encodeForXml(vLib.getName(), null);
                this.setNodeAttribute(libraryNode, NAME, encodeName.outString);
            }
        }
    }

    private void writeSearchClauses(Node parentNode) {
        Node searchClausesNode = this.createNodeNamed(parentNode, SEARCHCLAUSES);
        searchClausesNode.appendChild(this.document.createTextNode("\n"));
        this.writeSelectNode(searchClausesNode);
        this.writeFromNode(searchClausesNode);
        this.writeWhereNode(searchClausesNode);
        this.writeContentNode(searchClausesNode);
        this.writeFoldersNode(searchClausesNode);
        this.writeSubClassesNode(searchClausesNode);
    }

    private void writeSelectNode(Node parentNode) {
        Node selectNode = this.createNodeNamed(parentNode, SELECT);
        selectNode.appendChild(this.document.createTextNode("\n"));
        if (!(this.m_selectClause != null && this.m_selectClause.size() != 0 || this.m_searchOptions.m_docSummary)) {
            Node allNode = this.createNodeNamed(selectNode, SELECTPROPALL);
        } else {
            Node selectPropsNode = this.createNodeNamed(selectNode, SELECTPROPS);
            selectPropsNode.appendChild(this.document.createTextNode("\n"));
            if (this.m_selectClause != null || this.m_selectClause.size() > 0) {
                for (WcmColumnHeader item : this.m_selectClause) {
                    if (item == null || item.getPropertyName() == null) continue;
                    this.writeSelectPropNode(selectPropsNode, item);
                }
            }
            if (this.m_searchOptions.m_docSummary) {
                WcmColumnHeader item = new WcmColumnHeader();
                item.initializePropertyID();
                item.setPropertyName(CONTENTSUMMARY);
                item.setPropertyLabel(WcmResource.s_contentSummaryStr);
                item.setSortPriority(0);
                try {
                    item.setViewAlignment(LEFT);
                    item.setViewOrder(NONE);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.writeSelectPropNode(selectPropsNode, item);
            }
        }
    }

    private void writeSelectPropNode(Node parentNode, WcmColumnHeader item) {
        Node propNode = this.createNodeNamed(parentNode, SELECTPROP);
        int itemID = item.getItemId();
        this.setNodeAttribute(propNode, ITEMID, new Integer(itemID).toString());
        if (item.getPropertyName() != null) {
            this.setNodeAttribute(propNode, SYMNAME, item.getPropertyName());
        }
        if (item.getPropertyLabel() != null) {
            WcmXMLEncode.XmlEncodeResult result = WcmXMLEncode.encodeForXml(item.getPropertyLabel().trim(), null);
            this.setNodeAttribute(propNode, NAME, result.outString);
        }
        if (item.getXMLAlignment() != null) {
            this.setNodeAttribute(propNode, ALIGNMENT, item.getXMLAlignment());
        }
        if (item.getXMLOrder() != null) {
            this.setNodeAttribute(propNode, SORTORDER, item.getXMLOrder());
        }
        this.setNodeAttribute(propNode, SORTLEVEL, new Integer(item.getSortPriority()).toString());
    }

    private void writeDocSummaryNode(Node parentNode) {
    }

    private void writeFromNode(Node parentNode) {
        Node fromNode = this.createNodeNamed(parentNode, FROM);
        fromNode.appendChild(this.document.createTextNode("\n"));
        Node classNode = this.createNodeNamed(fromNode, CLASS);
        this.setNodeAttribute(classNode, SYMNAME, this.m_fromClause);
    }

    private void writeWhereNode(Node parentNode) {
        if (this.m_whereClause != null) {
            Node whereNode = this.createNodeNamed(parentNode, WHERE);
            whereNode.appendChild(this.document.createTextNode("\n"));
            whereNode.appendChild(this.m_whereClause);
            whereNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeContentNode(Node parentNode) {
        Node contentNode = this.createNodeNamed(parentNode, VERITY_CONTENT);
        contentNode.appendChild(this.document.createTextNode("\n"));
        if (this.m_searchOptions.m_interGridAnd) {
            this.setNodeAttribute(contentNode, JOINTYPE, INNER);
        } else {
            this.setNodeAttribute(contentNode, JOINTYPE, FULLOUTER);
        }
        if (this.m_searchOptions.m_rankContent) {
            this.setNodeAttribute(contentNode, RANK, TRUE);
        } else {
            this.setNodeAttribute(contentNode, RANK, FALSE);
        }
        if (this.m_contentClause != null) {
            contentNode.appendChild(this.m_contentClause);
            contentNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeFoldersNode(Node parentNode) {
        if (this.m_folders != null) {
            Node foldersNode = this.createNodeNamed(parentNode, FOLDERS);
            String libName = null;
            Node folder = null;
            Node libraryNode = null;
            for (WcmSearchFolder folderItem : this.m_folders) {
                folder = this.createNodeNamed(foldersNode, FOLDER);
                if (folderItem.getId() != null) {
                    WcmXMLEncode.XmlEncodeResult encodeId = WcmXMLEncode.encodeForXml(folderItem.getId(), null);
                    this.setNodeAttribute(folder, ID, encodeId.outString);
                }
                WcmXMLEncode.XmlEncodeResult encodeName = WcmXMLEncode.encodeForXml(folderItem.getFolder(), null);
                this.setNodeAttribute(folder, PATHNAME, encodeName.outString);
                this.setNodeAttribute(folder, SEARCHSUBFOLDERS, new Boolean(folderItem.getIncludeSubfolders()).toString());
                libName = folderItem.getLibraryName();
                if (libName == null || WcmString.compareIgnoreCase(libName, "") == 0) continue;
                libraryNode = this.createNodeNamed(folder, LIBRARY);
                WcmXMLEncode.XmlEncodeResult encodeLibName = WcmXMLEncode.encodeForXml(libName, null);
                this.setNodeAttribute(libraryNode, ID, encodeLibName.outString);
            }
            foldersNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    private void writeSubClassesNode(Node parentNode) {
        if (this.m_subClasses != null) {
            Node subClassesNode = this.createNodeNamed(parentNode, SUBCLASSES);
            Node subClass = null;
            for (WcmSubClass classItem : this.m_subClasses) {
                subClass = this.createNodeNamed(subClassesNode, SUBCLASS);
                this.setNodeAttribute(subClass, ITEMID, new Integer(classItem.getItemId()).toString());
                WcmXMLEncode.XmlEncodeResult encodeName = WcmXMLEncode.encodeForXml(classItem.getClassName(), null);
                this.setNodeAttribute(subClass, SYMNAME, encodeName.outString);
                WcmXMLEncode.XmlEncodeResult encodeLabel = WcmXMLEncode.encodeForXml(classItem.getClassLabel(), null);
                this.setNodeAttribute(subClass, NAME, encodeLabel.outString);
                if (classItem.getViewStr().length() <= 0) continue;
                this.setNodeAttribute(subClass, EDITPROPERTY, classItem.getViewStr());
            }
            subClassesNode.appendChild(this.document.createTextNode("\n"));
        }
    }

    public WcmSearchOptionsRec getSearchOptions() throws WcmException {
        this.readSearchOptions();
        return this.m_searchOptions;
    }

    public void readSearchOptions() throws WcmException {
        this.m_searchOptions = new WcmSearchOptionsRec();
        try {
            NodeList nodeList;
            String versionSelection;
            String val;
            Node node = this.getNodeNamed(this.m_topLevelNodeList, LIBRARIES);
            if (node != null) {
                val = this.getAttributeNamed(node, MERGEOPTION);
                this.m_searchOptions.m_union = WcmString.compareIgnoreCase(val, INTERSECTION) != 0;
            }
            if (this.m_foundContentSummary) {
                this.m_searchOptions.m_docSummary = true;
            }
            if ((node = this.getNodeNamed(this.m_searchClausesNodeList, VERITY_CONTENT)) != null) {
                val = this.getAttributeNamed(node, JOINTYPE);
                this.m_searchOptions.m_interGridAnd = WcmString.compareIgnoreCase(val, FULLOUTER) != 0;
                String rank = this.getAttributeNamed(node, RANK);
                this.m_searchOptions.m_rankContent = rank.length() > 0 ? new Boolean(rank) : false;
            }
            if ((versionSelection = this.getAttributeNamed(node = this.getNodeNamed(nodeList = this.rootNode.getChildNodes(), SEARCHSPEC), VERSIONSELECTION)).length() > 0) {
                if (WcmString.compareIgnoreCase(versionSelection, CURRENTVERSION) == 0) {
                    this.m_searchOptions.m_versionSelection = 1;
                } else if (WcmString.compareIgnoreCase(versionSelection, RELEASEDVERSION) == 0) {
                    this.m_searchOptions.m_versionSelection = 2;
                } else if (WcmString.compareIgnoreCase(versionSelection, ALLVERSIONS) == 0) {
                    this.m_searchOptions.m_versionSelection = 3;
                } else if (WcmString.compareIgnoreCase(versionSelection, NONE) == 0) {
                    this.m_searchOptions.m_versionSelection = 0;
                }
            } else {
                String allVersions = this.getAttributeNamed(node, SEARCHALLVERSIONS);
                this.m_searchOptions.m_versionSelection = allVersions.length() > 0 ? (new Boolean(allVersions).booleanValue() ? 3 : 1) : 2;
            }
            if (WcmString.compareIgnoreCase(this.getSearchType(), TEMPLATE) == 0 && (node = this.getNodeNamed(this.m_topLevelNodeList, SEARCHTYPE)) != null) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node itemNode = nodeList.item(i);
                    if (itemNode.getNodeType() != 1) continue;
                    String val2 = new String("");
                    val2 = this.getAttributeNamed(itemNode, SHOWANDORCONDITIONS);
                    this.m_searchOptions.m_showLogicalOperators = val2.length() > 0 ? new Boolean(val2) : false;
                    val2 = this.getAttributeNamed(itemNode, SHOWMAXRECORDS);
                    this.m_searchOptions.m_showMaxReturned = val2.length() > 0 ? new Boolean(val2) : false;
                    val2 = this.getAttributeNamed(itemNode, SHOWOPERATORS);
                    this.m_searchOptions.m_showOperators = val2.length() > 0 ? new Boolean(val2) : false;
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.searchOptions", "Failed to retrieve search options: {0}", (Object)e.getMessage());
        }
    }

    public Vector getLibraries() throws WcmException {
        if (this.m_libraries == null) {
            this.readLibraries();
        }
        return this.m_libraries;
    }

    public void readLibraries() throws WcmException {
        try {
            this.m_libraries = new Vector();
            Node node = this.getNodeNamed(this.m_topLevelNodeList, LIBRARIES);
            if (node != null) {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    WcmSearchLibrary lib = new WcmSearchLibrary();
                    lib.setId(this.getAttributeNamed(node, ID));
                    lib.setName(this.getAttributeNamed(node, NAME));
                    this.m_libraries.addElement(lib);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.readLibraries", "Failed to get object stores: {0}", (Object)e.getMessage());
        }
    }

    public Vector getFolders() throws WcmException {
        if (this.m_folders == null) {
            this.readFolders();
        }
        return this.m_folders;
    }

    public void readFolders() throws WcmException {
        try {
            this.m_folders = new Vector();
            Node node = null;
            NodeList nodeList = null;
            node = this.getNodeNamed(this.m_searchClausesNodeList, FOLDERS);
            if (node != null) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    WcmSearchFolder folder = new WcmSearchFolder();
                    folder.setId(this.getAttributeNamed(node, ID));
                    folder.setFolder(this.getAttributeNamed(node, PATHNAME));
                    String subFolders = this.getAttributeNamed(node, SEARCHSUBFOLDERS);
                    if (subFolders.length() > 0) {
                        folder.setIncludeSubfolders(new Boolean(subFolders));
                    } else {
                        folder.setIncludeSubfolders(false);
                    }
                    NodeList childNodeList = node.getChildNodes();
                    for (int j = 0; j < childNodeList.getLength(); ++j) {
                        Node childNode = childNodeList.item(j);
                        if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals(LIBRARY)) continue;
                        folder.setLibraryName(this.getAttributeNamed(childNode, ID));
                    }
                    Node libraryNode = this.getNodeNamed(nodeList, SEARCHSPEC);
                    this.m_folders.addElement(folder);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.readFolders", "Failed to get folders: {0}", (Object)e.getMessage());
        }
    }

    public Vector getSubClasses() throws WcmException {
        if (this.m_subClasses == null) {
            this.readSubClasses();
        }
        return this.m_subClasses;
    }

    public void readSubClasses() throws WcmException {
        try {
            this.m_subClasses = new Vector();
            Node node = null;
            NodeList nodeList = null;
            node = this.getNodeNamed(this.m_searchClausesNodeList, SUBCLASSES);
            if (node != null) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    WcmSubClass subClass = new WcmSubClass();
                    subClass.setItemId(new Integer(this.getAttributeNamed(node, ITEMID)));
                    subClass.setClassName(this.getAttributeNamed(node, SYMNAME));
                    subClass.setClassLabel(this.getAttributeNamed(node, NAME));
                    String view = this.getAttributeNamed(node, EDITPROPERTY);
                    if (view.length() > 0) {
                        subClass.setView(view);
                    } else {
                        subClass.setView(4);
                    }
                    this.m_subClasses.addElement(subClass);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.readSubClasses", "Failed to get subClasses: {0}", (Object)e.getMessage());
        }
    }

    public String getSearchType() {
        if (this.m_searchType == null) {
            this.readSearchType();
        }
        return this.m_searchType;
    }

    public void readSearchType() {
        this.m_searchType = new String("");
        Node node = this.getNodeNamed(this.m_topLevelNodeList, SEARCHTYPE);
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            if ((node = this.getNodeNamed(nodeList, SEARCH)) != null) {
                this.m_searchType = SEARCH;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node itemNode = nodeList.item(i);
                if (itemNode.getNodeType() != 1) continue;
                this.m_searchType = itemNode.getNodeName();
                break;
            }
        }
    }

    public String getNamespace() {
        if (this.m_namespace == null) {
            this.readNamespace();
        }
        return this.m_namespace;
    }

    public void readNamespace() {
        if (this.rootNode != null) {
            this.m_namespace = this.getAttributeNamed(this.rootNode, XMLNS);
        }
    }

    public String getVersion() {
        if (this.m_version == null) {
            this.readVersion();
        }
        return this.m_version;
    }

    public void readVersion() {
        Node node = this.getNodeNamed(this.rootNode.getChildNodes(), PRODUCT);
        if (node != null) {
            this.m_version = this.getAttributeNamed(node, VERSION);
        }
    }

    public String getMaxResults() {
        if (this.m_maxResults == null) {
            this.readMaxResults();
        }
        return this.m_maxResults;
    }

    public void readMaxResults() {
        Node node = this.getNodeNamed(this.m_topLevelNodeList, OPTIONS);
        if (node != null) {
            String maxResults = this.getAttributeNamed(node, MAXRECORDS);
            this.m_maxResults = maxResults.length() > 0 ? maxResults : DEF_MAXRESULTS;
        }
    }

    public Vector getSelectClause() throws WcmException {
        if (this.m_selectClause == null) {
            this.readSelectClause();
        }
        return this.m_selectClause;
    }

    public void readSelectClause() throws WcmException {
        this.m_selectClause = new Vector();
        String propName = new String();
        try {
            NodeList nodeList;
            Node node = this.getNodeNamed(this.m_searchClausesNodeList, SELECT);
            if (node != null && (node = this.getNodeNamed(nodeList = node.getChildNodes(), SELECTPROPALL)) == null && (node = this.getNodeNamed(nodeList, SELECTPROPS)) != null) {
                NodeList propList = node.getChildNodes();
                for (int k = 0; k < propList.getLength(); ++k) {
                    WcmColumnHeader colHeader;
                    if (propList.item(k).getNodeType() != 1 || (colHeader = this.makeProperty(propList.item(k))) == null) continue;
                    this.m_selectClause.addElement(colHeader);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.readSelectClauseFailed", "Failed to get the select clause from XML: {0}", (Object)e.getMessage());
        }
    }

    public String getFromClause() {
        if (this.m_fromClause == null) {
            this.readFromClause();
        }
        return this.m_fromClause;
    }

    public void readFromClause() {
        this.m_fromClause = new String("");
        Node node = this.getNodeNamed(this.m_searchClausesNodeList, FROM);
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.m_fromClause = this.m_fromClause + this.getAttributeNamed(nodeList.item(i), SYMNAME);
            }
        }
    }

    public Node getWhereClause() throws WcmException {
        if (this.m_whereClause == null) {
            this.readWhereClause();
        }
        return this.m_whereClause;
    }

    public void readWhereClause() throws WcmException {
        try {
            this.m_whereClause = this.getNodeNamed(this.m_searchClausesNodeList, WHERE);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.readWhereClauseFailed", "Failed to get the where clause from XML: {0}", (Object)e.getMessage());
        }
    }

    public Node getContentClause() throws WcmException {
        if (this.m_contentClause == null) {
            this.readContentClause();
        }
        return this.m_contentClause;
    }

    public void readContentClause() throws WcmException {
        Object node = null;
        try {
            this.m_contentClause = this.getNodeNamed(this.m_searchClausesNodeList, VERITY_CONTENT);
            if (this.m_contentClause == null) {
                this.m_contentClause = this.getNodeNamed(this.m_searchClausesNodeList, CONTENT);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.readContentClauseFailed", "Failed to get the content clause from XML: {0}", (Object)e.getMessage());
        }
    }

    public void setSearchOptions(WcmSearchOptionsRec options) {
        this.m_searchOptions = options;
    }

    public void setLibraries(Vector libraryList) {
        this.m_libraries = libraryList;
    }

    public void setFolders(Vector folderList) {
        this.m_folders = folderList;
    }

    public void setSearchType(String searchType) {
        this.m_searchType = searchType;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void setMaxResults(String maxResults) {
        this.m_maxResults = maxResults;
    }

    public void setSelectClause(Vector selectClause) {
        this.m_selectClause = selectClause;
    }

    public void setFromClause(int fromClause) {
        switch (fromClause) {
            case 1: {
                this.m_fromClause = DOCUMENT;
                break;
            }
            case 2: {
                this.m_fromClause = FOLDER;
                break;
            }
            case 15: {
                this.m_fromClause = CUSTOMOBJECT;
            }
        }
    }

    public void setSubClasses(Vector subClasses) {
        this.m_subClasses = subClasses;
    }

    public void setWhereClause(Node whereClause) {
        this.m_whereClause = whereClause;
    }

    public void setWhereClause(WcmQTree tree) {
        try {
            Node parent = null;
            DefaultMutableTreeNode root = tree.getRoot();
            if (root.getChildCount() == 0) {
                this.m_whereClause = null;
                return;
            }
            if (this.m_whereClause != null) {
                parent = this.getNodeNamed(this.m_searchClausesNodeList, WHERE);
                if (parent != null && this.m_whereClause != null) {
                    NodeList children = parent.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node child = children.item(i);
                        parent.removeChild(child);
                    }
                    this.m_whereClause = null;
                }
            } else {
                Node grandparent = this.getNodeNamed(this.m_topLevelNodeList, SEARCHCLAUSES);
                if (grandparent != null) {
                    parent = this.createNodeNamed(grandparent, WHERE);
                    parent.appendChild(this.document.createTextNode("\n"));
                }
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getFirstChild();
            this.createWhereClauseFromQTree(parent, node);
            this.readWhereClause();
        }
        catch (Exception e) {
            System.out.println("Error occurred in setWhereClause(): " + e.getMessage());
        }
    }

    public void setContentClause(Node contentClause) {
        this.m_contentClause = contentClause;
    }

    public void setContentClause(WcmQTree tree) {
        try {
            Node parent = null;
            DefaultMutableTreeNode root = tree.getRoot();
            if (root.getChildCount() == 0) {
                this.m_contentClause = null;
                return;
            }
            parent = this.getNodeNamed(this.m_searchClausesNodeList, VERITY_CONTENT);
            if (parent != null) {
                NodeList children = parent.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    parent.removeChild(child);
                }
                this.m_contentClause = null;
            } else {
                Node grandparent = this.getNodeNamed(this.m_topLevelNodeList, SEARCHCLAUSES);
                if (grandparent != null) {
                    parent = this.createNodeNamed(grandparent, VERITY_CONTENT);
                    if (this.m_searchOptions.m_interGridAnd) {
                        this.setNodeAttribute(parent, JOINTYPE, INNER);
                    } else {
                        this.setNodeAttribute(parent, JOINTYPE, FULLOUTER);
                    }
                    if (this.m_searchOptions.m_rankContent) {
                        this.setNodeAttribute(parent, RANK, TRUE);
                    } else {
                        this.setNodeAttribute(parent, RANK, FALSE);
                    }
                    parent.appendChild(this.document.createTextNode("\n"));
                }
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getFirstChild();
            this.createContentClauseFromQTree(parent, node);
            this.readContentClause();
        }
        catch (Exception e) {
            System.out.println("Error occurred in setContentClause(): " + e.getMessage());
        }
    }

    private void createContentClauseFromQTree(Node parent, DefaultMutableTreeNode node) throws WcmException {
        try {
            Node newNode = null;
            WcmCondition nodeObj = (WcmCondition)node.getUserObject();
            if (WcmString.compare(nodeObj.getProperty(), "AND") == 0 && nodeObj.getView() == 0) {
                newNode = this.createNodeNamed(parent, VERITY_AND);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else if (WcmString.compare(nodeObj.getProperty(), "OR") == 0 && nodeObj.getView() == 0) {
                newNode = this.createNodeNamed(parent, VERITY_OR);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else {
                newNode = this.createContentCondition(parent, node);
                return;
            }
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                this.createContentClauseFromQTree(newNode, child);
                if (node.getChildCount() > 2) {
                    DefaultMutableTreeNode logicalNode = new DefaultMutableTreeNode(nodeObj);
                    for (int i = 1; i < node.getChildCount(); ++i) {
                        child = child.getNextSibling();
                        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(child.getUserObject());
                        this.addAllGrandchildren(child, newChild);
                        logicalNode.add(newChild);
                    }
                    this.createContentClauseFromQTree(newNode, logicalNode);
                } else if (node.getChildCount() == 2) {
                    child = child.getNextSibling();
                    this.createContentClauseFromQTree(newNode, child);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmXMLLegacy::createContentClauseFromQTree(): " + e.getMessage());
        }
    }

    private Node createContentCondition(Node parent, DefaultMutableTreeNode node) throws WcmException {
        Node newNode = null;
        try {
            WcmCondition nodeObj = (WcmCondition)node.getUserObject();
            newNode = this.createNodeNamed(parent, VERITY_ITEM);
            this.setNodeAttribute(newNode, ITEMID, new Integer(nodeObj.getID()).toString());
            String viewStr = nodeObj.getViewStr();
            if (viewStr != null && viewStr.length() > 0) {
                this.setNodeAttribute(newNode, EDITPROPERTY, nodeObj.getViewStr());
            }
            String userText = nodeObj.getProperty();
            Node userNode = this.createNodeNamed(newNode, USERTEXT);
            if (userText.length() > 0) {
                WcmXMLEncode.XmlEncodeResult result = WcmXMLEncode.encodeForXml(userText.trim(), null);
                if (result.encoding == 1) {
                    this.setNodeAttribute(userNode, DATAENCODING, BASE64);
                }
                userNode.appendChild(this.document.createTextNode(result.outString));
            }
            Object otherItem = null;
            Object itemData = null;
            String zone = nodeObj.getZone();
            String mod = nodeObj.getOperator();
            if (mod.length() > 0) {
                if (WcmString.compareIgnoreCase(mod, WcmResource.s_verityNoneStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, NONE);
                } else if (WcmString.compareIgnoreCase(mod, WcmResource.s_allStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, ALL);
                } else if (WcmString.compareIgnoreCase(mod, WcmResource.s_anyStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, ANY);
                } else if (WcmString.compareIgnoreCase(mod, WcmResource.s_nearStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, NEAR);
                } else if (WcmString.compareIgnoreCase(mod, WcmResource.s_paragraphStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, PARAGRAPH);
                } else if (WcmString.compareIgnoreCase(mod, WcmResource.s_sentenceStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, SENTENCE);
                } else if (WcmString.compareIgnoreCase(mod, WcmResource.s_vqlStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, VQL);
                } else if (WcmString.compareIgnoreCase(mod, WcmResource.s_inZoneStr) == 0) {
                    this.setNodeAttribute(newNode, GROUPACTION, IN);
                }
            }
            HashMap<String, String> attributes = null;
            if (zone != null && zone.length() > 0) {
                attributes = new HashMap<String, String>();
                attributes.put("zoneName", zone);
                mod = WcmResource.s_inZoneStr;
            }
            this.m_verityItem.parse(nodeObj.getProperty(), mod, newNode, attributes);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error occurred in createContentCondition(): " + e.getMessage());
        }
        return newNode;
    }

    private void createWhereClauseFromQTree(Node parent, DefaultMutableTreeNode node) throws WcmException {
        try {
            Node newNode = null;
            WcmCondition nodeObj = (WcmCondition)node.getUserObject();
            if (WcmString.compareIgnoreCase(nodeObj.getProperty(), AND) == 0) {
                newNode = this.createNodeNamed(parent, AND);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else if (WcmString.compareIgnoreCase(nodeObj.getProperty(), OR) == 0) {
                newNode = this.createNodeNamed(parent, OR);
                newNode.appendChild(this.document.createTextNode("\n"));
            } else {
                newNode = this.createWhereCondition(parent, node);
                return;
            }
            if (node.getChildCount() > 0) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getFirstChild();
                this.createWhereClauseFromQTree(newNode, child);
                if (node.getChildCount() > 2) {
                    DefaultMutableTreeNode logicalNode = new DefaultMutableTreeNode(nodeObj);
                    for (int i = 1; i < node.getChildCount(); ++i) {
                        child = child.getNextSibling();
                        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(child.getUserObject());
                        this.addAllGrandchildren(child, newChild);
                        logicalNode.add(newChild);
                    }
                    this.createWhereClauseFromQTree(newNode, logicalNode);
                } else if (node.getChildCount() == 2) {
                    child = child.getNextSibling();
                    this.createWhereClauseFromQTree(newNode, child);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmXMLLegacy::createWhereClauseFromQTree(): " + e.getMessage());
        }
    }

    private void addAllGrandchildren(DefaultMutableTreeNode child, DefaultMutableTreeNode newChild) {
        try {
            if (child.getChildCount() > 0) {
                for (int j = 0; j < child.getChildCount() - 1; ++j) {
                    DefaultMutableTreeNode grandChild = (DefaultMutableTreeNode)child.getChildAt(j);
                    DefaultMutableTreeNode newGrandChild = new DefaultMutableTreeNode(grandChild.getUserObject());
                    if (grandChild.getChildCount() > 0) {
                        this.addAllGrandchildren(grandChild, newGrandChild);
                    }
                    newChild.add(newGrandChild);
                }
                DefaultMutableTreeNode grandChild = (DefaultMutableTreeNode)child.getLastChild();
                DefaultMutableTreeNode newGrandChild = new DefaultMutableTreeNode(grandChild.getUserObject());
                if (grandChild.getChildCount() > 0) {
                    this.addAllGrandchildren(grandChild, newGrandChild);
                }
                newChild.add(newGrandChild);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmXMLLegacy::addAllGrandchildren(): " + e.getMessage());
        }
    }

    private Node createWhereCondition(Node parent, DefaultMutableTreeNode node) throws WcmException {
        Node newNode = null;
        WcmCondition nodeObj = (WcmCondition)node.getUserObject();
        String op = nodeObj.getOperator();
        String internalOp = null;
        if (WcmString.compareIgnoreCase(op, WcmResourceString.s_equalStr) == 0) {
            internalOp = EQ;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_notEqualStr) == 0) {
            internalOp = NEQ;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_lessThanStr) == 0) {
            internalOp = LT;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_greaterThanStr) == 0) {
            internalOp = GT;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_lessThanEqualStr) == 0) {
            internalOp = LTE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_greaterThanEqualStr) == 0) {
            internalOp = GTE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_likeStr) == 0) {
            internalOp = LIKE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_notLikeStr) == 0) {
            internalOp = NOTLIKE;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_isNullStr) == 0) {
            internalOp = ISNULL;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_isNotNullStr) == 0) {
            internalOp = ISNOTNULL;
        } else if (WcmString.compareIgnoreCase(op, WcmResourceString.s_inStr) == 0) {
            internalOp = IN;
        } else {
            throw new WcmException("client.WcmXMLLegacy.invalidOperator", "operator is invalid: {0}", (Object)op);
        }
        newNode = this.createNodeNamed(parent, internalOp);
        newNode.appendChild(this.document.createTextNode("\n"));
        Node whereProp = this.createNodeNamed(newNode, WHEREPROP);
        if (nodeObj.getProperty().length() > 0) {
            this.setNodeAttribute(whereProp, SYMNAME, nodeObj.getProperty());
        }
        if (nodeObj.getPropertyLabel().length() > 0) {
            WcmXMLEncode.XmlEncodeResult result = WcmXMLEncode.encodeForXml(nodeObj.getPropertyLabel().trim(), null);
            this.setNodeAttribute(whereProp, NAME, result.outString);
        }
        this.setNodeAttribute(whereProp, ITEMID, new Integer(nodeObj.getID()).toString());
        if (nodeObj.getViewStr().length() > 0) {
            this.setNodeAttribute(whereProp, EDITPROPERTY, nodeObj.getViewStr());
        }
        whereProp.appendChild(this.document.createTextNode("\n"));
        Node propDesc = this.createNodeNamed(whereProp, PROPDESC);
        if (nodeObj.getProperty().length() > 0) {
            this.setNodeAttribute(propDesc, SYMNAME, nodeObj.getProperty());
        }
        this.setNodeAttribute(propDesc, DATATYPE, this.makeDataType(nodeObj));
        this.setNodeAttribute(propDesc, HASCHOICELIST, this.getCVLInfo(nodeObj));
        if (WcmString.compareIgnoreCase(internalOp, ISNULL) != 0 && WcmString.compareIgnoreCase(internalOp, ISNOTNULL) != 0) {
            String valStr = nodeObj.getValue();
            Node literal = this.createNodeNamed(newNode, LITERAL);
            if (valStr != null && valStr.length() > 0) {
                WcmXMLEncode.XmlEncodeResult result = WcmXMLEncode.encodeForXml(valStr.trim(), null);
                if (result.encoding == 1) {
                    this.setNodeAttribute(literal, DATAENCODING, BASE64);
                }
                literal.appendChild(this.document.createTextNode(result.outString));
            }
        }
        return newNode;
    }

    private String makeDataType(WcmCondition node) throws WcmException {
        try {
            SearchPropertyDescription vProp = null;
            vProp = node.getPropDesc().getPropertyDesc();
            if (vProp != null) {
                switch (vProp.getPropertyIntValue("DataType")) {
                    case 1: {
                        return TYPEBINARY;
                    }
                    case 2: {
                        return TYPEBOOLEAN;
                    }
                    case 3: {
                        return TYPEDATE;
                    }
                    case 4: {
                        return TYPEDOUBLE;
                    }
                    case 5: {
                        return TYPEGUID;
                    }
                    case 6: {
                        return TYPELONG;
                    }
                    case 7: {
                        return TYPEOBJECT;
                    }
                    case 8: {
                        return TYPESTRING;
                    }
                }
                return new String("");
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.getDataType", "{0}", (Object)e.getMessage());
        }
        return new String("");
    }

    private String getCVLInfo(WcmCondition node) throws WcmException {
        try {
            SearchPropertyDescription vProp = null;
            vProp = node.getPropDesc().getPropertyDesc();
            if (vProp != null) {
                try {
                    if (vProp.getPropertyBooleanValue("HasChoices")) {
                        return TRUE;
                    }
                    return FALSE;
                }
                catch (PropertyNotFoundException e) {
                    return FALSE;
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.getCVLFailed", "{0}", (Object)e.getMessage());
        }
        return new String("");
    }

    private WcmColumnHeader makeProperty(Node node) throws WcmException {
        String attrib = null;
        WcmColumnHeader property = new WcmColumnHeader();
        try {
            attrib = this.getAttributeNamed(node, SYMNAME);
            if (WcmString.compareIgnoreCase(attrib, CONTENTSUMMARY) == 0) {
                this.m_foundContentSummary = true;
                return null;
            }
            if (attrib.length() != 0) {
                property.setPropertyName(attrib);
            }
            if ((attrib = this.getAttributeNamed(node, ITEMID)).length() != 0) {
                property.setItemId(new Integer(attrib));
            }
            if ((attrib = this.getAttributeNamed(node, NAME)).length() != 0) {
                property.setPropertyLabel(attrib);
            }
            if ((attrib = this.getAttributeNamed(node, ALIGNMENT)).length() != 0) {
                property.setXMLAlignment(attrib);
            } else {
                property.setXMLAlignment(LEFT);
            }
            attrib = this.getAttributeNamed(node, SORTORDER);
            this.setPropertyOrder(property, attrib);
            attrib = this.getAttributeNamed(node, SORTLEVEL);
            this.setPropertyLevel(property, attrib);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmXMLLegacy.makePropertyFailed", "Failed to retrieve property info from XML: {0}", (Object)e.getMessage());
        }
        return property;
    }

    private void setPropertyOrder(WcmColumnHeader prop, String attrib) throws WcmException {
        try {
            if (attrib != null && attrib.length() != 0) {
                prop.setXMLOrder(attrib);
            } else {
                prop.setXMLOrder(NONE);
            }
        }
        catch (Exception e) {
            if (this.m_parentFrame != null) {
                String msg = WcmResource.s_invalidPropertySort4.toString(prop.getPropertyLabel());
                JOptionPane.showMessageDialog(this.m_parentFrame, msg);
                try {
                    prop.setXMLOrder(NONE);
                }
                catch (Exception ex) {}
            }
            throw new WcmException("client.WcmXMLLegacy.setPropertyOrder", "Failed to retrieve property info from XML: {0}", (Object)e.getMessage());
        }
    }

    private void setPropertyLevel(WcmColumnHeader prop, String attrib) throws WcmException {
        try {
            if (attrib != null && attrib.length() != 0) {
                prop.setSortPriority(new Integer(attrib));
            }
        }
        catch (Exception e) {
            if (this.m_parentFrame != null) {
                String msg = WcmResource.s_invalidPropertySort3.toString(prop.getPropertyLabel());
                JOptionPane.showMessageDialog(this.m_parentFrame, msg);
                prop.setSortPriority(0);
            }
            throw new WcmException("client.WcmXMLLegacy.setPropertyLevel", "Failed to retrieve property info from XML: {0}", (Object)e.getMessage());
        }
    }

    private String getAttributeNamed(Node item, String name) {
        String result = new String("");
        if (item.getNodeType() == 1) {
            NamedNodeMap al = item.getAttributes();
            for (int i = 0; i < al.getLength(); ++i) {
                if (WcmString.compareIgnoreCase(al.item(i).getNodeName(), name) != 0) continue;
                result = al.item(i).getNodeValue();
            }
        }
        return result;
    }

    private Node createNodeNamed(Node parentNode, String name) {
        Element newNode = this.document.createElement(name);
        parentNode.appendChild(newNode);
        parentNode.appendChild(this.document.createTextNode("\n"));
        return newNode;
    }

    private void setNodeAttribute(Node node, String attrName, String attrValue) {
        NamedNodeMap al = node.getAttributes();
        if (al != null) {
            Attr attrNode = this.document.createAttribute(attrName);
            attrNode.setNodeValue(attrValue);
            al.setNamedItem(attrNode);
        }
    }

    private Node getNodeNamed(NodeList nodeList, String name) {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (name.compareTo(node.getNodeName()) != 0) continue;
                return node;
            }
        }
        return null;
    }

    private String formatNode(Node n) {
        short nodeType = n.getNodeType();
        String formatted = null;
        if (nodeType == 3) {
            String nodeValue = n.getNodeValue();
            if (nodeValue.length() > 0) {
                formatted = new String("Text: '" + nodeValue + "'");
            }
        } else if (nodeType == 2) {
            formatted = new String("Attribute: " + n.getNodeName() + " = " + n.getNodeValue());
        } else if (nodeType == 1) {
            formatted = new String("Element: " + n.getNodeName());
            NamedNodeMap al = n.getAttributes();
            for (int i = 0; i < al.getLength(); ++i) {
                formatted = formatted + " [" + al.item(i).getNodeName() + "=" + al.item(i).getNodeValue() + "]";
            }
        } else {
            formatted = new String(n.getNodeName() + " (value=" + n.getNodeValue() + ") [nodeType=" + nodeType + "] ");
            switch (nodeType) {
                case 4: {
                    formatted = formatted + "CDATA_SECTION_NODE";
                    break;
                }
                case 8: {
                    formatted = formatted + "COMMENT_NODE";
                    break;
                }
                case 11: {
                    formatted = formatted + "DOCUMENT_FRAGMENT_NODE";
                    break;
                }
                case 9: {
                    formatted = formatted + "DOCUMENT_NODE";
                    break;
                }
                case 10: {
                    formatted = formatted + "DOCUMENT_TYPE_NODE";
                    break;
                }
                case 6: {
                    formatted = formatted + "ENTITY_NODE";
                    break;
                }
                case 5: {
                    formatted = formatted + "ENTITY_REFERENCE_NODE";
                    break;
                }
                case 12: {
                    formatted = formatted + "NOTATION_NODE";
                    break;
                }
                case 7: {
                    formatted = formatted + "PROCESSING_INSTRUCTION_NODE";
                }
            }
        }
        return formatted;
    }

    public void changeData() {
        WcmSearchOptionsRec options = new WcmSearchOptionsRec();
        options.m_union = false;
        options.m_interGridAnd = false;
        options.m_showLogicalOperators = false;
        options.m_showMaxReturned = false;
        options.m_showOperators = false;
        this.setSearchOptions(options);
        System.out.println("Testing setLibraries()...");
        Vector<String> libraries = new Vector<String>();
        libraries.addElement(new String("lib1"));
        libraries.addElement(new String("lib2"));
        this.setLibraries(libraries);
    }

    public static void testWriting(String filename) throws Exception {
        System.out.println("=========================================");
        System.out.println("Testing reading a stored search...");
        WcmXMLLegacy myXML = WcmXMLLegacy.testReading(filename);
        System.out.println("=========================================");
        System.out.println("Testing setting the where clause...");
        WcmQTree myPropTree = new WcmQTree(myXML.getWhereClause());
        myPropTree.printTree();
        myXML.setWhereClause(myPropTree);
        System.out.println("=========================================");
        System.out.println("Testing setting the content clause...");
        WcmQTree myContentsTree = new WcmQTree(myXML.getContentClause());
        myContentsTree.printTree();
        myXML.setContentClause(myContentsTree);
        System.out.println("=========================================");
        System.out.println("Printing the new stored search...");
        System.out.println(myXML);
    }

    public static void testWritingFromEmptyXML() throws Exception {
        WcmXMLLegacy myXML = new WcmXMLLegacy();
        System.out.println("=========================================");
        System.out.println("Testing setting the where clause...");
        WcmQTree myPropTree = new WcmQTree();
        myPropTree.populateTreeWithTestData();
        myPropTree.printTree();
        myXML.setWhereClause(myPropTree);
        System.out.println("=========================================");
        System.out.println("Testing setting the content clause...");
        WcmQTree myContentsTree = new WcmQTree();
        myContentsTree.populateTreeWithContentTestData();
        myContentsTree.printTree();
        myXML.setContentClause(myContentsTree);
        System.out.println("=========================================");
        System.out.println("Printing the new stored search...");
        System.out.println(myXML);
    }

    public static WcmXMLLegacy testReading(String filename) throws WcmException {
        Vector libraries = null;
        Vector result = null;
        Iterator it = null;
        try {
            FileInputStream file = new FileInputStream(filename);
            WcmXMLLegacy myXML = new WcmXMLLegacy(file);
            System.out.println("Printing the document...");
            System.out.println(myXML);
            System.out.println("=========================================");
            System.out.println("Version = " + myXML.getVersion());
            System.out.println("Search type: " + myXML.getSearchType());
            WcmSearchOptionsRec options = myXML.getSearchOptions();
            System.out.println("Search options rec: " + options);
            System.out.println("Libraries...");
            libraries = myXML.getLibraries();
            for (Object item : libraries) {
                System.out.println("-->" + item);
            }
            System.out.println("Folders...");
            result = myXML.getFolders();
            for (Object item : result) {
                System.out.println("-->" + item);
            }
            System.out.println("Select clause ...");
            result = myXML.getSelectClause();
            for (Object item : result) {
                System.out.println("-->" + item);
            }
            System.out.println("Max results = " + myXML.getMaxResults());
            System.out.println("From clause = " + myXML.getFromClause());
            System.out.println("Where clause: " + myXML.formatNode(myXML.getWhereClause()));
            System.out.println("Content clause: " + myXML.formatNode(myXML.getContentClause()));
            return myXML;
        }
        catch (Exception e) {
            System.out.println("Exception thrown in WcmXMLLegacy testReading(): " + e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            String filename = args[0];
            try {
                WcmXMLLegacy.testReading(filename);
                System.out.println("Done...");
            }
            catch (Exception e) {
                System.out.println("Exception thrown in WcmXMLLegacy main(): " + e.getMessage());
            }
        } else {
            WcmXMLLegacy.testWritingFromEmptyXML();
            System.out.println("Done...");
        }
    }
}

