/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.BaseRuntimeException;
import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.impl.BaseObjectImpl;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import filenet.vw.toolkit.utils.datatransfer.IVWCBData;
import java.awt.datatransfer.DataFlavor;

public class WcmSubClass
implements IVWCBData {
    public static final DataFlavor SUBCLASS_DATAFLAVOR = new DataFlavor(WcmSubClass.class, "Subclass");
    public static final int VIEW_UNINITIALIZED = 0;
    public static final int VIEW_REQUIRED = 1;
    public static final int VIEW_EDITABLE = 2;
    public static final int VIEW_READONLY = 3;
    public static final int VIEW_HIDDEN = 4;
    private static final String VIEW_UNINITIALIZED_STRING = "Uninitialized";
    private static final String VIEW_REQUIRED_STRING = new String(WcmResource.s_requiredStr);
    private static final String VIEW_EDITABLE_STRING = new String(WcmResource.s_editableStr);
    private static final String VIEW_READONLY_STRING = new String(WcmResource.s_readOnlyStr);
    private static final String VIEW_HIDDEN_STRING = new String(WcmResource.s_hiddenStr);
    private static final String XML_REQUIRED_STRING = "required";
    private static final String XML_EDITABLE_STRING = "editable";
    private static final String XML_READONLY_STRING = "readonly";
    private static final String XML_HIDDEN_STRING = "hidden";
    private int m_itemId = 0;
    private int m_view = 4;
    private String m_className = null;
    private ClassDescription m_classDesc = null;
    private ClassDescription m_singleClassDesc = null;
    private String m_classLabel = null;
    private boolean m_includeSubClasses = false;
    private static int m_idCounter = 0;

    public WcmSubClass() {
    }

    public WcmSubClass(ClassDescription classDesc) throws WcmException {
        try {
            this.m_classDesc = classDesc;
            this.m_className = this.m_classDesc.getName();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSubClass.constructor1", "Error occurred constructing WcmSubClass with a ClassDescription {0}", (Object)e.getMessage());
        }
    }

    public WcmSubClass(WcmSubClass otherSubClass) {
        this.m_view = otherSubClass.m_view;
        this.m_classDesc = otherSubClass.m_classDesc;
        this.m_singleClassDesc = otherSubClass.m_singleClassDesc;
        this.m_className = otherSubClass.m_className;
        this.m_classLabel = otherSubClass.m_classLabel;
        this.m_itemId = otherSubClass.m_itemId;
        this.m_includeSubClasses = otherSubClass.m_includeSubClasses;
    }

    public void initializePropertyID() {
        this.m_itemId = ++m_idCounter;
    }

    public int getItemId() {
        return this.m_itemId;
    }

    public void setItemId(int id) {
        this.m_itemId = id;
    }

    public int getView() {
        return this.m_view;
    }

    public void setView(int newView) throws WcmException {
        if (newView != 2 && newView != 3 && newView != 4) {
            throw new WcmException("client.WcmSubClass.invalidView", "\"{0}\" is not a valid view", (Object)this.getViewString(newView));
        }
        this.m_view = newView;
    }

    public void setView(String newView) throws WcmException {
        if (WcmString.compareIgnoreCase(newView, VIEW_EDITABLE_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_EDITABLE_STRING) == 0) {
            this.m_view = 2;
        } else if (WcmString.compareIgnoreCase(newView, VIEW_READONLY_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_READONLY_STRING) == 0) {
            this.m_view = 3;
        } else if (WcmString.compareIgnoreCase(newView, VIEW_HIDDEN_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_HIDDEN_STRING) == 0) {
            this.m_view = 4;
        } else {
            throw new WcmException("client.WcmSubClass.invalidView", "\"{0}\" is not a valid view", (Object)newView);
        }
    }

    public String getViewString(int view) {
        switch (view) {
            case 2: {
                return XML_EDITABLE_STRING;
            }
            case 3: {
                return XML_READONLY_STRING;
            }
            case 4: {
                return XML_HIDDEN_STRING;
            }
        }
        return VIEW_UNINITIALIZED_STRING;
    }

    public String getDisplayableViewStr() {
        switch (this.m_view) {
            case 2: {
                return VIEW_EDITABLE_STRING;
            }
            case 3: {
                return VIEW_READONLY_STRING;
            }
            case 4: {
                return VIEW_HIDDEN_STRING;
            }
        }
        return new String("");
    }

    public String getViewStr() {
        return this.getViewString(this.m_view);
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String name) {
        this.m_className = name;
    }

    public ClassDescription getClassDescription() {
        return this.m_classDesc;
    }

    public void setClassDescription(ClassDescription classDesc) {
        this.m_classDesc = classDesc;
        this.m_className = this.m_classDesc.getName();
    }

    public String getClassLabel() {
        return this.m_classLabel;
    }

    public void setClassLabel(String label) {
        this.m_classLabel = label;
    }

    public boolean getIncludeSubClasses() {
        return this.m_includeSubClasses;
    }

    public void setIncludeSubClasses(boolean include) {
        this.m_includeSubClasses = include;
    }

    public ClassDescription getSingleClassDescription() {
        if (this.m_singleClassDesc == null) {
            this.m_singleClassDesc = WcmSubClass.getSingleOSCDfromMultiOSCD(this.m_classDesc);
        }
        return this.m_singleClassDesc;
    }

    public static ClassDescription getSingleOSCDfromMultiOSCD(ClassDescription mCd) {
        if (mCd == null) {
            return null;
        }
        ClassDescription sCd = mCd;
        ObjectStores oss = ((BaseObjectImpl)mCd).getSearchObjectStores();
        if (oss != null && oss.size() > 1) {
            String cdId = mCd.getId();
            for (ObjectStore sOs : oss) {
                sCd = (ClassDescription)sOs.getObject(25, cdId);
                try {
                    sCd.getPropertyIntValue("InstanceType");
                    break;
                }
                catch (Exception e1) {
                    String cdName;
                    try {
                        cdName = mCd.getPropertyStringValue("SymbolicName");
                    }
                    catch (PropertyNotFoundException pnfe) {
                        throw new BaseRuntimeException("No symbolic name for class " + cdId);
                    }
                    sCd = (ClassDescription)sOs.getObject(25, cdName);
                    try {
                        sCd.getPropertyIntValue("InstanceType");
                        break;
                    }
                    catch (Exception e2) {
                    }
                }
            }
        }
        return sCd;
    }

    public boolean isEmpty() {
        return !(this.m_className != null && this.m_className.length() != 0 || this.m_classDesc != null || this.m_className != null && this.m_classLabel.length() != 0);
    }

    public String toString() {
        String tempStr = new String();
        tempStr = new Integer(this.m_itemId).toString() + ";";
        tempStr = tempStr + this.getViewString(this.m_view) + ";";
        tempStr = tempStr + this.m_className + ";";
        tempStr = tempStr + this.m_classLabel + ";";
        tempStr = tempStr + this.m_includeSubClasses;
        return tempStr;
    }

    public void setContent(String content) {
        try {
            if (content.length() == 0) {
                return;
            }
            String itemId = this.getNextParam(content);
            if (WcmString.compareIgnoreCase(itemId, "null") == 0) {
                this.initializePropertyID();
            } else {
                this.m_itemId = new Integer(itemId);
            }
            content = this.removeParam(content, itemId);
            String view = this.getNextParam(content);
            if (view != null) {
                this.setView(view);
            }
            content = this.removeParam(content, view);
            this.m_className = this.getNextParam(content);
            content = this.removeParam(content, this.m_className);
            this.m_classLabel = this.getNextParam(content);
            content = this.removeParam(content, this.m_classLabel);
            Boolean subClasses = new Boolean(this.getNextParam(content));
            this.m_includeSubClasses = subClasses;
            content = this.removeParam(content, subClasses.toString());
        }
        catch (Exception e) {
            System.out.println("Caught error in setContent(): " + e.getMessage());
        }
    }

    private String getNextParam(String buf) {
        int semiColonLoc = 0;
        semiColonLoc = buf.indexOf(";");
        if (semiColonLoc == -1) {
            return buf;
        }
        return buf.substring(0, semiColonLoc);
    }

    private String removeParam(String buf, String param) {
        if (buf == null) {
            return null;
        }
        if (WcmString.compareIgnoreCase(buf, param) == 0) {
            return null;
        }
        int len = param.length();
        if (len == -1) {
            return buf;
        }
        return buf.substring(len + 1, buf.length());
    }

    public String getContent() {
        return this.toString();
    }

    public DataFlavor getDataFlavor() {
        return SUBCLASS_DATAFLAVOR;
    }
}

