/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.StoredSearch;
import com.filenet.wcm.api.TransportInputStream;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.server.util.prefs.WcmObjectStorePrefs;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.Frame;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class WcmStoredSearch {
    public static final int READ_ONLY_COPY = 0;
    public static final int CHECKED_OUT = 1;
    public static final int CHECKED_OUT_NO_CANCEL = 2;
    private StoredSearch m_storedSearch = null;
    private int m_currentState = 0;
    private String m_name = null;
    private boolean m_isReserved = false;
    private boolean m_isReservation = false;
    private boolean m_isCurrentVersion = false;
    private StoredSearch m_reservation = null;
    private WcmDlgItem m_dlgItem = null;
    private String m_libName;
    private Frame m_parentFrame = null;
    private String m_userName = null;
    private boolean m_resvHasContent = false;
    private WcmObjectStorePrefs m_objStorePrefs;

    public WcmStoredSearch() {
    }

    public WcmStoredSearch(StoredSearch search, String libName, Frame parentFrame, WcmObjectStorePrefs objStorePrefs) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_libName = libName;
            this.m_objStorePrefs = objStorePrefs;
            this.initialize(search);
        }
        catch (Exception e) {
            System.out.println("Error occurred in initialize(): " + e.getMessage());
        }
    }

    public void initialize(StoredSearch search) throws WcmException {
        this.clear();
        this.m_storedSearch = search;
        this.loadProps();
    }

    public void setSearch(StoredSearch search) throws WcmException {
        this.initialize(search);
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public void setReservationObj(StoredSearch resvObj) throws WcmException {
        this.m_reservation = resvObj;
        this.getReservation();
        try {
            TransportInputStream stream = this.m_reservation.getContent();
            this.m_resvHasContent = true;
        }
        catch (Exception e) {
            this.m_resvHasContent = false;
        }
    }

    public void refreshDlgItem() throws WcmException {
        this.m_dlgItem.getParent().clearContents();
    }

    public String getName() {
        if (this.m_dlgItem != null) {
            return this.m_dlgItem.getLabel();
        }
        return this.m_name;
    }

    public boolean getIsReserved() {
        return this.m_isReserved;
    }

    public StoredSearch getSearch() {
        return this.m_storedSearch;
    }

    public int getCurrentState() {
        return this.m_currentState;
    }

    public void setDlgItem(WcmDlgItem item) {
        this.m_dlgItem = item;
    }

    public boolean doesResvHaveContent() {
        return this.m_resvHasContent;
    }

    public boolean getIsCurrentVersion() {
        return this.m_isCurrentVersion;
    }

    public boolean getIsReservation() {
        return this.m_isReservation;
    }

    public String getId() {
        if (this.m_resvHasContent) {
            return this.m_reservation.getId();
        }
        return this.m_storedSearch.getId();
    }

    public TransportInputStream getContent() throws WcmException {
        try {
            if (this.m_resvHasContent) {
                return this.m_reservation.getContent();
            }
            return this.m_storedSearch.getContent();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmStoredSearch.getContentFailed", "Failed to get content; {0}", (Object)e.getMessage());
        }
    }

    public StoredSearch getReservation() throws WcmException {
        if (this.m_reservation != null) {
            return this.m_reservation;
        }
        this.m_reservation = (StoredSearch)this.m_storedSearch.getReservation();
        if (this.m_reservation != null) {
            try {
                int asMask = this.m_reservation.getAccessMask();
                if ((asMask & 2) != 0 && (asMask & 4) != 0) {
                    this.m_currentState = 1;
                }
                try {
                    TransportInputStream stream = this.m_reservation.getContent();
                    this.m_resvHasContent = true;
                }
                catch (Exception e) {
                    this.m_resvHasContent = false;
                }
            }
            catch (Exception e) {
                System.out.println("WcmStoredSearch.getReservation:");
                System.out.println("Unable to get security info Error: " + e.getMessage());
                System.out.println("Search will be treated as read only");
            }
        }
        return this.m_reservation;
    }

    public String getObjectStoreName() {
        return this.m_libName;
    }

    private void clear() {
        this.m_name = null;
        this.m_isReserved = false;
        this.m_isReservation = false;
        this.m_isCurrentVersion = false;
        this.m_reservation = null;
        this.m_resvHasContent = false;
    }

    private void loadProps() throws WcmException {
        try {
            Properties propList = null;
            propList = this.m_storedSearch.getProperties(new String[]{"DocumentTitle", "IsReserved", "VersionStatus", "IsCurrentVersion"});
            Iterator it = propList.iterator();
            Boolean isReservedBool = null;
            Boolean isReservationBool = null;
            Boolean isCurrentVersionBool = null;
            while (it.hasNext()) {
                Property tempProp = (Property)it.next();
                if (tempProp.getName().compareToIgnoreCase("DocumentTitle") == 0) {
                    this.m_name = (String)tempProp.getValue();
                    continue;
                }
                if (tempProp.getName().compareToIgnoreCase("IsReserved") == 0) {
                    isReservedBool = (Boolean)tempProp.getValue();
                    continue;
                }
                if (tempProp.getName().compareToIgnoreCase("VersionStatus") == 0) {
                    if (tempProp.getIntValue() == 3) {
                        isReservationBool = new Boolean(true);
                        continue;
                    }
                    isReservationBool = new Boolean(false);
                    continue;
                }
                if (tempProp.getName().compareToIgnoreCase("IsCurrentVersion") != 0) continue;
                isCurrentVersionBool = (Boolean)tempProp.getValue();
            }
            try {
                this.m_name = this.m_storedSearch.getPropertyStringValue(this.m_objStorePrefs.getDocumentNameProperty());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.m_name == null) {
                throw new WcmException("client.WcmStoredSearch.noNameProp", "Name property not returned!");
            }
            if (isReservedBool == null) {
                throw new WcmException("client.WcmStoredSearch.noIsReservedProp", "IsReserved property not returned!");
            }
            this.m_isReserved = isReservedBool;
            if (isReservationBool == null) {
                throw new WcmException("client.WcmStoredSearch.noIsReservationProp", "IsReservation property not returned!");
            }
            this.m_isReservation = isReservationBool;
            if (isCurrentVersionBool == null) {
                throw new WcmException("client.WcmStoredSearch.noIsCurrentVerProp", "IsCurrentVersion property not returned!");
            }
            this.m_isCurrentVersion = isCurrentVersionBool;
            if (this.m_isReserved || this.m_isReservation) {
                this.getReservation();
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmStoredSearch.loadPropsFail", "Failed to get the object''s properties; {0}", (Object)e.getMessage());
        }
    }

    public void AssumeCheckout() {
        try {
            this.getReservation();
            if (this.m_reservation != null) {
                String resvUser = this.m_reservation.getPropertyStringValue("Creator");
                int resvType = this.m_reservation.getPropertyIntValue("ReservationType");
                if (resvType == 32 && WcmString.compareIgnoreCase(resvUser, this.m_userName) == 0 || resvType == 16) {
                    if (this.m_currentState == 1) {
                        int retVal = JOptionPane.showOptionDialog(this.m_parentFrame, WcmResource.s_assumeCheckout, WcmResource.s_searchAuthStr, 0, 3, null, null, null);
                        if (retVal == 1) {
                            this.m_currentState = 0;
                        }
                    } else if (this.m_currentState == 2) {
                        int retVal = JOptionPane.showOptionDialog(this.m_parentFrame, WcmResource.s_assumeCheckoutNoCancel, WcmResource.s_searchAuthStr, 0, 3, null, null, null);
                        this.m_currentState = retVal == 1 ? 0 : 1;
                    }
                } else {
                    this.m_currentState = 0;
                }
            }
        }
        catch (Exception e) {
            this.m_currentState = 0;
        }
    }
}

