/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.ui.WcmXMLTransformer;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class WcmShowXMLDialog
extends JDialog
implements ActionListener {
    private Container m_contentPane;
    private Frame m_parentFrame;
    private JTextPane m_text = new JTextPane();
    private JButton m_OKButton = new JButton(WcmResourceString.s_ok);
    private JButton m_saveButton = new JButton("Save to local filesystem");
    private FileDialog m_saveDlg = null;

    public WcmShowXMLDialog(Frame parent) {
        super(parent, true);
        this.m_parentFrame = parent;
    }

    public void init(WcmXMLTransformer xmlObj) {
        this.m_contentPane = this.getContentPane();
        this.m_contentPane.setLayout(new BorderLayout(10, 10));
        this.setTitle("Display XML before saving...");
        Dimension dim = new Dimension(800, 500);
        this.setSize(dim);
        this.setVisible(false);
        this.m_text.setText(xmlObj.toString());
        JScrollPane scroller = new JScrollPane(this.m_text);
        this.m_contentPane.add("Center", scroller);
        JPanel buttonPanel = new JPanel();
        this.m_OKButton.setSelected(true);
        buttonPanel.add(this.m_OKButton);
        buttonPanel.add(this.m_saveButton);
        this.getRootPane().setDefaultButton(this.m_OKButton);
        this.m_contentPane.add("South", buttonPanel);
        this.m_OKButton.addActionListener(this);
        this.m_saveButton.addActionListener(this);
        this.m_saveDlg = new FileDialog(this.m_parentFrame, "Save As...", 1);
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_OKButton) {
            this.setVisible(false);
        } else if (event.getSource() == this.m_saveButton) {
            this.performFileSave();
        }
    }

    private void performFileSave() {
        try {
            this.m_saveDlg.show();
            FileOutputStream stream = new FileOutputStream(this.m_saveDlg.getDirectory() + this.m_saveDlg.getFile());
            stream.write(this.m_text.getText().getBytes("UTF-16LE"));
            stream.close();
            JOptionPane.showMessageDialog(this.m_parentFrame, "Saved " + this.m_saveDlg.getFile());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.m_parentFrame, "Failed to save: " + e.getMessage());
        }
    }
}

