/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.ui.IWcmFileEventListener;
import com.filenet.wcm.apps.client.search.ui.WcmFileOpenEvent;
import com.filenet.wcm.apps.client.search.ui.WcmFileSaveEvent;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSearchCriteriaPanel;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WcmSearchTabbedPane
extends JTabbedPane
implements ChangeListener,
IWcmFileEventListener {
    private WcmSearchAuthCore m_parent = null;
    private JComponent m_thisPane;
    private boolean wasCBRCompatibilityChecked = false;

    public WcmSearchTabbedPane(WcmSearchAuthCore parent) {
        this.m_parent = parent;
        this.addChangeListener(this);
    }

    public void setSelectedIndex(int index) {
        if (index == 2 || index == 3 || index == 4) {
            this.m_parent.setWaitCursor();
            this.m_parent.setDefaultCursor();
        }
        super.setSelectedIndex(index);
    }

    public void stateChanged(ChangeEvent e) {
        WcmSearchTabbedPane source = (WcmSearchTabbedPane)e.getSource();
        int index = source.getSelectedIndex();
        if (this.getTabCount() < 5) {
            return;
        }
        this.m_thisPane = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (WcmSearchTabbedPane.this.m_thisPane != null) {
                    WcmSearchTabbedPane.this.m_thisPane.requestFocus();
                }
            }
        });
        if (index != 0) {
            this.m_parent.updateOSTabLabel();
        }
        if (index != 1) {
            this.m_parent.updatePropertyList();
        }
        if (index != 4) {
            this.m_parent.stopEditing(4);
            int valRet = this.m_parent.validateFormatResults();
            if (valRet != 0) {
                String strMsg = WcmResource.s_invalidPriority;
                if (valRet == 1) {
                    strMsg = WcmResource.s_dupPriority;
                } else if (valRet == 2) {
                    strMsg = WcmResource.s_exlimitPriority;
                }
                JOptionPane.showMessageDialog(this.m_parent, strMsg, WcmResource.s_invalidPriority, 0);
                this.setSelectedIndex(4);
                if (this.m_parent != null) {
                    this.m_parent.parentFrameRequestFocus();
                }
                return;
            }
        }
        if (index == 2 || index == 3 || index == 4 || index == 1) {
            if (index == 1) {
                this.m_parent.setStatusBarMsg(WcmResource.s_readingClassesStr);
            } else if (index == 2) {
                int multiOS = this.m_parent.getLibraryPanel().isMultiOS();
                if (multiOS == 1) {
                    this.m_parent.getFoldersPanel().enableViewColumn(true);
                } else {
                    this.m_parent.getFoldersPanel().enableViewColumn(false);
                }
            } else {
                this.m_parent.setStatusBarMsg(WcmResource.s_readingPropsStr);
            }
            this.m_parent.setWaitCursor();
            this.m_parent.stopEditing(index);
            this.m_parent.checkIfContentSearchingAvailable();
            this.m_parent.updatePropertyList();
            if (index == 2 || index == 1) {
                this.m_parent.updateSelectedLibs();
                this.m_parent.criteriaPageHasFocus(false);
            } else if (index == 3) {
                this.m_parent.criteriaPageHasFocus(true);
                WcmSearchCriteriaPanel criteriaPanel = this.m_parent.getCriteriaPanel();
                criteriaPanel.setObjectTypes(this.m_parent.getSelectedObjTypes());
                if (!this.wasCBRCompatibilityChecked) {
                    criteriaPanel.validateCBRCompatibility();
                    this.wasCBRCompatibilityChecked = true;
                }
            } else if (index == 4) {
                this.m_parent.criteriaPageHasFocus(false);
            }
            this.m_parent.updateCutCopyPaste(index);
            this.m_parent.setDefaultCursor();
            this.m_parent.setStatusBarMsg(WcmResource.s_readyStr);
        } else {
            this.m_parent.enableCutCopyPaste(false, index);
            this.m_parent.criteriaPageHasFocus(false);
        }
    }

    public void fileOpened(WcmFileOpenEvent e) {
        this.wasCBRCompatibilityChecked = false;
    }

    public void fileSave(WcmFileSaveEvent e) {
    }
}

