/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.ui.IWcmModel;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchCriteriaPanel;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class WcmSearchModel
extends AbstractTableModel
implements IWcmModel {
    protected Vector m_rowData = null;
    protected int m_nRows = 0;
    protected WcmQTree m_tree = new WcmQTree();
    protected boolean m_isComplete = true;
    protected boolean m_isDefaultAnd = true;
    protected int m_currentMode;
    protected boolean m_isValid = true;
    protected WcmSearchCriteriaPanel m_dialogPanel = null;
    protected boolean m_hasCommonCondition = false;

    public WcmSearchModel(int initialMode, WcmSearchCriteriaPanel dlgPanel) throws WcmException {
        try {
            this.m_rowData = new Vector();
            ++this.m_nRows;
            this.m_currentMode = initialMode;
            this.m_dialogPanel = dlgPanel;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInConstructor", "An error occurred while constructing object: {0}", (Object)e.getMessage());
        }
    }

    public void clearModel() {
        this.m_rowData = new Vector();
        this.m_tree = new WcmQTree();
        this.m_isComplete = true;
        this.m_isValid = true;
        this.m_hasCommonCondition = false;
        this.fireTableRowsDeleted(0, this.m_nRows);
        this.m_nRows = 0;
        this.fireTableStructureChanged();
    }

    public void copyItem(int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        WcmCondition newFieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null && (newFieldDef = fieldDef) != null) {
                this.m_rowData.addElement(newFieldDef);
                ++this.m_nRows;
                this.m_tree.appendNode(newFieldDef, this.m_isDefaultAnd);
                nRowIndex = this.getRowCount() - 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInCopy", "An error occurred in copyItem(): {0}", (Object)e.getMessage());
        }
    }

    public void deleteItem(int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                --this.m_nRows;
                this.m_tree.deleteNode(nRowIndex);
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInDelete", "An error occurred in deleteItem(): {0}", (Object)e.getMessage());
        }
    }

    public void insertRow(int nRowIndex, boolean addTreeNode) throws WcmException {
        try {
            WcmCondition fieldDef = new WcmCondition();
            if (fieldDef != null) {
                fieldDef.initializePropertyID();
                this.m_rowData.insertElementAt(fieldDef, nRowIndex);
                ++this.m_nRows;
                if (addTreeNode) {
                    this.m_tree.insertNode(fieldDef, nRowIndex, this.m_isDefaultAnd);
                }
                this.fireTableRowsInserted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInInsert", "An error occurred in insertItem(): {0}", (Object)e.getMessage());
        }
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public void setTree(WcmQTree tree) throws WcmException {
        this.m_tree = tree;
    }

    public WcmQTree getTree() {
        WcmQTree tree = new WcmQTree(this.m_tree);
        return tree;
    }

    public void setAnd(int nRowBegin, int nRowEnd) throws WcmException {
        try {
            this.m_tree.groupNodes(nRowBegin, nRowEnd, true);
            this.fireTableRowsUpdated(nRowBegin, nRowEnd);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInSetAnd", "An error occurred in setAnd(): {0}", (Object)e.getMessage());
        }
    }

    public void setOr(int nRowBegin, int nRowEnd) throws WcmException {
        try {
            this.m_tree.groupNodes(nRowBegin, nRowEnd, false);
            this.fireTableRowsUpdated(nRowBegin, nRowEnd);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInSetOr", "An error occurred in setOr(): {0}", (Object)e.getMessage());
        }
    }

    public void setDefaultLogicalOperator(boolean isAnd) {
        this.m_isDefaultAnd = isAnd;
    }

    public boolean getDefaultLogicalOperator() {
        return this.m_isDefaultAnd;
    }

    protected void checkCompleteness() {
        Iterator it = this.m_rowData.iterator();
        WcmCondition fieldDef = null;
        while (it.hasNext()) {
            fieldDef = (WcmCondition)it.next();
            if (fieldDef.isValid(this.m_currentMode)) continue;
            this.m_isComplete = false;
            return;
        }
        this.m_isComplete = true;
    }

    protected void removeBlankRows() {
        try {
            if (this.m_rowData == null) {
                return;
            }
            int dataSz = this.m_rowData.size();
            WcmCondition fieldDef = null;
            for (int i = dataSz - 1; i >= 0; --i) {
                fieldDef = this.getItemAt(i);
                if (!fieldDef.isEmpty()) continue;
                this.deleteItem(i);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmSearchModel::checkForBlankRows(): " + e.getMessage());
        }
    }

    public boolean isComplete() {
        return this.m_isComplete;
    }

    public void setIsValid(boolean isValid) {
        this.m_isValid = isValid;
    }

    public boolean isValid(boolean reset) {
        boolean isValid = this.m_isValid;
        if (reset) {
            this.m_isValid = true;
        }
        return isValid;
    }

    public int addRecord(WcmCondition item, int rowIndex) throws WcmException {
        try {
            if (item.isCommonCondition()) {
                this.m_hasCommonCondition = true;
            }
            this.setItemAt(item, rowIndex);
            return 0;
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmSearchModel::addRecord(): " + e.getMessage());
            return -1;
        }
    }

    public void addReadOnlyRecord(WcmCondition item, int rowIndex) throws WcmException {
        try {
            item.setIsCommonCondition(true);
            if (this.m_hasCommonCondition) {
                return;
            }
            WcmCondition currItem = this.getItemAt(rowIndex);
            if (currItem != null) {
                if (currItem.equals(item)) {
                    return;
                }
                if (WcmString.compareIgnoreCase(currItem.getPropertyLabel(), item.getPropertyLabel()) != 0) {
                    this.insertRow(rowIndex, true);
                    this.addRecord(item, rowIndex);
                } else if (WcmString.compareIgnoreCase(currItem.getOperator(), item.getOperator()) == 0 && currItem.getValue().length() == 0) {
                    this.addRecord(item, rowIndex);
                }
            } else if (item.getProperty() != null && item.getProperty().length() > 0) {
                this.insertRow(rowIndex, true);
                this.addRecord(item, rowIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setItemAt(WcmCondition item, int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return;
            }
            if (nRowIndex < this.m_rowData.size()) {
                this.m_rowData.setElementAt(item, nRowIndex);
                this.m_tree.setNode(item, nRowIndex);
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInGettingItem", "An error occurred in getItemAt(): {0}", (Object)e.getMessage());
        }
    }

    public WcmCondition getItemAt(int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return null;
            }
            if (nRowIndex < this.m_rowData.size()) {
                fieldDef = (WcmCondition)this.m_rowData.elementAt(nRowIndex);
            }
            return fieldDef;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmSearchModel.errorInGettingItem", "An error occurred in getItemAt(): {0}", (Object)e.getMessage());
        }
    }

    protected void setCurrentMode(int curMode) {
        this.m_currentMode = curMode;
    }
}

