/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.Folder;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import filenet.vw.toolkit.utils.datatransfer.IVWCBData;
import java.awt.datatransfer.DataFlavor;

public class WcmSearchFolder
implements IVWCBData {
    public static final DataFlavor FOLDER_DATAFLAVOR = new DataFlavor(WcmSearchFolder.class, "Search Folder");
    public static final int VIEW_UNINITIALIZED = 0;
    public static final int VIEW_EDITABLE = 1;
    public static final int VIEW_HIDDEN = 2;
    private static final String VIEW_UNINITIALIZED_STRING = "Uninitialized";
    private static final String VIEW_EDITABLE_STRING = new String(WcmResource.s_editableStr);
    private static final String VIEW_HIDDEN_STRING = new String(WcmResource.s_hiddenStr);
    private static final String XML_EDITABLE_STRING = "editable";
    private static final String XML_HIDDEN_STRING = "hidden";
    protected String m_id = new String("");
    protected int m_itemId = 0;
    protected int m_view = 0;
    protected String m_folder = new String("");
    protected String m_libName = new String("");
    protected boolean m_includeSubfolders = true;
    protected boolean m_crossLibraries = false;
    protected String m_validationError = null;
    private boolean m_isValid = false;
    private static int m_idCounter = 0;

    public WcmSearchFolder() {
    }

    public WcmSearchFolder(String folderPath, boolean inclSubfolders) {
        int idx = folderPath.indexOf(":");
        if (idx >= 0) {
            this.m_libName = folderPath.substring(0, idx);
        }
        this.m_folder = folderPath.substring(idx + 1);
        this.m_includeSubfolders = inclSubfolders;
    }

    public String getFolder() {
        return this.m_folder;
    }

    public void setFolder(String folder) {
        this.m_folder = folder;
    }

    public void updateFolder(String folder, String libName) {
        if (this.m_libName != null && libName != null && this.m_libName.compareTo(libName) != 0 || this.m_folder != null && folder != null && this.m_folder.compareTo(folder) != 0) {
            this.setId(new String(""));
        }
        this.m_libName = libName;
        this.m_folder = folder;
    }

    public String getFolderPath() {
        if (this.m_libName == null || WcmString.compareIgnoreCase(this.m_libName, "") == 0) {
            return this.m_folder;
        }
        return this.m_libName + ":" + this.m_folder;
    }

    public boolean isEmpty() {
        return !(this.m_id != null && this.m_id.length() != 0 || this.m_folder != null && this.m_folder.length() != 0 || this.m_libName != null && this.m_libName.length() != 0);
    }

    public boolean isValid(Session session) {
        this.m_isValid = false;
        if (session != null) {
            if (this.m_id.compareTo("") == 0) {
                this.m_isValid = this.m_folder.compareTo("") != 0;
            } else if (this.m_id.compareTo("") == 0 || this.m_libName.compareTo("") == 0) {
                this.m_isValid = false;
            } else {
                try {
                    this.m_isValid = false;
                    ObjectStore OS = ObjectFactory.getObjectStore((String)this.m_libName, (Session)session);
                    Folder folder = (Folder)OS.getObject(2, this.m_id);
                    Folder parentFolder = null;
                    if (folder != null) {
                        this.m_folder = folder.getName();
                        Folder curFolder = folder;
                        while ((parentFolder = curFolder.getParentFolder()) != null) {
                            if (parentFolder.getName().compareTo("") == 0) {
                                this.m_folder = new String("\\" + this.m_folder);
                                break;
                            }
                            this.m_folder = new String(parentFolder.getName() + "\\" + this.m_folder);
                            curFolder = parentFolder;
                        }
                        this.m_isValid = true;
                    }
                }
                catch (Exception e) {
                    this.m_validationError = new String(e.getMessage());
                    this.m_isValid = false;
                }
            }
        }
        return this.m_isValid;
    }

    public String getError() {
        if (!this.m_isValid) {
            return new String(this.m_validationError);
        }
        return new String("");
    }

    public boolean getIncludeSubfolders() {
        return this.m_includeSubfolders;
    }

    public void setIncludeSubfolders(boolean inclSubfolders) {
        this.m_includeSubfolders = inclSubfolders;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void initializeItemID() {
        this.m_itemId = ++m_idCounter;
    }

    public void setItemID(int id) {
        this.m_itemId = id;
    }

    public int getItemID() {
        return this.m_itemId;
    }

    public int getView() {
        return this.m_view;
    }

    public void setView(int newView) throws WcmException {
        if (newView != 1 && newView != 2) {
            throw new WcmException("client.WcmSearchFolder.invalidView", "\"{0}\" is not a valid view", (Object)new Integer(newView).toString());
        }
        this.m_view = newView;
    }

    public void setView(String newView) throws WcmException {
        if (WcmString.compareIgnoreCase(newView, VIEW_EDITABLE_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_EDITABLE_STRING) == 0) {
            this.m_view = 1;
        } else if (WcmString.compareIgnoreCase(newView, VIEW_HIDDEN_STRING) == 0 || WcmString.compareIgnoreCase(newView, XML_HIDDEN_STRING) == 0) {
            this.m_view = 2;
        } else {
            throw new WcmException("client.WcmSearchFolder.invalidView", "\"{0}\" is not a valid view", (Object)newView);
        }
    }

    public String getDisplayableViewStr() {
        switch (this.m_view) {
            case 1: {
                return VIEW_EDITABLE_STRING;
            }
            case 2: {
                return VIEW_HIDDEN_STRING;
            }
        }
        return new String("");
    }

    public String getInternalViewStr() {
        switch (this.m_view) {
            case 1: {
                return XML_EDITABLE_STRING;
            }
            case 2: {
                return XML_HIDDEN_STRING;
            }
        }
        return VIEW_UNINITIALIZED_STRING;
    }

    public String getLibraryName() {
        return this.m_libName;
    }

    public void setLibraryName(String name) {
        this.m_libName = name;
    }

    public boolean isCrossLibraries() {
        return this.m_crossLibraries;
    }

    public void setCrossLibraries(boolean isCrossLibraries) {
        this.m_crossLibraries = isCrossLibraries;
    }

    public void setValue(String folder, boolean inclSubfolders) {
        this.m_folder = folder;
        this.m_includeSubfolders = inclSubfolders;
    }

    public String toString() {
        String result = new Integer(this.m_itemId).toString() + ";";
        result = result + this.getDisplayableViewStr() + ";";
        result = result + this.m_id + ";";
        result = result + this.m_folder + ";" + this.m_includeSubfolders + ";" + this.m_libName + ";" + this.m_crossLibraries;
        return result;
    }

    public void setContent(String content) {
        try {
            if (content.length() == 0) {
                return;
            }
            String itemId = this.getNextParam(content);
            if (WcmString.compareIgnoreCase(itemId, "null") == 0) {
                this.initializeItemID();
            } else {
                this.m_itemId = new Integer(itemId);
            }
            content = this.removeParam(content, itemId);
            String view = this.getNextParam(content);
            if (view != null) {
                this.setView(view);
            }
            content = this.removeParam(content, view);
            this.m_id = this.getNextParam(content);
            content = this.removeParam(content, this.m_id);
            this.m_folder = this.getNextParam(content);
            content = this.removeParam(content, this.m_folder);
            Boolean subFolders = new Boolean(this.getNextParam(content));
            this.m_includeSubfolders = subFolders;
            content = this.removeParam(content, subFolders.toString());
            this.m_libName = this.getNextParam(content);
            content = this.removeParam(content, this.m_libName);
            if (WcmString.compare(this.m_libName, "null") == 0) {
                this.m_libName = new String("");
            }
            Boolean crossLibs = new Boolean(this.getNextParam(content));
            this.m_crossLibraries = crossLibs;
        }
        catch (Exception e) {
            System.out.println("Caught error in setContent(): " + e.getMessage());
        }
    }

    private String getNextParam(String buf) {
        int semiColonLoc = 0;
        semiColonLoc = buf.indexOf(";");
        if (semiColonLoc == -1) {
            return buf;
        }
        return buf.substring(0, semiColonLoc);
    }

    private String removeParam(String buf, String param) {
        if (buf == null) {
            return null;
        }
        if (WcmString.compareIgnoreCase(buf, param) == 0) {
            return null;
        }
        int len = param.length();
        if (len == -1) {
            return buf;
        }
        return buf.substring(len + 1, buf.length());
    }

    public String getContent() {
        return this.toString();
    }

    public DataFlavor getDataFlavor() {
        return FOLDER_DATAFLAVOR;
    }
}

