/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.SearchPropertyDescriptions;
import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.ui.BidiComboBox;
import com.filenet.wcm.apps.client.search.ui.IWcmCriteriaCompleteListener;
import com.filenet.wcm.apps.client.search.ui.WcmAndOrPane;
import com.filenet.wcm.apps.client.search.ui.WcmContentsModel;
import com.filenet.wcm.apps.client.search.ui.WcmCriteriaCompleteEvent;
import com.filenet.wcm.apps.client.search.ui.WcmFileOpenEvent;
import com.filenet.wcm.apps.client.search.ui.WcmGenericTablePanel;
import com.filenet.wcm.apps.client.search.ui.WcmPropMap;
import com.filenet.wcm.apps.client.search.ui.WcmPropertyModel;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSearchModel;
import com.filenet.wcm.apps.client.search.ui.WcmXMLTransformer;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import org.w3c.dom.Node;

public class WcmSearchCriteriaPanel
extends WcmGenericTablePanel
implements ActionListener,
FocusListener {
    private final int PROPERTY_COLS = 4;
    private final int CONTENT_COLS = 3;
    private final int MAX_RESULTS_DEFAULT = 100;
    private final String PROPERTY_TABLE_NAME = "property";
    private final String CONTENT_TABLE_NAME = "content";
    private final int DIVIDER_LOCATION = 130;
    private JPanel m_helperBtnPanel = new JPanel();
    private AbstractButton m_addButton = null;
    private AbstractButton m_removeButton = null;
    private AbstractButton m_andButton = null;
    private AbstractButton m_orButton = null;
    private JComboBox m_currentViewComboBox = null;
    private JLabel m_currentViewLabel = new JLabel(WcmResource.s_currentViewStr);
    private JPanel m_maxResultsPanel = new JPanel();
    private JLabel m_maxResultsLabel = new JLabel(WcmResource.s_maxResultsStr);
    private JTextField m_maxResults = new JTextField(new Integer(100).toString(), 5);
    private JSplitPane m_tableSplitPane = null;
    private WcmPropertyModel m_commonModel = null;
    private WcmPropertyModel m_documentModel = null;
    private WcmPropertyModel m_folderModel = null;
    private WcmPropertyModel m_customObjModel = null;
    private WcmPropertyModel m_currentModel = null;
    private Object[] m_modelIndex = new Object[4];
    private WcmAndOrPane m_propertyScrollPane = null;
    private WcmContentsModel m_contentModel = null;
    private WcmAndOrPane m_contentScrollPane = null;
    private JPanel m_contentPanel = new JPanel();
    private Object[] m_andOrStrings = new Object[]{new String(WcmResource.s_andGridsStr), new String(WcmResource.s_orGridsStr)};
    private DefaultComboBoxModel m_andOrModel = new DefaultComboBoxModel<Object>(this.m_andOrStrings);
    private JComboBox m_andOrBox = null;
    private JPanel m_andOrPanel = null;
    private boolean m_andGrids = true;
    private WcmAndOrPane m_tableWithFocus = null;
    private Vector m_criteriaCompleteListeners = new Vector();
    private TableModelEvent m_tableModelEvent;
    private int m_currentMode;
    private boolean m_contentCapable = false;
    private WcmPropMap m_commonMap = null;
    private ObjectStores m_libsList = null;
    private int m_absoluteMax = 0;
    private String m_absoluteMaxStr = null;

    public WcmSearchCriteriaPanel(WcmSearchAuthCore parent, int initialMode) {
        try {
            this.setLayout(new BorderLayout());
            this.m_parent = parent;
            this.m_currentMode = initialMode;
            this.setInstrText(WcmResource.s_criteriaInstrStr);
            this.add("First", this.m_instrPanel);
            this.add("Before", new JPanel());
            this.add("After", new JPanel());
            this.m_commonModel = new WcmPropertyModel(this.m_currentMode, 0, this);
            this.m_commonModel.setFrame(this);
            this.m_commonModel.setContainer(this.m_parent.getMainContainer());
            this.m_documentModel = new WcmPropertyModel(this.m_currentMode, 1, this);
            this.m_documentModel.setFrame(this);
            this.m_documentModel.setContainer(this.m_parent.getMainContainer());
            this.m_folderModel = new WcmPropertyModel(this.m_currentMode, 2, this);
            this.m_folderModel.setFrame(this);
            this.m_folderModel.setContainer(this.m_parent.getMainContainer());
            this.m_customObjModel = new WcmPropertyModel(this.m_currentMode, 15, this);
            this.m_customObjModel.setFrame(this);
            this.m_customObjModel.setContainer(this.m_parent.getMainContainer());
            this.m_currentModel = this.m_commonModel;
            this.m_contentModel = new WcmContentsModel(this.m_currentMode, this);
            this.m_propertyScrollPane = new WcmAndOrPane(this.m_currentModel, "property", this, this.m_parent);
            JPanel propertyPanel = new JPanel(new BorderLayout());
            propertyPanel.add("Center", this.m_propertyScrollPane);
            this.m_contentPanel.setLayout(new BorderLayout());
            this.m_contentScrollPane = new WcmAndOrPane(this.m_contentModel, "content", this, this.m_parent);
            ComponentOrientation componentOrienation = this.m_parent.getComponentOrientation();
            boolean isLTR = componentOrienation == ComponentOrientation.LEFT_TO_RIGHT;
            this.m_andOrBox = new BidiComboBox(componentOrienation);
            this.m_andOrBox.setModel(this.m_andOrModel);
            this.m_andOrPanel = new JPanel(new FlowLayout(isLTR ? 0 : 2));
            this.m_andOrPanel.add(this.m_andOrBox);
            this.m_contentPanel.add("First", this.m_andOrPanel);
            this.m_contentPanel.add("Center", this.m_contentScrollPane);
            this.m_tableSplitPane = new JSplitPane(0, propertyPanel, this.m_contentPanel);
            this.m_tableSplitPane.setDividerLocation(130);
            JPanel tableParentPanel = new JPanel(new BorderLayout());
            this.m_helperBtnPanel.setLayout(new FlowLayout(isLTR ? 2 : 0));
            this.m_addButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/InsertRow24.gif", WcmResource.s_insertRow, false, this);
            this.m_removeButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/DeleteRow24.gif", WcmResource.s_deleteRow, false, this);
            this.m_andButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/And24.gif", WcmResource.s_andTooltip, false, this);
            this.m_orButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/Or24.gif", WcmResource.s_orTooltip, false, this);
            this.m_addButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
            this.m_andButton.setEnabled(false);
            this.m_orButton.setEnabled(false);
            JPanel helperParentPanel = new JPanel(new GridLayout(1, 2));
            JPanel curViewPanel = new JPanel(new FlowLayout(isLTR ? 0 : 2));
            curViewPanel.add(this.m_currentViewLabel);
            this.m_currentViewComboBox = new BidiComboBox(componentOrienation);
            curViewPanel.add(this.m_currentViewComboBox);
            helperParentPanel.add((Component)curViewPanel, 0);
            helperParentPanel.add((Component)this.m_helperBtnPanel, 1);
            tableParentPanel.add("First", helperParentPanel);
            tableParentPanel.add("Center", this.m_tableSplitPane);
            this.add("Center", tableParentPanel);
            this.m_maxResultsPanel.setLayout(new FlowLayout(isLTR ? 2 : 0));
            this.m_maxResultsPanel.add(this.m_maxResultsLabel);
            this.m_maxResultsPanel.add(this.m_maxResults);
            this.m_maxResultsPanel.add(new JLabel(""));
            this.add("Last", this.m_maxResultsPanel);
            this.m_propertyScrollPane.setHasFocus(true);
            this.m_contentScrollPane.setHasFocus(false);
            this.m_tableWithFocus = this.m_propertyScrollPane;
            this.m_andOrBox.addActionListener(this);
            this.m_maxResults.addFocusListener(this);
            this.m_contentModel.addTableModelListener(this);
            this.m_maxResults.addKeyListener(this);
            this.m_currentViewComboBox.addActionListener(this);
            this.m_currentModel.addTableModelListener(this);
            this.m_commonModel.addTableModelListener(this);
            this.m_documentModel.addTableModelListener(this);
            this.m_folderModel.addTableModelListener(this);
            this.m_customObjModel.addTableModelListener(this);
            this.updateUI();
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void setDefaultOS(String defaultOS) {
        this.m_commonModel.setDefaultOS(defaultOS);
        this.m_documentModel.setDefaultOS(defaultOS);
        this.m_folderModel.setDefaultOS(defaultOS);
        this.m_customObjModel.setDefaultOS(defaultOS);
    }

    public void setContentCapable(boolean capable) {
        this.m_contentCapable = capable;
    }

    public void enableContentTable(boolean enable) {
        if (this.m_contentPanel.isVisible() != enable) {
            this.m_contentPanel.setVisible(enable);
            if (enable) {
                this.m_tableSplitPane.setDividerLocation(130);
            }
        }
    }

    public void setPaintEnabled(boolean enablePainting) {
        this.m_contentScrollPane.setPaintEnabled(enablePainting);
        this.m_propertyScrollPane.setPaintEnabled(enablePainting);
    }

    public void clear() {
        this.stopEditing();
        for (int i = 0; i < 4; ++i) {
            if (this.m_modelIndex[i] == null) continue;
            WcmPropertyModel item = (WcmPropertyModel)this.m_modelIndex[i];
            item.clearModel();
        }
        this.m_propertyScrollPane.clear();
        this.m_contentScrollPane.clear();
        this.m_andOrBox.setSelectedIndex(0);
        this.m_parent.m_optionsRec.m_interGridAnd = true;
        this.setMaxResults(100);
        this.enableActions(false);
    }

    public WcmQTree getCommonCriteria() {
        if (this.m_commonModel.getRowCount() > 0) {
            return this.m_commonModel.getTree();
        }
        return null;
    }

    public WcmQTree getDocumentCriteria() {
        if (this.m_documentModel.getRowCount() > 0) {
            return this.m_documentModel.getTree();
        }
        return null;
    }

    public WcmQTree getFolderCriteria() {
        if (this.m_folderModel.getRowCount() > 0) {
            return this.m_folderModel.getTree();
        }
        return null;
    }

    public WcmQTree getCustomObjCriteria() {
        if (this.m_customObjModel.getRowCount() > 0) {
            return this.m_customObjModel.getTree();
        }
        return null;
    }

    public WcmQTree getContentsCriteria() {
        return this.m_contentScrollPane.getTree();
    }

    public int getMaxResults() throws WcmException {
        return this.validateMaxResults();
    }

    private int validateMaxResults() throws WcmException {
        Integer maxResults;
        String max = this.m_maxResults.getText();
        if (this.m_absoluteMaxStr == null) {
            WcmSitePrefs prefs = this.m_parent.getSitePreferences();
            this.m_absoluteMax = prefs.getAbsoluteMaxResults();
            this.m_absoluteMaxStr = new Integer(this.m_absoluteMax).toString();
        }
        if (max.length() == 0) {
            this.m_maxResults.setText(new Integer(0).toString());
            return 0;
        }
        try {
            maxResults = new Integer(max);
            if (maxResults < 0) {
                JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_maxResultsNegative);
                this.m_maxResults.setText(new Integer(0).toString());
                return 0;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_maxResultsInteger);
            this.m_maxResults.setText(new Integer(0).toString());
            return 0;
        }
        if (maxResults > this.m_absoluteMax) {
            String msg = WcmResource.s_maxResultsExceeded.toString(this.m_absoluteMaxStr);
            JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), msg);
            this.m_maxResults.setText(this.m_absoluteMaxStr);
            return this.m_absoluteMax;
        }
        return maxResults;
    }

    public void setMaxResults(int max) {
        this.m_maxResults.setText(new Integer(max).toString());
    }

    public void setBothGridsToAnd(boolean and) {
        if (and) {
            this.m_andOrBox.setSelectedIndex(0);
        } else {
            this.m_andOrBox.setSelectedIndex(1);
        }
    }

    public void setDefaultLogicalOperator(boolean isAnd) {
        this.m_propertyScrollPane.setDefaultLogicalOperator(isAnd);
        this.m_contentScrollPane.setDefaultLogicalOperator(isAnd);
    }

    public void fileOpened(WcmFileOpenEvent event) {
        try {
            WcmXMLTransformer file;
            if (event != null && (file = event.getFile()) != null) {
                Node contentClause;
                this.m_parent.updatePropertyList();
                this.setMaxResults(new Integer(file.getMaxResults()));
                Node whereClause = file.getCommonWhereClause();
                if (whereClause != null) {
                    this.m_commonModel.setTree(new WcmQTree(whereClause));
                }
                if ((whereClause = file.getDocumentWhereClause()) != null) {
                    this.m_documentModel.setTree(new WcmQTree(whereClause));
                }
                if ((whereClause = file.getFolderWhereClause()) != null) {
                    this.m_folderModel.setTree(new WcmQTree(whereClause));
                }
                if ((whereClause = file.getCustomObjWhereClause()) != null) {
                    this.m_customObjModel.setTree(new WcmQTree(whereClause));
                }
                if ((contentClause = file.getContentClause()) != null) {
                    WcmQTree contentsTree = new WcmQTree(contentClause);
                    this.m_contentScrollPane.setTree(contentsTree);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught an error while reading a stored search: " + e.getMessage());
            this.m_parent.performNewItemAction(false, true);
        }
    }

    public void performCopy(boolean bDelete) {
        try {
            WcmAndOrPane focusedTable = this.getTableWithFocus();
            focusedTable.performCopy(bDelete);
            this.m_parent.enablePaste(true, 3);
        }
        catch (Exception e) {
            System.out.println("Error occurred in performCopy(): " + e.getMessage());
        }
    }

    public void performPaste() {
        try {
            WcmAndOrPane focusedTable = this.getTableWithFocus();
            focusedTable.performPaste();
        }
        catch (Exception e) {
            System.out.println("Error occurred in performPaste(): " + e.getMessage());
        }
    }

    public void performDelete() {
        WcmAndOrPane focusedTable = this.getTableWithFocus();
        focusedTable.doDelete();
    }

    public void actionPerformed(ActionEvent event) {
        WcmAndOrPane focusedTable = this.getTableWithFocus();
        if (event.getSource() == this.m_addButton) {
            focusedTable.doInsert();
        } else if (event.getSource() == this.m_removeButton) {
            focusedTable.doDelete();
        } else if (event.getSource() == this.m_andButton) {
            focusedTable.doAnd();
        } else if (event.getSource() == this.m_orButton) {
            focusedTable.doOr();
        } else if (event.getSource() == this.m_andOrBox) {
            this.updateAndOrSetting(this.m_andOrBox.getSelectedIndex());
        } else if (event.getSource() == this.m_currentViewComboBox) {
            this.updateCurrentView(this.m_currentViewComboBox.getSelectedIndex());
            this.showOrHideContentGrid(this.m_currentViewComboBox.getSelectedItem());
            TableModelEvent ev = new TableModelEvent(this.m_currentModel, 0, 0);
            this.m_currentModel.fireTableChanged(ev);
        }
        this.fireModifyEvent();
    }

    public void onListSelectionChanged(WcmAndOrPane source, ListSelectionEvent event) {
        if (source instanceof WcmAndOrPane) {
            this.m_tableWithFocus = source;
            if (source.getName().equalsIgnoreCase("property")) {
                this.m_contentScrollPane.clearSelection();
                this.m_contentScrollPane.stopEditing();
            } else if (source.getName().equalsIgnoreCase("content")) {
                this.m_propertyScrollPane.clearSelection();
                this.m_propertyScrollPane.stopEditing();
            }
        }
    }

    public void setPropertyDescList(SearchPropertyDescriptions commonList, SearchPropertyDescriptions docList, SearchPropertyDescriptions folderList, SearchPropertyDescriptions customObjList, int[] nObjTypes) {
        try {
            this.m_commonMap = new WcmPropMap();
            WcmPropMap docMap = new WcmPropMap(docList, true, false, false, false, 1);
            WcmPropMap folderMap = new WcmPropMap(folderList, true, false, false, false, 2);
            WcmPropMap customObjMap = new WcmPropMap(customObjList, true, false, false, false, 15);
            this.m_commonMap.createIntersectedList(commonList, docList, folderList, customObjList, true, false, false, nObjTypes);
            if (this.m_commonMap.foundDuplicates() || docMap.foundDuplicates() || folderMap.foundDuplicates() || customObjMap.foundDuplicates()) {
                JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResourceString.s_dupProperties);
            }
            this.m_commonModel.setPropertyDescList(this.m_commonMap);
            this.m_documentModel.setPropertyDescList(docMap);
            this.m_folderModel.setPropertyDescList(folderMap);
            this.m_customObjModel.setPropertyDescList(customObjMap);
            this.m_propertyScrollPane.setPropertyDescList(this.m_commonMap.getSearchPropertyDescriptions(), docMap.getSearchPropertyDescriptions(), folderMap.getSearchPropertyDescriptions(), customObjMap.getSearchPropertyDescriptions());
            this.m_propertyScrollPane.updatePropertyColumn();
        }
        catch (Exception e) {
            System.out.println("Caught an error in setPropertyDescList(): " + e.getMessage());
        }
    }

    public WcmPropMap getCommonMap() {
        return this.m_commonMap;
    }

    public boolean isCurrentViewCommon() {
        return this.m_currentModel == this.m_commonModel;
    }

    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.m_maxResults) {
            this.fireModifyEvent();
        }
        super.keyPressed(e);
    }

    private void showOrHideContentGrid(Object selectedItem) {
        if (selectedItem instanceof String) {
            String selStr = (String)selectedItem;
            if (this.m_contentCapable) {
                this.enableContentTable(true);
            } else {
                this.enableContentTable(false);
            }
        }
    }

    private WcmAndOrPane getTableWithFocus() {
        return this.m_tableWithFocus;
    }

    private void updateAndOrSetting(int selIndex) {
        if (selIndex == 0) {
            this.m_parent.m_optionsRec.m_interGridAnd = true;
        } else if (selIndex == 1) {
            this.m_parent.m_optionsRec.m_interGridAnd = false;
        }
    }

    private void updateCurrentView(int selIndex) {
        this.stopEditing();
        this.m_currentModel = (WcmPropertyModel)this.m_modelIndex[selIndex];
        this.m_propertyScrollPane.setModel(this.m_currentModel, selIndex);
    }

    public boolean isCriteriaComplete() {
        this.m_currentModel.checkCompleteness();
        this.m_contentModel.checkCompleteness();
        if (!this.m_currentModel.isComplete() || !this.m_contentModel.isComplete()) {
            this.fireCriteriaIncompleteEvent();
            return false;
        }
        this.fireCriteriaCompleteEvent();
        return true;
    }

    public void removeBlankRows() {
        this.m_contentModel.removeBlankRows();
        this.m_currentModel.removeBlankRows();
    }

    public boolean isValid(boolean reset) {
        return this.m_currentModel.isValid(reset) && this.m_contentModel.validate();
    }

    public boolean validateCBRCompatibility() {
        return this.m_contentModel.validate();
    }

    public void tableChanged(TableModelEvent e) {
        try {
            this.m_tableModelEvent = e;
            super.tableChanged(e);
            this.m_tableModelEvent = null;
            WcmSearchModel source = (WcmSearchModel)e.getSource();
            switch (e.getType()) {
                case 0: {
                    if (source != null && source == this.m_commonModel) {
                        int firstRow = e.getFirstRow();
                        int lastRow = e.getLastRow();
                        if (firstRow < 0) {
                            return;
                        }
                        for (int i = firstRow; i <= lastRow; ++i) {
                            WcmCondition item = this.m_commonModel.getItemAt(i);
                            if (item == null) continue;
                            this.m_documentModel.addReadOnlyRecord(new WcmCondition(item), i);
                            this.m_folderModel.addReadOnlyRecord(new WcmCondition(item), i);
                            this.m_customObjModel.addReadOnlyRecord(new WcmCondition(item), i);
                        }
                    } else {
                        int firstRow;
                        if (source != this.m_contentModel || (firstRow = e.getFirstRow()) == -1) break;
                        for (int i = firstRow; i <= e.getLastRow(); ++i) {
                            WcmCondition condition = this.m_contentModel.getItemAt(i);
                            if (condition == null || !condition.hasError()) continue;
                            this.m_contentModel.validateCondition(i);
                        }
                    }
                    break;
                }
            }
            this.isCriteriaComplete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteCommonPlaceholderFromOtherViews() {
        try {
            this.m_documentModel.deleteCommonPlaceholder();
            this.m_folderModel.deleteCommonPlaceholder();
            this.m_customObjModel.deleteCommonPlaceholder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TableModelEvent getTableModelEvent() {
        return this.m_tableModelEvent;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.m_maxResults) {
            try {
                this.validateMaxResults();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.fireModifyEvent();
        }
    }

    public void enableActions(boolean enable) {
        this.m_addButton.setEnabled(enable);
        this.m_removeButton.setEnabled(enable);
        this.m_andButton.setEnabled(enable);
        this.m_orButton.setEnabled(enable);
        this.m_parent.enableCutCopyPaste(enable, 3);
        if (!enable) {
            this.getParent().requestFocus();
        }
    }

    public boolean rowSelected() {
        return this.m_propertyScrollPane.rowSelected() | this.m_contentScrollPane.rowSelected();
    }

    public boolean stopEditing() {
        WcmAndOrPane focusedTable = this.getTableWithFocus();
        return focusedTable.stopEditing();
    }

    public void addCriteriaCompleteListener(IWcmCriteriaCompleteListener listener) {
        this.m_criteriaCompleteListeners.addElement(listener);
    }

    public void removeCriteriaCompleteListener(IWcmCriteriaCompleteListener listener) {
        this.m_criteriaCompleteListeners.removeElement(listener);
    }

    public void fireCriteriaCompleteEvent() {
        WcmCriteriaCompleteEvent event = new WcmCriteriaCompleteEvent(this);
        for (int i = 0; i < this.m_criteriaCompleteListeners.size(); ++i) {
            ((IWcmCriteriaCompleteListener)this.m_criteriaCompleteListeners.elementAt(i)).criteriaComplete(event);
        }
    }

    public void fireCriteriaIncompleteEvent() {
        WcmCriteriaCompleteEvent event = new WcmCriteriaCompleteEvent(this);
        for (int i = 0; i < this.m_criteriaCompleteListeners.size(); ++i) {
            ((IWcmCriteriaCompleteListener)this.m_criteriaCompleteListeners.elementAt(i)).criteriaIncomplete(event);
        }
    }

    public void setObjectTypes(boolean[] objTypes) {
        this.m_propertyScrollPane.setObjectTypes(objTypes);
        this.getViewComboBox(objTypes);
    }

    private void getViewComboBox(boolean[] objTypes) {
        try {
            this.m_currentViewComboBox.removeActionListener(this);
            this.m_modelIndex = new Object[4];
            int curModelIndex = 0;
            int objTypeCount = 0;
            for (int i = 0; i < 3; ++i) {
                if (!objTypes[i]) continue;
                ++objTypeCount;
            }
            this.m_currentViewComboBox.removeAllItems();
            if (objTypeCount > 1) {
                this.m_modelIndex[curModelIndex++] = this.m_commonModel;
                this.m_currentViewComboBox.addItem(WcmResource.s_commonStr);
            }
            if (objTypes[0]) {
                this.m_modelIndex[curModelIndex++] = this.m_documentModel;
                this.m_currentViewComboBox.addItem(WcmResourceString.s_document);
            }
            if (objTypes[1]) {
                this.m_modelIndex[curModelIndex++] = this.m_folderModel;
                this.m_currentViewComboBox.addItem(WcmResourceString.s_folder);
            }
            if (objTypes[2]) {
                this.m_modelIndex[curModelIndex++] = this.m_customObjModel;
                this.m_currentViewComboBox.addItem(WcmResourceString.s_customObject);
            }
            this.m_currentViewComboBox.addActionListener(this);
            this.updateCurrentView(0);
        }
        catch (Exception ex) {
            System.out.println("Failed to setup the CurrentView combobox: " + ex.getMessage());
        }
    }

    public void setCurrentMode(int curMode) {
        this.m_commonModel.setCurrentMode(curMode);
        this.m_documentModel.setCurrentMode(curMode);
        this.m_folderModel.setCurrentMode(curMode);
        this.m_customObjModel.setCurrentMode(curMode);
        this.m_contentModel.setCurrentMode(curMode);
        this.isCriteriaComplete();
    }

    public void refreshContentModifiers() {
        if (this.m_contentScrollPane != null) {
            this.m_contentScrollPane.populateModifiersColumn();
        }
    }
}

