/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.ui.WcmOpenBrowser;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.toolkit.client.util.WcmHelp;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseAppLauncherApplet;
import filenet.vw.toolkit.utils.VWSplashWindow;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.JApplet;

public class WcmSearchAuthApplet
extends VWBaseAppLauncherApplet
implements IVWSplashWindowListener {
    private static final String HELP_DIR = "/ae_help/search/";
    private VWSplashWindow m_splashWindow = null;
    private WcmSearchAuthCore m_searchAuthCore = null;

    public void init() {
        try {
            super.init();
            String bl = this.getParameter("browserlocale");
            Locale.setDefault(WcmSearchAuthApplet.getBrowserLocale(bl));
            this.updateComponentOrientation();
            this.m_splashWindow = new VWSplashWindow(null);
            WcmHelp.init((JApplet)((Object)this), HELP_DIR);
            WcmOpenBrowser.init((JApplet)((Object)this));
        }
        catch (Exception ex) {
            System.out.println("Failed to initialize Search Auth applet: " + ex.getMessage());
        }
    }

    public static Locale getBrowserLocale(String localeProperties) {
        Locale bl = Locale.getDefault();
        if (localeProperties != null && localeProperties.length() > 0) {
            String lang = null;
            String country = null;
            String[] lc = localeProperties.split(",");
            int l = lc.length;
            for (int i = 0; i < l; ++i) {
                String prop = lc[i].trim();
                if (prop.startsWith("language=") && prop.length() > 9) {
                    lang = prop.substring(9);
                    continue;
                }
                if (!prop.startsWith("country=") || prop.length() <= 8) continue;
                country = prop.substring(8);
            }
            if (lang != null && lang.length() > 0) {
                bl = country != null && country.length() > 0 ? new Locale(lang, country) : new Locale(lang);
            }
        }
        return bl;
    }

    public void start() {
        try {
            if (this.m_splashWindow != null) {
                this.m_splashWindow.start((IVWSplashWindowListener)this, 1000);
            }
        }
        catch (Exception ex) {
            System.out.println("Failed to start the Search Auth applet: " + ex.getMessage());
        }
    }

    public void destroy() {
        try {
            if (this.m_searchAuthCore != null) {
                this.m_searchAuthCore.windowClosing(null);
            }
            super.destroy();
        }
        catch (Exception ex) {
            System.out.println("Failed to destroy Search Auth applet: " + ex.getMessage());
        }
    }

    public void startProcessing() {
        try {
            if (this.m_splashWindow != null) {
                this.m_splashWindow.show();
            }
            this.m_searchAuthCore = new WcmSearchAuthCore();
            this.m_searchAuthCore.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException((Exception)ex);
        }
    }

    private void updateComponentOrientation() {
        try {
            ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.applyComponentOrientation(componentOrientation);
        }
        catch (Exception ex) {
            VWDebug.logException((Exception)ex);
        }
    }
}

