/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.ae.util.search.CBRSearchTerm;
import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import com.filenet.wcm.toolkit.util.WcmXMLEncode;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WcmQTree {
    public static final String AND = "AND";
    public static final String OR = "OR";
    private static final String ALL = "all";
    private static final String ANY = "any";
    private static final String BASE64 = "base64";
    private static final String COMMONPLACEHOLDER = "commonplaceholder";
    private static final String CONTENTAND = "contentand";
    private static final String CONTENTITEM = "contentitem";
    private static final String CONTENTOR = "contentor";
    private static final String DATAENCODING = "dataencoding";
    private static final String DATATYPE = "datatype";
    private static final String EDITPROPERTY = "editproperty";
    private static final String EQ = "eq";
    private static final String GROUPACTION = "groupaction";
    private static final String GT = "gt";
    private static final String GTE = "gte";
    private static final String ISNOTNULL = "isnotnull";
    private static final String ISNULL = "isnull";
    private static final String ITEMID = "itemid";
    private static final String LIKE = "like";
    private static final String IN = "in";
    private static final String LITERAL = "literal";
    private static final String LT = "lt";
    private static final String LTE = "lte";
    private static final String NAME = "name";
    private static final String NEAR = "near";
    private static final String NEARITEMS = "nearitems";
    private static final String NEQ = "neq";
    private static final String NOTLIKE = "notlike";
    private static final String PARAGRAPH = "paragraph";
    private static final String PROPDESC = "propdesc";
    private static final String SENTENCE = "sentence";
    private static final String SYMNAME = "symname";
    private static final String TYPEOBJECT = "typeobject";
    private static final String VERITYZONE = "verityzone";
    private static final String VERITYZONENAME = "verityzonename";
    private static final String VQL = "vql";
    private static final String WHEREPROP = "whereprop";
    private DefaultMutableTreeNode m_root = null;

    public WcmQTree() {
        this.m_root = new DefaultMutableTreeNode(new WcmCondition());
    }

    public WcmQTree(Node rootNode) {
        Node subRootNode = null;
        this.m_root = new DefaultMutableTreeNode(new WcmCondition());
        NodeList nodeList = rootNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            subRootNode = nodeList.item(i);
            if (subRootNode.getNodeType() != 1) continue;
            this.createSubTree(this.m_root, subRootNode);
            break;
        }
    }

    public WcmQTree(WcmQTree otherTree) {
        this.m_root = otherTree.m_root;
    }

    public DefaultMutableTreeNode getRoot() {
        DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode();
        newRoot = this.m_root;
        return newRoot;
    }

    public void groupNodes(int nRowBegin, int nRowEnd, boolean groupToAnd) throws WcmException {
        int leafCount = 0;
        boolean range = false;
        boolean invalid = false;
        Vector logicalNodeList = null;
        try {
            leafCount = this.m_root.getLeafCount();
            if (leafCount < 2) {
                return;
            }
            if (nRowBegin < 0 || nRowEnd > leafCount) {
                return;
            }
            logicalNodeList = this.makeListOfLogicalNodes(nRowBegin, nRowEnd, groupToAnd);
            Iterator it = logicalNodeList.iterator();
            DefaultMutableTreeNode node = null;
            WcmCondition condition = null;
            while (it.hasNext()) {
                node = (DefaultMutableTreeNode)it.next();
                condition = (WcmCondition)node.getUserObject();
                if (groupToAnd) {
                    condition.setProperty(AND);
                } else {
                    condition.setProperty(OR);
                }
                node.setUserObject(condition);
                this.coalesce(node);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.groupFailed", "Failure occurred when grouping nodes in the tree: {0}", (Object)e.getMessage());
        }
    }

    public int getLeafCount() {
        return this.m_root.getLeafCount();
    }

    public Vector getAllLeaves() {
        Vector<WcmCondition> leaves = new Vector<WcmCondition>();
        WcmCondition item = null;
        DefaultMutableTreeNode leaf = this.m_root.getFirstLeaf();
        item = (WcmCondition)leaf.getUserObject();
        if (!item.isEmpty()) {
            leaves.addElement(item);
        }
        for (int i = 1; i < this.m_root.getLeafCount(); ++i) {
            item = (WcmCondition)(leaf = leaf.getNextLeaf()).getUserObject();
            if (item.isEmpty()) continue;
            leaves.addElement(item);
        }
        return leaves;
    }

    private void createSubTree(DefaultMutableTreeNode parent, Node subtreeRoot) {
        try {
            DefaultMutableTreeNode newNode;
            if (subtreeRoot.getNodeName().compareToIgnoreCase(AND) == 0 || subtreeRoot.getNodeName().compareToIgnoreCase("verityand") == 0 || subtreeRoot.getNodeName().compareToIgnoreCase("and") == 0 || subtreeRoot.getNodeName().compareToIgnoreCase(CONTENTAND) == 0) {
                newNode = this.createLogicalNode(AND);
                parent.add(newNode);
                parent = newNode;
            } else if (subtreeRoot.getNodeName().compareToIgnoreCase(OR) == 0 || subtreeRoot.getNodeName().compareToIgnoreCase("verityor") == 0 || subtreeRoot.getNodeName().compareToIgnoreCase("or") == 0 || subtreeRoot.getNodeName().compareToIgnoreCase(CONTENTOR) == 0) {
                newNode = this.createLogicalNode(OR);
                parent.add(newNode);
                parent = newNode;
            } else {
                parent.add(this.createLeafNode(subtreeRoot));
                return;
            }
            NodeList children = subtreeRoot.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node itemNode = children.item(i);
                if (itemNode.getNodeType() != 1) continue;
                this.createSubTree(parent, itemNode);
            }
        }
        catch (Exception e) {
            System.out.println("Caught an error in createSubtree(): " + e.getMessage());
        }
    }

    private DefaultMutableTreeNode createLogicalNode(String logicalVal) {
        WcmCondition condition = new WcmCondition();
        condition.setProperty(logicalVal);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(condition);
        return newNode;
    }

    private DefaultMutableTreeNode createLeafNode(Node sourceNode) throws WcmException {
        WcmCondition condition = new WcmCondition();
        String op = sourceNode.getNodeName();
        if (op.compareToIgnoreCase(NEQ) == 0) {
            condition.setOperator(WcmResourceString.s_notEqualStr);
        } else if (op.compareToIgnoreCase(EQ) == 0) {
            condition.setOperator(WcmResourceString.s_equalStr);
        } else if (op.compareToIgnoreCase(LT) == 0) {
            condition.setOperator(WcmResourceString.s_lessThanStr);
        } else if (op.compareToIgnoreCase(GT) == 0) {
            condition.setOperator(WcmResourceString.s_greaterThanStr);
        } else if (op.compareToIgnoreCase(LTE) == 0) {
            condition.setOperator(WcmResourceString.s_lessThanEqualStr);
        } else if (op.compareToIgnoreCase(GTE) == 0) {
            condition.setOperator(WcmResourceString.s_greaterThanEqualStr);
        } else if (op.compareToIgnoreCase(NOTLIKE) == 0) {
            condition.setOperator(WcmResourceString.s_notLikeStr);
        } else if (op.compareToIgnoreCase(LIKE) == 0) {
            condition.setOperator(WcmResourceString.s_likeStr);
        } else if (op.compareToIgnoreCase(IN) == 0) {
            condition.setOperator(WcmResourceString.s_inStr);
        } else if (op.compareToIgnoreCase(ISNULL) == 0) {
            condition.setOperator(WcmResourceString.s_isNullStr);
        } else if (op.compareToIgnoreCase(ISNOTNULL) == 0) {
            condition.setOperator(WcmResourceString.s_isNotNullStr);
        } else {
            if (op.compareToIgnoreCase("verityitem") == 0 || op.compareToIgnoreCase("item") == 0) {
                DefaultMutableTreeNode newNode = this.createContentLeaf(sourceNode, condition);
                return newNode;
            }
            if (op.compareToIgnoreCase(CONTENTITEM) == 0) {
                DefaultMutableTreeNode newNode = this.upgradeContentLeaf(sourceNode, condition);
                return newNode;
            }
            if (op.compareToIgnoreCase(NEAR) == 0) {
                DefaultMutableTreeNode newNode = this.upgradeNearLeaf(sourceNode, condition);
                return newNode;
            }
            if (op.compareToIgnoreCase(COMMONPLACEHOLDER) == 0) {
                condition.setPropertyLabel(COMMONPLACEHOLDER);
                condition.setIsCommonCondition(true);
            } else {
                throw new WcmException("client.WcmQTree.invalidOperator", "\"{0}\" is not a valid operator", (Object)op);
            }
        }
        NodeList propNodeList = sourceNode.getChildNodes();
        for (int i = 0; i < propNodeList.getLength(); ++i) {
            String val;
            Node itemNode = propNodeList.item(i);
            if (itemNode.getNodeType() == 1 && itemNode.getNodeName().compareToIgnoreCase(WHEREPROP) == 0) {
                condition.setID(new Integer(this.getAttributeNamed(itemNode, ITEMID)));
                condition.setProperty(this.getAttributeNamed(itemNode, SYMNAME));
                condition.setPropertyLabel(this.getAttributeNamed(itemNode, NAME));
                String view = this.getAttributeNamed(itemNode, EDITPROPERTY);
                if (view.length() > 0) {
                    condition.setView(view);
                } else {
                    condition.setView(1);
                }
                NodeList whereNodeList = itemNode.getChildNodes();
                for (int j = 0; j < whereNodeList.getLength(); ++j) {
                    String type;
                    Node whereNode = whereNodeList.item(j);
                    if (whereNode.getNodeType() != 1 || whereNode.getNodeName().compareToIgnoreCase(PROPDESC) != 0 || WcmString.compareIgnoreCase(type = this.getAttributeNamed(whereNode, DATATYPE), TYPEOBJECT) != 0) continue;
                    String opStr = condition.getOperator();
                    if (WcmString.compareIgnoreCase(opStr, WcmResourceString.s_isNullStr) == 0) {
                        condition.setOperator(WcmResourceString.s_isNotDefinedStr);
                        continue;
                    }
                    if (WcmString.compareIgnoreCase(opStr, WcmResourceString.s_isNotNullStr) != 0) continue;
                    condition.setOperator(WcmResourceString.s_isDefinedStr);
                }
                continue;
            }
            if (itemNode.getNodeType() != 1 || itemNode.getNodeName().compareToIgnoreCase(LITERAL) != 0 || !itemNode.hasChildNodes() || (val = this.getTextNode(itemNode)) == null) continue;
            condition.setValue(val);
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(condition);
        return newNode;
    }

    private DefaultMutableTreeNode createContentLeaf(Node sourceNode, WcmCondition condition) throws WcmException {
        String view;
        condition.setValueFieldNotRequired();
        String itemID = this.getAttributeNamed(sourceNode, ITEMID);
        if (itemID.length() > 0) {
            condition.setID(new Integer(itemID));
        }
        if ((view = this.getAttributeNamed(sourceNode, EDITPROPERTY)).length() > 0) {
            condition.setView(view);
        } else {
            condition.setView(1);
        }
        String op = this.getAttributeNamed(sourceNode, GROUPACTION);
        if (op == null) {
            op = "";
        }
        if (op.compareToIgnoreCase(ALL) == 0) {
            condition.setOperator(WcmResource.s_allStr);
        } else if (op.compareToIgnoreCase(ANY) == 0) {
            condition.setOperator(WcmResource.s_anyStr);
        } else if (op.compareToIgnoreCase(IN) == 0) {
            condition.setOperator(WcmResource.s_inZoneStr);
        } else if (op.compareToIgnoreCase(NEAR) == 0) {
            condition.setOperator(WcmResource.s_nearStr);
        } else if (op.compareToIgnoreCase(PARAGRAPH) == 0) {
            condition.setOperator(WcmResource.s_paragraphStr);
        } else if (op.compareToIgnoreCase(SENTENCE) == 0) {
            condition.setOperator(WcmResource.s_sentenceStr);
        } else if (op.compareToIgnoreCase(VQL) == 0) {
            condition.setOperator(WcmResource.s_vqlStr);
        } else {
            condition.setOperator(WcmResource.s_verityNoneStr);
        }
        boolean prohibited = this.getAttributeNamed(sourceNode, "requiredstate").equals("prohibited");
        if ("proximity".equals(this.getAttributeNamed(sourceNode, "searchmodifier"))) {
            condition.setOperator(WcmResource.s_nearStr);
        }
        NodeList propNodeList = sourceNode.getChildNodes();
        for (int i = 0; i < propNodeList.getLength(); ++i) {
            Node itemNode = propNodeList.item(i);
            if (itemNode.getNodeType() != 1) continue;
            String nodeName = itemNode.getNodeName();
            if (nodeName.compareToIgnoreCase("usertext") == 0) {
                String phrase = this.getTextNode(itemNode);
                if (phrase == null || phrase.length() <= 0) continue;
                condition.setProperty(phrase);
                continue;
            }
            if (op.compareToIgnoreCase(IN) == 0 && nodeName.compareToIgnoreCase("verityitemdata") == 0) {
                NodeList itemsNodeList = itemNode.getChildNodes();
                for (int j = 0; j < itemsNodeList.getLength(); ++j) {
                    Node subItemNode = itemsNodeList.item(j);
                    if (subItemNode.getNodeType() != 1) continue;
                    condition.setZone(this.getZoneName(subItemNode));
                }
                continue;
            }
            if (nodeName.compareToIgnoreCase("terms") != 0) continue;
            NodeList childNodes = itemNode.getChildNodes();
            String text = null;
            for (int j = 0; j < childNodes.getLength(); ++j) {
                String value;
                Node termNode = childNodes.item(j);
                if (termNode.getNodeType() != 1 || (value = this.getTextNode(termNode)) == null) continue;
                boolean isPhrase = this.getAttributeNamed(termNode, "phrase").equals("true");
                CBRSearchTerm term = new CBRSearchTerm(value, isPhrase, prohibited);
                text = text == null ? "" : text + " ";
                text = text + term;
            }
            if (text == null) continue;
            condition.setProperty(text);
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(condition);
        return newNode;
    }

    private String getZoneName(Node parentNode) {
        NodeList zones = parentNode.getChildNodes();
        for (int i = 0; i < zones.getLength(); ++i) {
            Node zonesNode = zones.item(i);
            if (zonesNode.getNodeType() != 1) continue;
            NodeList zoneList = zonesNode.getChildNodes();
            for (int j = 0; j < zoneList.getLength(); ++j) {
                Node zoneNode = zoneList.item(j);
                if (zoneNode.getNodeType() != 1 || zoneNode.getNodeName().compareToIgnoreCase(VERITYZONE) != 0) continue;
                NodeList zoneNameList = zoneNode.getChildNodes();
                for (int k = 0; k < zoneNameList.getLength(); ++k) {
                    Node zoneNameNode = zoneNameList.item(k);
                    if (zoneNameNode.getNodeType() != 1 || zoneNameNode.getNodeName().compareToIgnoreCase(VERITYZONENAME) != 0) continue;
                    return this.getTextNode(zoneNameNode);
                }
            }
        }
        return null;
    }

    private DefaultMutableTreeNode upgradeContentLeaf(Node sourceNode, WcmCondition condition) throws WcmException {
        String view;
        condition.setValueFieldNotRequired();
        String itemID = this.getAttributeNamed(sourceNode, ITEMID);
        if (itemID.length() > 0) {
            condition.setID(new Integer(itemID));
        }
        if ((view = this.getAttributeNamed(sourceNode, EDITPROPERTY)).length() > 0) {
            condition.setView(view);
        } else {
            condition.setView(1);
        }
        StringBuffer phrase = new StringBuffer(this.getTextNode(sourceNode));
        if (phrase != null) {
            phrase.insert(0, '\"');
            phrase.append('\"');
            if (phrase.length() > 0) {
                condition.setProperty(phrase.toString());
            }
        }
        condition.setOperator(WcmResource.s_verityNoneStr);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(condition);
        return newNode;
    }

    private DefaultMutableTreeNode upgradeNearLeaf(Node sourceNode, WcmCondition condition) throws WcmException {
        condition.setValueFieldNotRequired();
        condition.setOperator(WcmResource.s_nearStr);
        NodeList subList = sourceNode.getChildNodes();
        block0: for (int i = 0; i < subList.getLength(); ++i) {
            Node subNode = subList.item(i);
            if (subNode.getNodeType() == 1 && subNode.getNodeName().compareToIgnoreCase("usertext") == 0) {
                String phrase = this.getTextNode(subNode);
                if (phrase == null || phrase.length() <= 0) continue;
                condition.setProperty(phrase.toString());
                continue;
            }
            if (subNode.getNodeType() != 1 || subNode.getNodeName().compareToIgnoreCase(NEARITEMS) != 0) continue;
            NodeList nearItems = subNode.getChildNodes();
            for (int j = 0; j < nearItems.getLength(); ++j) {
                String view;
                Node contentNode = nearItems.item(j);
                if (contentNode.getNodeType() != 1 || contentNode.getNodeName().compareToIgnoreCase(CONTENTITEM) != 0) continue;
                String itemID = this.getAttributeNamed(contentNode, ITEMID);
                if (itemID.length() > 0) {
                    condition.setID(new Integer(itemID));
                }
                if ((view = this.getAttributeNamed(contentNode, EDITPROPERTY)).length() > 0) {
                    condition.setView(view);
                    continue block0;
                }
                condition.setView(1);
                continue block0;
            }
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(condition);
        return newNode;
    }

    private String getTextNode(Node sourceNode) {
        Node firstChild;
        if (sourceNode != null && (firstChild = sourceNode.getFirstChild()) != null) {
            String encoding;
            String val = firstChild.getNodeValue();
            if (val != null && (encoding = this.getAttributeNamed(sourceNode, DATAENCODING)) != null && encoding.compareToIgnoreCase(BASE64) == 0) {
                try {
                    val = WcmXMLEncode.decodeFromXml(1, val);
                }
                catch (WcmXMLEncode.XmlDecodeException ex) {
                    System.out.println("WcmQTree couldn't decode base64 text!");
                    System.out.println("Error generated: " + ex.getMessage());
                    System.out.println("Using non-decoded text.");
                }
            }
            return val;
        }
        return null;
    }

    private String getAttributeNamed(Node item, String name) {
        String result = new String("");
        if (item.getNodeType() == 1) {
            NamedNodeMap al = item.getAttributes();
            for (int i = 0; i < al.getLength(); ++i) {
                if (al.item(i).getNodeName().compareToIgnoreCase(name) != 0) continue;
                result = al.item(i).getNodeValue();
            }
        }
        return result;
    }

    private Vector makeListOfLogicalNodes(int nRowBegin, int nRowEnd, boolean groupToAnd) throws WcmException {
        Vector<DefaultMutableTreeNode> logicalNodeList = null;
        DefaultMutableTreeNode firstLeaf = null;
        DefaultMutableTreeNode lastLeaf = null;
        DefaultMutableTreeNode sFirst = null;
        DefaultMutableTreeNode sLast = null;
        DefaultMutableTreeNode sParent = null;
        int i = 0;
        try {
            logicalNodeList = new Vector<DefaultMutableTreeNode>();
            firstLeaf = this.m_root.getFirstLeaf();
            if (nRowBegin > 0) {
                for (i = 1; i <= nRowBegin; ++i) {
                    firstLeaf = firstLeaf.getNextLeaf();
                }
            }
            lastLeaf = firstLeaf;
            for (i = nRowBegin + 1; i <= nRowEnd; ++i) {
                lastLeaf = lastLeaf.getNextLeaf();
            }
            if (firstLeaf == null || lastLeaf == null) {
                throw new WcmException("client.WcmQTree.nullLeafFound", "One of the leaves to be grouped is null");
            }
            if (sFirst.getLevel() > lastLeaf.getLevel()) {
                for (sFirst = firstLeaf; sFirst != this.m_root && sFirst.getLevel() > sLast.getLevel(); sFirst = (DefaultMutableTreeNode)sFirst.getParent()) {
                }
            } else if (sFirst.getLevel() < lastLeaf.getLevel()) {
                for (sLast = lastLeaf; sLast != this.m_root && sFirst.getLevel() < sLast.getLevel(); sLast = (DefaultMutableTreeNode)sLast.getParent()) {
                }
            }
            while (sFirst != this.m_root && sLast != this.m_root && sFirst.getParent() != sLast.getParent()) {
                sFirst = (DefaultMutableTreeNode)sFirst.getParent();
                sLast = (DefaultMutableTreeNode)sLast.getParent();
            }
            sParent = (DefaultMutableTreeNode)sFirst.getParent();
            DefaultMutableTreeNode currentNode = sFirst;
            while (currentNode.getChildCount() > 0) {
                currentNode = (DefaultMutableTreeNode)currentNode.getFirstChild();
            }
            if (currentNode != firstLeaf) {
                throw new WcmException("client.WcmQTree.verificationFailed1", "Failure occurred when verifying the ancestor against the first node.");
            }
            currentNode = sLast;
            while (currentNode.getChildCount() > 0) {
                currentNode = (DefaultMutableTreeNode)currentNode.getLastChild();
            }
            if (currentNode != lastLeaf) {
                throw new WcmException("client.WcmQTree.verificationFailed2", "Failure occurred when verifying the ancestor against the last node.");
            }
            if (sFirst == sParent.getFirstChild() && sLast == sParent.getLastChild()) {
                logicalNodeList.addElement(sParent);
                return logicalNodeList;
            }
            DefaultMutableTreeNode child = null;
            int nFirstIndex = 0;
            int nLastIndex = 0;
            boolean doLastNode = false;
            WcmCondition logicalNode = new WcmCondition();
            if (groupToAnd) {
                logicalNode.setProperty(AND);
            } else {
                logicalNode.setProperty(OR);
            }
            DefaultMutableTreeNode logicalTreeNode = new DefaultMutableTreeNode(logicalNode);
            nFirstIndex = sParent.getIndex(sFirst);
            nLastIndex = sParent.getIndex(sLast);
            for (i = nFirstIndex; i <= nLastIndex; ++i) {
                child = (DefaultMutableTreeNode)sParent.getChildAt(nFirstIndex);
                logicalTreeNode.add(child);
            }
            sParent.insert(logicalTreeNode, nFirstIndex);
            return logicalNodeList;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.makeListFailed", "Failure occurred when making the list of logical nodes: {0}", (Object)e.getMessage());
        }
    }

    private void coalesce(DefaultMutableTreeNode changedNode) throws WcmException {
        try {
            if (changedNode == null) {
                return;
            }
            WcmCondition changedCond = (WcmCondition)changedNode.getUserObject();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)changedNode.getParent();
            WcmCondition parentCond = (WcmCondition)parentNode.getUserObject();
            if (WcmString.compareIgnoreCase(changedCond.getProperty(), parentCond.getProperty()) == 0) {
                this.coalesceNode(changedNode);
            }
            for (int i = 0; i < changedNode.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)changedNode.getChildAt(i);
                this.coalesce(child);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.coalesceFailed", "WcmQTree::coalesceTree() failed: {0}", (Object)e.getMessage());
        }
    }

    private void coalesceNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode child = null;
        DefaultMutableTreeNode parent = null;
        int nodeIndex = 0;
        int childCount = 0;
        try {
            if (node == null) {
                return;
            }
            parent = (DefaultMutableTreeNode)node.getParent();
            nodeIndex = parent.getIndex(node) - 1;
            childCount = node.getChildCount();
            Enumeration<TreeNode> children = node.children();
            node.removeFromParent();
            while (children.hasMoreElements()) {
                child = (DefaultMutableTreeNode)children.nextElement();
                DefaultMutableTreeNode newChild = this.deepCopy(child);
                if (nodeIndex < childCount - 1) {
                    parent.insert(newChild, ++nodeIndex);
                    ++childCount;
                    continue;
                }
                parent.add(newChild);
            }
        }
        catch (Exception e) {
            System.out.println("Error in WcmQTree::coalesceNode(): " + e.getMessage());
        }
    }

    private DefaultMutableTreeNode deepCopy(DefaultMutableTreeNode orig) {
        try {
            WcmCondition newCondition = new WcmCondition((WcmCondition)orig.getUserObject());
            DefaultMutableTreeNode copy = new DefaultMutableTreeNode(newCondition);
            for (int i = 0; i < orig.getChildCount(); ++i) {
                DefaultMutableTreeNode newChild = this.deepCopy((DefaultMutableTreeNode)orig.getChildAt(i));
                copy.add(newChild);
            }
            return copy;
        }
        catch (Exception e) {
            System.out.println("Error in WcmQTree::deepCopy(): " + e.getMessage());
            return null;
        }
    }

    public void appendNode(WcmCondition node, boolean isAnd) throws WcmException {
        try {
            if (this.m_root.getChildCount() == 0) {
                this.addFirstLeafToRoot(node);
            } else if (this.m_root.getLeafCount() == 1) {
                DefaultMutableTreeNode subTree = (DefaultMutableTreeNode)this.m_root.getChildAt(0);
                DefaultMutableTreeNode newSubTree = this.appendToSubtree(subTree, node, isAnd);
                this.m_root.removeAllChildren();
                this.m_root.add(newSubTree);
            } else {
                DefaultMutableTreeNode subTree = (DefaultMutableTreeNode)this.m_root.getChildAt(0);
                WcmCondition subTreeObj = (WcmCondition)subTree.getUserObject();
                if (subTreeObj.getProperty().equalsIgnoreCase(AND) && isAnd || subTreeObj.getProperty().equalsIgnoreCase(OR) && !isAnd) {
                    DefaultMutableTreeNode newCondition = new DefaultMutableTreeNode(node);
                    subTree.add(newCondition);
                } else {
                    DefaultMutableTreeNode newSubTree = this.appendToSubtree(subTree, node, isAnd);
                    this.m_root.removeAllChildren();
                    this.m_root.add(newSubTree);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.appendFailed", "Failure occurred when appending a node to the tree: {0}", (Object)e.getMessage());
        }
    }

    public void appendSubTree(DefaultMutableTreeNode subTree, boolean isAnd) throws WcmException {
        try {
            DefaultMutableTreeNode rootTree = (DefaultMutableTreeNode)this.m_root.getChildAt(0);
            DefaultMutableTreeNode newSubTree = this.appendToSubtree(rootTree, subTree, isAnd);
            this.m_root.removeAllChildren();
            this.m_root.add(newSubTree);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.appendSubTreeFailed", "Failure occurred when appending a subtree to the tree: {0}", (Object)e.getMessage());
        }
    }

    public void insertNode(WcmCondition node, int nRowIndex, boolean isAnd) throws WcmException {
        int leafCount = 0;
        try {
            leafCount = this.m_root.getLeafCount();
            if (this.m_root.getChildCount() == 0) {
                this.addFirstLeafToRoot(node);
                return;
            }
            if (leafCount == 1 && nRowIndex == 0) {
                this.prependSecondLeafToRoot(node, isAnd);
                return;
            }
            if (nRowIndex < 0) {
                nRowIndex = 0;
            }
            if (nRowIndex > leafCount) {
                nRowIndex = leafCount;
            }
            if (nRowIndex == 0) {
                this.insertAtBeginning(node, isAnd);
            } else if (nRowIndex == leafCount) {
                this.appendNode(node, isAnd);
            } else {
                this.insertToTheMiddle(node, nRowIndex, isAnd);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.insertFailed", "Failure occurred when inserting a node at index {0}: {1}", new Integer(nRowIndex), (Object)e.getMessage());
        }
    }

    public void setNode(WcmCondition item, int rowIndex) throws WcmException {
        try {
            if (rowIndex < 0 || rowIndex > this.m_root.getLeafCount()) {
                return;
            }
            if (this.m_root.getChildCount() == 0) {
                return;
            }
            DefaultMutableTreeNode leaf = null;
            leaf = this.m_root.getFirstLeaf();
            for (int i = 1; i <= rowIndex; ++i) {
                leaf = leaf.getNextLeaf();
            }
            leaf.setUserObject(item);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.deleteNodeFailed", "Failure occurred when deleting a node in the tree: {0}", (Object)e.getMessage());
        }
    }

    public void deleteNode(int nRowIndex) throws WcmException {
        try {
            if (nRowIndex < 0 || nRowIndex > this.m_root.getLeafCount()) {
                return;
            }
            if (this.m_root.getChildCount() == 0) {
                return;
            }
            if (this.m_root.getLeafCount() == 1) {
                this.deleteOnlyNode();
            } else if (this.m_root.getLeafCount() == 2) {
                this.deleteOneOfTwoNodes(nRowIndex);
            } else {
                this.deleteNodeAndCollapseTree(nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.deleteNodeFailed", "Failure occurred when deleting a node in the tree: {0}", (Object)e.getMessage());
        }
    }

    private void deleteOnlyNode() throws WcmException {
        try {
            this.m_root.removeAllChildren();
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.deleteOnlyNodeFailed", "Failure occurred when deleting the only node in the tree: {0}", (Object)e.getMessage());
        }
    }

    private void deleteOneOfTwoNodes(int nRowIndex) throws WcmException {
        try {
            DefaultMutableTreeNode logicalNode = (DefaultMutableTreeNode)this.m_root.getFirstChild();
            logicalNode.remove(nRowIndex);
            this.m_root.remove(0);
            this.m_root.add((DefaultMutableTreeNode)logicalNode.getFirstChild());
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.deleteOneOfTwoNodesFailed", "Failure occurred when deleting one of the 2 nodes in the tree: {0}", (Object)e.getMessage());
        }
    }

    private void deleteNodeAndCollapseTree(int nRowIndex) throws WcmException {
        DefaultMutableTreeNode leaf = null;
        DefaultMutableTreeNode parent = null;
        DefaultMutableTreeNode grandparent = null;
        DefaultMutableTreeNode sibling = null;
        int childCount = 0;
        boolean leafIndex = false;
        int parentIndex = 0;
        int siblingIndex = 0;
        try {
            leaf = this.m_root.getFirstLeaf();
            for (int i = 1; i <= nRowIndex; ++i) {
                leaf = leaf.getNextLeaf();
            }
            parent = (DefaultMutableTreeNode)leaf.getParent();
            childCount = parent.getChildCount();
            if (childCount > 2) {
                parent.remove(leaf);
            } else if (childCount == 1) {
                grandparent = (DefaultMutableTreeNode)parent.getParent();
                grandparent.remove(parent);
            } else {
                grandparent = (DefaultMutableTreeNode)parent.getParent();
                siblingIndex = parent.getIndex(leaf) + 1;
                if (siblingIndex == 2) {
                    siblingIndex = 0;
                }
                sibling = (DefaultMutableTreeNode)parent.getChildAt(siblingIndex);
                if (grandparent == this.m_root) {
                    this.m_root.removeAllChildren();
                    this.m_root.add(sibling);
                } else {
                    parentIndex = grandparent.getIndex(parent);
                    grandparent.remove(parentIndex);
                    grandparent.insert(sibling, parentIndex);
                }
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.deleteAndCollapseFailed", "Failure when deleting a node from the tree: {0}", (Object)e.getMessage());
        }
    }

    private void addFirstLeafToRoot(WcmCondition node) throws WcmException {
        try {
            DefaultMutableTreeNode newCondition = new DefaultMutableTreeNode(node);
            this.m_root.add(newCondition);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.addFirstLeafFailed", "Failure occurred when adding the first node: {0}", (Object)e.getMessage());
        }
    }

    private DefaultMutableTreeNode appendToSubtree(DefaultMutableTreeNode subTree, WcmCondition node, boolean isAnd) throws WcmException {
        try {
            WcmCondition logicalNode = new WcmCondition();
            if (isAnd) {
                logicalNode.setProperty(AND);
            } else {
                logicalNode.setProperty(OR);
            }
            DefaultMutableTreeNode logicalTreeNode = new DefaultMutableTreeNode(logicalNode);
            logicalTreeNode.add(subTree);
            DefaultMutableTreeNode newCondition = new DefaultMutableTreeNode(node);
            logicalTreeNode.add(newCondition);
            return logicalTreeNode;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.subtreeAppendFailed", "Could not append node to subtree: {0}", (Object)e.getMessage());
        }
    }

    private DefaultMutableTreeNode appendToSubtree(DefaultMutableTreeNode subTree, DefaultMutableTreeNode node, boolean isAnd) throws WcmException {
        try {
            WcmCondition logicalNode = new WcmCondition();
            if (isAnd) {
                logicalNode.setProperty(AND);
            } else {
                logicalNode.setProperty(OR);
            }
            DefaultMutableTreeNode logicalTreeNode = new DefaultMutableTreeNode(logicalNode);
            logicalTreeNode.add(subTree);
            logicalTreeNode.add(node);
            return logicalTreeNode;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.subtreeAppendFailed2", "Could not append node to subtree: {0}", (Object)e.getMessage());
        }
    }

    private void prependSecondLeafToRoot(WcmCondition node, boolean isAnd) throws WcmException {
        try {
            WcmCondition logicalNode = new WcmCondition();
            if (isAnd) {
                logicalNode.setProperty(AND);
            } else {
                logicalNode.setProperty(OR);
            }
            DefaultMutableTreeNode logicalTreeNode = new DefaultMutableTreeNode(logicalNode);
            DefaultMutableTreeNode newCondition = new DefaultMutableTreeNode(node);
            logicalTreeNode.add(newCondition);
            DefaultMutableTreeNode firstCondition = (DefaultMutableTreeNode)this.m_root.getFirstChild();
            this.m_root.removeAllChildren();
            logicalTreeNode.add(firstCondition);
            this.m_root.add(logicalTreeNode);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.prependSecondNodeFailed", "Could not prepend a second node to subtree: {0}", (Object)e.getMessage());
        }
    }

    private DefaultMutableTreeNode prependToSubtree(DefaultMutableTreeNode subTree, WcmCondition node, boolean isAnd) throws WcmException {
        try {
            WcmCondition logicalNode = new WcmCondition();
            if (isAnd) {
                logicalNode.setProperty(AND);
            } else {
                logicalNode.setProperty(OR);
            }
            DefaultMutableTreeNode logicalTreeNode = new DefaultMutableTreeNode(logicalNode);
            DefaultMutableTreeNode newCondition = new DefaultMutableTreeNode(node);
            logicalTreeNode.add(newCondition);
            logicalTreeNode.add(subTree);
            return logicalTreeNode;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.subtreePrependFailed", "Could not prepend node to subtree: {0}", (Object)e.getMessage());
        }
    }

    private void insertAtBeginning(WcmCondition node, boolean isAnd) throws WcmException {
        try {
            DefaultMutableTreeNode subTree = (DefaultMutableTreeNode)this.m_root.getChildAt(0);
            WcmCondition subTreeObj = (WcmCondition)subTree.getUserObject();
            if (subTreeObj.getProperty().equalsIgnoreCase(AND) && isAnd || subTreeObj.getProperty().equalsIgnoreCase(OR) && !isAnd) {
                DefaultMutableTreeNode newCondition = new DefaultMutableTreeNode(node);
                subTree.insert(newCondition, 0);
            } else {
                DefaultMutableTreeNode newSubTree = this.prependToSubtree(subTree, node, isAnd);
                this.m_root.removeAllChildren();
                this.m_root.add(newSubTree);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.insertAtBeginningFailed", "Could not insert node to the beginning of the subtree: {0}", (Object)e.getMessage());
        }
    }

    private void insertToTheMiddle(WcmCondition node, int rowIndex, boolean isAnd) throws WcmException {
        DefaultMutableTreeNode leafAfter = null;
        DefaultMutableTreeNode subTree = null;
        int treeIndex = 0;
        try {
            leafAfter = this.m_root.getFirstLeaf();
            for (int i = 1; i <= rowIndex; ++i) {
                leafAfter = leafAfter.getNextLeaf();
            }
            subTree = (DefaultMutableTreeNode)leafAfter.getParent();
            treeIndex = subTree.getIndex(leafAfter);
            if (treeIndex >= 0) {
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(node);
                subTree.insert(treeNode, treeIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmQTree.insertToMiddleFailed", "Could not insert a new node into the middle of the tree: {0}", (Object)e.getMessage());
        }
    }

    public void runGroupingTest() {
        try {
            this.populateTreeWithTestData();
            this.groupNodes(0, 1, false);
            this.groupNodes(2, 3, false);
            this.groupNodes(4, 5, true);
            this.groupNodes(6, 7, true);
            this.groupNodes(8, 9, true);
            this.printTree();
            this.groupNodes(4, 9, true);
            this.printTree();
        }
        catch (Exception e) {
            System.out.println("Caught an error in runGroupingTest(): " + e.getMessage());
        }
    }

    public void runTest() {
        WcmCondition node = null;
        try {
            this.populateTreeWithTestData();
            this.groupNodes(0, 5, false);
            this.groupNodes(0, 1, true);
            this.groupNodes(2, 3, true);
            this.groupNodes(4, 5, true);
            this.groupNodes(6, 9, false);
            this.groupNodes(6, 7, true);
            this.groupNodes(8, 9, true);
            System.out.println("=============================================");
            System.out.println("Printing the tree with various node groupings");
            this.printTree();
            System.out.println("=============================================");
            System.out.println("Inserting the node '111' at various places");
            node = this.createTestNode(111);
            for (int i = 0; i < 11; ++i) {
                this.insertNode(node, i, true);
                System.out.println("---> Inserting at " + new Integer(i));
                this.printTree();
                System.out.println("---> Deleting at " + new Integer(i));
                this.deleteNode(i);
                this.printTree();
            }
            System.out.println("=============================================");
            System.out.println("Testing grouping again");
            this.groupNodes(0, 1, false);
            this.groupNodes(2, 3, false);
            this.groupNodes(4, 5, false);
            this.printTree();
        }
        catch (Exception e) {
            System.out.println("Caught an error in runTest(): " + e.getMessage());
        }
    }

    public void printTree() {
        System.out.println("Root node");
        if (this.m_root.getChildCount() == 1) {
            this.printNode((DefaultMutableTreeNode)this.m_root.getChildAt(0), 0);
        }
    }

    private void printNode(DefaultMutableTreeNode parentNode, int level) {
        int numOfChildren = parentNode.getChildCount();
        if (numOfChildren == 0) {
            for (int k = 1; k <= level; ++k) {
                System.out.print("-");
            }
            System.out.println("-> " + parentNode.getUserObject());
        } else {
            for (int k = 1; k <= level; ++k) {
                System.out.print("-");
            }
            System.out.println("-> " + parentNode.getUserObject());
            for (int i = 0; i < numOfChildren; ++i) {
                this.printNode((DefaultMutableTreeNode)parentNode.getChildAt(i), level + 1);
            }
        }
    }

    public void populateTreeWithTestData() {
        int i = 0;
        int place = 5;
        try {
            for (i = 1; i < 11; ++i) {
                WcmCondition node = this.createTestNode(i);
                this.appendNode(node, true);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in populateTreeWithTestData(): " + e.getMessage());
        }
    }

    public void populateTreeWithContentTestData() {
        int i = 0;
        try {
            for (i = 0; i < 4; ++i) {
                WcmCondition node = new WcmCondition();
                node.initializePropertyID();
                node.setView("Hidden");
                node.setProperty("Test Number" + new Integer(i).toString());
                node.setOperator("false");
                this.appendNode(node, true);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in populateTreeWithContentTestData(): " + e.getMessage());
        }
    }

    private WcmCondition createTestNode(int num) throws WcmException {
        WcmCondition newCondition = new WcmCondition();
        newCondition.initializePropertyID();
        newCondition.setView("Hidden");
        newCondition.setProperty("Test Number");
        newCondition.setOperator(WcmResourceString.s_equalStr);
        newCondition.setValue(new Integer(num).toString());
        return newCondition;
    }

    private void runXMLTest() throws Exception {
        FileInputStream file = new FileInputStream("C:\\files\\Peregrine\\CodeDesign\\revised_XML\\StoredSearchTmpl.xml");
        System.out.println("Printing contents tree...");
        System.out.println("Printing where tree...");
    }

    public static void main(String[] args) throws Exception {
        WcmQTree myTree = new WcmQTree();
        myTree.runXMLTest();
    }
}

