/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.util.StringUtil;
import com.filenet.wcm.toolkit.images.WcmImageLoader;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.table.TableColumn;

public class WcmPropertyRenderer
extends DefaultListCellRenderer {
    private TableColumn tableColumn;

    public WcmPropertyRenderer(TableColumn tableColumn) {
        this.tableColumn = tableColumn;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Object internalValue = value;
        this.applyComponentOrientation(list.getComponentOrientation());
        if (value != null && value instanceof WcmWrappedPD) {
            ImageIcon propIcon = null;
            WcmWrappedPD info = (WcmWrappedPD)value;
            if (info != null) {
                try {
                    int type = info.getObjType();
                    switch (type) {
                        case 1: {
                            propIcon = WcmImageLoader.createImageIcon("type/GenericDocument16.gif");
                            break;
                        }
                        case 2: {
                            propIcon = WcmImageLoader.createImageIcon("type/Folder16.gif");
                            break;
                        }
                        case 15: {
                            propIcon = WcmImageLoader.createImageIcon("type/CustomObject16.gif");
                            break;
                        }
                        case 0: {
                            propIcon = WcmImageLoader.createImageIcon("action/AddCustomObject16.gif");
                            break;
                        }
                    }
                    if (propIcon != null) {
                        this.setIcon(propIcon);
                    }
                    String text = info.getDisplayName();
                    this.setToolTipText(text);
                    int availableWidth = this.tableColumn.getWidth() - 50;
                    text = StringUtil.truncateText(text, availableWidth, this);
                    this.setText(text);
                }
                catch (Exception ex) {
                    this.setText(new String(""));
                }
            } else {
                this.setText(new String(""));
            }
        }
        return this;
    }
}

