/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.User;
import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.WcmPropInfo;
import com.filenet.wcm.apps.client.search.ui.WcmPropMap;
import com.filenet.wcm.apps.client.search.ui.WcmQTree;
import com.filenet.wcm.apps.client.search.ui.WcmSearchCriteriaPanel;
import com.filenet.wcm.apps.client.search.ui.WcmSearchModel;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmCtrlFactory;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmSVCtrl;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.client.ui.dlg.WcmDlgItemImpl;
import com.filenet.wcm.toolkit.client.ui.security.SecUserRealm;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.util.WcmException;
import com.filenet.wcm.toolkit.util.WcmString;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WcmPropertyModel
extends WcmSearchModel {
    private final int NUM_COLUMNS = 4;
    public static final int VIEW_COL = 0;
    public static final int PROPERTY_COL = 1;
    public static final int OPERATOR_COL = 2;
    public static final int VALUE_COL = 3;
    private String m_view = null;
    private String m_property = null;
    private String m_propertyLabel = null;
    private Vector m_operator = null;
    private Vector m_value = new Vector();
    public WcmCtrlFactory m_controlFactory = null;
    public JFrame m_frame = null;
    public Container m_mainContainer = null;
    private String m_defaultOS = null;
    private WcmPropMap m_propertyMap = null;
    private int m_objType = 1;

    public WcmPropertyModel(int initialMode, int objType, WcmSearchCriteriaPanel dlgPanel) throws WcmException {
        super(initialMode, dlgPanel);
        this.m_operator = new Vector();
        this.m_controlFactory = new WcmCtrlFactory();
        this.m_objType = objType;
    }

    public void setPropertyDescList(WcmPropMap propertyMap) {
        try {
            this.m_propertyMap = new WcmPropMap(propertyMap);
        }
        catch (Exception e) {
            System.out.println("Error caught in setPropertyDescList(): " + e.getMessage());
        }
    }

    public void clearModel() {
        this.m_view = null;
        this.m_property = null;
        this.m_propertyLabel = null;
        this.m_operator = new Vector();
        this.m_value = new Vector();
        super.clearModel();
    }

    public void setDefaultOS(String newDefaultOS) {
        this.m_defaultOS = newDefaultOS;
        this.m_controlFactory.setDefaultOS(newDefaultOS);
    }

    public void deleteItem(int nRowIndex) throws WcmException {
        if (nRowIndex < this.m_operator.size()) {
            this.m_operator.removeElementAt(nRowIndex);
        }
        if (nRowIndex < this.m_value.size()) {
            this.m_value.removeElementAt(nRowIndex);
        }
        if (this.m_objType == 0 && this.m_nRows == 1) {
            this.m_dialogPanel.deleteCommonPlaceholderFromOtherViews();
        }
        super.deleteItem(nRowIndex);
    }

    public void deleteCommonPlaceholder() {
        try {
            Iterator it = this.m_rowData.iterator();
            while (it.hasNext()) {
                WcmCondition item = (WcmCondition)it.next();
                if (!item.isCommonCondition()) continue;
                int idx = this.m_rowData.indexOf(item);
                it.remove();
                --this.m_nRows;
                this.m_tree.deleteNode(idx);
                if (idx < this.m_operator.size()) {
                    this.m_operator.removeElementAt(idx);
                }
                if (idx < this.m_value.size()) {
                    this.m_value.removeElementAt(idx);
                }
                this.fireTableRowsDeleted(idx, idx);
            }
            this.m_hasCommonCondition = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public void setFrame(JPanel panel) {
        this.m_frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, panel);
        if (this.m_frame == null) {
            this.m_frame = new JFrame();
        }
    }

    public void setContainer(Container container) {
        this.m_mainContainer = container;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return WcmResource.s_viewStr;
            }
            case 1: {
                return WcmResource.s_propertyStr;
            }
            case 2: {
                return WcmResource.s_operatorStr;
            }
            case 3: {
                return WcmResource.s_valueStr;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return WcmWrappedPD.class;
            }
            case 2: {
                return WcmPropInfo.class;
            }
            case 3: {
                return WcmPropInfo.class;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        WcmCondition fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (fieldDef != null) {
                        return fieldDef.getDisplayableViewStr();
                    }
                    return this.m_view;
                }
                case 1: {
                    if (fieldDef != null && fieldDef.getPropDesc() != null) {
                        return fieldDef.getPropDesc();
                    }
                    return null;
                }
                case 2: {
                    WcmPropInfo opDef = null;
                    if (nRowIndex < this.m_operator.size()) {
                        opDef = (WcmPropInfo)this.m_operator.elementAt(nRowIndex);
                    }
                    return opDef;
                }
                case 3: {
                    WcmPropInfo valDef = null;
                    if (nRowIndex < this.m_value.size()) {
                        valDef = (WcmPropInfo)this.m_value.elementAt(nRowIndex);
                    }
                    return valDef;
                }
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("An error occurred in getValueAt(): " + e.getMessage());
            return null;
        }
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateView(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateProperty(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateOperator(aValue, nRowIndex);
                    break;
                }
                case 3: {
                    this.onUpdateValue(aValue, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred in setValueAt(): " + e.getMessage());
        }
    }

    public void insertRow(int nRowIndex, boolean addTreeNode) throws WcmException {
        try {
            super.insertRow(nRowIndex, addTreeNode);
            WcmPropInfo opRec = new WcmPropInfo();
            this.m_operator.insertElementAt(opRec, nRowIndex);
            WcmPropInfo valRec = new WcmPropInfo();
            this.m_value.insertElementAt(valRec, nRowIndex);
            this.fireTableRowsInserted(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmPropertyModel.errorInInsert", "An error occurred in insertItem(): {0}", (Object)e.getMessage());
        }
    }

    public int handleInvalidCondition(WcmCondition item, int rowIndex) {
        String condition = item.getPropertyLabel() + " " + item.getOperator() + " " + item.getValue();
        String msg = WcmResource.s_invalidCondition.toString(condition);
        msg = msg + WcmResource.s_invalidCondition2;
        return JOptionPane.showOptionDialog(this.m_frame, msg, WcmResource.s_searchAuthStr, 2, 3, null, null, null);
    }

    public int addRecord(WcmCondition item, int rowIndex) throws WcmException {
        block21: {
            WcmUserGroupItem wcmUserItem = null;
            WcmPropInfo propDesc = null;
            try {
                if (item.isCommonCondition()) {
                    this.m_hasCommonCondition = true;
                    String propStr = item.getProperty();
                    propDesc = propStr != null || propStr.length() > 0 ? this.m_dialogPanel.getCommonMap().getPropInfoBySymName(item.getProperty()) : new WcmPropInfo();
                    propDesc.setIsCommonCond(true);
                } else {
                    propDesc = this.m_propertyMap.getPropInfoBySymName(item.getProperty());
                }
                if (propDesc != null && item != null) {
                    propDesc.setIsOVP(item.isOVP());
                }
                if (item.getValue().length() > 0 && (WcmString.compareIgnoreCase(WcmResourceString.s_creatorDisplayName, item.getPropertyLabel()) == 0 || WcmString.compareIgnoreCase(WcmResourceString.s_lastModifierDisplayName, item.getPropertyLabel()) == 0 || WcmString.compareIgnoreCase(WcmResourceString.s_lockOwnerDisplayName, item.getPropertyLabel()) == 0)) {
                    if (item.getValue().compareToIgnoreCase("#CREATOR-OWNER") == 0) {
                        wcmUserItem = new WcmUserGroupItem("#CREATOR-OWNER", "#CREATOR-OWNER", "#CREATOR-OWNER", "S-1-3-0", 0);
                    } else {
                        User user = SecUserRealm.findUserByShortName(propDesc.getSearchPropertyDescription().getSession(), item.getValue());
                        if (user != null) {
                            wcmUserItem = new WcmUserGroupItem(user);
                        }
                    }
                }
                if (propDesc == null) {
                    int retVal = this.handleInvalidCondition(item, rowIndex);
                    if (retVal == 0) {
                        return -1;
                    }
                    if (retVal == 2) {
                        throw new WcmException("client.WcmPropertyModel.invalidProperty", "Failed to open due to invalid property: {0}", (Object)item.getPropertyLabel());
                    }
                }
                if (!item.isCommonCondition()) {
                    this.generateNewOpAndValue(propDesc, rowIndex);
                }
                WcmWrappedPD wPD = new WcmWrappedPD(propDesc.getPropertyDescription(), this.m_objType);
                wPD.setIsCommonProp(item.isCommonCondition());
                item.setPropDesc(wPD);
                item.setPropertyLabel(propDesc.getLabel());
                this.setItemAt(item, rowIndex);
                if (item.isCommonCondition()) {
                    WcmPropInfo opObj = (WcmPropInfo)this.m_operator.elementAt(rowIndex);
                    opObj.setIsCommonCond(true);
                    WcmPropInfo valObj = (WcmPropInfo)this.m_value.elementAt(rowIndex);
                    valObj.setIsCommonCond(true);
                    break block21;
                }
                WcmPropInfo opObj = (WcmPropInfo)this.m_operator.elementAt(rowIndex);
                opObj.setOperator(item.getOperator());
                try {
                    WcmPropInfo valObj = (WcmPropInfo)this.m_value.elementAt(rowIndex);
                    if (WcmString.compareIgnoreCase(WcmResourceString.s_creatorDisplayName, item.getPropertyLabel()) == 0 || WcmString.compareIgnoreCase(WcmResourceString.s_lastModifierDisplayName, item.getPropertyLabel()) == 0 || WcmString.compareIgnoreCase(WcmResourceString.s_lockOwnerDisplayName, item.getPropertyLabel()) == 0) {
                        if (wcmUserItem != null) {
                            valObj.setValue(wcmUserItem);
                        }
                    } else {
                        String value = item.getValue();
                        if (value != null && value.length() > 0) {
                            valObj.setValue(value);
                        }
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.m_frame, e.getMessage());
                }
            }
            catch (Exception e) {
                if (e instanceof WcmException) {
                    throw (WcmException)e;
                }
                System.out.println("Error occurred in WcmPropertyModel::addRecord(): " + e.getMessage());
            }
        }
        return 0;
    }

    public void setTree(WcmQTree tree) throws WcmException {
        int rowIndex = 0;
        try {
            super.setTree(tree);
            Vector leaves = tree.getAllLeaves();
            for (WcmCondition item : leaves) {
                WcmCondition itemCopy = new WcmCondition(item);
                this.insertRow(rowIndex, false);
                int retVal = this.addRecord(itemCopy, rowIndex);
                if (retVal == -1) {
                    this.deleteItem(rowIndex);
                    --rowIndex;
                }
                ++rowIndex;
            }
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
        catch (Exception e) {
            if (e instanceof WcmException) {
                throw (WcmException)e;
            }
            System.out.println("Caught exception in setTree(): " + e.getMessage());
        }
    }

    private void generateNewOpAndValue(WcmPropInfo selItem, int nRowIndex) {
        try {
            WcmPropInfo operatorObj = this.getOperatorControlFactoryObj(selItem);
            this.setValueAt(operatorObj, nRowIndex, 2);
            if (selItem.getDataType() != 7) {
                WcmPropInfo valueObj = this.createControlFactoryObj(selItem);
                this.setValueAt(valueObj, nRowIndex, 3);
            } else {
                this.m_value.setElementAt(new WcmPropInfo(), nRowIndex);
                this.fireTableCellUpdated(nRowIndex, 3);
            }
        }
        catch (Exception e) {
            System.out.println("Failure occurred creating the Operator or Value object:" + e.getMessage());
        }
    }

    private void createNewRecord(int nRowIndex, WcmPropInfo selItem) throws WcmException {
        WcmCondition fieldDef = null;
        try {
            WcmPropInfo info;
            fieldDef = new WcmCondition();
            this.m_rowData.addElement(fieldDef);
            ++this.m_nRows;
            fieldDef.initializePropertyID();
            if (this.m_view == null) {
                if (this.m_currentMode == 1) {
                    fieldDef.setView(3);
                } else if (this.m_currentMode == 2) {
                    fieldDef.setView(2);
                }
            } else {
                fieldDef.setView(this.m_view);
            }
            if (this.m_property != null) {
                fieldDef.setProperty(this.m_property);
            }
            if (this.m_propertyLabel != null) {
                fieldDef.setPropertyLabel(this.m_propertyLabel);
            }
            if (nRowIndex < this.m_operator.size()) {
                info = (WcmPropInfo)this.m_operator.elementAt(nRowIndex);
                if (info != null) {
                    fieldDef.setOperator(info.getOperator().toString());
                }
            } else {
                info = new WcmPropInfo();
                this.m_operator.addElement(info);
            }
            if (nRowIndex < this.m_value.size()) {
                info = (WcmPropInfo)this.m_value.elementAt(nRowIndex);
                if (info != null) {
                    fieldDef.setValue(info.getValue().toString());
                }
            } else {
                info = new WcmPropInfo();
                this.m_value.addElement(info);
            }
            if (selItem != null) {
                fieldDef.setPropDesc(new WcmWrappedPD(selItem.getPropertyDescription(), selItem.getObjType()));
                this.generateNewOpAndValue(selItem, nRowIndex);
            }
            this.m_tree.appendNode(fieldDef, this.m_isDefaultAnd);
            this.m_view = null;
            this.m_property = null;
            this.m_propertyLabel = null;
            this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmPropertyModel.createNewRecord", "An error occurred while creating a new record: {0}", (Object)e.getMessage());
        }
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        try {
            WcmCondition fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null && fieldDef.isCommonCondition() && !this.m_dialogPanel.isCurrentViewCommon()) {
                return false;
            }
            if (nColumnIndex == 3 && fieldDef != null) {
                String op = fieldDef.getOperator();
                if (this.operatorIsNullIsNotNull(op) || this.operatorIsDefinedIsNotDefined(op)) {
                    return false;
                }
                if (fieldDef.isOVP()) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in isCellEditable(): " + e.getMessage());
        }
        return true;
    }

    private boolean operatorIsNullIsNotNull(String op) {
        return WcmString.compareIgnoreCase(op, WcmResourceString.s_isNullStr) == 0 || WcmString.compareIgnoreCase(op, WcmResourceString.s_isNotNullStr) == 0;
    }

    private boolean operatorIsDefinedIsNotDefined(String op) {
        return WcmString.compareIgnoreCase(op, WcmResourceString.s_isDefinedStr) == 0 || WcmString.compareIgnoreCase(op, WcmResourceString.s_isNotDefinedStr) == 0;
    }

    private void onUpdateView(Object aValue, int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            String view = new String(aValue.toString());
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setView(view);
            } else {
                this.m_view = view;
                this.createNewRecord(nRowIndex, null);
            }
            this.fireTableCellUpdated(nRowIndex, 0);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmPropertyModel.UpdateView", "An error occurred while in onUpdateView(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateProperty(Object aValue, int nRowIndex) throws WcmException {
        WcmCondition fieldDef = null;
        String pName = null;
        WcmWrappedPD propDesc = null;
        try {
            String name;
            if (aValue == null) {
                return;
            }
            if (aValue instanceof WcmWrappedPD) {
                propDesc = (WcmWrappedPD)aValue;
                pName = propDesc.getDisplayName();
            } else {
                System.out.println("Property is not of type WcmWrappedPD");
            }
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null && (name = fieldDef.getProperty()) != null && WcmString.compareIgnoreCase(name, propDesc.getName()) == 0) {
                return;
            }
            WcmPropInfo selItem = new WcmPropInfo(propDesc.getPropertyDesc());
            selItem.setObjType(propDesc.getObjType());
            selItem.setIsOVP(propDesc.isOVP());
            if (fieldDef != null) {
                fieldDef.setPropertyLabel(pName);
                if (selItem != null) {
                    fieldDef.setProperty(propDesc.getName());
                    fieldDef.setPropDesc(propDesc);
                    this.generateNewOpAndValue(selItem, nRowIndex);
                    fieldDef.setValue("");
                }
            } else {
                this.m_propertyLabel = pName;
                this.m_property = propDesc.getName();
                this.createNewRecord(nRowIndex, selItem);
            }
            this.fireTableCellUpdated(nRowIndex, 1);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmPropertyModel.UpdateProperty", "An error occurred while in onUpdateProperty(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateOperator(Object aValue, int nRowIndex) throws WcmException {
        block12: {
            WcmCondition fieldDef = null;
            try {
                String op;
                if (aValue == null) {
                    return;
                }
                if (!(aValue instanceof WcmPropInfo)) break block12;
                WcmPropInfo info = (WcmPropInfo)aValue;
                Component controlValue = info.getWrappedOperatorComponent();
                fieldDef = this.getItemAt(nRowIndex);
                if (fieldDef != null) {
                    if (controlValue != null) {
                        this.m_operator.setElementAt(info, nRowIndex);
                        if (info.getOperator() != null) {
                            fieldDef.setOperator(info.getOperator().toString());
                        }
                    } else {
                        fieldDef.setOperator("");
                    }
                } else if (controlValue != null) {
                    this.m_operator.setElementAt(info, nRowIndex);
                }
                if (info != null && this.operatorIsNullIsNotNull(op = info.getOperator().toString())) {
                    try {
                        WcmPropInfo valueObj = this.createControlFactoryObj(info);
                        this.setValueAt(valueObj, nRowIndex, 3);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.m_frame, e.getMessage());
                    }
                }
                this.fireTableCellUpdated(nRowIndex, 2);
            }
            catch (Exception e) {
                throw new WcmException("client.WcmPropertyModel.UpdateOperator", "An error occurred while in onUpdateOperator(): {0}", (Object)e.getMessage());
            }
        }
    }

    private void onUpdateValue(Object aValue, int nRowIndex) throws WcmException {
        block11: {
            WcmCondition fieldDef = null;
            try {
                String validityMsg;
                if (aValue == null) {
                    return;
                }
                if (!(aValue instanceof WcmPropInfo)) break block11;
                WcmPropInfo info = (WcmPropInfo)aValue;
                Component controlValue = info.getWrappedComponent();
                if (info.getUIComponent() != null && (validityMsg = info.isValid()) != null && validityMsg.length() > 0) {
                    this.setIsValid(false);
                    JOptionPane.showMessageDialog(this.m_frame, validityMsg);
                    try {
                        info.setUIComponent(null);
                        WcmPropInfo valueObj = this.createControlFactoryObj(info);
                        this.setValueAt(valueObj, nRowIndex, 3);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this.m_frame, e.getMessage());
                    }
                    return;
                }
                fieldDef = this.getItemAt(nRowIndex);
                if (fieldDef != null) {
                    if (controlValue != null) {
                        String val = info.getStringValue();
                        fieldDef.setValue(val);
                        this.m_value.setElementAt(info, nRowIndex);
                    } else {
                        fieldDef.setValue("");
                    }
                } else if (controlValue != null) {
                    this.m_value.setElementAt(info, nRowIndex);
                }
                this.fireTableCellUpdated(nRowIndex, 3);
            }
            catch (Exception e) {
                throw new WcmException("client.WcmPropertyModel.UpdateValue", "An error occurred while in onUpdateValue(): {0}", (Object)e.getMessage());
            }
        }
    }

    public WcmPropInfo createControlFactoryObj(WcmPropInfo info) {
        try {
            if (info == null || this.m_mainContainer == null || info.getSearchPropertyDescription() == null) {
                System.out.println("Received null parameter");
                return null;
            }
            if (info.getDataType() == 7) {
                return null;
            }
            WcmPropInfo newInfo = new WcmPropInfo(info.getSearchPropertyDescription());
            WcmUIComponent myComponent = this.m_controlFactory.getUIComponent(this.m_mainContainer, info.getSearchPropertyDescription(), info.getObjType());
            if (myComponent instanceof WcmSVCtrl) {
                this.m_dialogPanel.m_parent.getNetworkItem();
                WcmSitePrefs myPrefs = WcmDlgItemImpl.getSitePreferences();
                ((WcmSVCtrl)myComponent).setSitePreferences(myPrefs);
            }
            newInfo.setUIComponent(myComponent);
            newInfo.setWrappedComponent((Component)((Object)myComponent));
            return newInfo;
        }
        catch (Exception e) {
            System.out.println("caught error in createControlFactoryObj(): " + e.getMessage());
            return null;
        }
    }

    public WcmPropInfo getOperatorControlFactoryObj(WcmPropInfo info) {
        boolean includeIsEqualForOVP = false;
        try {
            if (info == null || this.m_mainContainer == null || info.getPropertyDescription() == null) {
                System.out.println("Received null parameter");
                return null;
            }
            int multiOS = this.m_dialogPanel.m_parent.getLibraryPanel().isMultiOS();
            if (this.m_dialogPanel.m_parent.isTemplateModeSelected() && multiOS < 2) {
                includeIsEqualForOVP = true;
            }
            WcmPropInfo newInfo = new WcmPropInfo(info.getSearchPropertyDescription());
            String[] propName = new String[]{"QueryOperatorDescriptions"};
            Properties prop = info.getSearchPropertyDescription().getProperties(propName);
            Iterator propIter = prop.iterator();
            if (propIter.hasNext()) {
                WcmUIComponent myComponent = this.m_controlFactory.getUIComponent(this.m_mainContainer, (Property)propIter.next(), (PropertyDescription)info.getSearchPropertyDescription(), includeIsEqualForOVP);
                newInfo.setOperatorUIComponent(myComponent);
                newInfo.setWrappedOperatorComponent((Component)((Object)myComponent));
            }
            return newInfo;
        }
        catch (Exception e) {
            System.out.println("caught error in getOperatorComboBox(): " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

