/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.SearchPropertyDescriptions;
import com.filenet.wcm.apps.client.search.base.WcmWrappedPD;
import com.filenet.wcm.apps.client.search.ui.WcmPropInfo;
import com.filenet.wcm.apps.client.util.api.PropertyUtil;
import com.filenet.wcm.toolkit.util.WcmString;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class WcmPropMap {
    private Map m_infoMap = Collections.synchronizedMap(new TreeMap());
    private Map m_nameMap = Collections.synchronizedMap(new TreeMap());
    private boolean m_filterNonSearchable = false;
    private boolean m_filterNonSelectable = false;
    private boolean m_filterObjectBased = false;
    private boolean m_foundDuplicateProperties = false;
    private Vector m_list = null;

    public WcmPropMap() {
    }

    public WcmPropMap(SearchPropertyDescriptions list, boolean filterNonSearchable, boolean filterNonSelectable, boolean filterObjectBased, boolean makeListUnique, int objType) {
        this.m_filterNonSearchable = filterNonSearchable;
        this.m_filterNonSelectable = filterNonSelectable;
        this.m_filterObjectBased = filterObjectBased;
        this.initialize(list, makeListUnique, objType);
    }

    public WcmPropMap(WcmPropMap orig) {
        if (orig != null) {
            this.m_infoMap = orig.m_infoMap;
            this.m_nameMap = orig.m_nameMap;
            this.m_filterNonSearchable = orig.m_filterNonSearchable;
            this.m_filterNonSelectable = orig.m_filterNonSelectable;
            this.m_filterObjectBased = orig.m_filterObjectBased;
            this.m_foundDuplicateProperties = orig.m_foundDuplicateProperties;
            this.m_list = orig.m_list;
        }
    }

    public void setPropDescList(SearchPropertyDescriptions list, boolean filterNonSearchable, boolean filterNonSelectable, boolean filterObjectBased, boolean makeListUnique, int objType) {
        this.m_filterNonSearchable = filterNonSearchable;
        this.m_filterNonSelectable = filterNonSelectable;
        this.m_filterObjectBased = filterObjectBased;
        this.initialize(list, makeListUnique, objType);
    }

    public void createIntersectedList(SearchPropertyDescriptions list, SearchPropertyDescriptions Doclist, SearchPropertyDescriptions Folderlist, SearchPropertyDescriptions CustomObjectlist, boolean filterNonSearchable, boolean filterNonSelectable, boolean filterObjectBased, int[] nObjType) {
        if (list == null || nObjType == null || nObjType.length < 2) {
            return;
        }
        if (nObjType.length == 2) {
            if (nObjType[0] == 1 && nObjType[1] == 2) {
                this.createIntersectedList(Doclist, Folderlist, filterNonSearchable, filterNonSelectable, filterObjectBased);
            } else if (nObjType[0] == 1 && nObjType[1] == 15) {
                this.createIntersectedList(Doclist, CustomObjectlist, filterNonSearchable, filterNonSelectable, filterObjectBased);
            } else if (nObjType[0] == 2 && nObjType[1] == 15) {
                this.createIntersectedList(Folderlist, CustomObjectlist, filterNonSearchable, filterNonSelectable, filterObjectBased);
            }
            return;
        }
        if (nObjType.length == 3) {
            this.createIntersectedList(Doclist, Folderlist, CustomObjectlist, filterNonSearchable, filterNonSelectable, filterObjectBased);
        }
    }

    public void createIntersectedList(SearchPropertyDescriptions list1, SearchPropertyDescriptions list2, boolean filterNonSearchable, boolean filterNonSelectable, boolean filterObjectBased) {
        SearchPropertyDescription curProp2 = null;
        try {
            if (list1 != null && list2 != null) {
                this.m_infoMap.clear();
                this.m_nameMap.clear();
                this.m_list = new Vector();
                for (SearchPropertyDescription curProp2 : list1) {
                    WcmPropInfo info = new WcmPropInfo(curProp2);
                    if (filterNonSearchable && !info.getIsSearchable() || filterNonSelectable && !info.getIsSelectable() || filterObjectBased && info.getDataType() == 7 || !this.FindSearchProp(curProp2, list2)) continue;
                    this.m_nameMap.put(curProp2.getName(), curProp2.getId());
                    this.m_infoMap.put(curProp2.getId(), info);
                    this.m_list.add(new WcmWrappedPD(curProp2, 0));
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in createIntersectedList(): " + e.getMessage());
        }
    }

    public void createIntersectedList(SearchPropertyDescriptions list1, SearchPropertyDescriptions list2, SearchPropertyDescriptions list3, boolean filterNonSearchable, boolean filterNonSelectable, boolean filterObjectBased) {
        SearchPropertyDescription curProp2 = null;
        try {
            if (list1 != null && list2 != null && list3 != null) {
                this.m_infoMap.clear();
                this.m_nameMap.clear();
                this.m_list = new Vector();
                for (SearchPropertyDescription curProp2 : list1) {
                    WcmPropInfo info = new WcmPropInfo(curProp2);
                    if (filterNonSearchable && !info.getIsSearchable() || filterNonSelectable && !info.getIsSelectable() || filterObjectBased && info.getDataType() == 7 || !this.FindSearchProp(curProp2, list2) || !this.FindSearchProp(curProp2, list3)) continue;
                    this.m_nameMap.put(curProp2.getName(), curProp2.getId());
                    this.m_infoMap.put(curProp2.getId(), info);
                    this.m_list.add(new WcmWrappedPD(curProp2, 0));
                }
                this.removeDuplicates();
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in createIntersectedList(): " + e.getMessage());
        }
    }

    private boolean FindSearchProp(SearchPropertyDescription theProp, SearchPropertyDescriptions list) {
        if (list == null || theProp == null) {
            return false;
        }
        try {
            for (SearchPropertyDescription curProp : list) {
                String propName1 = theProp.getName();
                String propName2 = curProp.getName();
                if (propName1 == null || propName2 == null || propName1.compareToIgnoreCase(propName2) != 0) continue;
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in FindSearchProp(): " + e.getMessage());
        }
        return false;
    }

    public void createUnionList(SearchPropertyDescriptions docList, SearchPropertyDescriptions folderList, SearchPropertyDescriptions customObjList, boolean[] objType, boolean filterNonSearchable, boolean filterNonSelectable, boolean filterObjectBased, boolean makeListUnique) {
        try {
            this.m_infoMap.clear();
            this.m_nameMap.clear();
            this.m_list = new Vector();
            if (objType[0]) {
                this.addToUnion(docList, 1, filterNonSearchable, filterNonSelectable, filterObjectBased, makeListUnique);
            }
            if (objType[1]) {
                this.addToUnion(folderList, 2, filterNonSearchable, filterNonSelectable, filterObjectBased, makeListUnique);
            }
            if (objType[2]) {
                this.addToUnion(customObjList, 15, filterNonSearchable, filterNonSelectable, filterObjectBased, makeListUnique);
            }
            this.m_list = PropertyUtil.sort(this.m_list);
            int nObjTypeCount = 0;
            if (objType[0]) {
                ++nObjTypeCount;
            }
            if (objType[1]) {
                ++nObjTypeCount;
            }
            if (objType[2]) {
                ++nObjTypeCount;
            }
            this.removeDuplicates(nObjTypeCount);
        }
        catch (Exception e) {
            System.out.println("Caught error in createUnionList(): " + e.getMessage());
        }
    }

    private void addToUnion(SearchPropertyDescriptions list, int objType, boolean filterNonSearchable, boolean filterNonSelectable, boolean filterObjectBased, boolean makeListUnique) {
        try {
            if (list != null) {
                for (SearchPropertyDescription prop : list) {
                    WcmPropInfo info = new WcmPropInfo(prop);
                    if (filterNonSearchable && !info.getIsSearchable() || filterNonSelectable && !info.getIsSelectable() || filterObjectBased && info.getDataType() == 7) continue;
                    this.m_infoMap.put(prop.getId(), info);
                    WcmWrappedPD wProp = new WcmWrappedPD(prop, objType);
                    if (this.m_nameMap.containsKey(prop.getName())) {
                        this.m_foundDuplicateProperties = true;
                        this.m_list.add(wProp);
                        continue;
                    }
                    this.m_nameMap.put(prop.getName(), prop.getId());
                    this.m_list.add(wProp);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in addToUnion(): " + e.getMessage());
        }
    }

    private void removeDuplicates(int nObjTypeCnt) {
        WcmWrappedPD prev2 = null;
        WcmWrappedPD prev = null;
        WcmWrappedPD curr2 = null;
        if (this.m_list == null) {
            return;
        }
        try {
            if (nObjTypeCnt < 3) {
                Iterator it = this.m_list.iterator();
                while (it.hasNext()) {
                    curr2 = (WcmWrappedPD)it.next();
                    if (prev != null && WcmString.compareIgnoreCase(curr2.getName(), prev.getName()) == 0) {
                        prev.setSourceObjType(0);
                        it.remove();
                        continue;
                    }
                    prev = curr2;
                }
            } else if (nObjTypeCnt == 3) {
                for (WcmWrappedPD curr2 : this.m_list) {
                    if (prev != null && prev2 != null && WcmString.compareIgnoreCase(curr2.getName(), prev.getName()) == 0 && WcmString.compareIgnoreCase(curr2.getName(), prev2.getName()) == 0) {
                        curr2.setSourceObjType(0);
                        prev2.setIsCommonProp(true);
                        prev.setIsCommonProp(true);
                    }
                    prev2 = prev;
                    prev = curr2;
                }
                Iterator it = this.m_list.iterator();
                while (it.hasNext()) {
                    curr2 = (WcmWrappedPD)it.next();
                    if (!curr2.getIsCommonProp()) continue;
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in removeDuplicates(): " + e.getMessage());
        }
    }

    private void removeDuplicates() {
        WcmWrappedPD prev = null;
        WcmWrappedPD curr = null;
        try {
            if (this.m_list != null) {
                Iterator it = this.m_list.iterator();
                while (it.hasNext()) {
                    curr = (WcmWrappedPD)it.next();
                    if (prev != null && WcmString.compareIgnoreCase(curr.getName(), prev.getName()) == 0) {
                        prev.setSourceObjType(0);
                        it.remove();
                        continue;
                    }
                    prev = curr;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error in removeDuplicates(): " + e.getMessage());
        }
    }

    private void initialize(SearchPropertyDescriptions list, boolean makeListUnique, int objType) {
        try {
            if (list != null) {
                this.m_infoMap.clear();
                this.m_nameMap.clear();
                this.m_list = new Vector();
                for (SearchPropertyDescription prop : list) {
                    WcmPropInfo info = new WcmPropInfo(prop);
                    if (this.m_filterNonSearchable && !info.getIsSearchable() || this.m_filterNonSelectable && !info.getIsSelectable() || this.m_filterObjectBased && info.getDataType() == 7) continue;
                    this.m_infoMap.put(prop.getId(), info);
                    WcmWrappedPD wProp = new WcmWrappedPD(prop, objType);
                    if (this.m_nameMap.containsKey(prop.getName())) {
                        this.m_foundDuplicateProperties = true;
                        if (makeListUnique) continue;
                        this.m_list.add(wProp);
                        continue;
                    }
                    this.m_nameMap.put(prop.getName(), prop.getId());
                    this.m_list.add(wProp);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in initialize(): " + e.getMessage());
        }
    }

    public Vector getSearchPropertyDescriptions() {
        return this.m_list;
    }

    public WcmPropInfo getPropInfoBySymName(String symbolicName) {
        try {
            if (symbolicName.length() > 0) {
                String id = (String)this.m_nameMap.get(symbolicName);
                if (id == null) {
                    return null;
                }
                WcmPropInfo info = (WcmPropInfo)this.m_infoMap.get(id);
                if (info != null) {
                    return new WcmPropInfo(info);
                }
            }
        }
        catch (Exception e) {
            System.out.println("error in getPropInfoBySymName(): " + e.getMessage());
        }
        return null;
    }

    public String toString() {
        String retStr = new String();
        retStr = retStr + new Boolean(this.m_filterNonSearchable).toString() + "; ";
        retStr = retStr + new Boolean(this.m_filterNonSelectable).toString() + "; ";
        retStr = retStr + new Boolean(this.m_filterObjectBased).toString();
        return retStr;
    }

    public boolean foundDuplicates() {
        return this.m_foundDuplicateProperties;
    }
}

