/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.PropertyDescription;
import com.filenet.wcm.api.PropertyNotFoundException;
import com.filenet.wcm.api.SearchPropertyDescription;
import com.filenet.wcm.api.User;
import com.filenet.wcm.apps.client.util.BooleanRef;
import com.filenet.wcm.apps.client.util.ISODateUtil;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmComboBox;
import com.filenet.wcm.toolkit.client.ui.ctrlf.WcmUIComponent;
import com.filenet.wcm.toolkit.client.ui.security.WcmUserGroupItem;
import com.filenet.wcm.toolkit.client.util.WcmDate;
import com.filenet.wcm.toolkit.util.WcmException;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;

public class WcmPropInfo {
    private SearchPropertyDescription m_sPropDesc = null;
    private WcmUIComponent m_uiComponent = null;
    private Component m_wrappedComponent = null;
    private WcmUIComponent m_operatorUIComponent = null;
    private Component m_wrappedOperatorComponent = null;
    private String m_label = null;
    private boolean m_isSearchable = false;
    private boolean m_isSelectable = false;
    private boolean m_isOrderable = false;
    private boolean m_isHidden = false;
    private int m_dataType = 0;
    private int m_sourceObjType = 1;
    private boolean m_isCommonProp = false;
    private boolean m_isOVP = false;

    public WcmPropInfo() {
    }

    public WcmPropInfo(SearchPropertyDescription propDesc) {
        try {
            this.m_sPropDesc = propDesc;
            this.initProperties();
        }
        catch (Exception e) {
            System.out.println("caught error in WcmPropInfo() constructor: " + e.getMessage());
        }
    }

    public WcmPropInfo(WcmPropInfo orig) {
        if (orig != null) {
            this.m_sPropDesc = orig.m_sPropDesc;
            this.m_uiComponent = orig.m_uiComponent;
            this.m_wrappedComponent = orig.m_wrappedComponent;
            this.m_operatorUIComponent = orig.m_operatorUIComponent;
            this.m_wrappedOperatorComponent = orig.m_wrappedOperatorComponent;
            this.m_dataType = orig.m_dataType;
            this.m_isSearchable = orig.m_isSearchable;
            this.m_isSelectable = orig.m_isSelectable;
            this.m_isOrderable = orig.m_isOrderable;
            this.m_isHidden = orig.m_isHidden;
            this.m_label = orig.m_label;
            this.m_sourceObjType = orig.m_sourceObjType;
            this.m_isCommonProp = orig.m_isCommonProp;
            this.m_isOVP = orig.m_isOVP;
        }
    }

    public void setPropertyDescription(SearchPropertyDescription propDesc) {
        try {
            this.m_sPropDesc = propDesc;
            this.initProperties();
        }
        catch (Exception e) {
            System.out.println("caught error in setPropertyDescription(): " + e.getMessage());
        }
    }

    public SearchPropertyDescription getSearchPropertyDescription() {
        return this.m_sPropDesc;
    }

    public PropertyDescription getPropertyDescription() {
        return this.m_sPropDesc;
    }

    public void setUIComponent(WcmUIComponent comp) {
        this.m_uiComponent = comp;
    }

    public WcmUIComponent getUIComponent() {
        return this.m_uiComponent;
    }

    public void setObjType(int objType) {
        this.m_sourceObjType = objType;
    }

    public int getObjType() {
        return this.m_sourceObjType;
    }

    public void setWrappedComponent(Component comp) {
        this.m_wrappedComponent = comp;
    }

    public Component getWrappedComponent() {
        return this.m_wrappedComponent;
    }

    public void setOperatorUIComponent(WcmUIComponent comp) {
        this.m_operatorUIComponent = comp;
    }

    public WcmUIComponent getOperatorUIComponent() {
        return this.m_operatorUIComponent;
    }

    public void setWrappedOperatorComponent(Component comp) {
        this.m_wrappedOperatorComponent = comp;
    }

    public Component getWrappedOperatorComponent() {
        return this.m_wrappedOperatorComponent;
    }

    public void setIsCommonCond(boolean isCommonCond) {
        this.m_isCommonProp = isCommonCond;
    }

    public boolean getIsCommonCond() {
        return this.m_isCommonProp;
    }

    public void setIsOVP(boolean isOVP) {
        this.m_isOVP = isOVP;
    }

    public boolean getIsOVP() {
        return this.m_isOVP;
    }

    public void setOperator(Object value) throws WcmException {
        if (this.m_operatorUIComponent == null) {
            throw new WcmException("client.WcmPropInfo.nullUIComponent", "Cannot set the value until the UI component is created.");
        }
        try {
            this.m_operatorUIComponent.setValue(value);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmPropInfo.setValueFailed", "Exception occurred in setValue(): {0}", (Object)e.getMessage());
        }
    }

    public Object getOperator() {
        if (this.m_operatorUIComponent == null) {
            return new String("");
        }
        try {
            return this.m_operatorUIComponent.getValue();
        }
        catch (Exception e) {
            return new String("");
        }
    }

    private Object setConvertStringValueToObject(String inValue) throws WcmException {
        Object outValue = null;
        if (this.m_dataType == 6) {
            if (this.m_label.compareToIgnoreCase(WcmResourceString.s_versionStatusDisplayName) == 0) {
                outValue = inValue;
            } else {
                try {
                    Integer intValue = new Integer(inValue);
                    outValue = intValue;
                }
                catch (Exception e) {
                    outValue = inValue;
                }
            }
        } else if (this.m_dataType == 4) {
            Double dblValue = new Double(inValue);
            outValue = dblValue;
        } else if (this.m_dataType == 2) {
            Boolean boolValue = new Boolean(inValue);
            outValue = boolValue;
        } else if (this.m_dataType == 3) {
            BooleanRef dateOnly = new BooleanRef();
            WcmDate w3cDate = new WcmDate(ISODateUtil.convertW3CDateToDate(inValue, dateOnly));
            w3cDate.setUseDateOnly(dateOnly.getBoolVal());
            outValue = w3cDate;
        } else {
            outValue = inValue;
        }
        return outValue;
    }

    public void setValue(Object value) throws WcmException {
        if (this.m_uiComponent == null) {
            throw new WcmException("client.WcmPropInfo.nullUIComponent", "Cannot set the value until the UI component is created.");
        }
        try {
            if (value instanceof String) {
                value = this.setConvertStringValueToObject((String)value);
            }
            if (value != null) {
                this.m_uiComponent.setValue(value);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmPropInfo.setValueFailed", "Exception occurred in setValue(): {0}", (Object)e.getMessage());
        }
    }

    public Object getDisplayValue() {
        if (this.m_uiComponent == null) {
            return new String("");
        }
        if (this.m_label.compareToIgnoreCase(WcmResourceString.s_versionStatusDisplayName) == 0) {
            Object objVal = this.m_uiComponent.getValue();
            if (objVal instanceof Integer) {
                Integer intVal = (Integer)objVal;
                switch (intVal) {
                    case 1: {
                        return new String(WcmResourceString.s_versionStatusReleased);
                    }
                    case 2: {
                        return new String(WcmResourceString.s_versionStatusInProcess);
                    }
                    case 3: {
                        return new String(WcmResourceString.s_versionStatusReserved);
                    }
                    case 4: {
                        return new String(WcmResourceString.s_versionStatusSuperseded);
                    }
                }
                return objVal;
            }
            return objVal;
        }
        try {
            if (this.m_uiComponent instanceof WcmComboBox) {
                return ((WcmComboBox)this.m_uiComponent).getDisplayValue();
            }
            return this.m_uiComponent.getValue();
        }
        catch (Exception e) {
            return new String("");
        }
    }

    public String getStringValue() {
        String stringValue = null;
        try {
            Object value = this.getValue();
            stringValue = value instanceof Integer ? ((Integer)value).toString() : (value instanceof Double ? ((Double)value).toString() : (value instanceof Boolean ? ((Boolean)value).toString() : (value instanceof Date ? DateFormat.getInstance().format((Date)value) : (value instanceof User ? ((User)value).getPropertyStringValue("ShortName") : (value instanceof WcmUserGroupItem ? ((WcmUserGroupItem)value).getShortName() : (String)value)))));
        }
        catch (Exception e) {
            System.out.println("Error in WcmPropInfo::getStringValue(): " + e.getMessage());
        }
        return stringValue;
    }

    public Object getValue() {
        if (this.m_uiComponent == null) {
            return new String("");
        }
        try {
            if (this.m_dataType == 3) {
                WcmDate w3cDate = null;
                Object componentValue = this.m_uiComponent.getValue();
                if (componentValue instanceof Date) {
                    w3cDate = new WcmDate((Date)componentValue);
                } else if (componentValue instanceof WcmDate) {
                    w3cDate = (WcmDate)componentValue;
                } else {
                    throw new WcmException("client.WcmPropInfo.invalidObject", "Control factory returned an unknown object");
                }
                return ISODateUtil.convertDateToW3CDate(w3cDate.getDate(), w3cDate.getUseDateOnly());
            }
            return this.m_uiComponent.getValue();
        }
        catch (Exception e) {
            return new String("");
        }
    }

    public String toString() {
        String retStr = new String();
        retStr = retStr + this.m_label + "; ";
        if (this.m_operatorUIComponent != null) {
            retStr = retStr + this.m_operatorUIComponent.toString() + "; ";
        }
        if (this.m_uiComponent != null) {
            retStr = retStr + this.m_uiComponent.toString();
        }
        return retStr;
    }

    public String isValid() {
        try {
            WcmException result = null;
            if (this.m_uiComponent != null) {
                result = this.m_uiComponent.validateValue();
            }
            if (result == null) {
                return null;
            }
            return result.getMessage();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initProperties() {
        try {
            this.m_label = this.m_sPropDesc.getPropertyStringValue("DisplayName");
            this.m_dataType = this.m_sPropDesc.getPropertyIntValue("DataType");
            this.m_isSearchable = this.m_sPropDesc.getPropertyBooleanValue("IsSearchable");
            this.m_isSelectable = this.m_sPropDesc.getPropertyBooleanValue("IsSelectable");
            this.m_isOrderable = this.m_sPropDesc.getPropertyBooleanValue("IsOrderable");
            try {
                this.m_isHidden = this.m_sPropDesc.getPropertyBooleanValue("IsHidden");
            }
            catch (PropertyNotFoundException e) {}
        }
        catch (Exception e) {
            System.out.println("Error thrown in WcmPropInfo::initProperties(): " + e.getMessage());
        }
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getName() {
        return this.m_sPropDesc.getName();
    }

    public boolean getIsSearchable() {
        return this.m_isSearchable;
    }

    public boolean getIsSelectable() {
        return this.m_isSelectable;
    }

    public boolean getIsHidden() {
        return this.m_isHidden;
    }

    public boolean getIsOrderable() {
        return this.m_isOrderable;
    }

    public int getDataType() {
        return this.m_dataType;
    }
}

