/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.apps.client.search.base.WcmCondition;
import com.filenet.wcm.apps.client.search.ui.WcmColumnHeader;
import com.filenet.wcm.apps.client.search.ui.WcmSearchFolder;
import com.filenet.wcm.apps.client.search.ui.WcmSubClass;
import com.filenet.wcm.toolkit.server.util.xml.WcmXMLUtil;
import com.filenet.wcm.toolkit.util.WcmXMLEncode;
import java.io.StringReader;
import java.io.StringWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WcmPasteUtil {
    private static final String PASTESTRING = "paste_string";
    private static final String SDELEMENT = "sdelement";
    private static final String SDATTRIBUTE_NAME = "name";
    private static final String FOLDERS = "wcmfolders";
    private static final String CONDITIONS = "conditions";
    private static final String SEARCHRESULT = "searchresult";
    private static final String SUBCLASS = "subclass";
    Document document = null;

    public String makeString(Object[] objSet) {
        StringBuffer result = new StringBuffer();
        try {
            if (objSet == null) {
                return new String("");
            }
            Element rootNode = null;
            Node sdElemNode = null;
            this.document = WcmXMLUtil.getNewDocument();
            rootNode = this.document.createElement(PASTESTRING);
            this.document.appendChild(rootNode);
            for (int i = 0; i < objSet.length; ++i) {
                Object obj = objSet[i];
                sdElemNode = this.createNodeNamed(rootNode, SDELEMENT);
                if (obj instanceof WcmSearchFolder) {
                    this.setNodeAttribute(sdElemNode, SDATTRIBUTE_NAME, FOLDERS);
                } else if (obj instanceof WcmCondition) {
                    this.setNodeAttribute(sdElemNode, SDATTRIBUTE_NAME, CONDITIONS);
                } else if (obj instanceof WcmColumnHeader) {
                    this.setNodeAttribute(sdElemNode, SDATTRIBUTE_NAME, SEARCHRESULT);
                } else if (obj instanceof WcmSubClass) {
                    this.setNodeAttribute(sdElemNode, SDATTRIBUTE_NAME, SUBCLASS);
                }
                WcmXMLEncode.XmlEncodeResult encodedData = WcmXMLEncode.encodeForXml(obj.toString().trim(), null);
                sdElemNode.appendChild(this.document.createTextNode(encodedData.outString));
            }
            StringWriter xmlStringWriter = new StringWriter();
            WcmXMLUtil.writeXML(xmlStringWriter, (Node)this.document);
            result.append(xmlStringWriter.toString());
        }
        catch (Exception e) {
            return new String("");
        }
        return result.toString();
    }

    public Object[] parseString(String xmlString) {
        Object[] objSet = null;
        if (xmlString == null || xmlString.length() == 0) {
            return null;
        }
        try {
            Element rootNode = null;
            InputSource inputSrc = new InputSource(new StringReader(xmlString));
            this.document = WcmXMLUtil.getDocumentFromString(xmlString);
            rootNode = this.document.getDocumentElement();
            if (rootNode == null) {
                return null;
            }
            Node node = null;
            NodeList nodeList = null;
            String attributeName = null;
            nodeList = rootNode.getChildNodes();
            if (nodeList.getLength() == 0) {
                return null;
            }
            objSet = new Object[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object newItem;
                node = nodeList.item(i);
                NamedNodeMap al = node.getAttributes();
                if (al != null) {
                    attributeName = al.item(0).getNodeValue();
                }
                String xmlText = node.getFirstChild().getNodeValue();
                if (attributeName.compareToIgnoreCase(CONDITIONS) == 0) {
                    newItem = new WcmCondition();
                    ((WcmCondition)newItem).setContent(xmlText);
                    ((WcmCondition)newItem).initializePropertyID();
                    objSet[i] = newItem;
                    continue;
                }
                if (attributeName.compareToIgnoreCase(SEARCHRESULT) == 0) {
                    newItem = new WcmColumnHeader();
                    ((WcmColumnHeader)newItem).setContent(xmlText);
                    ((WcmColumnHeader)newItem).initializePropertyID();
                    objSet[i] = newItem;
                    continue;
                }
                if (attributeName.compareToIgnoreCase(FOLDERS) == 0) {
                    newItem = new WcmSearchFolder();
                    ((WcmSearchFolder)newItem).setContent(xmlText);
                    objSet[i] = newItem;
                    continue;
                }
                if (attributeName.compareToIgnoreCase(SUBCLASS) != 0) continue;
                newItem = new WcmSubClass();
                ((WcmSubClass)newItem).setContent(xmlText);
                ((WcmSubClass)newItem).initializePropertyID();
                objSet[i] = newItem;
            }
        }
        catch (Exception e) {
            System.out.println("Error in parseString: " + e.getMessage());
        }
        return objSet;
    }

    private Node createNodeNamed(Node parentNode, String name) {
        Element newNode = this.document.createElement(name);
        parentNode.appendChild(newNode);
        return newNode;
    }

    private void setNodeAttribute(Node node, String attrName, String attrValue) {
        NamedNodeMap al = node.getAttributes();
        if (al != null) {
            Attr attrNode = this.document.createAttribute(attrName);
            attrNode.setNodeValue(attrValue);
            al.setNamedItem(attrNode);
        }
    }
}

