/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.api.ClassDescriptions;
import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.ObjectStore;
import com.filenet.wcm.api.ObjectStores;
import com.filenet.wcm.api.Search;
import com.filenet.wcm.api.SearchClassInfo;
import com.filenet.wcm.apps.client.search.ui.BidiComboBox;
import com.filenet.wcm.apps.client.search.ui.WcmClassCellRenderer;
import com.filenet.wcm.apps.client.search.ui.WcmClassDescComboBox;
import com.filenet.wcm.apps.client.search.ui.WcmFileOpenEvent;
import com.filenet.wcm.apps.client.search.ui.WcmGenericTablePanel;
import com.filenet.wcm.apps.client.search.ui.WcmObjectTypeModel;
import com.filenet.wcm.apps.client.search.ui.WcmPasteUtil;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSubClass;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.apps.client.util.api.VerboseLibrary;
import com.filenet.wcm.toolkit.client.ui.common.WcmResourceString;
import filenet.vw.toolkit.utils.datatransfer.VWTransferable;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class WcmObjectTypePanel
extends WcmGenericTablePanel
implements ActionListener,
ListSelectionListener,
ClipboardOwner {
    public static final int DOCUMENT = 0;
    public static final int FOLDER = 1;
    public static final int CUSTOM_OBJECT = 2;
    private static final int VIEW_COL_SIZE = 60;
    private static final int SUBCLASS_COL_SIZE = 120;
    private static final String DOCUMENT_XML = "document";
    private static final String FOLDER_XML = "folder";
    private static final String CUSTOMOBJECT_XML = "customobject";
    private JPanel m_tablePanel = new JPanel();
    private JScrollPane m_tableScrollPane = null;
    private WcmObjectTypeModel m_model;
    private WcmClassDescComboBox m_classCB = new WcmClassDescComboBox();
    private JPanel m_helperBtnPanel = new JPanel();
    private AbstractButton m_addButton = null;
    private AbstractButton m_removeButton = null;
    private AbstractButton m_upButton = null;
    private AbstractButton m_downButton = null;
    private JCheckBox m_documentBox = new JCheckBox(WcmResourceString.s_document, true);
    private JCheckBox m_folderBox = new JCheckBox(WcmResourceString.s_folder);
    private JCheckBox m_customObjBox = new JCheckBox(WcmResourceString.s_customObject);
    private JButton m_updateList = new JButton(WcmResource.s_subclassBtnStr);
    private Search m_searchObj = null;
    private ObjectStores m_libsList = null;
    private boolean m_subClassesChanged = false;
    private boolean m_objTypeChanged = false;
    private Vector m_compareLibsList = null;
    private boolean[] m_selObjTypes = new boolean[3];
    private boolean m_enableCustomObjs = false;
    private ImageIcon m_customObjIcon = null;
    private ClassDescriptions m_classes = null;

    public WcmObjectTypePanel(WcmSearchAuthCore parent) {
        this.m_parent = parent;
        this.setLayout(new BorderLayout());
        this.setInstrText(WcmResource.s_objTypeInstrStr + WcmResource.s_objTypeInstr2Str);
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.add(new JLabel(WcmResource.s_objectTypeStr));
        checkboxPanel.add(this.m_documentBox);
        checkboxPanel.add(this.m_folderBox);
        checkboxPanel.add(this.m_customObjBox);
        checkboxPanel.add(this.m_updateList);
        this.m_selObjTypes[0] = true;
        this.add("First", this.m_instrPanel);
        this.add("Before", new JPanel());
        this.add("After", new JPanel());
        this.add("Last", new JPanel());
        this.m_helperBtnPanel.setLayout(new FlowLayout(this.m_parent.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT ? 2 : 0));
        this.m_addButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/InsertRow24.gif", WcmResource.s_insertRow, false, this);
        this.m_removeButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/DeleteRow24.gif", WcmResource.s_deleteRow, false, this);
        this.m_upButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/Up24.gif", WcmResource.s_upTooltip, false, this);
        this.m_downButton = this.m_parent.createPanelButton(this.m_helperBtnPanel, "action/button/Down24.gif", WcmResource.s_downTooltip, false, this);
        this.m_addButton.setEnabled(false);
        this.m_removeButton.setEnabled(false);
        this.m_upButton.setEnabled(false);
        this.m_downButton.setEnabled(false);
        JPanel northPanel = new JPanel(new GridBagLayout());
        GridBagConstraints standard = new GridBagConstraints();
        standard.gridx = 0;
        standard.gridy = 0;
        standard.anchor = 21;
        standard.weightx = 1.0;
        northPanel.add((Component)checkboxPanel, standard);
        standard.gridx = 2;
        standard.gridy = 1;
        standard.anchor = 22;
        northPanel.add((Component)this.m_helperBtnPanel, standard);
        this.m_tablePanel.setLayout(new BorderLayout());
        this.m_tablePanel.add("First", northPanel);
        this.m_model = new WcmObjectTypeModel(parent);
        this.m_table = new VWTable((TableModel)this.m_model);
        this.m_tableScrollPane = new JScrollPane((Component)this.m_table);
        this.m_tablePanel.add("Center", this.m_tableScrollPane);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.m_table.setGridColor(Color.gray);
        this.m_table.setShowGrid(true);
        this.m_table.setRowHeight(this.m_table.getRowHeight() + 2);
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(0);
        if (tcCol != null) {
            tcCol.setCellEditor(new DefaultCellEditor(this.getViewComboBox()));
            Integer width = new Integer(WcmResource.s_viewColWidth);
            if (width > 0) {
                tcCol.setPreferredWidth(width);
            } else {
                tcCol.setPreferredWidth(60);
            }
        }
        this.setupSubClassColumn();
        this.add("Center", this.m_tablePanel);
        this.m_model.addTableModelListener(this);
        this.m_table.addKeyListener((KeyListener)this);
        this.m_documentBox.addActionListener(this);
        this.m_folderBox.addActionListener(this);
        this.m_customObjBox.addActionListener(this);
        this.m_updateList.addActionListener(this);
        this.updateSubClasses();
    }

    public void setupSubClassColumn() {
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(1);
        if (tcCol != null) {
            TableCellEditor ceditor = tcCol.getCellEditor();
            if (ceditor != null) {
                ceditor.stopCellEditing();
            }
            WcmClassCellRenderer pCellRenderer = this.m_classCB.getClassCellRenderer();
            pCellRenderer.setVerticalAlignment(1);
            pCellRenderer.setBackground(new Color(255, 255, 255));
            pCellRenderer.setOpaque(true);
            pCellRenderer.applyComponentOrientation(this.m_parent.getComponentOrientation());
            tcCol.setCellRenderer(pCellRenderer);
            this.m_classCB.applyComponentOrientation(this.m_parent.getComponentOrientation());
            tcCol.setCellEditor(new DefaultCellEditor(this.m_classCB));
            tcCol.setPreferredWidth(120);
        }
    }

    public JComboBox getViewComboBox() {
        BidiComboBox pComboBox = null;
        try {
            pComboBox = new BidiComboBox(this.m_parent.getComponentOrientation());
            pComboBox.addItem(WcmResource.s_editableStr);
            pComboBox.addItem(WcmResource.s_readOnlyStr);
            pComboBox.addItem(WcmResource.s_hiddenStr);
        }
        catch (Exception ex) {
            System.out.println("Failed to setup the View combobox: " + ex.getMessage());
        }
        return pComboBox;
    }

    public void clear() {
        this.clearObjectType();
        this.clearTable();
    }

    private void clearObjectType() {
        this.setObjectType(true, false, false);
    }

    public void setObjectType(boolean setDocuments, boolean setFolders, boolean setCOs) {
        this.m_selObjTypes[0] = setDocuments;
        this.m_selObjTypes[1] = setFolders;
        this.m_selObjTypes[2] = setCOs;
        this.m_documentBox.setSelected(setDocuments);
        this.m_folderBox.setSelected(setFolders);
        this.m_customObjBox.setSelected(setCOs);
        this.m_objTypeChanged = true;
    }

    private void clearTable() {
        this.stopEditing();
        this.m_model.clearModel();
        this.m_table.refreshUI();
        this.enableActions(false);
    }

    private void clearProperties() {
        this.m_parent.performClearProperties(false);
    }

    public void setSearchObject(Search searchObj) {
        this.m_searchObj = searchObj;
    }

    public void enableCustomObjs(boolean enable) {
        this.m_enableCustomObjs = enable;
        if (this.m_enableCustomObjs) {
            this.m_customObjBox.setVisible(true);
        } else {
            this.m_customObjBox.setVisible(false);
        }
    }

    public void removeBlankRows() {
        this.m_model.removeBlankRows();
    }

    public boolean haveSubClassesChanged() {
        return this.m_subClassesChanged;
    }

    public boolean hasObjectTypeChanged() {
        return this.m_objTypeChanged;
    }

    public void resetObjTypeChangedFlag(boolean val) {
        this.m_objTypeChanged = val;
    }

    public void doInsert() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int nRowIndex = this.m_table.getSelectedRow();
            this.m_table.clearSelection();
            if (nRowIndex >= 0 && nRowIndex < this.m_table.getRowCount()) {
                this.m_model.insertRow(nRowIndex);
                this.m_table.setRowSelectionInterval(nRowIndex, nRowIndex);
            } else {
                this.enableActions(false);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    private void copySelection(StringBuffer xmlStream) {
        try {
            int[] sz = this.m_table.getSelectedRows();
            if (sz.length > 0) {
                Object[] objSet = new Object[sz.length];
                for (int i = 0; i < sz.length; ++i) {
                    objSet[i] = this.m_model.getItemAt(sz[i]);
                }
                WcmPasteUtil pasteUtil = new WcmPasteUtil();
                String xmlString = pasteUtil.makeString(objSet);
                xmlStream.append(xmlString);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in copySelection(): " + e.getMessage());
        }
    }

    public void performCopy(boolean bDelete) {
        StringBuffer xmlStream = null;
        try {
            VWTransferable transferData;
            xmlStream = new StringBuffer();
            this.copySelection(xmlStream);
            if (bDelete) {
                this.performDelete();
            }
            if (xmlStream != null && (transferData = new VWTransferable(xmlStream.toString())) != null) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents((Transferable)transferData, this);
            }
            this.m_parent.enablePaste(true, 1);
        }
        catch (Exception e) {
            System.out.println("Error occurred in performCopy(): " + e.getMessage());
        }
    }

    public void performPaste() {
        Transferable transferData = null;
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = cb.getContents(this);
            if (contents != null && contents instanceof Transferable) {
                transferData = contents;
            }
            if (transferData == null) {
                return;
            }
            WcmPasteUtil pasteUtil = new WcmPasteUtil();
            String xmlString = (String)transferData.getTransferData(DataFlavor.stringFlavor);
            Object[] newItems = pasteUtil.parseString(xmlString);
            if (newItems != null && newItems.length > 0 && newItems[0] instanceof WcmSubClass) {
                int i;
                int[] rows = this.m_table.getSelectedRows();
                int sel = this.m_table.getSelectedRow();
                for (i = rows.length - 1; i >= 0; --i) {
                    this.m_model.deleteItem(rows[i]);
                }
                if (sel >= 0 && sel < this.m_table.getRowCount()) {
                    this.m_table.setRowSelectionInterval(sel, sel);
                }
                for (i = 0; i < newItems.length; ++i) {
                    int index = this.m_table.getSelectedRow();
                    this.m_model.insertRow(index);
                    WcmSubClass newItem = (WcmSubClass)newItems[i];
                    ClassDescription cDesc = (ClassDescription)this.m_classes.findByProperty("SymbolicName", 1, newItem.getClassName());
                    newItem.setClassDescription(cDesc);
                    this.m_model.setItemAt(newItem, index);
                    this.redrawSubClassComboBox(newItem);
                    this.redrawViewComboBox(newItem);
                    this.m_table.setRowSelectionInterval(index + 1, index + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in performPaste(): " + e.getMessage());
        }
    }

    private void redrawSubClassComboBox(WcmSubClass item) {
        DefaultCellEditor ceditor;
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(1);
        if (tcCol != null && (ceditor = (DefaultCellEditor)tcCol.getCellEditor()) != null) {
            JComboBox comp = (JComboBox)ceditor.getComponent();
            comp.getModel().setSelectedItem(item.getClassDescription());
        }
    }

    private void redrawViewComboBox(WcmSubClass item) {
        DefaultCellEditor ceditor;
        TableColumn tcCol = this.m_table.getColumnModel().getColumn(0);
        if (tcCol != null && (ceditor = (DefaultCellEditor)tcCol.getCellEditor()) != null) {
            JComboBox comp = (JComboBox)ceditor.getComponent();
            comp.getModel().setSelectedItem(item.getViewStr());
        }
    }

    public void performDelete() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            int sel = this.m_table.getSelectedRow();
            for (int i = rows.length - 1; i >= 0; --i) {
                this.m_model.deleteItem(rows[i]);
                if (rows[i] != this.m_model.getRowCount() - 1) continue;
                this.cancelRowEditing(rows[i]);
            }
            if (sel == this.m_table.getRowCount() - 1) {
                --sel;
            }
            if (sel >= 0 && sel < this.m_table.getRowCount()) {
                this.m_table.setRowSelectionInterval(sel, sel);
            } else {
                this.enableActions(false);
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in performDelete(): " + e.getMessage());
        }
    }

    public void doUp() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            if (rows[0] > 0) {
                this.m_table.removeRowSelectionInterval(rows[0], rows[rows.length - 1]);
                for (int i = 0; i < rows.length; ++i) {
                    this.m_model.moveUp(rows[i]);
                    this.m_table.addRowSelectionInterval(rows[i] - 1, rows[i] - 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public void doDown() {
        try {
            this.m_parent.stopEditing((JTable)this.m_table);
            int[] rows = this.m_table.getSelectedRows();
            if (rows[rows.length - 1] < this.m_table.getRowCount() - 2) {
                this.m_table.removeRowSelectionInterval(rows[0], rows[rows.length - 1]);
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.m_model.moveDown(rows[i]);
                    this.m_table.addRowSelectionInterval(rows[i] + 1, rows[i] + 1);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error: " + e.getMessage());
        }
    }

    public boolean[] getObjectType() {
        return this.m_selObjTypes;
    }

    public boolean isDocumentSet() {
        return this.m_selObjTypes[0];
    }

    public boolean isFolderSet() {
        return this.m_selObjTypes[1];
    }

    public boolean isCustomObjectSet() {
        return this.m_selObjTypes[2];
    }

    public Vector getSubClasses() {
        Vector<WcmSubClass> subClassList = new Vector<WcmSubClass>();
        try {
            for (int i = 1; i < this.m_model.getRowCount(); ++i) {
                subClassList.addElement(this.m_model.getItemAt(i - 1));
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmObjectType::getSubClasses(): " + e.getMessage());
        }
        return subClassList;
    }

    public void setSubClasses(Vector subClassList) {
        int rowCounter = 0;
        ClassDescription cDesc = null;
        try {
            if (this.m_classes == null) {
                this.updateSubClasses();
            }
            if (this.m_classes != null && subClassList != null) {
                for (WcmSubClass item : subClassList) {
                    cDesc = (ClassDescription)this.m_classes.findByProperty("SymbolicName", 1, item.getClassName());
                    if (cDesc == null) continue;
                    item.setClassDescription(cDesc);
                    this.m_model.insertRow(rowCounter);
                    this.m_model.setItemAt(item, rowCounter);
                    ++rowCounter;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmObjectTypePanel::setSubClasses(): " + e.getMessage());
        }
    }

    public ArrayList getSelectedClassDescs() {
        ArrayList<SearchClassInfo> subClassList = new ArrayList<SearchClassInfo>();
        try {
            for (int i = 1; i < this.m_model.getRowCount(); ++i) {
                WcmSubClass item = this.m_model.getItemAt(i - 1);
                if (item == null || item.isEmpty()) continue;
                ClassDescription obj = item.getClassDescription();
                subClassList.add(new SearchClassInfo(obj.getName(), false));
            }
        }
        catch (Exception e) {
            System.out.println("Caught error in WcmObjectType::getSelectedClassDescs(): " + e.getMessage());
        }
        this.m_subClassesChanged = false;
        return subClassList;
    }

    public void fileOpened(WcmFileOpenEvent event) {
        try {
            boolean[] type = event.getFile().getFromClause();
            if (type[2] && !this.m_enableCustomObjs) {
                JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), WcmResource.s_cantOpenCustObjSearch, WcmResource.s_searchAuthStr, 0);
                this.m_parent.performNewItemAction(false, true);
                type[2] = false;
            }
            this.setObjectType(type[0], type[1], type[2]);
            this.m_objTypeChanged = true;
            this.updateSubClasses();
            this.setSubClasses(event.getFile().getSubClasses());
            this.m_parent.updatePropertyList();
        }
        catch (Exception e) {
            System.out.println("Caught error in fileOpened: " + e.getMessage());
            this.m_parent.performNewItemAction(false, true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_addButton) {
            this.doInsert();
        } else if (event.getSource() == this.m_removeButton) {
            this.performDelete();
        } else if (event.getSource() == this.m_upButton) {
            this.doUp();
        } else if (event.getSource() == this.m_downButton) {
            this.doDown();
        } else if (event.getSource() == this.m_documentBox) {
            this.m_selObjTypes[0] = this.m_documentBox.isSelected();
            this.m_objTypeChanged = true;
        } else if (event.getSource() == this.m_folderBox) {
            this.m_selObjTypes[1] = this.m_folderBox.isSelected();
            this.m_objTypeChanged = true;
        } else if (event.getSource() == this.m_customObjBox) {
            this.m_selObjTypes[2] = this.m_customObjBox.isSelected();
            this.m_objTypeChanged = true;
        } else if (event.getSource() == this.m_updateList) {
            this.onUpdateObjType();
        }
    }

    private void onUpdateObjType() {
        if (!this.m_parent.askUserToSavePropertiesOrCancel(false)) {
            return;
        }
        this.clearTable();
        this.clearProperties();
        if (this.m_objTypeChanged) {
            this.updateSubClasses();
        }
    }

    private void updateSubClasses() {
        try {
            if (this.m_searchObj != null && this.m_libsList != null && !this.m_libsList.isEmpty()) {
                int objTypeCount = 0;
                for (int i = 0; i < 3; ++i) {
                    if (!this.m_selObjTypes[i]) continue;
                    ++objTypeCount;
                }
                int[] filter = new int[objTypeCount];
                int filterCount = 0;
                if (this.m_selObjTypes[0]) {
                    filter[filterCount++] = 1;
                }
                if (this.m_selObjTypes[1]) {
                    filter[filterCount++] = 2;
                }
                if (this.m_selObjTypes[2]) {
                    filter[filterCount++] = 15;
                }
                this.m_classes = this.m_parent.m_optionsRec.m_union ? this.m_searchObj.getClassDescriptions(this.m_libsList, "union", filter) : this.m_searchObj.getClassDescriptions(this.m_libsList, "intersection", filter);
                this.m_classCB.setClassDescriptions(this.m_classes);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.m_parent.getParentFrame(), e.getMessage(), WcmResource.s_searchAuthStr, 0);
        }
    }

    public void setSelectedLibs(Vector libs) {
        if (libs != null) {
            if (this.m_compareLibsList != null && this.m_compareLibsList.equals(libs)) {
                return;
            }
            this.m_compareLibsList = (Vector)libs.clone();
            this.m_libsList = ObjectFactory.getObjectStores();
            for (VerboseLibrary vLib : libs) {
                ObjectStore lib = vLib.getLibrary();
                if (lib == null) continue;
                this.m_libsList.add((Object)lib);
            }
            this.updateSubClasses();
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.enableActions(true);
    }

    private void cancelRowEditing(int rowIdx) {
        for (int column = 0; column < this.m_table.getColumnCount(); ++column) {
            TableCellEditor cellEditor;
            if (!this.m_table.isCellEditable(rowIdx, column) || (cellEditor = this.m_table.getCellEditor(rowIdx, column)) == null) continue;
            cellEditor.cancelCellEditing();
        }
    }

    private void enableActions(boolean enable) {
        this.m_addButton.setEnabled(enable);
        this.m_removeButton.setEnabled(enable);
        this.m_parent.enableCutCopyPaste(enable, 1);
        if (enable) {
            int[] rows = this.m_table.getSelectedRows();
            int realLast = this.m_table.getRowCount() - 2;
            if (rows.length > 0) {
                this.m_upButton.setEnabled(rows[0] > 0 & rows[0] <= realLast);
                this.m_downButton.setEnabled(rows[rows.length - 1] < realLast);
            }
        } else {
            this.m_upButton.setEnabled(false);
            this.m_downButton.setEnabled(false);
        }
    }

    public boolean rowSelected() {
        return this.m_table.getSelectedRow() >= 0;
    }

    public void tableChanged(TableModelEvent e) {
        this.m_subClassesChanged = true;
        super.tableChanged(e);
    }

    public void lostOwnership(Clipboard clipboard, Transferable content) {
    }
}

