/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.wcm.apps.client.search.ui;

import com.filenet.wcm.api.ClassDescription;
import com.filenet.wcm.apps.client.search.ui.WcmSearchAuthCore;
import com.filenet.wcm.apps.client.search.ui.WcmSubClass;
import com.filenet.wcm.apps.client.search.ui.resources.WcmResource;
import com.filenet.wcm.toolkit.util.WcmException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class WcmObjectTypeModel
extends AbstractTableModel {
    private final int NUM_COLUMNS = 2;
    public static final int VIEW_COL = 0;
    public static final int SUBCLASS_COL = 1;
    protected Vector m_rowData = null;
    protected int m_nRows = 0;
    private WcmSearchAuthCore m_grandParent = null;
    private String m_view = null;
    private String m_subClass = null;

    public WcmObjectTypeModel(WcmSearchAuthCore grandParent) {
        try {
            this.m_grandParent = grandParent;
            this.m_rowData = new Vector();
            ++this.m_nRows;
        }
        catch (Exception e) {
            System.out.println("An error occurred while constructing object: " + e.getMessage());
        }
    }

    public void clearModel() {
        this.m_rowData = new Vector();
        this.fireTableRowsDeleted(0, this.m_nRows);
        this.m_nRows = 0;
    }

    public void copyItem(int nRowIndex) throws WcmException {
        WcmSubClass fieldDef = null;
        WcmSubClass newFieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null && (newFieldDef = fieldDef) != null) {
                this.m_rowData.addElement(newFieldDef);
                ++this.m_nRows;
                nRowIndex = this.getRowCount() - 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjecttypeModel.errorInCopy", "An error occurred in copyItem(): {0}", (Object)e.getMessage());
        }
    }

    public void deleteItem(int nRowIndex) throws WcmException {
        WcmSubClass fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                --this.m_nRows;
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.errorInDelete", "An error occurred in deleteItem(): {0}", (Object)e.getMessage());
        }
    }

    public void insertRow(int nRowIndex) throws WcmException {
        try {
            WcmSubClass fieldDef = new WcmSubClass();
            fieldDef.initializePropertyID();
            if (fieldDef != null) {
                this.m_rowData.insertElementAt(fieldDef, nRowIndex);
                ++this.m_nRows;
                this.fireTableRowsInserted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.errorInInsert", "An error occurred in insertItem(): {0}", (Object)e.getMessage());
        }
    }

    public void moveUp(int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex <= 0 || nRowIndex > this.m_rowData.size() - 1) {
                return;
            }
            WcmSubClass movingRow = (WcmSubClass)this.m_rowData.get(nRowIndex);
            WcmSubClass upperRow = (WcmSubClass)this.m_rowData.get(nRowIndex - 1);
            this.m_rowData.setElementAt(movingRow, nRowIndex - 1);
            this.m_rowData.setElementAt(upperRow, nRowIndex);
            this.fireTableRowsUpdated(nRowIndex - 1, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.errorInMoveUp", "An error occurred in moveUp(): {0}", (Object)e.getMessage());
        }
    }

    public void moveDown(int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex >= this.m_rowData.size() - 1) {
                return;
            }
            WcmSubClass movingRow = (WcmSubClass)this.m_rowData.get(nRowIndex);
            WcmSubClass lowerRow = (WcmSubClass)this.m_rowData.get(nRowIndex + 1);
            this.m_rowData.setElementAt(movingRow, nRowIndex + 1);
            this.m_rowData.setElementAt(lowerRow, nRowIndex);
            this.fireTableRowsUpdated(nRowIndex, nRowIndex + 1);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.errorInMoveUp", "An error occurred in moveUp(): {0}", (Object)e.getMessage());
        }
    }

    protected void removeBlankRows() {
        try {
            if (this.m_rowData == null) {
                return;
            }
            WcmSubClass fieldDef = null;
            for (int i = this.m_rowData.size() - 1; i >= 0; --i) {
                fieldDef = this.getItemAt(i);
                if (!fieldDef.isEmpty()) continue;
                this.deleteItem(i);
            }
        }
        catch (Exception e) {
            System.out.println("Error occurred in WcmObjectTypeModel::removeBlankRows(): " + e.getMessage());
        }
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return WcmResource.s_viewStr;
            }
            case 1: {
                return WcmResource.s_subClassStr;
            }
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        WcmSubClass fieldDef = null;
        try {
            fieldDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (fieldDef != null) {
                        return fieldDef.getDisplayableViewStr();
                    }
                    return this.m_view;
                }
                case 1: {
                    if (fieldDef != null) {
                        return fieldDef.getClassDescription();
                    }
                    return this.m_subClass;
                }
            }
            return null;
        }
        catch (Exception e) {
            System.out.println("An error occurred in getValueAt(): " + e.getMessage());
            return null;
        }
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateView(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateSubClass(aValue, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("An error occurred in setValueAt(): " + e.getMessage());
        }
    }

    private void onUpdateView(Object aValue, int nRowIndex) throws WcmException {
        WcmSubClass fieldDef = null;
        try {
            if (aValue == null) {
                return;
            }
            fieldDef = this.getItemAt(nRowIndex);
            if (fieldDef != null) {
                fieldDef.setView(aValue.toString());
            } else {
                this.m_view = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.UpdateView", "An error occurred while in onUpdateView(): {0}", (Object)e.getMessage());
        }
    }

    private void onUpdateSubClass(Object aValue, int nRowIndex) throws WcmException {
        WcmSubClass fieldDef = null;
        String subClass = null;
        ClassDescription classDesc = null;
        try {
            if (aValue == null) {
                return;
            }
            if (aValue instanceof ClassDescription) {
                classDesc = (ClassDescription)aValue;
                subClass = classDesc.getPropertyStringValue("DisplayName");
            } else {
                System.out.println("Subclass is not of type ClassDescription");
            }
            if (this.m_grandParent.isSearchCriteriaModified() || this.m_grandParent.isFormatResultsModified()) {
                int retVal = JOptionPane.showConfirmDialog(this.m_grandParent.getParentFrame(), WcmResource.s_okToContinue, WcmResource.s_searchAuthStr, 2);
                if (retVal == 0) {
                    this.m_grandParent.performClearProperties(false);
                } else {
                    return;
                }
            }
            if ((fieldDef = this.getItemAt(nRowIndex)) != null) {
                fieldDef.setClassLabel(subClass);
                if (classDesc != null) {
                    fieldDef.setClassDescription(classDesc);
                    fieldDef.setClassName(classDesc.getName());
                    if (fieldDef.getView() == 0) {
                        fieldDef.setView(4);
                    }
                }
            } else {
                this.m_subClass = subClass;
                fieldDef = classDesc != null ? new WcmSubClass(classDesc) : new WcmSubClass();
                fieldDef.initializePropertyID();
                fieldDef.setClassLabel(subClass);
                if (classDesc != null) {
                    fieldDef.setClassName(classDesc.getName());
                }
                if (this.m_view != null) {
                    fieldDef.setView(this.m_view);
                }
                this.m_rowData.addElement(fieldDef);
                ++this.m_nRows;
                this.m_subClass = null;
                this.m_view = null;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.UpdateSubClass", "An error occurred while in onUpdateSubClass(): {0}", (Object)e.getMessage());
        }
    }

    protected void setItemAt(WcmSubClass item, int nRowIndex) throws WcmException {
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return;
            }
            if (nRowIndex < this.m_rowData.size()) {
                this.m_rowData.setElementAt(item, nRowIndex);
                this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            }
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.errorInGettingItem", "An error occurred in getItemAt(): {0}", (Object)e.getMessage());
        }
    }

    protected WcmSubClass getItemAt(int nRowIndex) throws WcmException {
        WcmSubClass fieldDef = null;
        try {
            if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
                return null;
            }
            if (nRowIndex < this.m_rowData.size()) {
                fieldDef = (WcmSubClass)this.m_rowData.elementAt(nRowIndex);
            }
            return fieldDef;
        }
        catch (Exception e) {
            throw new WcmException("client.WcmObjectTypeModel.errorInGettingItem", "An error occurred in getItemAt(): {0}", (Object)e.getMessage());
        }
    }
}

